/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.PaymentMethodValidation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.selectable.PaymentMethodValidationSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.PaymentMethodValidation
 * PaymentMethodValidation} to other entities. Instances of this object are used in query modifier methods of the entity
 * fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class PaymentMethodValidationLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<PaymentMethodValidationLink<ObjectT>, PaymentMethodValidation, ObjectT>
    implements
    PaymentMethodValidationSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public PaymentMethodValidationLink( final String fieldName )
    {
        super(fieldName);
    }

    private PaymentMethodValidationLink(
        final EntityLink<PaymentMethodValidationLink<ObjectT>, PaymentMethodValidation, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected PaymentMethodValidationLink<ObjectT> translateLinkType(
        final EntityLink<PaymentMethodValidationLink<ObjectT>, PaymentMethodValidation, ObjectT> link )
    {
        return new PaymentMethodValidationLink<ObjectT>(link);
    }

}
