/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.PaymentMethodValidation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.PaymentMethodValidation
 * PaymentMethodValidation}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.field.PaymentMethodValidationField
 * PaymentMethodValidationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.link.PaymentMethodValidationLink
 * PaymentMethodValidationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.PaymentMethodValidation#ISO_COUNTRY_CODE_FOR_BANK
 * ISO_COUNTRY_CODE_FOR_BANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.PaymentMethodValidation#PAYMENT_METHOD_IN_EC
 * PAYMENT_METHOD_IN_EC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.PaymentMethodValidation#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.PaymentMethodValidation#IBAN_EXISTS
 * IBAN_EXISTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.PaymentMethodValidation#SWIFT_EXISTS
 * SWIFT_EXISTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.PaymentMethodValidation#BANK_ACCOUNT_NUMBER_EXISTS
 * BANK_ACCOUNT_NUMBER_EXISTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.PaymentMethodValidation#ISO_EMPLOYEE_COUNTRY_CODE
 * ISO_EMPLOYEE_COUNTRY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.PaymentMethodValidation#BANK_KEY_EXISTS
 * BANK_KEY_EXISTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.PaymentMethodValidation#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.PaymentMethodValidation#PAYMENT_METHOD
 * PAYMENT_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.paymentmethodvalidation.PaymentMethodValidation#IS_VALID
 * IS_VALID}</li>
 * </ul>
 *
 */
public interface PaymentMethodValidationSelectable extends EntitySelectable<PaymentMethodValidation>
{

}
