/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.field.PersCompnElmntCostAssgmtField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.link.PersCompnElmntCostAssgmtOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.selectable.PersCompnElmntCostAssgmtSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Personnel Compensation Element Cost Assignment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PersCompnElmntCostAssgmtType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PersCompnElmntCostAssgmt extends VdmEntity<PersCompnElmntCostAssgmt>
{

    /**
     * Selector for all available fields of PersCompnElmntCostAssgmt.
     *
     */
    public final static PersCompnElmntCostAssgmtSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelSettlementDocument</b>
     * </p>
     *
     * @return Personnel Settlement Document Number
     */
    @Key
    @SerializedName( "PersonnelSettlementDocument" )
    @JsonProperty( "PersonnelSettlementDocument" )
    @Nullable
    @ODataField( odataName = "PersonnelSettlementDocument" )
    private String personnelSettlementDocument;
    /**
     * Use with available fluent helpers to apply the <b>PersonnelSettlementDocument</b> field to query operations.
     *
     */
    public final static PersCompnElmntCostAssgmtField<String> PERSONNEL_SETTLEMENT_DOCUMENT =
        new PersCompnElmntCostAssgmtField<String>("PersonnelSettlementDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static PersCompnElmntCostAssgmtField<String> CONTROLLING_AREA =
        new PersCompnElmntCostAssgmtField<String>("ControllingArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @Key
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static PersCompnElmntCostAssgmtField<String> COST_CENTER =
        new PersCompnElmntCostAssgmtField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterResponsibilityArea</b>
     * </p>
     *
     * @return The costCenterResponsibilityArea contained in this entity.
     */
    @SerializedName( "CostCenterResponsibilityArea" )
    @JsonProperty( "CostCenterResponsibilityArea" )
    @Nullable
    @ODataField( odataName = "CostCenterResponsibilityArea" )
    private String costCenterResponsibilityArea;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterResponsibilityArea</b> field to query operations.
     *
     */
    public final static PersCompnElmntCostAssgmtField<String> COST_CENTER_RESPONSIBILITY_AREA =
        new PersCompnElmntCostAssgmtField<String>("CostCenterResponsibilityArea");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @return The netAmount contained in this entity.
     */
    @SerializedName( "NetAmount" )
    @JsonProperty( "NetAmount" )
    @Nullable
    @ODataField( odataName = "NetAmount" )
    private BigDecimal netAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetAmount</b> field to query operations.
     *
     */
    public final static PersCompnElmntCostAssgmtField<BigDecimal> NET_AMOUNT =
        new PersCompnElmntCostAssgmtField<BigDecimal>("NetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PersSettlmtDocCurrency</b>
     * </p>
     *
     * @return Currency of Settlement Document
     */
    @SerializedName( "PersSettlmtDocCurrency" )
    @JsonProperty( "PersSettlmtDocCurrency" )
    @Nullable
    @ODataField( odataName = "PersSettlmtDocCurrency" )
    private String persSettlmtDocCurrency;
    /**
     * Use with available fluent helpers to apply the <b>PersSettlmtDocCurrency</b> field to query operations.
     *
     */
    public final static PersCompnElmntCostAssgmtField<String> PERS_SETTLMT_DOC_CURRENCY =
        new PersCompnElmntCostAssgmtField<String>("PersSettlmtDocCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PersSettlmtDocCurrencyISOCode</b>
     * </p>
     *
     * @return ISO Currency Code
     */
    @SerializedName( "PersSettlmtDocCurrencyISOCode" )
    @JsonProperty( "PersSettlmtDocCurrencyISOCode" )
    @Nullable
    @ODataField( odataName = "PersSettlmtDocCurrencyISOCode" )
    private String persSettlmtDocCurrencyISOCode;
    /**
     * Use with available fluent helpers to apply the <b>PersSettlmtDocCurrencyISOCode</b> field to query operations.
     *
     */
    public final static PersCompnElmntCostAssgmtField<String> PERS_SETTLMT_DOC_CURRENCY_ISO_CODE =
        new PersCompnElmntCostAssgmtField<String>("PersSettlmtDocCurrencyISOCode");
    /**
     * Navigation property <b>to_PersonnelCompensationElement</b> for <b>PersCompnElmntCostAssgmt</b> to single
     * <b>PersonnelCompensationElement</b>.
     *
     */
    @SerializedName( "to_PersonnelCompensationElement" )
    @JsonProperty( "to_PersonnelCompensationElement" )
    @ODataField( odataName = "to_PersonnelCompensationElement" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PersonnelCompensationElement toPersonnelCompensationElement;
    /**
     * Use with available fluent helpers to apply the <b>to_PersonnelCompensationElement</b> navigation property to
     * query operations.
     *
     */
    public final static PersCompnElmntCostAssgmtOneToOneLink<PersonnelCompensationElement> TO_PERSONNEL_COMPENSATION_ELEMENT =
        new PersCompnElmntCostAssgmtOneToOneLink<PersonnelCompensationElement>("to_PersonnelCompensationElement");

    @Nonnull
    @Override
    public Class<PersCompnElmntCostAssgmt> getType()
    {
        return PersCompnElmntCostAssgmt.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelSettlementDocument</b>
     * </p>
     *
     * @param personnelSettlementDocument
     *            Personnel Settlement Document Number
     */
    public void setPersonnelSettlementDocument( @Nullable final String personnelSettlementDocument )
    {
        rememberChangedField("PersonnelSettlementDocument", this.personnelSettlementDocument);
        this.personnelSettlementDocument = personnelSettlementDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterResponsibilityArea</b>
     * </p>
     *
     * @param costCenterResponsibilityArea
     *            The costCenterResponsibilityArea to set.
     */
    public void setCostCenterResponsibilityArea( @Nullable final String costCenterResponsibilityArea )
    {
        rememberChangedField("CostCenterResponsibilityArea", this.costCenterResponsibilityArea);
        this.costCenterResponsibilityArea = costCenterResponsibilityArea;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @param netAmount
     *            The netAmount to set.
     */
    public void setNetAmount( @Nullable final BigDecimal netAmount )
    {
        rememberChangedField("NetAmount", this.netAmount);
        this.netAmount = netAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PersSettlmtDocCurrency</b>
     * </p>
     *
     * @param persSettlmtDocCurrency
     *            Currency of Settlement Document
     */
    public void setPersSettlmtDocCurrency( @Nullable final String persSettlmtDocCurrency )
    {
        rememberChangedField("PersSettlmtDocCurrency", this.persSettlmtDocCurrency);
        this.persSettlmtDocCurrency = persSettlmtDocCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PersSettlmtDocCurrencyISOCode</b>
     * </p>
     *
     * @param persSettlmtDocCurrencyISOCode
     *            ISO Currency Code
     */
    public void setPersSettlmtDocCurrencyISOCode( @Nullable final String persSettlmtDocCurrencyISOCode )
    {
        rememberChangedField("PersSettlmtDocCurrencyISOCode", this.persSettlmtDocCurrencyISOCode);
        this.persSettlmtDocCurrencyISOCode = persSettlmtDocCurrencyISOCode;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PersCompnElmntCostAssgmt";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PersonnelSettlementDocument", getPersonnelSettlementDocument());
        result.put("ControllingArea", getControllingArea());
        result.put("CostCenter", getCostCenter());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PersonnelSettlementDocument", getPersonnelSettlementDocument());
        values.put("ControllingArea", getControllingArea());
        values.put("CostCenter", getCostCenter());
        values.put("CostCenterResponsibilityArea", getCostCenterResponsibilityArea());
        values.put("NetAmount", getNetAmount());
        values.put("PersSettlmtDocCurrency", getPersSettlmtDocCurrency());
        values.put("PersSettlmtDocCurrencyISOCode", getPersSettlmtDocCurrencyISOCode());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PersonnelSettlementDocument") ) {
                final Object value = values.remove("PersonnelSettlementDocument");
                if( (value == null) || (!value.equals(getPersonnelSettlementDocument())) ) {
                    setPersonnelSettlementDocument(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("CostCenterResponsibilityArea") ) {
                final Object value = values.remove("CostCenterResponsibilityArea");
                if( (value == null) || (!value.equals(getCostCenterResponsibilityArea())) ) {
                    setCostCenterResponsibilityArea(((String) value));
                }
            }
            if( values.containsKey("NetAmount") ) {
                final Object value = values.remove("NetAmount");
                if( (value == null) || (!value.equals(getNetAmount())) ) {
                    setNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("PersSettlmtDocCurrency") ) {
                final Object value = values.remove("PersSettlmtDocCurrency");
                if( (value == null) || (!value.equals(getPersSettlmtDocCurrency())) ) {
                    setPersSettlmtDocCurrency(((String) value));
                }
            }
            if( values.containsKey("PersSettlmtDocCurrencyISOCode") ) {
                final Object value = values.remove("PersSettlmtDocCurrencyISOCode");
                if( (value == null) || (!value.equals(getPersSettlmtDocCurrencyISOCode())) ) {
                    setPersSettlmtDocCurrencyISOCode(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PersonnelCompensationElement") ) {
                final Object value = (values).remove("to_PersonnelCompensationElement");
                if( value instanceof Map ) {
                    if( toPersonnelCompensationElement == null ) {
                        toPersonnelCompensationElement = new PersonnelCompensationElement();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPersonnelCompensationElement.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PersCompnElmntCostAssgmtField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PersCompnElmntCostAssgmtField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PersCompnElmntCostAssgmtField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PersCompnElmntCostAssgmtField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PersonnelSettlementDocumentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPersonnelCompensationElement != null ) {
            (values).put("to_PersonnelCompensationElement", toPersonnelCompensationElement);
        }
        return values;
    }

    /**
     * Fetches the <b>PersonnelCompensationElement</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PersonnelCompensationElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PersonnelCompensationElement</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PersonnelCompensationElement fetchPersonnelCompensationElement()
    {
        return fetchFieldAsSingle("to_PersonnelCompensationElement", PersonnelCompensationElement.class);
    }

    /**
     * Retrieval of associated <b>PersonnelCompensationElement</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PersonnelCompensationElement</b>.
     * <p>
     * If the navigation property <b>to_PersonnelCompensationElement</b> of a queried <b>PersCompnElmntCostAssgmt</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PersonnelCompensationElement</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PersonnelCompensationElement getPersonnelCompensationElementOrFetch()
    {
        if( toPersonnelCompensationElement == null ) {
            toPersonnelCompensationElement = fetchPersonnelCompensationElement();
        }
        return toPersonnelCompensationElement;
    }

    /**
     * Retrieval of associated <b>PersonnelCompensationElement</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PersonnelCompensationElement</b>.
     * <p>
     * If the navigation property for an entity <b>PersCompnElmntCostAssgmt</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PersonnelCompensationElement</b> is already loaded, the
     *         result will contain the <b>PersonnelCompensationElement</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PersonnelCompensationElement> getPersonnelCompensationElementIfPresent()
    {
        return Option.of(toPersonnelCompensationElement);
    }

    /**
     * Overwrites the associated <b>PersonnelCompensationElement</b> entity for the loaded navigation property
     * <b>to_PersonnelCompensationElement</b>.
     *
     * @param value
     *            New <b>PersonnelCompensationElement</b> entity.
     */
    public void setPersonnelCompensationElement( final PersonnelCompensationElement value )
    {
        toPersonnelCompensationElement = value;
    }

    /**
     * Helper class to allow for fluent creation of PersCompnElmntCostAssgmt instances.
     *
     */
    public final static class PersCompnElmntCostAssgmtBuilder
    {

        private PersonnelCompensationElement toPersonnelCompensationElement;

        private PersCompnElmntCostAssgmt.PersCompnElmntCostAssgmtBuilder toPersonnelCompensationElement(
            final PersonnelCompensationElement value )
        {
            toPersonnelCompensationElement = value;
            return this;
        }

        /**
         * Navigation property <b>to_PersonnelCompensationElement</b> for <b>PersCompnElmntCostAssgmt</b> to single
         * <b>PersonnelCompensationElement</b>.
         *
         * @param value
         *            The PersonnelCompensationElement to build this PersCompnElmntCostAssgmt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PersCompnElmntCostAssgmt.PersCompnElmntCostAssgmtBuilder personnelCompensationElement(
            final PersonnelCompensationElement value )
        {
            return toPersonnelCompensationElement(value);
        }

    }

}
