/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.selectable.PersCompnElmntCostAssgmtSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmt
 * PersCompnElmntCostAssgmt} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class PersCompnElmntCostAssgmtByKeyFluentHelper
    extends
    FluentHelperByKey<PersCompnElmntCostAssgmtByKeyFluentHelper, PersCompnElmntCostAssgmt, PersCompnElmntCostAssgmtSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmt
     * PersCompnElmntCostAssgmt} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param personnelSettlementDocument
     *            Personnel Settlement Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PersCompnElmntCostAssgmt}
     * @param costCenter
     *            Cost Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PersCompnElmntCostAssgmt}
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public PersCompnElmntCostAssgmtByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String personnelSettlementDocument,
        final String controllingArea,
        final String costCenter )
    {
        super(servicePath, entityCollection);
        this.key.put("PersonnelSettlementDocument", personnelSettlementDocument);
        this.key.put("ControllingArea", controllingArea);
        this.key.put("CostCenter", costCenter);
    }

    @Override
    @Nonnull
    protected Class<PersCompnElmntCostAssgmt> getEntityClass()
    {
        return PersCompnElmntCostAssgmt.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
