/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.field.PersonnelCompensationElementField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.link.PersonnelCompensationElementLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.selectable.PersonnelCompensationElementSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Personnel Compensation Element
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PersonnelCompensationElementType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PersonnelCompensationElement extends VdmEntity<PersonnelCompensationElement>
{

    /**
     * Selector for all available fields of PersonnelCompensationElement.
     *
     */
    public final static PersonnelCompensationElementSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelSettlementDocument</b>
     * </p>
     *
     * @return Personnel Settlement Document Number
     */
    @Key
    @SerializedName( "PersonnelSettlementDocument" )
    @JsonProperty( "PersonnelSettlementDocument" )
    @Nullable
    @ODataField( odataName = "PersonnelSettlementDocument" )
    private String personnelSettlementDocument;
    /**
     * Use with available fluent helpers to apply the <b>PersonnelSettlementDocument</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<String> PERSONNEL_SETTLEMENT_DOCUMENT =
        new PersonnelCompensationElementField<String>("PersonnelSettlementDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocType</b>
     * </p>
     *
     * @return Settlement Document Type
     */
    @SerializedName( "SettlmtDocType" )
    @JsonProperty( "SettlmtDocType" )
    @Nullable
    @ODataField( odataName = "SettlmtDocType" )
    private String settlmtDocType;
    /**
     * Use with available fluent helpers to apply the <b>SettlmtDocType</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<String> SETTLMT_DOC_TYPE =
        new PersonnelCompensationElementField<String>("SettlmtDocType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocCat</b>
     * </p>
     *
     * @return Settlement Document Category
     */
    @SerializedName( "SettlmtDocCat" )
    @JsonProperty( "SettlmtDocCat" )
    @Nullable
    @ODataField( odataName = "SettlmtDocCat" )
    private String settlmtDocCat;
    /**
     * Use with available fluent helpers to apply the <b>SettlmtDocCat</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<String> SETTLMT_DOC_CAT =
        new PersonnelCompensationElementField<String>("SettlmtDocCat");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<String> COMPANY_CODE =
        new PersonnelCompensationElementField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCountry</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "CompanyCodeCountry" )
    @JsonProperty( "CompanyCodeCountry" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCountry" )
    private String companyCodeCountry;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCountry</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<String> COMPANY_CODE_COUNTRY =
        new PersonnelCompensationElementField<String>("CompanyCodeCountry");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCountryISOCode</b>
     * </p>
     *
     * @return ISO Country/Region Code 3 Characters
     */
    @SerializedName( "CompanyCodeCountryISOCode" )
    @JsonProperty( "CompanyCodeCountryISOCode" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCountryISOCode" )
    private String companyCodeCountryISOCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCountryISOCode</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<String> COMPANY_CODE_COUNTRY_ISO_CODE =
        new PersonnelCompensationElementField<String>("CompanyCodeCountryISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryThreeDigitISOCode</b>
     * </p>
     *
     * @return ISO Country/Region Code Numeric 3-Characters
     */
    @SerializedName( "CountryThreeDigitISOCode" )
    @JsonProperty( "CountryThreeDigitISOCode" )
    @Nullable
    @ODataField( odataName = "CountryThreeDigitISOCode" )
    private String countryThreeDigitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>CountryThreeDigitISOCode</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<String> COUNTRY_THREE_DIGIT_ISO_CODE =
        new PersonnelCompensationElementField<String>("CountryThreeDigitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonWorkAgreement</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "PersonWorkAgreement" )
    @JsonProperty( "PersonWorkAgreement" )
    @Nullable
    @ODataField( odataName = "PersonWorkAgreement" )
    private String personWorkAgreement;
    /**
     * Use with available fluent helpers to apply the <b>PersonWorkAgreement</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<String> PERSON_WORK_AGREEMENT =
        new PersonnelCompensationElementField<String>("PersonWorkAgreement");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PersonWorkAgreementExternalID</b>
     * </p>
     *
     * @return Work Agreement External ID
     */
    @SerializedName( "PersonWorkAgreementExternalID" )
    @JsonProperty( "PersonWorkAgreementExternalID" )
    @Nullable
    @ODataField( odataName = "PersonWorkAgreementExternalID" )
    private String personWorkAgreementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>PersonWorkAgreementExternalID</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<String> PERSON_WORK_AGREEMENT_EXTERNAL_ID =
        new PersonnelCompensationElementField<String>("PersonWorkAgreementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtCompensationReason</b>
     * </p>
     *
     * @return Compensation Reason for a Settlement Management Document
     */
    @SerializedName( "SettlmtCompensationReason" )
    @JsonProperty( "SettlmtCompensationReason" )
    @Nullable
    @ODataField( odataName = "SettlmtCompensationReason" )
    private String settlmtCompensationReason;
    /**
     * Use with available fluent helpers to apply the <b>SettlmtCompensationReason</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<String> SETTLMT_COMPENSATION_REASON =
        new PersonnelCompensationElementField<String>("SettlmtCompensationReason");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtCompnVar</b>
     * </p>
     *
     * @return Compensation Variant
     */
    @SerializedName( "SettlmtCompnVar" )
    @JsonProperty( "SettlmtCompnVar" )
    @Nullable
    @ODataField( odataName = "SettlmtCompnVar" )
    private String settlmtCompnVar;
    /**
     * Use with available fluent helpers to apply the <b>SettlmtCompnVar</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<String> SETTLMT_COMPN_VAR =
        new PersonnelCompensationElementField<String>("SettlmtCompnVar");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting Date
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<LocalDateTime> POSTING_DATE =
        new PersonnelCompensationElementField<LocalDateTime>("PostingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @return Document Date in Settlement Management Document
     */
    @SerializedName( "DocumentDate" )
    @JsonProperty( "DocumentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DocumentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime documentDate;
    /**
     * Use with available fluent helpers to apply the <b>DocumentDate</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<LocalDateTime> DOCUMENT_DATE =
        new PersonnelCompensationElementField<LocalDateTime>("DocumentDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualSettlmtDate</b>
     * </p>
     *
     * @return Actual Settlement Date
     */
    @SerializedName( "ActualSettlmtDate" )
    @JsonProperty( "ActualSettlmtDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ActualSettlmtDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime actualSettlmtDate;
    /**
     * Use with available fluent helpers to apply the <b>ActualSettlmtDate</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<LocalDateTime> ACTUAL_SETTLMT_DATE =
        new PersonnelCompensationElementField<LocalDateTime>("ActualSettlmtDate");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalNetAmount</b>
     * </p>
     *
     * @return Net Settlement Amount in Document Currency
     */
    @SerializedName( "TotalNetAmount" )
    @JsonProperty( "TotalNetAmount" )
    @Nullable
    @ODataField( odataName = "TotalNetAmount" )
    private BigDecimal totalNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>TotalNetAmount</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<BigDecimal> TOTAL_NET_AMOUNT =
        new PersonnelCompensationElementField<BigDecimal>("TotalNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PersSettlmtDocCurrency</b>
     * </p>
     *
     * @return Currency of Settlement Document
     */
    @SerializedName( "PersSettlmtDocCurrency" )
    @JsonProperty( "PersSettlmtDocCurrency" )
    @Nullable
    @ODataField( odataName = "PersSettlmtDocCurrency" )
    private String persSettlmtDocCurrency;
    /**
     * Use with available fluent helpers to apply the <b>PersSettlmtDocCurrency</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<String> PERS_SETTLMT_DOC_CURRENCY =
        new PersonnelCompensationElementField<String>("PersSettlmtDocCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PersSettlmtDocCurrencyISOCode</b>
     * </p>
     *
     * @return ISO Currency Code
     */
    @SerializedName( "PersSettlmtDocCurrencyISOCode" )
    @JsonProperty( "PersSettlmtDocCurrencyISOCode" )
    @Nullable
    @ODataField( odataName = "PersSettlmtDocCurrencyISOCode" )
    private String persSettlmtDocCurrencyISOCode;
    /**
     * Use with available fluent helpers to apply the <b>PersSettlmtDocCurrencyISOCode</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<String> PERS_SETTLMT_DOC_CURRENCY_ISO_CODE =
        new PersonnelCompensationElementField<String>("PersSettlmtDocCurrencyISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReferenceID</b>
     * </p>
     *
     * @return Reference Document Number
     */
    @SerializedName( "DocumentReferenceID" )
    @JsonProperty( "DocumentReferenceID" )
    @Nullable
    @ODataField( odataName = "DocumentReferenceID" )
    private String documentReferenceID;
    /**
     * Use with available fluent helpers to apply the <b>DocumentReferenceID</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<String> DOCUMENT_REFERENCE_ID =
        new PersonnelCompensationElementField<String>("DocumentReferenceID");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @return Assignment number
     */
    @SerializedName( "AssignmentReference" )
    @JsonProperty( "AssignmentReference" )
    @Nullable
    @ODataField( odataName = "AssignmentReference" )
    private String assignmentReference;
    /**
     * Use with available fluent helpers to apply the <b>AssignmentReference</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<String> ASSIGNMENT_REFERENCE =
        new PersonnelCompensationElementField<String>("AssignmentReference");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentReference</b>
     * </p>
     *
     * @return Payment Reference
     */
    @SerializedName( "PaymentReference" )
    @JsonProperty( "PaymentReference" )
    @Nullable
    @ODataField( odataName = "PaymentReference" )
    private String paymentReference;
    /**
     * Use with available fluent helpers to apply the <b>PaymentReference</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<String> PAYMENT_REFERENCE =
        new PersonnelCompensationElementField<String>("PaymentReference");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PersSettlmtDocIsReversed</b>
     * </p>
     *
     * @return Personnel Settlement Document Is Reversed
     */
    @SerializedName( "PersSettlmtDocIsReversed" )
    @JsonProperty( "PersSettlmtDocIsReversed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PersSettlmtDocIsReversed" )
    private Boolean persSettlmtDocIsReversed;
    /**
     * Use with available fluent helpers to apply the <b>PersSettlmtDocIsReversed</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<Boolean> PERS_SETTLMT_DOC_IS_REVERSED =
        new PersonnelCompensationElementField<Boolean>("PersSettlmtDocIsReversed");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RvsdPersSettlmtDoc</b>
     * </p>
     *
     * @return Reversed Document
     */
    @SerializedName( "RvsdPersSettlmtDoc" )
    @JsonProperty( "RvsdPersSettlmtDoc" )
    @Nullable
    @ODataField( odataName = "RvsdPersSettlmtDoc" )
    private String rvsdPersSettlmtDoc;
    /**
     * Use with available fluent helpers to apply the <b>RvsdPersSettlmtDoc</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<String> RVSD_PERS_SETTLMT_DOC =
        new PersonnelCompensationElementField<String>("RvsdPersSettlmtDoc");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>JournalEntryCreationDate</b>
     * </p>
     *
     * @return Journal Entry Creation Date in UTC
     */
    @SerializedName( "JournalEntryCreationDate" )
    @JsonProperty( "JournalEntryCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "JournalEntryCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime journalEntryCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>JournalEntryCreationDate</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<LocalDateTime> JOURNAL_ENTRY_CREATION_DATE =
        new PersonnelCompensationElementField<LocalDateTime>("JournalEntryCreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>JournalEntryCreationTime</b>
     * </p>
     *
     * @return Journal Entry Creation Time in UTC
     */
    @SerializedName( "JournalEntryCreationTime" )
    @JsonProperty( "JournalEntryCreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "JournalEntryCreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime journalEntryCreationTime;
    /**
     * Use with available fluent helpers to apply the <b>JournalEntryCreationTime</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<LocalTime> JOURNAL_ENTRY_CREATION_TIME =
        new PersonnelCompensationElementField<LocalTime>("JournalEntryCreationTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>JournalEntryCreationDateTime</b>
     * </p>
     *
     * @return Journal Entry Creation Date and Time in UTC
     */
    @SerializedName( "JournalEntryCreationDateTime" )
    @JsonProperty( "JournalEntryCreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "JournalEntryCreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime journalEntryCreationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>JournalEntryCreationDateTime</b> field to query operations.
     *
     */
    public final static PersonnelCompensationElementField<ZonedDateTime> JOURNAL_ENTRY_CREATION_DATE_TIME =
        new PersonnelCompensationElementField<ZonedDateTime>("JournalEntryCreationDateTime");
    /**
     * Navigation property <b>to_PersCompnElmntCostAssgmt</b> for <b>PersonnelCompensationElement</b> to multiple
     * <b>PersCompnElmntCostAssgmt</b>.
     *
     */
    @SerializedName( "to_PersCompnElmntCostAssgmt" )
    @JsonProperty( "to_PersCompnElmntCostAssgmt" )
    @ODataField( odataName = "to_PersCompnElmntCostAssgmt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PersCompnElmntCostAssgmt> toPersCompnElmntCostAssgmt;
    /**
     * Use with available fluent helpers to apply the <b>to_PersCompnElmntCostAssgmt</b> navigation property to query
     * operations.
     *
     */
    public final static PersonnelCompensationElementLink<PersCompnElmntCostAssgmt> TO_PERS_COMPN_ELMNT_COST_ASSGMT =
        new PersonnelCompensationElementLink<PersCompnElmntCostAssgmt>("to_PersCompnElmntCostAssgmt");

    @Nonnull
    @Override
    public Class<PersonnelCompensationElement> getType()
    {
        return PersonnelCompensationElement.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelSettlementDocument</b>
     * </p>
     *
     * @param personnelSettlementDocument
     *            Personnel Settlement Document Number
     */
    public void setPersonnelSettlementDocument( @Nullable final String personnelSettlementDocument )
    {
        rememberChangedField("PersonnelSettlementDocument", this.personnelSettlementDocument);
        this.personnelSettlementDocument = personnelSettlementDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocType</b>
     * </p>
     *
     * @param settlmtDocType
     *            Settlement Document Type
     */
    public void setSettlmtDocType( @Nullable final String settlmtDocType )
    {
        rememberChangedField("SettlmtDocType", this.settlmtDocType);
        this.settlmtDocType = settlmtDocType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocCat</b>
     * </p>
     *
     * @param settlmtDocCat
     *            Settlement Document Category
     */
    public void setSettlmtDocCat( @Nullable final String settlmtDocCat )
    {
        rememberChangedField("SettlmtDocCat", this.settlmtDocCat);
        this.settlmtDocCat = settlmtDocCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCountry</b>
     * </p>
     *
     * @param companyCodeCountry
     *            Country/Region Key
     */
    public void setCompanyCodeCountry( @Nullable final String companyCodeCountry )
    {
        rememberChangedField("CompanyCodeCountry", this.companyCodeCountry);
        this.companyCodeCountry = companyCodeCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCountryISOCode</b>
     * </p>
     *
     * @param companyCodeCountryISOCode
     *            ISO Country/Region Code 3 Characters
     */
    public void setCompanyCodeCountryISOCode( @Nullable final String companyCodeCountryISOCode )
    {
        rememberChangedField("CompanyCodeCountryISOCode", this.companyCodeCountryISOCode);
        this.companyCodeCountryISOCode = companyCodeCountryISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryThreeDigitISOCode</b>
     * </p>
     *
     * @param countryThreeDigitISOCode
     *            ISO Country/Region Code Numeric 3-Characters
     */
    public void setCountryThreeDigitISOCode( @Nullable final String countryThreeDigitISOCode )
    {
        rememberChangedField("CountryThreeDigitISOCode", this.countryThreeDigitISOCode);
        this.countryThreeDigitISOCode = countryThreeDigitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonWorkAgreement</b>
     * </p>
     *
     * @param personWorkAgreement
     *            Personnel Number
     */
    public void setPersonWorkAgreement( @Nullable final String personWorkAgreement )
    {
        rememberChangedField("PersonWorkAgreement", this.personWorkAgreement);
        this.personWorkAgreement = personWorkAgreement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PersonWorkAgreementExternalID</b>
     * </p>
     *
     * @param personWorkAgreementExternalID
     *            Work Agreement External ID
     */
    public void setPersonWorkAgreementExternalID( @Nullable final String personWorkAgreementExternalID )
    {
        rememberChangedField("PersonWorkAgreementExternalID", this.personWorkAgreementExternalID);
        this.personWorkAgreementExternalID = personWorkAgreementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtCompensationReason</b>
     * </p>
     *
     * @param settlmtCompensationReason
     *            Compensation Reason for a Settlement Management Document
     */
    public void setSettlmtCompensationReason( @Nullable final String settlmtCompensationReason )
    {
        rememberChangedField("SettlmtCompensationReason", this.settlmtCompensationReason);
        this.settlmtCompensationReason = settlmtCompensationReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtCompnVar</b>
     * </p>
     *
     * @param settlmtCompnVar
     *            Compensation Variant
     */
    public void setSettlmtCompnVar( @Nullable final String settlmtCompnVar )
    {
        rememberChangedField("SettlmtCompnVar", this.settlmtCompnVar);
        this.settlmtCompnVar = settlmtCompnVar;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @param documentDate
     *            Document Date in Settlement Management Document
     */
    public void setDocumentDate( @Nullable final LocalDateTime documentDate )
    {
        rememberChangedField("DocumentDate", this.documentDate);
        this.documentDate = documentDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualSettlmtDate</b>
     * </p>
     *
     * @param actualSettlmtDate
     *            Actual Settlement Date
     */
    public void setActualSettlmtDate( @Nullable final LocalDateTime actualSettlmtDate )
    {
        rememberChangedField("ActualSettlmtDate", this.actualSettlmtDate);
        this.actualSettlmtDate = actualSettlmtDate;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalNetAmount</b>
     * </p>
     *
     * @param totalNetAmount
     *            Net Settlement Amount in Document Currency
     */
    public void setTotalNetAmount( @Nullable final BigDecimal totalNetAmount )
    {
        rememberChangedField("TotalNetAmount", this.totalNetAmount);
        this.totalNetAmount = totalNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PersSettlmtDocCurrency</b>
     * </p>
     *
     * @param persSettlmtDocCurrency
     *            Currency of Settlement Document
     */
    public void setPersSettlmtDocCurrency( @Nullable final String persSettlmtDocCurrency )
    {
        rememberChangedField("PersSettlmtDocCurrency", this.persSettlmtDocCurrency);
        this.persSettlmtDocCurrency = persSettlmtDocCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PersSettlmtDocCurrencyISOCode</b>
     * </p>
     *
     * @param persSettlmtDocCurrencyISOCode
     *            ISO Currency Code
     */
    public void setPersSettlmtDocCurrencyISOCode( @Nullable final String persSettlmtDocCurrencyISOCode )
    {
        rememberChangedField("PersSettlmtDocCurrencyISOCode", this.persSettlmtDocCurrencyISOCode);
        this.persSettlmtDocCurrencyISOCode = persSettlmtDocCurrencyISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReferenceID</b>
     * </p>
     *
     * @param documentReferenceID
     *            Reference Document Number
     */
    public void setDocumentReferenceID( @Nullable final String documentReferenceID )
    {
        rememberChangedField("DocumentReferenceID", this.documentReferenceID);
        this.documentReferenceID = documentReferenceID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @param assignmentReference
     *            Assignment number
     */
    public void setAssignmentReference( @Nullable final String assignmentReference )
    {
        rememberChangedField("AssignmentReference", this.assignmentReference);
        this.assignmentReference = assignmentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentReference</b>
     * </p>
     *
     * @param paymentReference
     *            Payment Reference
     */
    public void setPaymentReference( @Nullable final String paymentReference )
    {
        rememberChangedField("PaymentReference", this.paymentReference);
        this.paymentReference = paymentReference;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PersSettlmtDocIsReversed</b>
     * </p>
     *
     * @param persSettlmtDocIsReversed
     *            Personnel Settlement Document Is Reversed
     */
    public void setPersSettlmtDocIsReversed( @Nullable final Boolean persSettlmtDocIsReversed )
    {
        rememberChangedField("PersSettlmtDocIsReversed", this.persSettlmtDocIsReversed);
        this.persSettlmtDocIsReversed = persSettlmtDocIsReversed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RvsdPersSettlmtDoc</b>
     * </p>
     *
     * @param rvsdPersSettlmtDoc
     *            Reversed Document
     */
    public void setRvsdPersSettlmtDoc( @Nullable final String rvsdPersSettlmtDoc )
    {
        rememberChangedField("RvsdPersSettlmtDoc", this.rvsdPersSettlmtDoc);
        this.rvsdPersSettlmtDoc = rvsdPersSettlmtDoc;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>JournalEntryCreationDate</b>
     * </p>
     *
     * @param journalEntryCreationDate
     *            Journal Entry Creation Date in UTC
     */
    public void setJournalEntryCreationDate( @Nullable final LocalDateTime journalEntryCreationDate )
    {
        rememberChangedField("JournalEntryCreationDate", this.journalEntryCreationDate);
        this.journalEntryCreationDate = journalEntryCreationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>JournalEntryCreationTime</b>
     * </p>
     *
     * @param journalEntryCreationTime
     *            Journal Entry Creation Time in UTC
     */
    public void setJournalEntryCreationTime( @Nullable final LocalTime journalEntryCreationTime )
    {
        rememberChangedField("JournalEntryCreationTime", this.journalEntryCreationTime);
        this.journalEntryCreationTime = journalEntryCreationTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>JournalEntryCreationDateTime</b>
     * </p>
     *
     * @param journalEntryCreationDateTime
     *            Journal Entry Creation Date and Time in UTC
     */
    public void setJournalEntryCreationDateTime( @Nullable final ZonedDateTime journalEntryCreationDateTime )
    {
        rememberChangedField("JournalEntryCreationDateTime", this.journalEntryCreationDateTime);
        this.journalEntryCreationDateTime = journalEntryCreationDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PersonnelCompensationElement";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PersonnelSettlementDocument", getPersonnelSettlementDocument());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PersonnelSettlementDocument", getPersonnelSettlementDocument());
        values.put("SettlmtDocType", getSettlmtDocType());
        values.put("SettlmtDocCat", getSettlmtDocCat());
        values.put("CompanyCode", getCompanyCode());
        values.put("CompanyCodeCountry", getCompanyCodeCountry());
        values.put("CompanyCodeCountryISOCode", getCompanyCodeCountryISOCode());
        values.put("CountryThreeDigitISOCode", getCountryThreeDigitISOCode());
        values.put("PersonWorkAgreement", getPersonWorkAgreement());
        values.put("PersonWorkAgreementExternalID", getPersonWorkAgreementExternalID());
        values.put("SettlmtCompensationReason", getSettlmtCompensationReason());
        values.put("SettlmtCompnVar", getSettlmtCompnVar());
        values.put("PostingDate", getPostingDate());
        values.put("DocumentDate", getDocumentDate());
        values.put("ActualSettlmtDate", getActualSettlmtDate());
        values.put("TotalNetAmount", getTotalNetAmount());
        values.put("PersSettlmtDocCurrency", getPersSettlmtDocCurrency());
        values.put("PersSettlmtDocCurrencyISOCode", getPersSettlmtDocCurrencyISOCode());
        values.put("DocumentReferenceID", getDocumentReferenceID());
        values.put("AssignmentReference", getAssignmentReference());
        values.put("PaymentReference", getPaymentReference());
        values.put("PersSettlmtDocIsReversed", getPersSettlmtDocIsReversed());
        values.put("RvsdPersSettlmtDoc", getRvsdPersSettlmtDoc());
        values.put("JournalEntryCreationDate", getJournalEntryCreationDate());
        values.put("JournalEntryCreationTime", getJournalEntryCreationTime());
        values.put("JournalEntryCreationDateTime", getJournalEntryCreationDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PersonnelSettlementDocument") ) {
                final Object value = values.remove("PersonnelSettlementDocument");
                if( (value == null) || (!value.equals(getPersonnelSettlementDocument())) ) {
                    setPersonnelSettlementDocument(((String) value));
                }
            }
            if( values.containsKey("SettlmtDocType") ) {
                final Object value = values.remove("SettlmtDocType");
                if( (value == null) || (!value.equals(getSettlmtDocType())) ) {
                    setSettlmtDocType(((String) value));
                }
            }
            if( values.containsKey("SettlmtDocCat") ) {
                final Object value = values.remove("SettlmtDocCat");
                if( (value == null) || (!value.equals(getSettlmtDocCat())) ) {
                    setSettlmtDocCat(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeCountry") ) {
                final Object value = values.remove("CompanyCodeCountry");
                if( (value == null) || (!value.equals(getCompanyCodeCountry())) ) {
                    setCompanyCodeCountry(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeCountryISOCode") ) {
                final Object value = values.remove("CompanyCodeCountryISOCode");
                if( (value == null) || (!value.equals(getCompanyCodeCountryISOCode())) ) {
                    setCompanyCodeCountryISOCode(((String) value));
                }
            }
            if( values.containsKey("CountryThreeDigitISOCode") ) {
                final Object value = values.remove("CountryThreeDigitISOCode");
                if( (value == null) || (!value.equals(getCountryThreeDigitISOCode())) ) {
                    setCountryThreeDigitISOCode(((String) value));
                }
            }
            if( values.containsKey("PersonWorkAgreement") ) {
                final Object value = values.remove("PersonWorkAgreement");
                if( (value == null) || (!value.equals(getPersonWorkAgreement())) ) {
                    setPersonWorkAgreement(((String) value));
                }
            }
            if( values.containsKey("PersonWorkAgreementExternalID") ) {
                final Object value = values.remove("PersonWorkAgreementExternalID");
                if( (value == null) || (!value.equals(getPersonWorkAgreementExternalID())) ) {
                    setPersonWorkAgreementExternalID(((String) value));
                }
            }
            if( values.containsKey("SettlmtCompensationReason") ) {
                final Object value = values.remove("SettlmtCompensationReason");
                if( (value == null) || (!value.equals(getSettlmtCompensationReason())) ) {
                    setSettlmtCompensationReason(((String) value));
                }
            }
            if( values.containsKey("SettlmtCompnVar") ) {
                final Object value = values.remove("SettlmtCompnVar");
                if( (value == null) || (!value.equals(getSettlmtCompnVar())) ) {
                    setSettlmtCompnVar(((String) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("DocumentDate") ) {
                final Object value = values.remove("DocumentDate");
                if( (value == null) || (!value.equals(getDocumentDate())) ) {
                    setDocumentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ActualSettlmtDate") ) {
                final Object value = values.remove("ActualSettlmtDate");
                if( (value == null) || (!value.equals(getActualSettlmtDate())) ) {
                    setActualSettlmtDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TotalNetAmount") ) {
                final Object value = values.remove("TotalNetAmount");
                if( (value == null) || (!value.equals(getTotalNetAmount())) ) {
                    setTotalNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("PersSettlmtDocCurrency") ) {
                final Object value = values.remove("PersSettlmtDocCurrency");
                if( (value == null) || (!value.equals(getPersSettlmtDocCurrency())) ) {
                    setPersSettlmtDocCurrency(((String) value));
                }
            }
            if( values.containsKey("PersSettlmtDocCurrencyISOCode") ) {
                final Object value = values.remove("PersSettlmtDocCurrencyISOCode");
                if( (value == null) || (!value.equals(getPersSettlmtDocCurrencyISOCode())) ) {
                    setPersSettlmtDocCurrencyISOCode(((String) value));
                }
            }
            if( values.containsKey("DocumentReferenceID") ) {
                final Object value = values.remove("DocumentReferenceID");
                if( (value == null) || (!value.equals(getDocumentReferenceID())) ) {
                    setDocumentReferenceID(((String) value));
                }
            }
            if( values.containsKey("AssignmentReference") ) {
                final Object value = values.remove("AssignmentReference");
                if( (value == null) || (!value.equals(getAssignmentReference())) ) {
                    setAssignmentReference(((String) value));
                }
            }
            if( values.containsKey("PaymentReference") ) {
                final Object value = values.remove("PaymentReference");
                if( (value == null) || (!value.equals(getPaymentReference())) ) {
                    setPaymentReference(((String) value));
                }
            }
            if( values.containsKey("PersSettlmtDocIsReversed") ) {
                final Object value = values.remove("PersSettlmtDocIsReversed");
                if( (value == null) || (!value.equals(getPersSettlmtDocIsReversed())) ) {
                    setPersSettlmtDocIsReversed(((Boolean) value));
                }
            }
            if( values.containsKey("RvsdPersSettlmtDoc") ) {
                final Object value = values.remove("RvsdPersSettlmtDoc");
                if( (value == null) || (!value.equals(getRvsdPersSettlmtDoc())) ) {
                    setRvsdPersSettlmtDoc(((String) value));
                }
            }
            if( values.containsKey("JournalEntryCreationDate") ) {
                final Object value = values.remove("JournalEntryCreationDate");
                if( (value == null) || (!value.equals(getJournalEntryCreationDate())) ) {
                    setJournalEntryCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("JournalEntryCreationTime") ) {
                final Object value = values.remove("JournalEntryCreationTime");
                if( (value == null) || (!value.equals(getJournalEntryCreationTime())) ) {
                    setJournalEntryCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("JournalEntryCreationDateTime") ) {
                final Object value = values.remove("JournalEntryCreationDateTime");
                if( (value == null) || (!value.equals(getJournalEntryCreationDateTime())) ) {
                    setJournalEntryCreationDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PersCompnElmntCostAssgmt") ) {
                final Object value = (values).remove("to_PersCompnElmntCostAssgmt");
                if( value instanceof Iterable ) {
                    if( toPersCompnElmntCostAssgmt == null ) {
                        toPersCompnElmntCostAssgmt = Lists.newArrayList();
                    } else {
                        toPersCompnElmntCostAssgmt = Lists.newArrayList(toPersCompnElmntCostAssgmt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PersCompnElmntCostAssgmt entity;
                        if( toPersCompnElmntCostAssgmt.size() > i ) {
                            entity = toPersCompnElmntCostAssgmt.get(i);
                        } else {
                            entity = new PersCompnElmntCostAssgmt();
                            toPersCompnElmntCostAssgmt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PersonnelCompensationElementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new PersonnelCompensationElementField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PersonnelCompensationElementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PersonnelCompensationElementField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PersonnelSettlementDocumentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPersCompnElmntCostAssgmt != null ) {
            (values).put("to_PersCompnElmntCostAssgmt", toPersCompnElmntCostAssgmt);
        }
        return values;
    }

    /**
     * Fetches the <b>PersCompnElmntCostAssgmt</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PersCompnElmntCostAssgmt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PersCompnElmntCostAssgmt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PersCompnElmntCostAssgmt> fetchPersCompnElmntCostAssgmt()
    {
        return fetchFieldAsList("to_PersCompnElmntCostAssgmt", PersCompnElmntCostAssgmt.class);
    }

    /**
     * Retrieval of associated <b>PersCompnElmntCostAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PersCompnElmntCostAssgmt</b>.
     * <p>
     * If the navigation property <b>to_PersCompnElmntCostAssgmt</b> of a queried <b>PersonnelCompensationElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PersCompnElmntCostAssgmt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PersCompnElmntCostAssgmt> getPersCompnElmntCostAssgmtOrFetch()
    {
        if( toPersCompnElmntCostAssgmt == null ) {
            toPersCompnElmntCostAssgmt = fetchPersCompnElmntCostAssgmt();
        }
        return toPersCompnElmntCostAssgmt;
    }

    /**
     * Retrieval of associated <b>PersCompnElmntCostAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PersCompnElmntCostAssgmt</b>.
     * <p>
     * If the navigation property for an entity <b>PersonnelCompensationElement</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PersCompnElmntCostAssgmt</b> is already loaded, the
     *         result will contain the <b>PersCompnElmntCostAssgmt</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PersCompnElmntCostAssgmt>> getPersCompnElmntCostAssgmtIfPresent()
    {
        return Option.of(toPersCompnElmntCostAssgmt);
    }

    /**
     * Overwrites the list of associated <b>PersCompnElmntCostAssgmt</b> entities for the loaded navigation property
     * <b>to_PersCompnElmntCostAssgmt</b>.
     * <p>
     * If the navigation property <b>to_PersCompnElmntCostAssgmt</b> of a queried <b>PersonnelCompensationElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PersCompnElmntCostAssgmt</b> entities.
     */
    public void setPersCompnElmntCostAssgmt( @Nonnull final List<PersCompnElmntCostAssgmt> value )
    {
        if( toPersCompnElmntCostAssgmt == null ) {
            toPersCompnElmntCostAssgmt = Lists.newArrayList();
        }
        toPersCompnElmntCostAssgmt.clear();
        toPersCompnElmntCostAssgmt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PersCompnElmntCostAssgmt</b> entities. This corresponds to the OData
     * navigation property <b>to_PersCompnElmntCostAssgmt</b>.
     * <p>
     * If the navigation property <b>to_PersCompnElmntCostAssgmt</b> of a queried <b>PersonnelCompensationElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PersCompnElmntCostAssgmt</b> entities.
     */
    public void addPersCompnElmntCostAssgmt( PersCompnElmntCostAssgmt... entity )
    {
        if( toPersCompnElmntCostAssgmt == null ) {
            toPersCompnElmntCostAssgmt = Lists.newArrayList();
        }
        toPersCompnElmntCostAssgmt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PersonnelCompensationElement instances.
     *
     */
    public final static class PersonnelCompensationElementBuilder
    {

        private List<PersCompnElmntCostAssgmt> toPersCompnElmntCostAssgmt = Lists.newArrayList();

        private PersonnelCompensationElement.PersonnelCompensationElementBuilder toPersCompnElmntCostAssgmt(
            final List<PersCompnElmntCostAssgmt> value )
        {
            toPersCompnElmntCostAssgmt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PersCompnElmntCostAssgmt</b> for <b>PersonnelCompensationElement</b> to multiple
         * <b>PersCompnElmntCostAssgmt</b>.
         *
         * @param value
         *            The PersCompnElmntCostAssgmts to build this PersonnelCompensationElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PersonnelCompensationElement.PersonnelCompensationElementBuilder persCompnElmntCostAssgmt(
            PersCompnElmntCostAssgmt... value )
        {
            return toPersCompnElmntCostAssgmt(Lists.newArrayList(value));
        }

    }

}
