/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.selectable.PersonnelCompensationElementSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement
 * PersonnelCompensationElement} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class PersonnelCompensationElementByKeyFluentHelper
    extends
    FluentHelperByKey<PersonnelCompensationElementByKeyFluentHelper, PersonnelCompensationElement, PersonnelCompensationElementSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement
     * PersonnelCompensationElement} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param personnelSettlementDocument
     *            Personnel Settlement Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PersonnelCompensationElement}
     * @param servicePath
     *            Service path to be used to fetch a single {@code PersonnelCompensationElement}
     */
    public PersonnelCompensationElementByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String personnelSettlementDocument )
    {
        super(servicePath, entityCollection);
        this.key.put("PersonnelSettlementDocument", personnelSettlementDocument);
    }

    @Override
    @Nonnull
    protected Class<PersonnelCompensationElement> getEntityClass()
    {
        return PersonnelCompensationElement.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
