/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link PersonnelSettlementDocumentServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PersonnelSettlementDocumentService
 * PersonnelSettlementDocumentService}.
 *
 */
public class DefaultPersonnelSettlementDocumentServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PersonnelSettlementDocumentServiceBatch, PersonnelSettlementDocumentServiceBatchChangeSet>
    implements
    PersonnelSettlementDocumentServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PersonnelSettlementDocumentService service;

    @SuppressWarnings( "deprecation" )
    DefaultPersonnelSettlementDocumentServiceBatchChangeSet(
        @Nonnull final DefaultPersonnelSettlementDocumentServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PersonnelSettlementDocumentService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPersonnelSettlementDocumentServiceBatchChangeSet getThis()
    {
        return this;
    }

}
