/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmt;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmt
 * PersCompnElmntCostAssgmt}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.field.PersCompnElmntCostAssgmtField
 * PersCompnElmntCostAssgmtField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.link.PersCompnElmntCostAssgmtLink
 * PersCompnElmntCostAssgmtLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmt#PERSONNEL_SETTLEMENT_DOCUMENT
 * PERSONNEL_SETTLEMENT_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmt#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmt#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmt#COST_CENTER_RESPONSIBILITY_AREA
 * COST_CENTER_RESPONSIBILITY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmt#NET_AMOUNT
 * NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmt#PERS_SETTLMT_DOC_CURRENCY
 * PERS_SETTLMT_DOC_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmt#PERS_SETTLMT_DOC_CURRENCY_ISO_CODE
 * PERS_SETTLMT_DOC_CURRENCY_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersCompnElmntCostAssgmt#TO_PERSONNEL_COMPENSATION_ELEMENT
 * TO_PERSONNEL_COMPENSATION_ELEMENT}</li>
 * </ul>
 *
 */
public interface PersCompnElmntCostAssgmtSelectable extends EntitySelectable<PersCompnElmntCostAssgmt>
{

}
