/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement
 * PersonnelCompensationElement}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.field.PersonnelCompensationElementField
 * PersonnelCompensationElementField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.link.PersonnelCompensationElementLink
 * PersonnelCompensationElementLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#PERSONNEL_SETTLEMENT_DOCUMENT
 * PERSONNEL_SETTLEMENT_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#SETTLMT_DOC_TYPE
 * SETTLMT_DOC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#SETTLMT_DOC_CAT
 * SETTLMT_DOC_CAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#COMPANY_CODE_COUNTRY
 * COMPANY_CODE_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#COMPANY_CODE_COUNTRY_ISO_CODE
 * COMPANY_CODE_COUNTRY_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#COUNTRY_THREE_DIGIT_ISO_CODE
 * COUNTRY_THREE_DIGIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#PERSON_WORK_AGREEMENT
 * PERSON_WORK_AGREEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#PERSON_WORK_AGREEMENT_EXTERNAL_ID
 * PERSON_WORK_AGREEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#SETTLMT_COMPENSATION_REASON
 * SETTLMT_COMPENSATION_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#SETTLMT_COMPN_VAR
 * SETTLMT_COMPN_VAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#DOCUMENT_DATE
 * DOCUMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#ACTUAL_SETTLMT_DATE
 * ACTUAL_SETTLMT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#TOTAL_NET_AMOUNT
 * TOTAL_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#PERS_SETTLMT_DOC_CURRENCY
 * PERS_SETTLMT_DOC_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#PERS_SETTLMT_DOC_CURRENCY_ISO_CODE
 * PERS_SETTLMT_DOC_CURRENCY_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#DOCUMENT_REFERENCE_ID
 * DOCUMENT_REFERENCE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#ASSIGNMENT_REFERENCE
 * ASSIGNMENT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#PAYMENT_REFERENCE
 * PAYMENT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#PERS_SETTLMT_DOC_IS_REVERSED
 * PERS_SETTLMT_DOC_IS_REVERSED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#RVSD_PERS_SETTLMT_DOC
 * RVSD_PERS_SETTLMT_DOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#JOURNAL_ENTRY_CREATION_DATE
 * JOURNAL_ENTRY_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#JOURNAL_ENTRY_CREATION_TIME
 * JOURNAL_ENTRY_CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#JOURNAL_ENTRY_CREATION_DATE_TIME
 * JOURNAL_ENTRY_CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.personnelsettlementdocument.PersonnelCompensationElement#TO_PERS_COMPN_ELMNT_COST_ASSGMT
 * TO_PERS_COMPN_ELMNT_COST_ASSGMT}</li>
 * </ul>
 *
 */
public interface PersonnelCompensationElementSelectable extends EntitySelectable<PersonnelCompensationElement>
{

}
