/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.field.PhaseRelationshipTypeTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.link.PhaseRelationshipTypeTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.selectable.PhaseRelationshipTypeTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Relationship Type Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PhaseRelationshipTypeTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PhaseRelationshipTypeText extends VdmEntity<PhaseRelationshipTypeText>
{

    /**
     * Selector for all available fields of PhaseRelationshipTypeText.
     *
     */
    public final static PhaseRelationshipTypeTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PhaseRelationshipTypeTextField<String> LANGUAGE =
        new PhaseRelationshipTypeTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PhaseRelationshipTypeKey</b>
     * </p>
     *
     * @return The phaseRelationshipTypeKey contained in this entity.
     */
    @Key
    @SerializedName( "PhaseRelationshipTypeKey" )
    @JsonProperty( "PhaseRelationshipTypeKey" )
    @Nullable
    @ODataField( odataName = "PhaseRelationshipTypeKey" )
    private String phaseRelationshipTypeKey;
    /**
     * Use with available fluent helpers to apply the <b>PhaseRelationshipTypeKey</b> field to query operations.
     *
     */
    public final static PhaseRelationshipTypeTextField<String> PHASE_RELATIONSHIP_TYPE_KEY =
        new PhaseRelationshipTypeTextField<String>("PhaseRelationshipTypeKey");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PhaseRelationshipType</b>
     * </p>
     *
     * @return Short text for the relationship type
     */
    @SerializedName( "PhaseRelationshipType" )
    @JsonProperty( "PhaseRelationshipType" )
    @Nullable
    @ODataField( odataName = "PhaseRelationshipType" )
    private String phaseRelationshipType;
    /**
     * Use with available fluent helpers to apply the <b>PhaseRelationshipType</b> field to query operations.
     *
     */
    public final static PhaseRelationshipTypeTextField<String> PHASE_RELATIONSHIP_TYPE =
        new PhaseRelationshipTypeTextField<String>("PhaseRelationshipType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PhaseRelationshipTypeDesc</b>
     * </p>
     *
     * @return Short text for the type of relationship
     */
    @SerializedName( "PhaseRelationshipTypeDesc" )
    @JsonProperty( "PhaseRelationshipTypeDesc" )
    @Nullable
    @ODataField( odataName = "PhaseRelationshipTypeDesc" )
    private String phaseRelationshipTypeDesc;
    /**
     * Use with available fluent helpers to apply the <b>PhaseRelationshipTypeDesc</b> field to query operations.
     *
     */
    public final static PhaseRelationshipTypeTextField<String> PHASE_RELATIONSHIP_TYPE_DESC =
        new PhaseRelationshipTypeTextField<String>("PhaseRelationshipTypeDesc");
    /**
     * Navigation property <b>to_RelshpType</b> for <b>PhaseRelationshipTypeText</b> to single
     * <b>PhaseRelationshipType</b>.
     *
     */
    @SerializedName( "to_RelshpType" )
    @JsonProperty( "to_RelshpType" )
    @ODataField( odataName = "to_RelshpType" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PhaseRelationshipType toRelshpType;
    /**
     * Use with available fluent helpers to apply the <b>to_RelshpType</b> navigation property to query operations.
     *
     */
    public final static PhaseRelationshipTypeTextOneToOneLink<PhaseRelationshipType> TO_RELSHP_TYPE =
        new PhaseRelationshipTypeTextOneToOneLink<PhaseRelationshipType>("to_RelshpType");

    @Nonnull
    @Override
    public Class<PhaseRelationshipTypeText> getType()
    {
        return PhaseRelationshipTypeText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PhaseRelationshipTypeKey</b>
     * </p>
     *
     * @param phaseRelationshipTypeKey
     *            The phaseRelationshipTypeKey to set.
     */
    public void setPhaseRelationshipTypeKey( @Nullable final String phaseRelationshipTypeKey )
    {
        rememberChangedField("PhaseRelationshipTypeKey", this.phaseRelationshipTypeKey);
        this.phaseRelationshipTypeKey = phaseRelationshipTypeKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PhaseRelationshipType</b>
     * </p>
     *
     * @param phaseRelationshipType
     *            Short text for the relationship type
     */
    public void setPhaseRelationshipType( @Nullable final String phaseRelationshipType )
    {
        rememberChangedField("PhaseRelationshipType", this.phaseRelationshipType);
        this.phaseRelationshipType = phaseRelationshipType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PhaseRelationshipTypeDesc</b>
     * </p>
     *
     * @param phaseRelationshipTypeDesc
     *            Short text for the type of relationship
     */
    public void setPhaseRelationshipTypeDesc( @Nullable final String phaseRelationshipTypeDesc )
    {
        rememberChangedField("PhaseRelationshipTypeDesc", this.phaseRelationshipTypeDesc);
        this.phaseRelationshipTypeDesc = phaseRelationshipTypeDesc;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PhaseRelationshipTypeText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("PhaseRelationshipTypeKey", getPhaseRelationshipTypeKey());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("PhaseRelationshipTypeKey", getPhaseRelationshipTypeKey());
        values.put("PhaseRelationshipType", getPhaseRelationshipType());
        values.put("PhaseRelationshipTypeDesc", getPhaseRelationshipTypeDesc());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("PhaseRelationshipTypeKey") ) {
                final Object value = values.remove("PhaseRelationshipTypeKey");
                if( (value == null) || (!value.equals(getPhaseRelationshipTypeKey())) ) {
                    setPhaseRelationshipTypeKey(((String) value));
                }
            }
            if( values.containsKey("PhaseRelationshipType") ) {
                final Object value = values.remove("PhaseRelationshipType");
                if( (value == null) || (!value.equals(getPhaseRelationshipType())) ) {
                    setPhaseRelationshipType(((String) value));
                }
            }
            if( values.containsKey("PhaseRelationshipTypeDesc") ) {
                final Object value = values.remove("PhaseRelationshipTypeDesc");
                if( (value == null) || (!value.equals(getPhaseRelationshipTypeDesc())) ) {
                    setPhaseRelationshipTypeDesc(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_RelshpType") ) {
                final Object value = (values).remove("to_RelshpType");
                if( value instanceof Map ) {
                    if( toRelshpType == null ) {
                        toRelshpType = new PhaseRelationshipType();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRelshpType.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PhaseRelationshipTypeTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PhaseRelationshipTypeTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PhaseRelationshipTypeTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PhaseRelationshipTypeTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhaseRelationshipTypeService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toRelshpType != null ) {
            (values).put("to_RelshpType", toRelshpType);
        }
        return values;
    }

    /**
     * Fetches the <b>PhaseRelationshipType</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_RelshpType</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PhaseRelationshipType</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PhaseRelationshipType fetchRelshpType()
    {
        return fetchFieldAsSingle("to_RelshpType", PhaseRelationshipType.class);
    }

    /**
     * Retrieval of associated <b>PhaseRelationshipType</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_RelshpType</b>.
     * <p>
     * If the navigation property <b>to_RelshpType</b> of a queried <b>PhaseRelationshipTypeText</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PhaseRelationshipType</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PhaseRelationshipType getRelshpTypeOrFetch()
    {
        if( toRelshpType == null ) {
            toRelshpType = fetchRelshpType();
        }
        return toRelshpType;
    }

    /**
     * Retrieval of associated <b>PhaseRelationshipType</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_RelshpType</b>.
     * <p>
     * If the navigation property for an entity <b>PhaseRelationshipTypeText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RelshpType</b> is already loaded, the result will
     *         contain the <b>PhaseRelationshipType</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PhaseRelationshipType> getRelshpTypeIfPresent()
    {
        return Option.of(toRelshpType);
    }

    /**
     * Overwrites the associated <b>PhaseRelationshipType</b> entity for the loaded navigation property
     * <b>to_RelshpType</b>.
     *
     * @param value
     *            New <b>PhaseRelationshipType</b> entity.
     */
    public void setRelshpType( final PhaseRelationshipType value )
    {
        toRelshpType = value;
    }

    /**
     * Helper class to allow for fluent creation of PhaseRelationshipTypeText instances.
     *
     */
    public final static class PhaseRelationshipTypeTextBuilder
    {

        private PhaseRelationshipType toRelshpType;

        private PhaseRelationshipTypeText.PhaseRelationshipTypeTextBuilder toRelshpType(
            final PhaseRelationshipType value )
        {
            toRelshpType = value;
            return this;
        }

        /**
         * Navigation property <b>to_RelshpType</b> for <b>PhaseRelationshipTypeText</b> to single
         * <b>PhaseRelationshipType</b>.
         *
         * @param value
         *            The PhaseRelationshipType to build this PhaseRelationshipTypeText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PhaseRelationshipTypeText.PhaseRelationshipTypeTextBuilder relshpType(
            final PhaseRelationshipType value )
        {
            return toRelshpType(value);
        }

    }

}
