/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PhaseRelationshipTypeServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhaseRelationshipTypeService PhaseRelationshipTypeService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultPhaseRelationshipTypeServiceBatch
    extends
    BatchFluentHelperBasic<PhaseRelationshipTypeServiceBatch, PhaseRelationshipTypeServiceBatchChangeSet>
    implements
    PhaseRelationshipTypeServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhaseRelationshipTypeService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPhaseRelationshipTypeServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPhaseRelationshipTypeServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhaseRelationshipTypeService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhaseRelationshipTypeService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPhaseRelationshipTypeServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPhaseRelationshipTypeServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhaseRelationshipTypeService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPhaseRelationshipTypeServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PhaseRelationshipTypeServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPhaseRelationshipTypeServiceBatchChangeSet(this, service);
    }

}
