/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link PhaseRelationshipTypeServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhaseRelationshipTypeService PhaseRelationshipTypeService}.
 *
 */
public class DefaultPhaseRelationshipTypeServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PhaseRelationshipTypeServiceBatch, PhaseRelationshipTypeServiceBatchChangeSet>
    implements
    PhaseRelationshipTypeServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhaseRelationshipTypeService service;

    @SuppressWarnings( "deprecation" )
    DefaultPhaseRelationshipTypeServiceBatchChangeSet(
        @Nonnull final DefaultPhaseRelationshipTypeServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhaseRelationshipTypeService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPhaseRelationshipTypeServiceBatchChangeSet getThis()
    {
        return this;
    }

}
