/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipType;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipType
 * PhaseRelationshipType}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.field.PhaseRelationshipTypeField
 * PhaseRelationshipTypeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.link.PhaseRelationshipTypeLink
 * PhaseRelationshipTypeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipType#PHASE_RELATIONSHIP_TYPE_KEY
 * PHASE_RELATIONSHIP_TYPE_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipType#PHASE_RELATIONSHIP_TYPE
 * PHASE_RELATIONSHIP_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipType#PHASE_RELATIONSHIP_TYPE_DESC
 * PHASE_RELATIONSHIP_TYPE_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipType#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface PhaseRelationshipTypeSelectable extends EntitySelectable<PhaseRelationshipType>
{

}
