/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeText
 * PhaseRelationshipTypeText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.field.PhaseRelationshipTypeTextField
 * PhaseRelationshipTypeTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.link.PhaseRelationshipTypeTextLink
 * PhaseRelationshipTypeTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeText#PHASE_RELATIONSHIP_TYPE_KEY
 * PHASE_RELATIONSHIP_TYPE_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeText#PHASE_RELATIONSHIP_TYPE
 * PHASE_RELATIONSHIP_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeText#PHASE_RELATIONSHIP_TYPE_DESC
 * PHASE_RELATIONSHIP_TYPE_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.phaserelationshiptype.PhaseRelationshipTypeText#TO_RELSHP_TYPE
 * TO_RELSHP_TYPE}</li>
 * </ul>
 *
 */
public interface PhaseRelationshipTypeTextSelectable extends EntitySelectable<PhaseRelationshipTypeText>
{

}
