/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.field.PhysInventoryDocHeaderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.link.PhysInventoryDocHeaderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.selectable.PhysInventoryDocHeaderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Document Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PhysInventoryDocHeaderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PhysInventoryDocHeader extends VdmEntity<PhysInventoryDocHeader>
{

    /**
     * Selector for all available fields of PhysInventoryDocHeader.
     *
     */
    public final static PhysInventoryDocHeaderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @Key
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<String> FISCAL_YEAR =
        new PhysInventoryDocHeaderField<String>("FiscalYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocument</b>
     * </p>
     *
     * @return Physical Inventory Document
     */
    @Key
    @SerializedName( "PhysicalInventoryDocument" )
    @JsonProperty( "PhysicalInventoryDocument" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryDocument" )
    private String physicalInventoryDocument;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryDocument</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<String> PHYSICAL_INVENTORY_DOCUMENT =
        new PhysInventoryDocHeaderField<String>("PhysicalInventoryDocument");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InventoryTransactionType</b>
     * </p>
     *
     * @return Inventory Transaction Type
     */
    @SerializedName( "InventoryTransactionType" )
    @JsonProperty( "InventoryTransactionType" )
    @Nullable
    @ODataField( odataName = "InventoryTransactionType" )
    private String inventoryTransactionType;
    /**
     * Use with available fluent helpers to apply the <b>InventoryTransactionType</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<String> INVENTORY_TRANSACTION_TYPE =
        new PhysInventoryDocHeaderField<String>("InventoryTransactionType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<String> PLANT = new PhysInventoryDocHeaderField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<String> STORAGE_LOCATION =
        new PhysInventoryDocHeaderField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @return Special Stock Indicator
     */
    @SerializedName( "InventorySpecialStockType" )
    @JsonProperty( "InventorySpecialStockType" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockType" )
    private String inventorySpecialStockType;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockType</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<String> INVENTORY_SPECIAL_STOCK_TYPE =
        new PhysInventoryDocHeaderField<String>("InventorySpecialStockType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @return Document Date in Document
     */
    @SerializedName( "DocumentDate" )
    @JsonProperty( "DocumentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DocumentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime documentDate;
    /**
     * Use with available fluent helpers to apply the <b>DocumentDate</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<LocalDateTime> DOCUMENT_DATE =
        new PhysInventoryDocHeaderField<LocalDateTime>("DocumentDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PhysInventoryPlannedCountDate</b>
     * </p>
     *
     * @return Planned Date of Inventory Count
     */
    @SerializedName( "PhysInventoryPlannedCountDate" )
    @JsonProperty( "PhysInventoryPlannedCountDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PhysInventoryPlannedCountDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime physInventoryPlannedCountDate;
    /**
     * Use with available fluent helpers to apply the <b>PhysInventoryPlannedCountDate</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<LocalDateTime> PHYS_INVENTORY_PLANNED_COUNT_DATE =
        new PhysInventoryDocHeaderField<LocalDateTime>("PhysInventoryPlannedCountDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryLastCountDate</b>
     * </p>
     *
     * @return Date of Last Count
     */
    @SerializedName( "PhysicalInventoryLastCountDate" )
    @JsonProperty( "PhysicalInventoryLastCountDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PhysicalInventoryLastCountDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime physicalInventoryLastCountDate;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryLastCountDate</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<LocalDateTime> PHYSICAL_INVENTORY_LAST_COUNT_DATE =
        new PhysInventoryDocHeaderField<LocalDateTime>("PhysicalInventoryLastCountDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting Date in the Document
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<LocalDateTime> POSTING_DATE =
        new PhysInventoryDocHeaderField<LocalDateTime>("PostingDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @return Posting Period
     */
    @SerializedName( "FiscalPeriod" )
    @JsonProperty( "FiscalPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalPeriod" )
    private String fiscalPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriod</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<String> FISCAL_PERIOD =
        new PhysInventoryDocHeaderField<String>("FiscalPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Physical Inventory Created by User
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<String> CREATED_BY_USER =
        new PhysInventoryDocHeaderField<String>("CreatedByUser");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PostingIsBlockedForPhysInvtry</b>
     * </p>
     *
     * @return Posting Block Due to Physical Inventory
     */
    @SerializedName( "PostingIsBlockedForPhysInvtry" )
    @JsonProperty( "PostingIsBlockedForPhysInvtry" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PostingIsBlockedForPhysInvtry" )
    private Boolean postingIsBlockedForPhysInvtry;
    /**
     * Use with available fluent helpers to apply the <b>PostingIsBlockedForPhysInvtry</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<Boolean> POSTING_IS_BLOCKED_FOR_PHYS_INVTRY =
        new PhysInventoryDocHeaderField<Boolean>("PostingIsBlockedForPhysInvtry");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryCountStatus</b>
     * </p>
     *
     * @return Count Status
     */
    @SerializedName( "PhysicalInventoryCountStatus" )
    @JsonProperty( "PhysicalInventoryCountStatus" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryCountStatus" )
    private String physicalInventoryCountStatus;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryCountStatus</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<String> PHYSICAL_INVENTORY_COUNT_STATUS =
        new PhysInventoryDocHeaderField<String>("PhysicalInventoryCountStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PhysInvtryAdjustmentPostingSts</b>
     * </p>
     *
     * @return Status of Adjustment Posting (Inventory Differences)
     */
    @SerializedName( "PhysInvtryAdjustmentPostingSts" )
    @JsonProperty( "PhysInvtryAdjustmentPostingSts" )
    @Nullable
    @ODataField( odataName = "PhysInvtryAdjustmentPostingSts" )
    private String physInvtryAdjustmentPostingSts;
    /**
     * Use with available fluent helpers to apply the <b>PhysInvtryAdjustmentPostingSts</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<String> PHYS_INVTRY_ADJUSTMENT_POSTING_STS =
        new PhysInventoryDocHeaderField<String>("PhysInvtryAdjustmentPostingSts");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PhysInvtryDeletionStatus</b>
     * </p>
     *
     * @return Status of Deletion
     */
    @SerializedName( "PhysInvtryDeletionStatus" )
    @JsonProperty( "PhysInvtryDeletionStatus" )
    @Nullable
    @ODataField( odataName = "PhysInvtryDeletionStatus" )
    private String physInvtryDeletionStatus;
    /**
     * Use with available fluent helpers to apply the <b>PhysInvtryDeletionStatus</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<String> PHYS_INVTRY_DELETION_STATUS =
        new PhysInventoryDocHeaderField<String>("PhysInvtryDeletionStatus");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PhysInvtryDocHasQtySnapshot</b>
     * </p>
     *
     * @return Book Inventory Freeze
     */
    @SerializedName( "PhysInvtryDocHasQtySnapshot" )
    @JsonProperty( "PhysInvtryDocHasQtySnapshot" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PhysInvtryDocHasQtySnapshot" )
    private Boolean physInvtryDocHasQtySnapshot;
    /**
     * Use with available fluent helpers to apply the <b>PhysInvtryDocHasQtySnapshot</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<Boolean> PHYS_INVTRY_DOC_HAS_QTY_SNAPSHOT =
        new PhysInventoryDocHeaderField<Boolean>("PhysInvtryDocHasQtySnapshot");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryGroupType</b>
     * </p>
     *
     * @return Type of Grouping Criterion
     */
    @SerializedName( "PhysicalInventoryGroupType" )
    @JsonProperty( "PhysicalInventoryGroupType" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryGroupType" )
    private String physicalInventoryGroupType;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryGroupType</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<String> PHYSICAL_INVENTORY_GROUP_TYPE =
        new PhysInventoryDocHeaderField<String>("PhysicalInventoryGroupType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryGroup</b>
     * </p>
     *
     * @return Grouping Criterion of Physical Inventory Document Item
     */
    @SerializedName( "PhysicalInventoryGroup" )
    @JsonProperty( "PhysicalInventoryGroup" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryGroup" )
    private String physicalInventoryGroup;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryGroup</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<String> PHYSICAL_INVENTORY_GROUP =
        new PhysInventoryDocHeaderField<String>("PhysicalInventoryGroup");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryNumber</b>
     * </p>
     *
     * @return Physical Inventory Number
     */
    @SerializedName( "PhysicalInventoryNumber" )
    @JsonProperty( "PhysicalInventoryNumber" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryNumber" )
    private String physicalInventoryNumber;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryNumber</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<String> PHYSICAL_INVENTORY_NUMBER =
        new PhysInventoryDocHeaderField<String>("PhysicalInventoryNumber");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PhysInventoryReferenceNumber</b>
     * </p>
     *
     * @return Physical Inventory Reference
     */
    @SerializedName( "PhysInventoryReferenceNumber" )
    @JsonProperty( "PhysInventoryReferenceNumber" )
    @Nullable
    @ODataField( odataName = "PhysInventoryReferenceNumber" )
    private String physInventoryReferenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>PhysInventoryReferenceNumber</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<String> PHYS_INVENTORY_REFERENCE_NUMBER =
        new PhysInventoryDocHeaderField<String>("PhysInventoryReferenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocumentDesc</b>
     * </p>
     *
     * @return Description of Physical Inventory Document
     */
    @SerializedName( "PhysicalInventoryDocumentDesc" )
    @JsonProperty( "PhysicalInventoryDocumentDesc" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryDocumentDesc" )
    private String physicalInventoryDocumentDesc;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryDocumentDesc</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<String> PHYSICAL_INVENTORY_DOCUMENT_DESC =
        new PhysInventoryDocHeaderField<String>("PhysicalInventoryDocumentDesc");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryType</b>
     * </p>
     *
     * @return Physical Inventory Type
     */
    @SerializedName( "PhysicalInventoryType" )
    @JsonProperty( "PhysicalInventoryType" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryType" )
    private String physicalInventoryType;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryType</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<String> PHYSICAL_INVENTORY_TYPE =
        new PhysInventoryDocHeaderField<String>("PhysicalInventoryType");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Change Timestamp
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static PhysInventoryDocHeaderField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new PhysInventoryDocHeaderField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Navigation property <b>to_PhysicalInventoryDocumentItem</b> for <b>PhysInventoryDocHeader</b> to multiple
     * <b>PhysInventoryDocItem</b>.
     *
     */
    @SerializedName( "to_PhysicalInventoryDocumentItem" )
    @JsonProperty( "to_PhysicalInventoryDocumentItem" )
    @ODataField( odataName = "to_PhysicalInventoryDocumentItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PhysInventoryDocItem> toPhysicalInventoryDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>to_PhysicalInventoryDocumentItem</b> navigation property to
     * query operations.
     *
     */
    public final static PhysInventoryDocHeaderLink<PhysInventoryDocItem> TO_PHYSICAL_INVENTORY_DOCUMENT_ITEM =
        new PhysInventoryDocHeaderLink<PhysInventoryDocItem>("to_PhysicalInventoryDocumentItem");

    @Nonnull
    @Override
    public Class<PhysInventoryDocHeader> getType()
    {
        return PhysInventoryDocHeader.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocument</b>
     * </p>
     *
     * @param physicalInventoryDocument
     *            Physical Inventory Document
     */
    public void setPhysicalInventoryDocument( @Nullable final String physicalInventoryDocument )
    {
        rememberChangedField("PhysicalInventoryDocument", this.physicalInventoryDocument);
        this.physicalInventoryDocument = physicalInventoryDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InventoryTransactionType</b>
     * </p>
     *
     * @param inventoryTransactionType
     *            Inventory Transaction Type
     */
    public void setInventoryTransactionType( @Nullable final String inventoryTransactionType )
    {
        rememberChangedField("InventoryTransactionType", this.inventoryTransactionType);
        this.inventoryTransactionType = inventoryTransactionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @param inventorySpecialStockType
     *            Special Stock Indicator
     */
    public void setInventorySpecialStockType( @Nullable final String inventorySpecialStockType )
    {
        rememberChangedField("InventorySpecialStockType", this.inventorySpecialStockType);
        this.inventorySpecialStockType = inventorySpecialStockType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @param documentDate
     *            Document Date in Document
     */
    public void setDocumentDate( @Nullable final LocalDateTime documentDate )
    {
        rememberChangedField("DocumentDate", this.documentDate);
        this.documentDate = documentDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PhysInventoryPlannedCountDate</b>
     * </p>
     *
     * @param physInventoryPlannedCountDate
     *            Planned Date of Inventory Count
     */
    public void setPhysInventoryPlannedCountDate( @Nullable final LocalDateTime physInventoryPlannedCountDate )
    {
        rememberChangedField("PhysInventoryPlannedCountDate", this.physInventoryPlannedCountDate);
        this.physInventoryPlannedCountDate = physInventoryPlannedCountDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryLastCountDate</b>
     * </p>
     *
     * @param physicalInventoryLastCountDate
     *            Date of Last Count
     */
    public void setPhysicalInventoryLastCountDate( @Nullable final LocalDateTime physicalInventoryLastCountDate )
    {
        rememberChangedField("PhysicalInventoryLastCountDate", this.physicalInventoryLastCountDate);
        this.physicalInventoryLastCountDate = physicalInventoryLastCountDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date in the Document
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @param fiscalPeriod
     *            Posting Period
     */
    public void setFiscalPeriod( @Nullable final String fiscalPeriod )
    {
        rememberChangedField("FiscalPeriod", this.fiscalPeriod);
        this.fiscalPeriod = fiscalPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Physical Inventory Created by User
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PostingIsBlockedForPhysInvtry</b>
     * </p>
     *
     * @param postingIsBlockedForPhysInvtry
     *            Posting Block Due to Physical Inventory
     */
    public void setPostingIsBlockedForPhysInvtry( @Nullable final Boolean postingIsBlockedForPhysInvtry )
    {
        rememberChangedField("PostingIsBlockedForPhysInvtry", this.postingIsBlockedForPhysInvtry);
        this.postingIsBlockedForPhysInvtry = postingIsBlockedForPhysInvtry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryCountStatus</b>
     * </p>
     *
     * @param physicalInventoryCountStatus
     *            Count Status
     */
    public void setPhysicalInventoryCountStatus( @Nullable final String physicalInventoryCountStatus )
    {
        rememberChangedField("PhysicalInventoryCountStatus", this.physicalInventoryCountStatus);
        this.physicalInventoryCountStatus = physicalInventoryCountStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PhysInvtryAdjustmentPostingSts</b>
     * </p>
     *
     * @param physInvtryAdjustmentPostingSts
     *            Status of Adjustment Posting (Inventory Differences)
     */
    public void setPhysInvtryAdjustmentPostingSts( @Nullable final String physInvtryAdjustmentPostingSts )
    {
        rememberChangedField("PhysInvtryAdjustmentPostingSts", this.physInvtryAdjustmentPostingSts);
        this.physInvtryAdjustmentPostingSts = physInvtryAdjustmentPostingSts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PhysInvtryDeletionStatus</b>
     * </p>
     *
     * @param physInvtryDeletionStatus
     *            Status of Deletion
     */
    public void setPhysInvtryDeletionStatus( @Nullable final String physInvtryDeletionStatus )
    {
        rememberChangedField("PhysInvtryDeletionStatus", this.physInvtryDeletionStatus);
        this.physInvtryDeletionStatus = physInvtryDeletionStatus;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PhysInvtryDocHasQtySnapshot</b>
     * </p>
     *
     * @param physInvtryDocHasQtySnapshot
     *            Book Inventory Freeze
     */
    public void setPhysInvtryDocHasQtySnapshot( @Nullable final Boolean physInvtryDocHasQtySnapshot )
    {
        rememberChangedField("PhysInvtryDocHasQtySnapshot", this.physInvtryDocHasQtySnapshot);
        this.physInvtryDocHasQtySnapshot = physInvtryDocHasQtySnapshot;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryGroupType</b>
     * </p>
     *
     * @param physicalInventoryGroupType
     *            Type of Grouping Criterion
     */
    public void setPhysicalInventoryGroupType( @Nullable final String physicalInventoryGroupType )
    {
        rememberChangedField("PhysicalInventoryGroupType", this.physicalInventoryGroupType);
        this.physicalInventoryGroupType = physicalInventoryGroupType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryGroup</b>
     * </p>
     *
     * @param physicalInventoryGroup
     *            Grouping Criterion of Physical Inventory Document Item
     */
    public void setPhysicalInventoryGroup( @Nullable final String physicalInventoryGroup )
    {
        rememberChangedField("PhysicalInventoryGroup", this.physicalInventoryGroup);
        this.physicalInventoryGroup = physicalInventoryGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryNumber</b>
     * </p>
     *
     * @param physicalInventoryNumber
     *            Physical Inventory Number
     */
    public void setPhysicalInventoryNumber( @Nullable final String physicalInventoryNumber )
    {
        rememberChangedField("PhysicalInventoryNumber", this.physicalInventoryNumber);
        this.physicalInventoryNumber = physicalInventoryNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PhysInventoryReferenceNumber</b>
     * </p>
     *
     * @param physInventoryReferenceNumber
     *            Physical Inventory Reference
     */
    public void setPhysInventoryReferenceNumber( @Nullable final String physInventoryReferenceNumber )
    {
        rememberChangedField("PhysInventoryReferenceNumber", this.physInventoryReferenceNumber);
        this.physInventoryReferenceNumber = physInventoryReferenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocumentDesc</b>
     * </p>
     *
     * @param physicalInventoryDocumentDesc
     *            Description of Physical Inventory Document
     */
    public void setPhysicalInventoryDocumentDesc( @Nullable final String physicalInventoryDocumentDesc )
    {
        rememberChangedField("PhysicalInventoryDocumentDesc", this.physicalInventoryDocumentDesc);
        this.physicalInventoryDocumentDesc = physicalInventoryDocumentDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryType</b>
     * </p>
     *
     * @param physicalInventoryType
     *            Physical Inventory Type
     */
    public void setPhysicalInventoryType( @Nullable final String physicalInventoryType )
    {
        rememberChangedField("PhysicalInventoryType", this.physicalInventoryType);
        this.physicalInventoryType = physicalInventoryType;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Change Timestamp
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PhysInventoryDocHeader";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FiscalYear", getFiscalYear());
        result.put("PhysicalInventoryDocument", getPhysicalInventoryDocument());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FiscalYear", getFiscalYear());
        values.put("PhysicalInventoryDocument", getPhysicalInventoryDocument());
        values.put("InventoryTransactionType", getInventoryTransactionType());
        values.put("Plant", getPlant());
        values.put("StorageLocation", getStorageLocation());
        values.put("InventorySpecialStockType", getInventorySpecialStockType());
        values.put("DocumentDate", getDocumentDate());
        values.put("PhysInventoryPlannedCountDate", getPhysInventoryPlannedCountDate());
        values.put("PhysicalInventoryLastCountDate", getPhysicalInventoryLastCountDate());
        values.put("PostingDate", getPostingDate());
        values.put("FiscalPeriod", getFiscalPeriod());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("PostingIsBlockedForPhysInvtry", getPostingIsBlockedForPhysInvtry());
        values.put("PhysicalInventoryCountStatus", getPhysicalInventoryCountStatus());
        values.put("PhysInvtryAdjustmentPostingSts", getPhysInvtryAdjustmentPostingSts());
        values.put("PhysInvtryDeletionStatus", getPhysInvtryDeletionStatus());
        values.put("PhysInvtryDocHasQtySnapshot", getPhysInvtryDocHasQtySnapshot());
        values.put("PhysicalInventoryGroupType", getPhysicalInventoryGroupType());
        values.put("PhysicalInventoryGroup", getPhysicalInventoryGroup());
        values.put("PhysicalInventoryNumber", getPhysicalInventoryNumber());
        values.put("PhysInventoryReferenceNumber", getPhysInventoryReferenceNumber());
        values.put("PhysicalInventoryDocumentDesc", getPhysicalInventoryDocumentDesc());
        values.put("PhysicalInventoryType", getPhysicalInventoryType());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryDocument") ) {
                final Object value = values.remove("PhysicalInventoryDocument");
                if( (value == null) || (!value.equals(getPhysicalInventoryDocument())) ) {
                    setPhysicalInventoryDocument(((String) value));
                }
            }
            if( values.containsKey("InventoryTransactionType") ) {
                final Object value = values.remove("InventoryTransactionType");
                if( (value == null) || (!value.equals(getInventoryTransactionType())) ) {
                    setInventoryTransactionType(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("InventorySpecialStockType") ) {
                final Object value = values.remove("InventorySpecialStockType");
                if( (value == null) || (!value.equals(getInventorySpecialStockType())) ) {
                    setInventorySpecialStockType(((String) value));
                }
            }
            if( values.containsKey("DocumentDate") ) {
                final Object value = values.remove("DocumentDate");
                if( (value == null) || (!value.equals(getDocumentDate())) ) {
                    setDocumentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PhysInventoryPlannedCountDate") ) {
                final Object value = values.remove("PhysInventoryPlannedCountDate");
                if( (value == null) || (!value.equals(getPhysInventoryPlannedCountDate())) ) {
                    setPhysInventoryPlannedCountDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PhysicalInventoryLastCountDate") ) {
                final Object value = values.remove("PhysicalInventoryLastCountDate");
                if( (value == null) || (!value.equals(getPhysicalInventoryLastCountDate())) ) {
                    setPhysicalInventoryLastCountDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FiscalPeriod") ) {
                final Object value = values.remove("FiscalPeriod");
                if( (value == null) || (!value.equals(getFiscalPeriod())) ) {
                    setFiscalPeriod(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("PostingIsBlockedForPhysInvtry") ) {
                final Object value = values.remove("PostingIsBlockedForPhysInvtry");
                if( (value == null) || (!value.equals(getPostingIsBlockedForPhysInvtry())) ) {
                    setPostingIsBlockedForPhysInvtry(((Boolean) value));
                }
            }
            if( values.containsKey("PhysicalInventoryCountStatus") ) {
                final Object value = values.remove("PhysicalInventoryCountStatus");
                if( (value == null) || (!value.equals(getPhysicalInventoryCountStatus())) ) {
                    setPhysicalInventoryCountStatus(((String) value));
                }
            }
            if( values.containsKey("PhysInvtryAdjustmentPostingSts") ) {
                final Object value = values.remove("PhysInvtryAdjustmentPostingSts");
                if( (value == null) || (!value.equals(getPhysInvtryAdjustmentPostingSts())) ) {
                    setPhysInvtryAdjustmentPostingSts(((String) value));
                }
            }
            if( values.containsKey("PhysInvtryDeletionStatus") ) {
                final Object value = values.remove("PhysInvtryDeletionStatus");
                if( (value == null) || (!value.equals(getPhysInvtryDeletionStatus())) ) {
                    setPhysInvtryDeletionStatus(((String) value));
                }
            }
            if( values.containsKey("PhysInvtryDocHasQtySnapshot") ) {
                final Object value = values.remove("PhysInvtryDocHasQtySnapshot");
                if( (value == null) || (!value.equals(getPhysInvtryDocHasQtySnapshot())) ) {
                    setPhysInvtryDocHasQtySnapshot(((Boolean) value));
                }
            }
            if( values.containsKey("PhysicalInventoryGroupType") ) {
                final Object value = values.remove("PhysicalInventoryGroupType");
                if( (value == null) || (!value.equals(getPhysicalInventoryGroupType())) ) {
                    setPhysicalInventoryGroupType(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryGroup") ) {
                final Object value = values.remove("PhysicalInventoryGroup");
                if( (value == null) || (!value.equals(getPhysicalInventoryGroup())) ) {
                    setPhysicalInventoryGroup(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryNumber") ) {
                final Object value = values.remove("PhysicalInventoryNumber");
                if( (value == null) || (!value.equals(getPhysicalInventoryNumber())) ) {
                    setPhysicalInventoryNumber(((String) value));
                }
            }
            if( values.containsKey("PhysInventoryReferenceNumber") ) {
                final Object value = values.remove("PhysInventoryReferenceNumber");
                if( (value == null) || (!value.equals(getPhysInventoryReferenceNumber())) ) {
                    setPhysInventoryReferenceNumber(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryDocumentDesc") ) {
                final Object value = values.remove("PhysicalInventoryDocumentDesc");
                if( (value == null) || (!value.equals(getPhysicalInventoryDocumentDesc())) ) {
                    setPhysicalInventoryDocumentDesc(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryType") ) {
                final Object value = values.remove("PhysicalInventoryType");
                if( (value == null) || (!value.equals(getPhysicalInventoryType())) ) {
                    setPhysicalInventoryType(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PhysicalInventoryDocumentItem") ) {
                final Object value = (values).remove("to_PhysicalInventoryDocumentItem");
                if( value instanceof Iterable ) {
                    if( toPhysicalInventoryDocumentItem == null ) {
                        toPhysicalInventoryDocumentItem = Lists.newArrayList();
                    } else {
                        toPhysicalInventoryDocumentItem = Lists.newArrayList(toPhysicalInventoryDocumentItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PhysInventoryDocItem entity;
                        if( toPhysicalInventoryDocumentItem.size() > i ) {
                            entity = toPhysicalInventoryDocumentItem.get(i);
                        } else {
                            entity = new PhysInventoryDocItem();
                            toPhysicalInventoryDocumentItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PhysInventoryDocHeaderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PhysInventoryDocHeaderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PhysInventoryDocHeaderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PhysInventoryDocHeaderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhysicalInventoryDocumentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPhysicalInventoryDocumentItem != null ) {
            (values).put("to_PhysicalInventoryDocumentItem", toPhysicalInventoryDocumentItem);
        }
        return values;
    }

    /**
     * Fetches the <b>PhysInventoryDocItem</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PhysicalInventoryDocumentItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PhysInventoryDocItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PhysInventoryDocItem> fetchPhysicalInventoryDocumentItem()
    {
        return fetchFieldAsList("to_PhysicalInventoryDocumentItem", PhysInventoryDocItem.class);
    }

    /**
     * Retrieval of associated <b>PhysInventoryDocItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PhysicalInventoryDocumentItem</b>.
     * <p>
     * If the navigation property <b>to_PhysicalInventoryDocumentItem</b> of a queried <b>PhysInventoryDocHeader</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PhysInventoryDocItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PhysInventoryDocItem> getPhysicalInventoryDocumentItemOrFetch()
    {
        if( toPhysicalInventoryDocumentItem == null ) {
            toPhysicalInventoryDocumentItem = fetchPhysicalInventoryDocumentItem();
        }
        return toPhysicalInventoryDocumentItem;
    }

    /**
     * Retrieval of associated <b>PhysInventoryDocItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PhysicalInventoryDocumentItem</b>.
     * <p>
     * If the navigation property for an entity <b>PhysInventoryDocHeader</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PhysicalInventoryDocumentItem</b> is already loaded, the
     *         result will contain the <b>PhysInventoryDocItem</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PhysInventoryDocItem>> getPhysicalInventoryDocumentItemIfPresent()
    {
        return Option.of(toPhysicalInventoryDocumentItem);
    }

    /**
     * Overwrites the list of associated <b>PhysInventoryDocItem</b> entities for the loaded navigation property
     * <b>to_PhysicalInventoryDocumentItem</b>.
     * <p>
     * If the navigation property <b>to_PhysicalInventoryDocumentItem</b> of a queried <b>PhysInventoryDocHeader</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PhysInventoryDocItem</b> entities.
     */
    public void setPhysicalInventoryDocumentItem( @Nonnull final List<PhysInventoryDocItem> value )
    {
        if( toPhysicalInventoryDocumentItem == null ) {
            toPhysicalInventoryDocumentItem = Lists.newArrayList();
        }
        toPhysicalInventoryDocumentItem.clear();
        toPhysicalInventoryDocumentItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PhysInventoryDocItem</b> entities. This corresponds to the OData
     * navigation property <b>to_PhysicalInventoryDocumentItem</b>.
     * <p>
     * If the navigation property <b>to_PhysicalInventoryDocumentItem</b> of a queried <b>PhysInventoryDocHeader</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PhysInventoryDocItem</b> entities.
     */
    public void addPhysicalInventoryDocumentItem( PhysInventoryDocItem... entity )
    {
        if( toPhysicalInventoryDocumentItem == null ) {
            toPhysicalInventoryDocumentItem = Lists.newArrayList();
        }
        toPhysicalInventoryDocumentItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PhysInventoryDocHeader instances.
     *
     */
    public final static class PhysInventoryDocHeaderBuilder
    {

        private List<PhysInventoryDocItem> toPhysicalInventoryDocumentItem = Lists.newArrayList();

        private PhysInventoryDocHeader.PhysInventoryDocHeaderBuilder toPhysicalInventoryDocumentItem(
            final List<PhysInventoryDocItem> value )
        {
            toPhysicalInventoryDocumentItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PhysicalInventoryDocumentItem</b> for <b>PhysInventoryDocHeader</b> to multiple
         * <b>PhysInventoryDocItem</b>.
         *
         * @param value
         *            The PhysInventoryDocItems to build this PhysInventoryDocHeader with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PhysInventoryDocHeader.PhysInventoryDocHeaderBuilder physicalInventoryDocumentItem(
            PhysInventoryDocItem... value )
        {
            return toPhysicalInventoryDocumentItem(Lists.newArrayList(value));
        }

    }

}
