/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.field.PhysInventoryDocItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.link.PhysInventoryDocItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.link.PhysInventoryDocItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.selectable.PhysInventoryDocItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Document Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PhysInventoryDocItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PhysInventoryDocItem extends VdmEntity<PhysInventoryDocItem>
{

    /**
     * Selector for all available fields of PhysInventoryDocItem.
     *
     */
    public final static PhysInventoryDocItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @Key
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> FISCAL_YEAR =
        new PhysInventoryDocItemField<String>("FiscalYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocument</b>
     * </p>
     *
     * @return Physical Inventory Document
     */
    @Key
    @SerializedName( "PhysicalInventoryDocument" )
    @JsonProperty( "PhysicalInventoryDocument" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryDocument" )
    private String physicalInventoryDocument;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryDocument</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> PHYSICAL_INVENTORY_DOCUMENT =
        new PhysInventoryDocItemField<String>("PhysicalInventoryDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocumentItem</b>
     * </p>
     *
     * @return Physical Inventory Item Number
     */
    @Key
    @SerializedName( "PhysicalInventoryDocumentItem" )
    @JsonProperty( "PhysicalInventoryDocumentItem" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryDocumentItem" )
    private String physicalInventoryDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryDocumentItem</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> PHYSICAL_INVENTORY_DOCUMENT_ITEM =
        new PhysInventoryDocItemField<String>("PhysicalInventoryDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> PLANT = new PhysInventoryDocItemField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> STORAGE_LOCATION =
        new PhysInventoryDocItemField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> MATERIAL = new PhysInventoryDocItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> BATCH = new PhysInventoryDocItemField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @return Special Stock Type
     */
    @SerializedName( "InventorySpecialStockType" )
    @JsonProperty( "InventorySpecialStockType" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockType" )
    private String inventorySpecialStockType;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockType</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> INVENTORY_SPECIAL_STOCK_TYPE =
        new PhysInventoryDocItemField<String>("InventorySpecialStockType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryStockType</b>
     * </p>
     *
     * @return Stock Type (Physical Inventory)
     */
    @SerializedName( "PhysicalInventoryStockType" )
    @JsonProperty( "PhysicalInventoryStockType" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryStockType" )
    private String physicalInventoryStockType;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryStockType</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> PHYSICAL_INVENTORY_STOCK_TYPE =
        new PhysInventoryDocItemField<String>("PhysicalInventoryStockType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order Number
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> SALES_ORDER =
        new PhysInventoryDocItemField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Item Number in Sales Order
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> SALES_ORDER_ITEM =
        new PhysInventoryDocItemField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier's Account Number
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> SUPPLIER = new PhysInventoryDocItemField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Account number of customer
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> CUSTOMER = new PhysInventoryDocItemField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> WBS_ELEMENT =
        new PhysInventoryDocItemField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeUser</b>
     * </p>
     *
     * @return Changed By
     */
    @SerializedName( "LastChangeUser" )
    @JsonProperty( "LastChangeUser" )
    @Nullable
    @ODataField( odataName = "LastChangeUser" )
    private String lastChangeUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeUser</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> LAST_CHANGE_USER =
        new PhysInventoryDocItemField<String>("LastChangeUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<LocalDateTime> LAST_CHANGE_DATE =
        new PhysInventoryDocItemField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CountedByUser</b>
     * </p>
     *
     * @return Counted By
     */
    @SerializedName( "CountedByUser" )
    @JsonProperty( "CountedByUser" )
    @Nullable
    @ODataField( odataName = "CountedByUser" )
    private String countedByUser;
    /**
     * Use with available fluent helpers to apply the <b>CountedByUser</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> COUNTED_BY_USER =
        new PhysInventoryDocItemField<String>("CountedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryLastCountDate</b>
     * </p>
     *
     * @return Date of Last Count
     */
    @SerializedName( "PhysicalInventoryLastCountDate" )
    @JsonProperty( "PhysicalInventoryLastCountDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PhysicalInventoryLastCountDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime physicalInventoryLastCountDate;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryLastCountDate</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<LocalDateTime> PHYSICAL_INVENTORY_LAST_COUNT_DATE =
        new PhysInventoryDocItemField<LocalDateTime>("PhysicalInventoryLastCountDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>AdjustmentPostingMadeByUser</b>
     * </p>
     *
     * @return Adjustment Posting Made By
     */
    @SerializedName( "AdjustmentPostingMadeByUser" )
    @JsonProperty( "AdjustmentPostingMadeByUser" )
    @Nullable
    @ODataField( odataName = "AdjustmentPostingMadeByUser" )
    private String adjustmentPostingMadeByUser;
    /**
     * Use with available fluent helpers to apply the <b>AdjustmentPostingMadeByUser</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> ADJUSTMENT_POSTING_MADE_BY_USER =
        new PhysInventoryDocItemField<String>("AdjustmentPostingMadeByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting Date in the Document
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<LocalDateTime> POSTING_DATE =
        new PhysInventoryDocItemField<LocalDateTime>("PostingDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryItemIsCounted</b>
     * </p>
     *
     * @return Item is Counted
     */
    @SerializedName( "PhysicalInventoryItemIsCounted" )
    @JsonProperty( "PhysicalInventoryItemIsCounted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PhysicalInventoryItemIsCounted" )
    private Boolean physicalInventoryItemIsCounted;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryItemIsCounted</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<Boolean> PHYSICAL_INVENTORY_ITEM_IS_COUNTED =
        new PhysInventoryDocItemField<Boolean>("PhysicalInventoryItemIsCounted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PhysInvtryDifferenceIsPosted</b>
     * </p>
     *
     * @return Difference of Item is Posted
     */
    @SerializedName( "PhysInvtryDifferenceIsPosted" )
    @JsonProperty( "PhysInvtryDifferenceIsPosted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PhysInvtryDifferenceIsPosted" )
    private Boolean physInvtryDifferenceIsPosted;
    /**
     * Use with available fluent helpers to apply the <b>PhysInvtryDifferenceIsPosted</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<Boolean> PHYS_INVTRY_DIFFERENCE_IS_POSTED =
        new PhysInventoryDocItemField<Boolean>("PhysInvtryDifferenceIsPosted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PhysInvtryItemIsRecounted</b>
     * </p>
     *
     * @return Item is Recounted
     */
    @SerializedName( "PhysInvtryItemIsRecounted" )
    @JsonProperty( "PhysInvtryItemIsRecounted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PhysInvtryItemIsRecounted" )
    private Boolean physInvtryItemIsRecounted;
    /**
     * Use with available fluent helpers to apply the <b>PhysInvtryItemIsRecounted</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<Boolean> PHYS_INVTRY_ITEM_IS_RECOUNTED =
        new PhysInventoryDocItemField<Boolean>("PhysInvtryItemIsRecounted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PhysInvtryItemIsDeleted</b>
     * </p>
     *
     * @return Item is Deleted
     */
    @SerializedName( "PhysInvtryItemIsDeleted" )
    @JsonProperty( "PhysInvtryItemIsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PhysInvtryItemIsDeleted" )
    private Boolean physInvtryItemIsDeleted;
    /**
     * Use with available fluent helpers to apply the <b>PhysInvtryItemIsDeleted</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<Boolean> PHYS_INVTRY_ITEM_IS_DELETED =
        new PhysInventoryDocItemField<Boolean>("PhysInvtryItemIsDeleted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsHandledInAltvUnitOfMsr</b>
     * </p>
     *
     * @return Without Unit of Measure Proposal
     */
    @SerializedName( "IsHandledInAltvUnitOfMsr" )
    @JsonProperty( "IsHandledInAltvUnitOfMsr" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsHandledInAltvUnitOfMsr" )
    private Boolean isHandledInAltvUnitOfMsr;
    /**
     * Use with available fluent helpers to apply the <b>IsHandledInAltvUnitOfMsr</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<Boolean> IS_HANDLED_IN_ALTV_UNIT_OF_MSR =
        new PhysInventoryDocItemField<Boolean>("IsHandledInAltvUnitOfMsr");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CycleCountType</b>
     * </p>
     *
     * @return Cycle Count Type
     */
    @SerializedName( "CycleCountType" )
    @JsonProperty( "CycleCountType" )
    @Nullable
    @ODataField( odataName = "CycleCountType" )
    private String cycleCountType;
    /**
     * Use with available fluent helpers to apply the <b>CycleCountType</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> CYCLE_COUNT_TYPE =
        new PhysInventoryDocItemField<String>("CycleCountType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsValueOnlyMaterial</b>
     * </p>
     *
     * @return Is Value-Only Material
     */
    @SerializedName( "IsValueOnlyMaterial" )
    @JsonProperty( "IsValueOnlyMaterial" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsValueOnlyMaterial" )
    private Boolean isValueOnlyMaterial;
    /**
     * Use with available fluent helpers to apply the <b>IsValueOnlyMaterial</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<Boolean> IS_VALUE_ONLY_MATERIAL =
        new PhysInventoryDocItemField<Boolean>("IsValueOnlyMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PhysInventoryReferenceNumber</b>
     * </p>
     *
     * @return Physical Inventory Reference
     */
    @SerializedName( "PhysInventoryReferenceNumber" )
    @JsonProperty( "PhysInventoryReferenceNumber" )
    @Nullable
    @ODataField( odataName = "PhysInventoryReferenceNumber" )
    private String physInventoryReferenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>PhysInventoryReferenceNumber</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> PHYS_INVENTORY_REFERENCE_NUMBER =
        new PhysInventoryDocItemField<String>("PhysInventoryReferenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @return Number of Material Document
     */
    @SerializedName( "MaterialDocument" )
    @JsonProperty( "MaterialDocument" )
    @Nullable
    @ODataField( odataName = "MaterialDocument" )
    private String materialDocument;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocument</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> MATERIAL_DOCUMENT =
        new PhysInventoryDocItemField<String>("MaterialDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @return Material Document Year
     */
    @SerializedName( "MaterialDocumentYear" )
    @JsonProperty( "MaterialDocumentYear" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentYear" )
    private String materialDocumentYear;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentYear</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> MATERIAL_DOCUMENT_YEAR =
        new PhysInventoryDocItemField<String>("MaterialDocumentYear");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItem</b>
     * </p>
     *
     * @return Material Document Item
     */
    @SerializedName( "MaterialDocumentItem" )
    @JsonProperty( "MaterialDocumentItem" )
    @Nullable
    @ODataField( odataName = "MaterialDocumentItem" )
    private String materialDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocumentItem</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> MATERIAL_DOCUMENT_ITEM =
        new PhysInventoryDocItemField<String>("MaterialDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PhysInvtryRecountDocument</b>
     * </p>
     *
     * @return Number of Recount Document
     */
    @SerializedName( "PhysInvtryRecountDocument" )
    @JsonProperty( "PhysInvtryRecountDocument" )
    @Nullable
    @ODataField( odataName = "PhysInvtryRecountDocument" )
    private String physInvtryRecountDocument;
    /**
     * Use with available fluent helpers to apply the <b>PhysInvtryRecountDocument</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> PHYS_INVTRY_RECOUNT_DOCUMENT =
        new PhysInventoryDocItemField<String>("PhysInvtryRecountDocument");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryItemIsZero</b>
     * </p>
     *
     * @return Is Zero Count
     */
    @SerializedName( "PhysicalInventoryItemIsZero" )
    @JsonProperty( "PhysicalInventoryItemIsZero" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PhysicalInventoryItemIsZero" )
    private Boolean physicalInventoryItemIsZero;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryItemIsZero</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<Boolean> PHYSICAL_INVENTORY_ITEM_IS_ZERO =
        new PhysInventoryDocItemField<Boolean>("PhysicalInventoryItemIsZero");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReasonForPhysInvtryDifference</b>
     * </p>
     *
     * @return Difference Reason
     */
    @SerializedName( "ReasonForPhysInvtryDifference" )
    @JsonProperty( "ReasonForPhysInvtryDifference" )
    @Nullable
    @ODataField( odataName = "ReasonForPhysInvtryDifference" )
    private String reasonForPhysInvtryDifference;
    /**
     * Use with available fluent helpers to apply the <b>ReasonForPhysInvtryDifference</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> REASON_FOR_PHYS_INVTRY_DIFFERENCE =
        new PhysInventoryDocItemField<String>("ReasonForPhysInvtryDifference");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "MaterialBaseUnit" )
    @JsonProperty( "MaterialBaseUnit" )
    @Nullable
    @ODataField( odataName = "MaterialBaseUnit" )
    private String materialBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>MaterialBaseUnit</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> MATERIAL_BASE_UNIT =
        new PhysInventoryDocItemField<String>("MaterialBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BookQtyBfrCountInMatlBaseUnit</b>
     * </p>
     *
     * @return Book Quantity Immediately Prior to Count
     */
    @SerializedName( "BookQtyBfrCountInMatlBaseUnit" )
    @JsonProperty( "BookQtyBfrCountInMatlBaseUnit" )
    @Nullable
    @ODataField( odataName = "BookQtyBfrCountInMatlBaseUnit" )
    private BigDecimal bookQtyBfrCountInMatlBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BookQtyBfrCountInMatlBaseUnit</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<BigDecimal> BOOK_QTY_BFR_COUNT_IN_MATL_BASE_UNIT =
        new PhysInventoryDocItemField<BigDecimal>("BookQtyBfrCountInMatlBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return Counted Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<BigDecimal> QUANTITY =
        new PhysInventoryDocItemField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfEntry</b>
     * </p>
     *
     * @return Entry Unit
     */
    @SerializedName( "UnitOfEntry" )
    @JsonProperty( "UnitOfEntry" )
    @Nullable
    @ODataField( odataName = "UnitOfEntry" )
    private String unitOfEntry;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfEntry</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> UNIT_OF_ENTRY =
        new PhysInventoryDocItemField<String>("UnitOfEntry");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInUnitOfEntry</b>
     * </p>
     *
     * @return Counted Quantity in Entry Unit
     */
    @SerializedName( "QuantityInUnitOfEntry" )
    @JsonProperty( "QuantityInUnitOfEntry" )
    @Nullable
    @ODataField( odataName = "QuantityInUnitOfEntry" )
    private BigDecimal quantityInUnitOfEntry;
    /**
     * Use with available fluent helpers to apply the <b>QuantityInUnitOfEntry</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<BigDecimal> QUANTITY_IN_UNIT_OF_ENTRY =
        new PhysInventoryDocItemField<BigDecimal>("QuantityInUnitOfEntry");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Company Code Currency
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<String> CURRENCY = new PhysInventoryDocItemField<String>("Currency");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DifferenceAmountInCoCodeCrcy</b>
     * </p>
     *
     * @return Value of Difference
     */
    @SerializedName( "DifferenceAmountInCoCodeCrcy" )
    @JsonProperty( "DifferenceAmountInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "DifferenceAmountInCoCodeCrcy" )
    private BigDecimal differenceAmountInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>DifferenceAmountInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<BigDecimal> DIFFERENCE_AMOUNT_IN_CO_CODE_CRCY =
        new PhysInventoryDocItemField<BigDecimal>("DifferenceAmountInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EnteredSlsAmtInCoCodeCrcy</b>
     * </p>
     *
     * @return Externally Entered Value Based on Sales Price
     */
    @SerializedName( "EnteredSlsAmtInCoCodeCrcy" )
    @JsonProperty( "EnteredSlsAmtInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "EnteredSlsAmtInCoCodeCrcy" )
    private BigDecimal enteredSlsAmtInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>EnteredSlsAmtInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<BigDecimal> ENTERED_SLS_AMT_IN_CO_CODE_CRCY =
        new PhysInventoryDocItemField<BigDecimal>("EnteredSlsAmtInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SlsPriceAmountInCoCodeCrcy</b>
     * </p>
     *
     * @return Sales Price Book Value
     */
    @SerializedName( "SlsPriceAmountInCoCodeCrcy" )
    @JsonProperty( "SlsPriceAmountInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "SlsPriceAmountInCoCodeCrcy" )
    private BigDecimal slsPriceAmountInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>SlsPriceAmountInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<BigDecimal> SLS_PRICE_AMOUNT_IN_CO_CODE_CRCY =
        new PhysInventoryDocItemField<BigDecimal>("SlsPriceAmountInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PhysInvtryCtAmtInCoCodeCrcy</b>
     * </p>
     *
     * @return Counted Quantity Value
     */
    @SerializedName( "PhysInvtryCtAmtInCoCodeCrcy" )
    @JsonProperty( "PhysInvtryCtAmtInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "PhysInvtryCtAmtInCoCodeCrcy" )
    private BigDecimal physInvtryCtAmtInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>PhysInvtryCtAmtInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<BigDecimal> PHYS_INVTRY_CT_AMT_IN_CO_CODE_CRCY =
        new PhysInventoryDocItemField<BigDecimal>("PhysInvtryCtAmtInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BookQtyAmountInCoCodeCrcy</b>
     * </p>
     *
     * @return Book Value
     */
    @SerializedName( "BookQtyAmountInCoCodeCrcy" )
    @JsonProperty( "BookQtyAmountInCoCodeCrcy" )
    @Nullable
    @ODataField( odataName = "BookQtyAmountInCoCodeCrcy" )
    private BigDecimal bookQtyAmountInCoCodeCrcy;
    /**
     * Use with available fluent helpers to apply the <b>BookQtyAmountInCoCodeCrcy</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<BigDecimal> BOOK_QTY_AMOUNT_IN_CO_CODE_CRCY =
        new PhysInventoryDocItemField<BigDecimal>("BookQtyAmountInCoCodeCrcy");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Change Timestamp
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static PhysInventoryDocItemField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new PhysInventoryDocItemField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Navigation property <b>to_PhysicalInventoryDocument</b> for <b>PhysInventoryDocItem</b> to single
     * <b>PhysInventoryDocHeader</b>.
     *
     */
    @SerializedName( "to_PhysicalInventoryDocument" )
    @JsonProperty( "to_PhysicalInventoryDocument" )
    @ODataField( odataName = "to_PhysicalInventoryDocument" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PhysInventoryDocHeader toPhysicalInventoryDocument;
    /**
     * Navigation property <b>to_SerialNumbers</b> for <b>PhysInventoryDocItem</b> to multiple
     * <b>SerialNumberPhysInventoryDoc</b>.
     *
     */
    @SerializedName( "to_SerialNumbers" )
    @JsonProperty( "to_SerialNumbers" )
    @ODataField( odataName = "to_SerialNumbers" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SerialNumberPhysInventoryDoc> toSerialNumbers;
    /**
     * Use with available fluent helpers to apply the <b>to_PhysicalInventoryDocument</b> navigation property to query
     * operations.
     *
     */
    public final static PhysInventoryDocItemOneToOneLink<PhysInventoryDocHeader> TO_PHYSICAL_INVENTORY_DOCUMENT =
        new PhysInventoryDocItemOneToOneLink<PhysInventoryDocHeader>("to_PhysicalInventoryDocument");
    /**
     * Use with available fluent helpers to apply the <b>to_SerialNumbers</b> navigation property to query operations.
     *
     */
    public final static PhysInventoryDocItemLink<SerialNumberPhysInventoryDoc> TO_SERIAL_NUMBERS =
        new PhysInventoryDocItemLink<SerialNumberPhysInventoryDoc>("to_SerialNumbers");

    @Nonnull
    @Override
    public Class<PhysInventoryDocItem> getType()
    {
        return PhysInventoryDocItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocument</b>
     * </p>
     *
     * @param physicalInventoryDocument
     *            Physical Inventory Document
     */
    public void setPhysicalInventoryDocument( @Nullable final String physicalInventoryDocument )
    {
        rememberChangedField("PhysicalInventoryDocument", this.physicalInventoryDocument);
        this.physicalInventoryDocument = physicalInventoryDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocumentItem</b>
     * </p>
     *
     * @param physicalInventoryDocumentItem
     *            Physical Inventory Item Number
     */
    public void setPhysicalInventoryDocumentItem( @Nullable final String physicalInventoryDocumentItem )
    {
        rememberChangedField("PhysicalInventoryDocumentItem", this.physicalInventoryDocumentItem);
        this.physicalInventoryDocumentItem = physicalInventoryDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockType</b>
     * </p>
     *
     * @param inventorySpecialStockType
     *            Special Stock Type
     */
    public void setInventorySpecialStockType( @Nullable final String inventorySpecialStockType )
    {
        rememberChangedField("InventorySpecialStockType", this.inventorySpecialStockType);
        this.inventorySpecialStockType = inventorySpecialStockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryStockType</b>
     * </p>
     *
     * @param physicalInventoryStockType
     *            Stock Type (Physical Inventory)
     */
    public void setPhysicalInventoryStockType( @Nullable final String physicalInventoryStockType )
    {
        rememberChangedField("PhysicalInventoryStockType", this.physicalInventoryStockType);
        this.physicalInventoryStockType = physicalInventoryStockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order Number
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Item Number in Sales Order
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier's Account Number
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Account number of customer
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeUser</b>
     * </p>
     *
     * @param lastChangeUser
     *            Changed By
     */
    public void setLastChangeUser( @Nullable final String lastChangeUser )
    {
        rememberChangedField("LastChangeUser", this.lastChangeUser);
        this.lastChangeUser = lastChangeUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CountedByUser</b>
     * </p>
     *
     * @param countedByUser
     *            Counted By
     */
    public void setCountedByUser( @Nullable final String countedByUser )
    {
        rememberChangedField("CountedByUser", this.countedByUser);
        this.countedByUser = countedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryLastCountDate</b>
     * </p>
     *
     * @param physicalInventoryLastCountDate
     *            Date of Last Count
     */
    public void setPhysicalInventoryLastCountDate( @Nullable final LocalDateTime physicalInventoryLastCountDate )
    {
        rememberChangedField("PhysicalInventoryLastCountDate", this.physicalInventoryLastCountDate);
        this.physicalInventoryLastCountDate = physicalInventoryLastCountDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>AdjustmentPostingMadeByUser</b>
     * </p>
     *
     * @param adjustmentPostingMadeByUser
     *            Adjustment Posting Made By
     */
    public void setAdjustmentPostingMadeByUser( @Nullable final String adjustmentPostingMadeByUser )
    {
        rememberChangedField("AdjustmentPostingMadeByUser", this.adjustmentPostingMadeByUser);
        this.adjustmentPostingMadeByUser = adjustmentPostingMadeByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date in the Document
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryItemIsCounted</b>
     * </p>
     *
     * @param physicalInventoryItemIsCounted
     *            Item is Counted
     */
    public void setPhysicalInventoryItemIsCounted( @Nullable final Boolean physicalInventoryItemIsCounted )
    {
        rememberChangedField("PhysicalInventoryItemIsCounted", this.physicalInventoryItemIsCounted);
        this.physicalInventoryItemIsCounted = physicalInventoryItemIsCounted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PhysInvtryDifferenceIsPosted</b>
     * </p>
     *
     * @param physInvtryDifferenceIsPosted
     *            Difference of Item is Posted
     */
    public void setPhysInvtryDifferenceIsPosted( @Nullable final Boolean physInvtryDifferenceIsPosted )
    {
        rememberChangedField("PhysInvtryDifferenceIsPosted", this.physInvtryDifferenceIsPosted);
        this.physInvtryDifferenceIsPosted = physInvtryDifferenceIsPosted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PhysInvtryItemIsRecounted</b>
     * </p>
     *
     * @param physInvtryItemIsRecounted
     *            Item is Recounted
     */
    public void setPhysInvtryItemIsRecounted( @Nullable final Boolean physInvtryItemIsRecounted )
    {
        rememberChangedField("PhysInvtryItemIsRecounted", this.physInvtryItemIsRecounted);
        this.physInvtryItemIsRecounted = physInvtryItemIsRecounted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PhysInvtryItemIsDeleted</b>
     * </p>
     *
     * @param physInvtryItemIsDeleted
     *            Item is Deleted
     */
    public void setPhysInvtryItemIsDeleted( @Nullable final Boolean physInvtryItemIsDeleted )
    {
        rememberChangedField("PhysInvtryItemIsDeleted", this.physInvtryItemIsDeleted);
        this.physInvtryItemIsDeleted = physInvtryItemIsDeleted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsHandledInAltvUnitOfMsr</b>
     * </p>
     *
     * @param isHandledInAltvUnitOfMsr
     *            Without Unit of Measure Proposal
     */
    public void setIsHandledInAltvUnitOfMsr( @Nullable final Boolean isHandledInAltvUnitOfMsr )
    {
        rememberChangedField("IsHandledInAltvUnitOfMsr", this.isHandledInAltvUnitOfMsr);
        this.isHandledInAltvUnitOfMsr = isHandledInAltvUnitOfMsr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CycleCountType</b>
     * </p>
     *
     * @param cycleCountType
     *            Cycle Count Type
     */
    public void setCycleCountType( @Nullable final String cycleCountType )
    {
        rememberChangedField("CycleCountType", this.cycleCountType);
        this.cycleCountType = cycleCountType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsValueOnlyMaterial</b>
     * </p>
     *
     * @param isValueOnlyMaterial
     *            Is Value-Only Material
     */
    public void setIsValueOnlyMaterial( @Nullable final Boolean isValueOnlyMaterial )
    {
        rememberChangedField("IsValueOnlyMaterial", this.isValueOnlyMaterial);
        this.isValueOnlyMaterial = isValueOnlyMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PhysInventoryReferenceNumber</b>
     * </p>
     *
     * @param physInventoryReferenceNumber
     *            Physical Inventory Reference
     */
    public void setPhysInventoryReferenceNumber( @Nullable final String physInventoryReferenceNumber )
    {
        rememberChangedField("PhysInventoryReferenceNumber", this.physInventoryReferenceNumber);
        this.physInventoryReferenceNumber = physInventoryReferenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @param materialDocument
     *            Number of Material Document
     */
    public void setMaterialDocument( @Nullable final String materialDocument )
    {
        rememberChangedField("MaterialDocument", this.materialDocument);
        this.materialDocument = materialDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentYear</b>
     * </p>
     *
     * @param materialDocumentYear
     *            Material Document Year
     */
    public void setMaterialDocumentYear( @Nullable final String materialDocumentYear )
    {
        rememberChangedField("MaterialDocumentYear", this.materialDocumentYear);
        this.materialDocumentYear = materialDocumentYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocumentItem</b>
     * </p>
     *
     * @param materialDocumentItem
     *            Material Document Item
     */
    public void setMaterialDocumentItem( @Nullable final String materialDocumentItem )
    {
        rememberChangedField("MaterialDocumentItem", this.materialDocumentItem);
        this.materialDocumentItem = materialDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PhysInvtryRecountDocument</b>
     * </p>
     *
     * @param physInvtryRecountDocument
     *            Number of Recount Document
     */
    public void setPhysInvtryRecountDocument( @Nullable final String physInvtryRecountDocument )
    {
        rememberChangedField("PhysInvtryRecountDocument", this.physInvtryRecountDocument);
        this.physInvtryRecountDocument = physInvtryRecountDocument;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryItemIsZero</b>
     * </p>
     *
     * @param physicalInventoryItemIsZero
     *            Is Zero Count
     */
    public void setPhysicalInventoryItemIsZero( @Nullable final Boolean physicalInventoryItemIsZero )
    {
        rememberChangedField("PhysicalInventoryItemIsZero", this.physicalInventoryItemIsZero);
        this.physicalInventoryItemIsZero = physicalInventoryItemIsZero;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReasonForPhysInvtryDifference</b>
     * </p>
     *
     * @param reasonForPhysInvtryDifference
     *            Difference Reason
     */
    public void setReasonForPhysInvtryDifference( @Nullable final String reasonForPhysInvtryDifference )
    {
        rememberChangedField("ReasonForPhysInvtryDifference", this.reasonForPhysInvtryDifference);
        this.reasonForPhysInvtryDifference = reasonForPhysInvtryDifference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseUnit</b>
     * </p>
     *
     * @param materialBaseUnit
     *            Base Unit of Measure
     */
    public void setMaterialBaseUnit( @Nullable final String materialBaseUnit )
    {
        rememberChangedField("MaterialBaseUnit", this.materialBaseUnit);
        this.materialBaseUnit = materialBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BookQtyBfrCountInMatlBaseUnit</b>
     * </p>
     *
     * @param bookQtyBfrCountInMatlBaseUnit
     *            Book Quantity Immediately Prior to Count
     */
    public void setBookQtyBfrCountInMatlBaseUnit( @Nullable final BigDecimal bookQtyBfrCountInMatlBaseUnit )
    {
        rememberChangedField("BookQtyBfrCountInMatlBaseUnit", this.bookQtyBfrCountInMatlBaseUnit);
        this.bookQtyBfrCountInMatlBaseUnit = bookQtyBfrCountInMatlBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            Counted Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfEntry</b>
     * </p>
     *
     * @param unitOfEntry
     *            Entry Unit
     */
    public void setUnitOfEntry( @Nullable final String unitOfEntry )
    {
        rememberChangedField("UnitOfEntry", this.unitOfEntry);
        this.unitOfEntry = unitOfEntry;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInUnitOfEntry</b>
     * </p>
     *
     * @param quantityInUnitOfEntry
     *            Counted Quantity in Entry Unit
     */
    public void setQuantityInUnitOfEntry( @Nullable final BigDecimal quantityInUnitOfEntry )
    {
        rememberChangedField("QuantityInUnitOfEntry", this.quantityInUnitOfEntry);
        this.quantityInUnitOfEntry = quantityInUnitOfEntry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Company Code Currency
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DifferenceAmountInCoCodeCrcy</b>
     * </p>
     *
     * @param differenceAmountInCoCodeCrcy
     *            Value of Difference
     */
    public void setDifferenceAmountInCoCodeCrcy( @Nullable final BigDecimal differenceAmountInCoCodeCrcy )
    {
        rememberChangedField("DifferenceAmountInCoCodeCrcy", this.differenceAmountInCoCodeCrcy);
        this.differenceAmountInCoCodeCrcy = differenceAmountInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EnteredSlsAmtInCoCodeCrcy</b>
     * </p>
     *
     * @param enteredSlsAmtInCoCodeCrcy
     *            Externally Entered Value Based on Sales Price
     */
    public void setEnteredSlsAmtInCoCodeCrcy( @Nullable final BigDecimal enteredSlsAmtInCoCodeCrcy )
    {
        rememberChangedField("EnteredSlsAmtInCoCodeCrcy", this.enteredSlsAmtInCoCodeCrcy);
        this.enteredSlsAmtInCoCodeCrcy = enteredSlsAmtInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SlsPriceAmountInCoCodeCrcy</b>
     * </p>
     *
     * @param slsPriceAmountInCoCodeCrcy
     *            Sales Price Book Value
     */
    public void setSlsPriceAmountInCoCodeCrcy( @Nullable final BigDecimal slsPriceAmountInCoCodeCrcy )
    {
        rememberChangedField("SlsPriceAmountInCoCodeCrcy", this.slsPriceAmountInCoCodeCrcy);
        this.slsPriceAmountInCoCodeCrcy = slsPriceAmountInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PhysInvtryCtAmtInCoCodeCrcy</b>
     * </p>
     *
     * @param physInvtryCtAmtInCoCodeCrcy
     *            Counted Quantity Value
     */
    public void setPhysInvtryCtAmtInCoCodeCrcy( @Nullable final BigDecimal physInvtryCtAmtInCoCodeCrcy )
    {
        rememberChangedField("PhysInvtryCtAmtInCoCodeCrcy", this.physInvtryCtAmtInCoCodeCrcy);
        this.physInvtryCtAmtInCoCodeCrcy = physInvtryCtAmtInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BookQtyAmountInCoCodeCrcy</b>
     * </p>
     *
     * @param bookQtyAmountInCoCodeCrcy
     *            Book Value
     */
    public void setBookQtyAmountInCoCodeCrcy( @Nullable final BigDecimal bookQtyAmountInCoCodeCrcy )
    {
        rememberChangedField("BookQtyAmountInCoCodeCrcy", this.bookQtyAmountInCoCodeCrcy);
        this.bookQtyAmountInCoCodeCrcy = bookQtyAmountInCoCodeCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Change Timestamp
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PhysInventoryDocItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FiscalYear", getFiscalYear());
        result.put("PhysicalInventoryDocument", getPhysicalInventoryDocument());
        result.put("PhysicalInventoryDocumentItem", getPhysicalInventoryDocumentItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FiscalYear", getFiscalYear());
        values.put("PhysicalInventoryDocument", getPhysicalInventoryDocument());
        values.put("PhysicalInventoryDocumentItem", getPhysicalInventoryDocumentItem());
        values.put("Plant", getPlant());
        values.put("StorageLocation", getStorageLocation());
        values.put("Material", getMaterial());
        values.put("Batch", getBatch());
        values.put("InventorySpecialStockType", getInventorySpecialStockType());
        values.put("PhysicalInventoryStockType", getPhysicalInventoryStockType());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("Supplier", getSupplier());
        values.put("Customer", getCustomer());
        values.put("WBSElement", getWBSElement());
        values.put("LastChangeUser", getLastChangeUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("CountedByUser", getCountedByUser());
        values.put("PhysicalInventoryLastCountDate", getPhysicalInventoryLastCountDate());
        values.put("AdjustmentPostingMadeByUser", getAdjustmentPostingMadeByUser());
        values.put("PostingDate", getPostingDate());
        values.put("PhysicalInventoryItemIsCounted", getPhysicalInventoryItemIsCounted());
        values.put("PhysInvtryDifferenceIsPosted", getPhysInvtryDifferenceIsPosted());
        values.put("PhysInvtryItemIsRecounted", getPhysInvtryItemIsRecounted());
        values.put("PhysInvtryItemIsDeleted", getPhysInvtryItemIsDeleted());
        values.put("IsHandledInAltvUnitOfMsr", getIsHandledInAltvUnitOfMsr());
        values.put("CycleCountType", getCycleCountType());
        values.put("IsValueOnlyMaterial", getIsValueOnlyMaterial());
        values.put("PhysInventoryReferenceNumber", getPhysInventoryReferenceNumber());
        values.put("MaterialDocument", getMaterialDocument());
        values.put("MaterialDocumentYear", getMaterialDocumentYear());
        values.put("MaterialDocumentItem", getMaterialDocumentItem());
        values.put("PhysInvtryRecountDocument", getPhysInvtryRecountDocument());
        values.put("PhysicalInventoryItemIsZero", getPhysicalInventoryItemIsZero());
        values.put("ReasonForPhysInvtryDifference", getReasonForPhysInvtryDifference());
        values.put("MaterialBaseUnit", getMaterialBaseUnit());
        values.put("BookQtyBfrCountInMatlBaseUnit", getBookQtyBfrCountInMatlBaseUnit());
        values.put("Quantity", getQuantity());
        values.put("UnitOfEntry", getUnitOfEntry());
        values.put("QuantityInUnitOfEntry", getQuantityInUnitOfEntry());
        values.put("Currency", getCurrency());
        values.put("DifferenceAmountInCoCodeCrcy", getDifferenceAmountInCoCodeCrcy());
        values.put("EnteredSlsAmtInCoCodeCrcy", getEnteredSlsAmtInCoCodeCrcy());
        values.put("SlsPriceAmountInCoCodeCrcy", getSlsPriceAmountInCoCodeCrcy());
        values.put("PhysInvtryCtAmtInCoCodeCrcy", getPhysInvtryCtAmtInCoCodeCrcy());
        values.put("BookQtyAmountInCoCodeCrcy", getBookQtyAmountInCoCodeCrcy());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryDocument") ) {
                final Object value = values.remove("PhysicalInventoryDocument");
                if( (value == null) || (!value.equals(getPhysicalInventoryDocument())) ) {
                    setPhysicalInventoryDocument(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryDocumentItem") ) {
                final Object value = values.remove("PhysicalInventoryDocumentItem");
                if( (value == null) || (!value.equals(getPhysicalInventoryDocumentItem())) ) {
                    setPhysicalInventoryDocumentItem(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("InventorySpecialStockType") ) {
                final Object value = values.remove("InventorySpecialStockType");
                if( (value == null) || (!value.equals(getInventorySpecialStockType())) ) {
                    setInventorySpecialStockType(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryStockType") ) {
                final Object value = values.remove("PhysicalInventoryStockType");
                if( (value == null) || (!value.equals(getPhysicalInventoryStockType())) ) {
                    setPhysicalInventoryStockType(((String) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("LastChangeUser") ) {
                final Object value = values.remove("LastChangeUser");
                if( (value == null) || (!value.equals(getLastChangeUser())) ) {
                    setLastChangeUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CountedByUser") ) {
                final Object value = values.remove("CountedByUser");
                if( (value == null) || (!value.equals(getCountedByUser())) ) {
                    setCountedByUser(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryLastCountDate") ) {
                final Object value = values.remove("PhysicalInventoryLastCountDate");
                if( (value == null) || (!value.equals(getPhysicalInventoryLastCountDate())) ) {
                    setPhysicalInventoryLastCountDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AdjustmentPostingMadeByUser") ) {
                final Object value = values.remove("AdjustmentPostingMadeByUser");
                if( (value == null) || (!value.equals(getAdjustmentPostingMadeByUser())) ) {
                    setAdjustmentPostingMadeByUser(((String) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PhysicalInventoryItemIsCounted") ) {
                final Object value = values.remove("PhysicalInventoryItemIsCounted");
                if( (value == null) || (!value.equals(getPhysicalInventoryItemIsCounted())) ) {
                    setPhysicalInventoryItemIsCounted(((Boolean) value));
                }
            }
            if( values.containsKey("PhysInvtryDifferenceIsPosted") ) {
                final Object value = values.remove("PhysInvtryDifferenceIsPosted");
                if( (value == null) || (!value.equals(getPhysInvtryDifferenceIsPosted())) ) {
                    setPhysInvtryDifferenceIsPosted(((Boolean) value));
                }
            }
            if( values.containsKey("PhysInvtryItemIsRecounted") ) {
                final Object value = values.remove("PhysInvtryItemIsRecounted");
                if( (value == null) || (!value.equals(getPhysInvtryItemIsRecounted())) ) {
                    setPhysInvtryItemIsRecounted(((Boolean) value));
                }
            }
            if( values.containsKey("PhysInvtryItemIsDeleted") ) {
                final Object value = values.remove("PhysInvtryItemIsDeleted");
                if( (value == null) || (!value.equals(getPhysInvtryItemIsDeleted())) ) {
                    setPhysInvtryItemIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("IsHandledInAltvUnitOfMsr") ) {
                final Object value = values.remove("IsHandledInAltvUnitOfMsr");
                if( (value == null) || (!value.equals(getIsHandledInAltvUnitOfMsr())) ) {
                    setIsHandledInAltvUnitOfMsr(((Boolean) value));
                }
            }
            if( values.containsKey("CycleCountType") ) {
                final Object value = values.remove("CycleCountType");
                if( (value == null) || (!value.equals(getCycleCountType())) ) {
                    setCycleCountType(((String) value));
                }
            }
            if( values.containsKey("IsValueOnlyMaterial") ) {
                final Object value = values.remove("IsValueOnlyMaterial");
                if( (value == null) || (!value.equals(getIsValueOnlyMaterial())) ) {
                    setIsValueOnlyMaterial(((Boolean) value));
                }
            }
            if( values.containsKey("PhysInventoryReferenceNumber") ) {
                final Object value = values.remove("PhysInventoryReferenceNumber");
                if( (value == null) || (!value.equals(getPhysInventoryReferenceNumber())) ) {
                    setPhysInventoryReferenceNumber(((String) value));
                }
            }
            if( values.containsKey("MaterialDocument") ) {
                final Object value = values.remove("MaterialDocument");
                if( (value == null) || (!value.equals(getMaterialDocument())) ) {
                    setMaterialDocument(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentYear") ) {
                final Object value = values.remove("MaterialDocumentYear");
                if( (value == null) || (!value.equals(getMaterialDocumentYear())) ) {
                    setMaterialDocumentYear(((String) value));
                }
            }
            if( values.containsKey("MaterialDocumentItem") ) {
                final Object value = values.remove("MaterialDocumentItem");
                if( (value == null) || (!value.equals(getMaterialDocumentItem())) ) {
                    setMaterialDocumentItem(((String) value));
                }
            }
            if( values.containsKey("PhysInvtryRecountDocument") ) {
                final Object value = values.remove("PhysInvtryRecountDocument");
                if( (value == null) || (!value.equals(getPhysInvtryRecountDocument())) ) {
                    setPhysInvtryRecountDocument(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryItemIsZero") ) {
                final Object value = values.remove("PhysicalInventoryItemIsZero");
                if( (value == null) || (!value.equals(getPhysicalInventoryItemIsZero())) ) {
                    setPhysicalInventoryItemIsZero(((Boolean) value));
                }
            }
            if( values.containsKey("ReasonForPhysInvtryDifference") ) {
                final Object value = values.remove("ReasonForPhysInvtryDifference");
                if( (value == null) || (!value.equals(getReasonForPhysInvtryDifference())) ) {
                    setReasonForPhysInvtryDifference(((String) value));
                }
            }
            if( values.containsKey("MaterialBaseUnit") ) {
                final Object value = values.remove("MaterialBaseUnit");
                if( (value == null) || (!value.equals(getMaterialBaseUnit())) ) {
                    setMaterialBaseUnit(((String) value));
                }
            }
            if( values.containsKey("BookQtyBfrCountInMatlBaseUnit") ) {
                final Object value = values.remove("BookQtyBfrCountInMatlBaseUnit");
                if( (value == null) || (!value.equals(getBookQtyBfrCountInMatlBaseUnit())) ) {
                    setBookQtyBfrCountInMatlBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnitOfEntry") ) {
                final Object value = values.remove("UnitOfEntry");
                if( (value == null) || (!value.equals(getUnitOfEntry())) ) {
                    setUnitOfEntry(((String) value));
                }
            }
            if( values.containsKey("QuantityInUnitOfEntry") ) {
                final Object value = values.remove("QuantityInUnitOfEntry");
                if( (value == null) || (!value.equals(getQuantityInUnitOfEntry())) ) {
                    setQuantityInUnitOfEntry(((BigDecimal) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("DifferenceAmountInCoCodeCrcy") ) {
                final Object value = values.remove("DifferenceAmountInCoCodeCrcy");
                if( (value == null) || (!value.equals(getDifferenceAmountInCoCodeCrcy())) ) {
                    setDifferenceAmountInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("EnteredSlsAmtInCoCodeCrcy") ) {
                final Object value = values.remove("EnteredSlsAmtInCoCodeCrcy");
                if( (value == null) || (!value.equals(getEnteredSlsAmtInCoCodeCrcy())) ) {
                    setEnteredSlsAmtInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("SlsPriceAmountInCoCodeCrcy") ) {
                final Object value = values.remove("SlsPriceAmountInCoCodeCrcy");
                if( (value == null) || (!value.equals(getSlsPriceAmountInCoCodeCrcy())) ) {
                    setSlsPriceAmountInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("PhysInvtryCtAmtInCoCodeCrcy") ) {
                final Object value = values.remove("PhysInvtryCtAmtInCoCodeCrcy");
                if( (value == null) || (!value.equals(getPhysInvtryCtAmtInCoCodeCrcy())) ) {
                    setPhysInvtryCtAmtInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("BookQtyAmountInCoCodeCrcy") ) {
                final Object value = values.remove("BookQtyAmountInCoCodeCrcy");
                if( (value == null) || (!value.equals(getBookQtyAmountInCoCodeCrcy())) ) {
                    setBookQtyAmountInCoCodeCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PhysicalInventoryDocument") ) {
                final Object value = (values).remove("to_PhysicalInventoryDocument");
                if( value instanceof Map ) {
                    if( toPhysicalInventoryDocument == null ) {
                        toPhysicalInventoryDocument = new PhysInventoryDocHeader();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPhysicalInventoryDocument.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SerialNumbers") ) {
                final Object value = (values).remove("to_SerialNumbers");
                if( value instanceof Iterable ) {
                    if( toSerialNumbers == null ) {
                        toSerialNumbers = Lists.newArrayList();
                    } else {
                        toSerialNumbers = Lists.newArrayList(toSerialNumbers);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SerialNumberPhysInventoryDoc entity;
                        if( toSerialNumbers.size() > i ) {
                            entity = toSerialNumbers.get(i);
                        } else {
                            entity = new SerialNumberPhysInventoryDoc();
                            toSerialNumbers.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PhysInventoryDocItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PhysInventoryDocItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PhysInventoryDocItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PhysInventoryDocItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhysicalInventoryDocumentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPhysicalInventoryDocument != null ) {
            (values).put("to_PhysicalInventoryDocument", toPhysicalInventoryDocument);
        }
        if( toSerialNumbers != null ) {
            (values).put("to_SerialNumbers", toSerialNumbers);
        }
        return values;
    }

    /**
     * Fetches the <b>PhysInventoryDocHeader</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PhysicalInventoryDocument</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PhysInventoryDocHeader</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PhysInventoryDocHeader fetchPhysicalInventoryDocument()
    {
        return fetchFieldAsSingle("to_PhysicalInventoryDocument", PhysInventoryDocHeader.class);
    }

    /**
     * Retrieval of associated <b>PhysInventoryDocHeader</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PhysicalInventoryDocument</b>.
     * <p>
     * If the navigation property <b>to_PhysicalInventoryDocument</b> of a queried <b>PhysInventoryDocItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PhysInventoryDocHeader</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PhysInventoryDocHeader getPhysicalInventoryDocumentOrFetch()
    {
        if( toPhysicalInventoryDocument == null ) {
            toPhysicalInventoryDocument = fetchPhysicalInventoryDocument();
        }
        return toPhysicalInventoryDocument;
    }

    /**
     * Retrieval of associated <b>PhysInventoryDocHeader</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PhysicalInventoryDocument</b>.
     * <p>
     * If the navigation property for an entity <b>PhysInventoryDocItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PhysicalInventoryDocument</b> is already loaded, the
     *         result will contain the <b>PhysInventoryDocHeader</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PhysInventoryDocHeader> getPhysicalInventoryDocumentIfPresent()
    {
        return Option.of(toPhysicalInventoryDocument);
    }

    /**
     * Overwrites the associated <b>PhysInventoryDocHeader</b> entity for the loaded navigation property
     * <b>to_PhysicalInventoryDocument</b>.
     *
     * @param value
     *            New <b>PhysInventoryDocHeader</b> entity.
     */
    public void setPhysicalInventoryDocument( final PhysInventoryDocHeader value )
    {
        toPhysicalInventoryDocument = value;
    }

    /**
     * Fetches the <b>SerialNumberPhysInventoryDoc</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_SerialNumbers</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SerialNumberPhysInventoryDoc</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SerialNumberPhysInventoryDoc> fetchSerialNumbers()
    {
        return fetchFieldAsList("to_SerialNumbers", SerialNumberPhysInventoryDoc.class);
    }

    /**
     * Retrieval of associated <b>SerialNumberPhysInventoryDoc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SerialNumbers</b>.
     * <p>
     * If the navigation property <b>to_SerialNumbers</b> of a queried <b>PhysInventoryDocItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SerialNumberPhysInventoryDoc</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SerialNumberPhysInventoryDoc> getSerialNumbersOrFetch()
    {
        if( toSerialNumbers == null ) {
            toSerialNumbers = fetchSerialNumbers();
        }
        return toSerialNumbers;
    }

    /**
     * Retrieval of associated <b>SerialNumberPhysInventoryDoc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SerialNumbers</b>.
     * <p>
     * If the navigation property for an entity <b>PhysInventoryDocItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SerialNumbers</b> is already loaded, the result will
     *         contain the <b>SerialNumberPhysInventoryDoc</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SerialNumberPhysInventoryDoc>> getSerialNumbersIfPresent()
    {
        return Option.of(toSerialNumbers);
    }

    /**
     * Overwrites the list of associated <b>SerialNumberPhysInventoryDoc</b> entities for the loaded navigation property
     * <b>to_SerialNumbers</b>.
     * <p>
     * If the navigation property <b>to_SerialNumbers</b> of a queried <b>PhysInventoryDocItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SerialNumberPhysInventoryDoc</b> entities.
     */
    public void setSerialNumbers( @Nonnull final List<SerialNumberPhysInventoryDoc> value )
    {
        if( toSerialNumbers == null ) {
            toSerialNumbers = Lists.newArrayList();
        }
        toSerialNumbers.clear();
        toSerialNumbers.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SerialNumberPhysInventoryDoc</b> entities. This corresponds to the
     * OData navigation property <b>to_SerialNumbers</b>.
     * <p>
     * If the navigation property <b>to_SerialNumbers</b> of a queried <b>PhysInventoryDocItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SerialNumberPhysInventoryDoc</b> entities.
     */
    public void addSerialNumbers( SerialNumberPhysInventoryDoc... entity )
    {
        if( toSerialNumbers == null ) {
            toSerialNumbers = Lists.newArrayList();
        }
        toSerialNumbers.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PhysInventoryDocItem instances.
     *
     */
    public final static class PhysInventoryDocItemBuilder
    {

        private PhysInventoryDocHeader toPhysicalInventoryDocument;
        private String physicalInventoryDocument = null;
        private List<SerialNumberPhysInventoryDoc> toSerialNumbers = Lists.newArrayList();

        private PhysInventoryDocItem.PhysInventoryDocItemBuilder toPhysicalInventoryDocument(
            final PhysInventoryDocHeader value )
        {
            toPhysicalInventoryDocument = value;
            return this;
        }

        /**
         * Navigation property <b>to_PhysicalInventoryDocument</b> for <b>PhysInventoryDocItem</b> to single
         * <b>PhysInventoryDocHeader</b>.
         *
         * @param value
         *            The PhysInventoryDocHeader to build this PhysInventoryDocItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PhysInventoryDocItem.PhysInventoryDocItemBuilder physicalInventoryDocument(
            final PhysInventoryDocHeader value )
        {
            return toPhysicalInventoryDocument(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>PhysicalInventoryDocument</b>
         * </p>
         *
         * @param value
         *            The physicalInventoryDocument to build this PhysInventoryDocItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PhysInventoryDocItem.PhysInventoryDocItemBuilder physicalInventoryDocument( final String value )
        {
            physicalInventoryDocument = value;
            return this;
        }

        private PhysInventoryDocItem.PhysInventoryDocItemBuilder toSerialNumbers(
            final List<SerialNumberPhysInventoryDoc> value )
        {
            toSerialNumbers.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SerialNumbers</b> for <b>PhysInventoryDocItem</b> to multiple
         * <b>SerialNumberPhysInventoryDoc</b>.
         *
         * @param value
         *            The SerialNumberPhysInventoryDocs to build this PhysInventoryDocItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PhysInventoryDocItem.PhysInventoryDocItemBuilder serialNumbers( SerialNumberPhysInventoryDoc... value )
        {
            return toSerialNumbers(Lists.newArrayList(value));
        }

    }

}
