/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.field.SerialNumberPhysInventoryDocField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.selectable.SerialNumberPhysInventoryDocSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Document Serial Number
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SerialNumberPhysInventoryDocType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SerialNumberPhysInventoryDoc extends VdmEntity<SerialNumberPhysInventoryDoc>
{

    /**
     * Selector for all available fields of SerialNumberPhysInventoryDoc.
     *
     */
    public final static SerialNumberPhysInventoryDocSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @Key
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static SerialNumberPhysInventoryDocField<String> EQUIPMENT =
        new SerialNumberPhysInventoryDocField<String>("Equipment");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @Key
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static SerialNumberPhysInventoryDocField<String> FISCAL_YEAR =
        new SerialNumberPhysInventoryDocField<String>("FiscalYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocument</b>
     * </p>
     *
     * @return Physical Inventory Document
     */
    @Key
    @SerializedName( "PhysicalInventoryDocument" )
    @JsonProperty( "PhysicalInventoryDocument" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryDocument" )
    private String physicalInventoryDocument;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryDocument</b> field to query operations.
     *
     */
    public final static SerialNumberPhysInventoryDocField<String> PHYSICAL_INVENTORY_DOCUMENT =
        new SerialNumberPhysInventoryDocField<String>("PhysicalInventoryDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocumentItem</b>
     * </p>
     *
     * @return Line Number
     */
    @Key
    @SerializedName( "PhysicalInventoryDocumentItem" )
    @JsonProperty( "PhysicalInventoryDocumentItem" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryDocumentItem" )
    private String physicalInventoryDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryDocumentItem</b> field to query operations.
     *
     */
    public final static SerialNumberPhysInventoryDocField<String> PHYSICAL_INVENTORY_DOCUMENT_ITEM =
        new SerialNumberPhysInventoryDocField<String>("PhysicalInventoryDocumentItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumberPhysicalInvtryType</b>
     * </p>
     *
     * @return Serial Number Physical Inventory Type
     */
    @Key
    @SerializedName( "SerialNumberPhysicalInvtryType" )
    @JsonProperty( "SerialNumberPhysicalInvtryType" )
    @Nullable
    @ODataField( odataName = "SerialNumberPhysicalInvtryType" )
    private String serialNumberPhysicalInvtryType;
    /**
     * Use with available fluent helpers to apply the <b>SerialNumberPhysicalInvtryType</b> field to query operations.
     *
     */
    public final static SerialNumberPhysInventoryDocField<String> SERIAL_NUMBER_PHYSICAL_INVTRY_TYPE =
        new SerialNumberPhysInventoryDocField<String>("SerialNumberPhysicalInvtryType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static SerialNumberPhysInventoryDocField<String> MATERIAL =
        new SerialNumberPhysInventoryDocField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     *
     * @return Serial Number
     */
    @SerializedName( "SerialNumber" )
    @JsonProperty( "SerialNumber" )
    @Nullable
    @ODataField( odataName = "SerialNumber" )
    private String serialNumber;
    /**
     * Use with available fluent helpers to apply the <b>SerialNumber</b> field to query operations.
     *
     */
    public final static SerialNumberPhysInventoryDocField<String> SERIAL_NUMBER =
        new SerialNumberPhysInventoryDocField<String>("SerialNumber");

    @Nonnull
    @Override
    public Class<SerialNumberPhysInventoryDoc> getType()
    {
        return SerialNumberPhysInventoryDoc.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocument</b>
     * </p>
     *
     * @param physicalInventoryDocument
     *            Physical Inventory Document
     */
    public void setPhysicalInventoryDocument( @Nullable final String physicalInventoryDocument )
    {
        rememberChangedField("PhysicalInventoryDocument", this.physicalInventoryDocument);
        this.physicalInventoryDocument = physicalInventoryDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocumentItem</b>
     * </p>
     *
     * @param physicalInventoryDocumentItem
     *            Line Number
     */
    public void setPhysicalInventoryDocumentItem( @Nullable final String physicalInventoryDocumentItem )
    {
        rememberChangedField("PhysicalInventoryDocumentItem", this.physicalInventoryDocumentItem);
        this.physicalInventoryDocumentItem = physicalInventoryDocumentItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumberPhysicalInvtryType</b>
     * </p>
     *
     * @param serialNumberPhysicalInvtryType
     *            Serial Number Physical Inventory Type
     */
    public void setSerialNumberPhysicalInvtryType( @Nullable final String serialNumberPhysicalInvtryType )
    {
        rememberChangedField("SerialNumberPhysicalInvtryType", this.serialNumberPhysicalInvtryType);
        this.serialNumberPhysicalInvtryType = serialNumberPhysicalInvtryType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     *
     * @param serialNumber
     *            Serial Number
     */
    public void setSerialNumber( @Nullable final String serialNumber )
    {
        rememberChangedField("SerialNumber", this.serialNumber);
        this.serialNumber = serialNumber;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SerialNumberPhysInventoryDoc";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Equipment", getEquipment());
        result.put("FiscalYear", getFiscalYear());
        result.put("PhysicalInventoryDocument", getPhysicalInventoryDocument());
        result.put("PhysicalInventoryDocumentItem", getPhysicalInventoryDocumentItem());
        result.put("SerialNumberPhysicalInvtryType", getSerialNumberPhysicalInvtryType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Equipment", getEquipment());
        values.put("FiscalYear", getFiscalYear());
        values.put("PhysicalInventoryDocument", getPhysicalInventoryDocument());
        values.put("PhysicalInventoryDocumentItem", getPhysicalInventoryDocumentItem());
        values.put("SerialNumberPhysicalInvtryType", getSerialNumberPhysicalInvtryType());
        values.put("Material", getMaterial());
        values.put("SerialNumber", getSerialNumber());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryDocument") ) {
                final Object value = values.remove("PhysicalInventoryDocument");
                if( (value == null) || (!value.equals(getPhysicalInventoryDocument())) ) {
                    setPhysicalInventoryDocument(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryDocumentItem") ) {
                final Object value = values.remove("PhysicalInventoryDocumentItem");
                if( (value == null) || (!value.equals(getPhysicalInventoryDocumentItem())) ) {
                    setPhysicalInventoryDocumentItem(((String) value));
                }
            }
            if( values.containsKey("SerialNumberPhysicalInvtryType") ) {
                final Object value = values.remove("SerialNumberPhysicalInvtryType");
                if( (value == null) || (!value.equals(getSerialNumberPhysicalInvtryType())) ) {
                    setSerialNumberPhysicalInvtryType(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("SerialNumber") ) {
                final Object value = values.remove("SerialNumber");
                if( (value == null) || (!value.equals(getSerialNumber())) ) {
                    setSerialNumber(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SerialNumberPhysInventoryDocField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SerialNumberPhysInventoryDocField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SerialNumberPhysInventoryDocField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SerialNumberPhysInventoryDocField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhysicalInventoryDocumentService.DEFAULT_SERVICE_PATH);
    }

}
