/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.selectable.SerialNumberPhysInventoryDocSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc
 * SerialNumberPhysInventoryDoc} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SerialNumberPhysInventoryDocByKeyFluentHelper
    extends
    FluentHelperByKey<SerialNumberPhysInventoryDocByKeyFluentHelper, SerialNumberPhysInventoryDoc, SerialNumberPhysInventoryDocSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc
     * SerialNumberPhysInventoryDoc} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SerialNumberPhysInventoryDoc}
     * @param physicalInventoryDocumentItem
     *            Line Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param serialNumberPhysicalInvtryType
     *            Serial Number Physical Inventory Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SerialNumberPhysInventoryDoc}
     * @param equipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param physicalInventoryDocument
     *            Physical Inventory Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public SerialNumberPhysInventoryDocByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String equipment,
        final String fiscalYear,
        final String physicalInventoryDocument,
        final String physicalInventoryDocumentItem,
        final String serialNumberPhysicalInvtryType )
    {
        super(servicePath, entityCollection);
        this.key.put("Equipment", equipment);
        this.key.put("FiscalYear", fiscalYear);
        this.key.put("PhysicalInventoryDocument", physicalInventoryDocument);
        this.key.put("PhysicalInventoryDocumentItem", physicalInventoryDocumentItem);
        this.key.put("SerialNumberPhysicalInvtryType", serialNumberPhysicalInvtryType);
    }

    @Override
    @Nonnull
    protected Class<SerialNumberPhysInventoryDoc> getEntityClass()
    {
        return SerialNumberPhysInventoryDoc.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
