/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PhysicalInventoryDocumentServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhysicalInventoryDocumentService
 * PhysicalInventoryDocumentService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultPhysicalInventoryDocumentServiceBatch
    extends
    BatchFluentHelperBasic<PhysicalInventoryDocumentServiceBatch, PhysicalInventoryDocumentServiceBatchChangeSet>
    implements
    PhysicalInventoryDocumentServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhysicalInventoryDocumentService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPhysicalInventoryDocumentServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPhysicalInventoryDocumentServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhysicalInventoryDocumentService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhysicalInventoryDocumentService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPhysicalInventoryDocumentServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPhysicalInventoryDocumentServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhysicalInventoryDocumentService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPhysicalInventoryDocumentServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PhysicalInventoryDocumentServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPhysicalInventoryDocumentServiceBatchChangeSet(this, service);
    }

}
