/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc;

/**
 * Implementation of the {@link PhysicalInventoryDocumentServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhysicalInventoryDocumentService
 * PhysicalInventoryDocumentService}.
 *
 */
public class DefaultPhysicalInventoryDocumentServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PhysicalInventoryDocumentServiceBatch, PhysicalInventoryDocumentServiceBatchChangeSet>
    implements
    PhysicalInventoryDocumentServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhysicalInventoryDocumentService service;

    @SuppressWarnings( "deprecation" )
    DefaultPhysicalInventoryDocumentServiceBatchChangeSet(
        @Nonnull final DefaultPhysicalInventoryDocumentServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhysicalInventoryDocumentService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPhysicalInventoryDocumentServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PhysicalInventoryDocumentServiceBatchChangeSet createPhysInventoryDocHeader(
        @Nonnull final PhysInventoryDocHeader physInventoryDocHeader )
    {
        return addRequestCreate(service::createPhysInventoryDocHeader, physInventoryDocHeader);
    }

    @Nonnull
    @Override
    public PhysicalInventoryDocumentServiceBatchChangeSet updatePhysInventoryDocItem(
        @Nonnull final PhysInventoryDocItem physInventoryDocItem )
    {
        return addRequestUpdate(service::updatePhysInventoryDocItem, physInventoryDocItem);
    }

    @Nonnull
    @Override
    public PhysicalInventoryDocumentServiceBatchChangeSet updateSerialNumberPhysInventoryDoc(
        @Nonnull final SerialNumberPhysInventoryDoc serialNumberPhysInventoryDoc )
    {
        return addRequestUpdate(service::updateSerialNumberPhysInventoryDoc, serialNumberPhysInventoryDoc);
    }

}
