/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PhysicalInventoryDocumentService
 * PhysicalInventoryDocumentService}.
 *
 */
public interface PhysicalInventoryDocumentServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<PhysicalInventoryDocumentServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<PhysicalInventoryDocumentServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader
     * PhysInventoryDocHeader} entity and save it to the S/4HANA system.
     *
     * @param physInventoryDocHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader
     *            PhysInventoryDocHeader} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PhysicalInventoryDocumentServiceBatchChangeSet
        createPhysInventoryDocHeader( @Nonnull final PhysInventoryDocHeader physInventoryDocHeader );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem
     * PhysInventoryDocItem} entity and save it to the S/4HANA system.
     *
     * @param physInventoryDocItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem
     *            PhysInventoryDocItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PhysicalInventoryDocumentServiceBatchChangeSet
        updatePhysInventoryDocItem( @Nonnull final PhysInventoryDocItem physInventoryDocItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc
     * SerialNumberPhysInventoryDoc} entity and save it to the S/4HANA system.
     *
     * @param serialNumberPhysInventoryDoc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc
     *            SerialNumberPhysInventoryDoc} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PhysicalInventoryDocumentServiceBatchChangeSet
        updateSerialNumberPhysInventoryDoc( @Nonnull final SerialNumberPhysInventoryDoc serialNumberPhysInventoryDoc );

}
