/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader
 * PhysInventoryDocHeader}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.field.PhysInventoryDocHeaderField
 * PhysInventoryDocHeaderField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.link.PhysInventoryDocHeaderLink
 * PhysInventoryDocHeaderLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#PHYSICAL_INVENTORY_DOCUMENT
 * PHYSICAL_INVENTORY_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#INVENTORY_TRANSACTION_TYPE
 * INVENTORY_TRANSACTION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#INVENTORY_SPECIAL_STOCK_TYPE
 * INVENTORY_SPECIAL_STOCK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#DOCUMENT_DATE
 * DOCUMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#PHYS_INVENTORY_PLANNED_COUNT_DATE
 * PHYS_INVENTORY_PLANNED_COUNT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#PHYSICAL_INVENTORY_LAST_COUNT_DATE
 * PHYSICAL_INVENTORY_LAST_COUNT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#FISCAL_PERIOD
 * FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#POSTING_IS_BLOCKED_FOR_PHYS_INVTRY
 * POSTING_IS_BLOCKED_FOR_PHYS_INVTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#PHYSICAL_INVENTORY_COUNT_STATUS
 * PHYSICAL_INVENTORY_COUNT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#PHYS_INVTRY_ADJUSTMENT_POSTING_STS
 * PHYS_INVTRY_ADJUSTMENT_POSTING_STS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#PHYS_INVTRY_DELETION_STATUS
 * PHYS_INVTRY_DELETION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#PHYS_INVTRY_DOC_HAS_QTY_SNAPSHOT
 * PHYS_INVTRY_DOC_HAS_QTY_SNAPSHOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#PHYSICAL_INVENTORY_GROUP_TYPE
 * PHYSICAL_INVENTORY_GROUP_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#PHYSICAL_INVENTORY_GROUP
 * PHYSICAL_INVENTORY_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#PHYSICAL_INVENTORY_NUMBER
 * PHYSICAL_INVENTORY_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#PHYS_INVENTORY_REFERENCE_NUMBER
 * PHYS_INVENTORY_REFERENCE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#PHYSICAL_INVENTORY_DOCUMENT_DESC
 * PHYSICAL_INVENTORY_DOCUMENT_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#PHYSICAL_INVENTORY_TYPE
 * PHYSICAL_INVENTORY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocHeader#TO_PHYSICAL_INVENTORY_DOCUMENT_ITEM
 * TO_PHYSICAL_INVENTORY_DOCUMENT_ITEM}</li>
 * </ul>
 *
 */
public interface PhysInventoryDocHeaderSelectable extends EntitySelectable<PhysInventoryDocHeader>
{

}
