/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem
 * PhysInventoryDocItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.field.PhysInventoryDocItemField
 * PhysInventoryDocItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.link.PhysInventoryDocItemLink
 * PhysInventoryDocItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#PHYSICAL_INVENTORY_DOCUMENT
 * PHYSICAL_INVENTORY_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#PHYSICAL_INVENTORY_DOCUMENT_ITEM
 * PHYSICAL_INVENTORY_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#BATCH
 * BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#INVENTORY_SPECIAL_STOCK_TYPE
 * INVENTORY_SPECIAL_STOCK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#PHYSICAL_INVENTORY_STOCK_TYPE
 * PHYSICAL_INVENTORY_STOCK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#LAST_CHANGE_USER
 * LAST_CHANGE_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#COUNTED_BY_USER
 * COUNTED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#PHYSICAL_INVENTORY_LAST_COUNT_DATE
 * PHYSICAL_INVENTORY_LAST_COUNT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#ADJUSTMENT_POSTING_MADE_BY_USER
 * ADJUSTMENT_POSTING_MADE_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#PHYSICAL_INVENTORY_ITEM_IS_COUNTED
 * PHYSICAL_INVENTORY_ITEM_IS_COUNTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#PHYS_INVTRY_DIFFERENCE_IS_POSTED
 * PHYS_INVTRY_DIFFERENCE_IS_POSTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#PHYS_INVTRY_ITEM_IS_RECOUNTED
 * PHYS_INVTRY_ITEM_IS_RECOUNTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#PHYS_INVTRY_ITEM_IS_DELETED
 * PHYS_INVTRY_ITEM_IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#IS_HANDLED_IN_ALTV_UNIT_OF_MSR
 * IS_HANDLED_IN_ALTV_UNIT_OF_MSR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#CYCLE_COUNT_TYPE
 * CYCLE_COUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#IS_VALUE_ONLY_MATERIAL
 * IS_VALUE_ONLY_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#PHYS_INVENTORY_REFERENCE_NUMBER
 * PHYS_INVENTORY_REFERENCE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#MATERIAL_DOCUMENT
 * MATERIAL_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#MATERIAL_DOCUMENT_YEAR
 * MATERIAL_DOCUMENT_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#MATERIAL_DOCUMENT_ITEM
 * MATERIAL_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#PHYS_INVTRY_RECOUNT_DOCUMENT
 * PHYS_INVTRY_RECOUNT_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#PHYSICAL_INVENTORY_ITEM_IS_ZERO
 * PHYSICAL_INVENTORY_ITEM_IS_ZERO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#REASON_FOR_PHYS_INVTRY_DIFFERENCE
 * REASON_FOR_PHYS_INVTRY_DIFFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#MATERIAL_BASE_UNIT
 * MATERIAL_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#BOOK_QTY_BFR_COUNT_IN_MATL_BASE_UNIT
 * BOOK_QTY_BFR_COUNT_IN_MATL_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#QUANTITY
 * QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#UNIT_OF_ENTRY
 * UNIT_OF_ENTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#QUANTITY_IN_UNIT_OF_ENTRY
 * QUANTITY_IN_UNIT_OF_ENTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#CURRENCY
 * CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#DIFFERENCE_AMOUNT_IN_CO_CODE_CRCY
 * DIFFERENCE_AMOUNT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#ENTERED_SLS_AMT_IN_CO_CODE_CRCY
 * ENTERED_SLS_AMT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#SLS_PRICE_AMOUNT_IN_CO_CODE_CRCY
 * SLS_PRICE_AMOUNT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#PHYS_INVTRY_CT_AMT_IN_CO_CODE_CRCY
 * PHYS_INVTRY_CT_AMT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#BOOK_QTY_AMOUNT_IN_CO_CODE_CRCY
 * BOOK_QTY_AMOUNT_IN_CO_CODE_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#TO_PHYSICAL_INVENTORY_DOCUMENT
 * TO_PHYSICAL_INVENTORY_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.PhysInventoryDocItem#TO_SERIAL_NUMBERS
 * TO_SERIAL_NUMBERS}</li>
 * </ul>
 *
 */
public interface PhysInventoryDocItemSelectable extends EntitySelectable<PhysInventoryDocItem>
{

}
