/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc
 * SerialNumberPhysInventoryDoc}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.field.SerialNumberPhysInventoryDocField
 * SerialNumberPhysInventoryDocField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.link.SerialNumberPhysInventoryDocLink
 * SerialNumberPhysInventoryDocLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc#EQUIPMENT
 * EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc#PHYSICAL_INVENTORY_DOCUMENT
 * PHYSICAL_INVENTORY_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc#PHYSICAL_INVENTORY_DOCUMENT_ITEM
 * PHYSICAL_INVENTORY_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc#SERIAL_NUMBER_PHYSICAL_INVTRY_TYPE
 * SERIAL_NUMBER_PHYSICAL_INVTRY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.physicalinventorydocument.SerialNumberPhysInventoryDoc#SERIAL_NUMBER
 * SERIAL_NUMBER}</li>
 * </ul>
 *
 */
public interface SerialNumberPhysInventoryDocSelectable extends EntitySelectable<SerialNumberPhysInventoryDoc>
{

}
