/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.field.MaintainYearsPeriodField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.selectable.MaintainYearsPeriodSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>MaintainYearsPeriod</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintainYearsPeriod extends VdmEntity<MaintainYearsPeriod>
{

    /**
     * Selector for all available fields of MaintainYearsPeriod.
     *
     */
    public final static MaintainYearsPeriodSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static MaintainYearsPeriodField<String> MATERIAL = new MaintainYearsPeriodField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static MaintainYearsPeriodField<String> PLANT = new MaintainYearsPeriodField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @return MRP Area
     */
    @Key
    @SerializedName( "MRPArea" )
    @JsonProperty( "MRPArea" )
    @Nullable
    @ODataField( odataName = "MRPArea" )
    private String mRPArea;
    /**
     * Use with available fluent helpers to apply the <b>MRPArea</b> field to query operations.
     *
     */
    public final static MaintainYearsPeriodField<String> MRP_AREA = new MaintainYearsPeriodField<String>("MRPArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RequirementsType</b>
     * </p>
     *
     * @return Requirements Type
     */
    @Key
    @SerializedName( "RequirementsType" )
    @JsonProperty( "RequirementsType" )
    @Nullable
    @ODataField( odataName = "RequirementsType" )
    private String requirementsType;
    /**
     * Use with available fluent helpers to apply the <b>RequirementsType</b> field to query operations.
     *
     */
    public final static MaintainYearsPeriodField<String> REQUIREMENTS_TYPE =
        new MaintainYearsPeriodField<String>("RequirementsType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ForecastDemandVersion</b>
     * </p>
     *
     * @return Forecast Demand Version
     */
    @Key
    @SerializedName( "ForecastDemandVersion" )
    @JsonProperty( "ForecastDemandVersion" )
    @Nullable
    @ODataField( odataName = "ForecastDemandVersion" )
    private String forecastDemandVersion;
    /**
     * Use with available fluent helpers to apply the <b>ForecastDemandVersion</b> field to query operations.
     *
     */
    public final static MaintainYearsPeriodField<String> FORECAST_DEMAND_VERSION =
        new MaintainYearsPeriodField<String>("ForecastDemandVersion");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ForecastPeriodStartDate</b>
     * </p>
     *
     * @return Forecast Period Start Date
     */
    @Key
    @SerializedName( "ForecastPeriodStartDate" )
    @JsonProperty( "ForecastPeriodStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ForecastPeriodStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime forecastPeriodStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ForecastPeriodStartDate</b> field to query operations.
     *
     */
    public final static MaintainYearsPeriodField<LocalDateTime> FORECAST_PERIOD_START_DATE =
        new MaintainYearsPeriodField<LocalDateTime>("ForecastPeriodStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ForecastPeriodType</b>
     * </p>
     *
     * @return Forecast Period Type
     */
    @SerializedName( "ForecastPeriodType" )
    @JsonProperty( "ForecastPeriodType" )
    @Nullable
    @ODataField( odataName = "ForecastPeriodType" )
    private String forecastPeriodType;
    /**
     * Use with available fluent helpers to apply the <b>ForecastPeriodType</b> field to query operations.
     *
     */
    public final static MaintainYearsPeriodField<String> FORECAST_PERIOD_TYPE =
        new MaintainYearsPeriodField<String>("ForecastPeriodType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductBaseUnit</b>
     * </p>
     *
     * @return Product Base Unit
     */
    @SerializedName( "ProductBaseUnit" )
    @JsonProperty( "ProductBaseUnit" )
    @Nullable
    @ODataField( odataName = "ProductBaseUnit" )
    private String productBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProductBaseUnit</b> field to query operations.
     *
     */
    public final static MaintainYearsPeriodField<String> PRODUCT_BASE_UNIT =
        new MaintainYearsPeriodField<String>("ProductBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ForecastQuantity</b>
     * </p>
     *
     * @return Forecast Quantity
     */
    @SerializedName( "ForecastQuantity" )
    @JsonProperty( "ForecastQuantity" )
    @Nullable
    @ODataField( odataName = "ForecastQuantity" )
    private BigDecimal forecastQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ForecastQuantity</b> field to query operations.
     *
     */
    public final static MaintainYearsPeriodField<BigDecimal> FORECAST_QUANTITY =
        new MaintainYearsPeriodField<BigDecimal>("ForecastQuantity");

    @Nonnull
    @Override
    public Class<MaintainYearsPeriod> getType()
    {
        return MaintainYearsPeriod.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @param mRPArea
     *            MRP Area
     */
    public void setMRPArea( @Nullable final String mRPArea )
    {
        rememberChangedField("MRPArea", this.mRPArea);
        this.mRPArea = mRPArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RequirementsType</b>
     * </p>
     *
     * @param requirementsType
     *            Requirements Type
     */
    public void setRequirementsType( @Nullable final String requirementsType )
    {
        rememberChangedField("RequirementsType", this.requirementsType);
        this.requirementsType = requirementsType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ForecastDemandVersion</b>
     * </p>
     *
     * @param forecastDemandVersion
     *            Forecast Demand Version
     */
    public void setForecastDemandVersion( @Nullable final String forecastDemandVersion )
    {
        rememberChangedField("ForecastDemandVersion", this.forecastDemandVersion);
        this.forecastDemandVersion = forecastDemandVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ForecastPeriodStartDate</b>
     * </p>
     *
     * @param forecastPeriodStartDate
     *            Forecast Period Start Date
     */
    public void setForecastPeriodStartDate( @Nullable final LocalDateTime forecastPeriodStartDate )
    {
        rememberChangedField("ForecastPeriodStartDate", this.forecastPeriodStartDate);
        this.forecastPeriodStartDate = forecastPeriodStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ForecastPeriodType</b>
     * </p>
     *
     * @param forecastPeriodType
     *            Forecast Period Type
     */
    public void setForecastPeriodType( @Nullable final String forecastPeriodType )
    {
        rememberChangedField("ForecastPeriodType", this.forecastPeriodType);
        this.forecastPeriodType = forecastPeriodType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductBaseUnit</b>
     * </p>
     *
     * @param productBaseUnit
     *            Product Base Unit
     */
    public void setProductBaseUnit( @Nullable final String productBaseUnit )
    {
        rememberChangedField("ProductBaseUnit", this.productBaseUnit);
        this.productBaseUnit = productBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ForecastQuantity</b>
     * </p>
     *
     * @param forecastQuantity
     *            Forecast Quantity
     */
    public void setForecastQuantity( @Nullable final BigDecimal forecastQuantity )
    {
        rememberChangedField("ForecastQuantity", this.forecastQuantity);
        this.forecastQuantity = forecastQuantity;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintainYearsPeriodSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        result.put("Plant", getPlant());
        result.put("MRPArea", getMRPArea());
        result.put("RequirementsType", getRequirementsType());
        result.put("ForecastDemandVersion", getForecastDemandVersion());
        result.put("ForecastPeriodStartDate", getForecastPeriodStartDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("MRPArea", getMRPArea());
        values.put("RequirementsType", getRequirementsType());
        values.put("ForecastDemandVersion", getForecastDemandVersion());
        values.put("ForecastPeriodStartDate", getForecastPeriodStartDate());
        values.put("ForecastPeriodType", getForecastPeriodType());
        values.put("ProductBaseUnit", getProductBaseUnit());
        values.put("ForecastQuantity", getForecastQuantity());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("MRPArea") ) {
                final Object value = values.remove("MRPArea");
                if( (value == null) || (!value.equals(getMRPArea())) ) {
                    setMRPArea(((String) value));
                }
            }
            if( values.containsKey("RequirementsType") ) {
                final Object value = values.remove("RequirementsType");
                if( (value == null) || (!value.equals(getRequirementsType())) ) {
                    setRequirementsType(((String) value));
                }
            }
            if( values.containsKey("ForecastDemandVersion") ) {
                final Object value = values.remove("ForecastDemandVersion");
                if( (value == null) || (!value.equals(getForecastDemandVersion())) ) {
                    setForecastDemandVersion(((String) value));
                }
            }
            if( values.containsKey("ForecastPeriodStartDate") ) {
                final Object value = values.remove("ForecastPeriodStartDate");
                if( (value == null) || (!value.equals(getForecastPeriodStartDate())) ) {
                    setForecastPeriodStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ForecastPeriodType") ) {
                final Object value = values.remove("ForecastPeriodType");
                if( (value == null) || (!value.equals(getForecastPeriodType())) ) {
                    setForecastPeriodType(((String) value));
                }
            }
            if( values.containsKey("ProductBaseUnit") ) {
                final Object value = values.remove("ProductBaseUnit");
                if( (value == null) || (!value.equals(getProductBaseUnit())) ) {
                    setProductBaseUnit(((String) value));
                }
            }
            if( values.containsKey("ForecastQuantity") ) {
                final Object value = values.remove("ForecastQuantity");
                if( (value == null) || (!value.equals(getForecastQuantity())) ) {
                    setForecastQuantity(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintainYearsPeriodField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintainYearsPeriodField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintainYearsPeriodField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintainYearsPeriodField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedIndependentRequirementService.DEFAULT_SERVICE_PATH);
    }

}
