/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.selectable.MaintainYearsPeriodSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriod
 * MaintainYearsPeriod} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class MaintainYearsPeriodByKeyFluentHelper
    extends
    FluentHelperByKey<MaintainYearsPeriodByKeyFluentHelper, MaintainYearsPeriod, MaintainYearsPeriodSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriod
     * MaintainYearsPeriod} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaintainYearsPeriod}
     * @param mRPArea
     *            MRP Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param material
     *            Material
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param forecastDemandVersion
     *            Forecast Demand Version
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaintainYearsPeriod}
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param requirementsType
     *            Requirements Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param forecastPeriodStartDate
     *            Forecast Period Start Date
     *            <p>
     *            Constraints: Not nullable, Precision: 7
     *            </p>
     */
    public MaintainYearsPeriodByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String material,
        final String plant,
        final String mRPArea,
        final String requirementsType,
        final String forecastDemandVersion,
        final LocalDateTime forecastPeriodStartDate )
    {
        super(servicePath, entityCollection);
        this.key.put("Material", material);
        this.key.put("Plant", plant);
        this.key.put("MRPArea", mRPArea);
        this.key.put("RequirementsType", requirementsType);
        this.key.put("ForecastDemandVersion", forecastDemandVersion);
        this.key.put("ForecastPeriodStartDate", forecastPeriodStartDate);
    }

    @Override
    @Nonnull
    protected Class<MaintainYearsPeriod> getEntityClass()
    {
        return MaintainYearsPeriod.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
