/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PlannedIndependentRequirementServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedIndependentRequirementService
 * PlannedIndependentRequirementService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultPlannedIndependentRequirementServiceBatch
    extends
    BatchFluentHelperBasic<PlannedIndependentRequirementServiceBatch, PlannedIndependentRequirementServiceBatchChangeSet>
    implements
    PlannedIndependentRequirementServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedIndependentRequirementService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPlannedIndependentRequirementServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPlannedIndependentRequirementServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedIndependentRequirementService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedIndependentRequirementService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPlannedIndependentRequirementServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPlannedIndependentRequirementServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedIndependentRequirementService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPlannedIndependentRequirementServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PlannedIndependentRequirementServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPlannedIndependentRequirementServiceBatchChangeSet(this, service);
    }

}
