/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriod;

/**
 * Implementation of the {@link PlannedIndependentRequirementServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedIndependentRequirementService
 * PlannedIndependentRequirementService}.
 *
 */
public class DefaultPlannedIndependentRequirementServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PlannedIndependentRequirementServiceBatch, PlannedIndependentRequirementServiceBatchChangeSet>
    implements
    PlannedIndependentRequirementServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedIndependentRequirementService service;

    @SuppressWarnings( "deprecation" )
    DefaultPlannedIndependentRequirementServiceBatchChangeSet(
        @Nonnull final DefaultPlannedIndependentRequirementServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedIndependentRequirementService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPlannedIndependentRequirementServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PlannedIndependentRequirementServiceBatchChangeSet updateMaintainYearsPeriod(
        @Nonnull final MaintainYearsPeriod maintainYearsPeriod )
    {
        return addRequestUpdate(service::updateMaintainYearsPeriod, maintainYearsPeriod);
    }

}
