/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriod;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedIndependentRequirementService
 * PlannedIndependentRequirementService}.
 *
 */
public interface PlannedIndependentRequirementServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<PlannedIndependentRequirementServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<PlannedIndependentRequirementServiceBatch>
{

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriod
     * MaintainYearsPeriod} entity and save it to the S/4HANA system.
     *
     * @param maintainYearsPeriod
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriod
     *            MaintainYearsPeriod} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PlannedIndependentRequirementServiceBatchChangeSet
        updateMaintainYearsPeriod( @Nonnull final MaintainYearsPeriod maintainYearsPeriod );

}
