/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriod;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriod
 * MaintainYearsPeriod}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.field.MaintainYearsPeriodField
 * MaintainYearsPeriodField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.link.MaintainYearsPeriodLink
 * MaintainYearsPeriodLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriod#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriod#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriod#MRP_AREA
 * MRP_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriod#REQUIREMENTS_TYPE
 * REQUIREMENTS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriod#FORECAST_DEMAND_VERSION
 * FORECAST_DEMAND_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriod#FORECAST_PERIOD_START_DATE
 * FORECAST_PERIOD_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriod#FORECAST_PERIOD_TYPE
 * FORECAST_PERIOD_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriod#PRODUCT_BASE_UNIT
 * PRODUCT_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedindependentrequirement.MaintainYearsPeriod#FORECAST_QUANTITY
 * FORECAST_QUANTITY}</li>
 * </ul>
 *
 */
public interface MaintainYearsPeriodSelectable extends EntitySelectable<MaintainYearsPeriod>
{

}
