/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.field.PlannedOrderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.link.PlannedOrderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.selectable.PlannedOrderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Planned Order
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PlannedOrderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PlannedOrder extends VdmEntity<PlannedOrder>
{

    /**
     * Selector for all available fields of PlannedOrder.
     *
     */
    public final static PlannedOrderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrder</b>
     * </p>
     *
     * @return Planned Order
     */
    @Key
    @SerializedName( "PlannedOrder" )
    @JsonProperty( "PlannedOrder" )
    @Nullable
    @ODataField( odataName = "PlannedOrder" )
    private String plannedOrder;
    /**
     * Use with available fluent helpers to apply the <b>PlannedOrder</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> PLANNED_ORDER = new PlannedOrderField<String>("PlannedOrder");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrderType</b>
     * </p>
     *
     * @return Planned Order Type
     */
    @SerializedName( "PlannedOrderType" )
    @JsonProperty( "PlannedOrderType" )
    @Nullable
    @ODataField( odataName = "PlannedOrderType" )
    private String plannedOrderType;
    /**
     * Use with available fluent helpers to apply the <b>PlannedOrderType</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> PLANNED_ORDER_TYPE =
        new PlannedOrderField<String>("PlannedOrderType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrderProfile</b>
     * </p>
     *
     * @return Planned order profile
     */
    @SerializedName( "PlannedOrderProfile" )
    @JsonProperty( "PlannedOrderProfile" )
    @Nullable
    @ODataField( odataName = "PlannedOrderProfile" )
    private String plannedOrderProfile;
    /**
     * Use with available fluent helpers to apply the <b>PlannedOrderProfile</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> PLANNED_ORDER_PROFILE =
        new PlannedOrderField<String>("PlannedOrderProfile");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Planning material
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> MATERIAL = new PlannedOrderField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @return Material Description
     */
    @SerializedName( "MaterialName" )
    @JsonProperty( "MaterialName" )
    @Nullable
    @ODataField( odataName = "MaterialName" )
    private String materialName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialName</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> MATERIAL_NAME = new PlannedOrderField<String>("MaterialName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @return Production Plant
     */
    @SerializedName( "ProductionPlant" )
    @JsonProperty( "ProductionPlant" )
    @Nullable
    @ODataField( odataName = "ProductionPlant" )
    private String productionPlant;
    /**
     * Use with available fluent helpers to apply the <b>ProductionPlant</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> PRODUCTION_PLANT = new PlannedOrderField<String>("ProductionPlant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlant</b>
     * </p>
     *
     * @return Planning Plant
     */
    @SerializedName( "MRPPlant" )
    @JsonProperty( "MRPPlant" )
    @Nullable
    @ODataField( odataName = "MRPPlant" )
    private String mRPPlant;
    /**
     * Use with available fluent helpers to apply the <b>MRPPlant</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> MRP_PLANT = new PlannedOrderField<String>("MRPPlant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @return MRP Area
     */
    @SerializedName( "MRPArea" )
    @JsonProperty( "MRPArea" )
    @Nullable
    @ODataField( odataName = "MRPArea" )
    private String mRPArea;
    /**
     * Use with available fluent helpers to apply the <b>MRPArea</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> MRP_AREA = new PlannedOrderField<String>("MRPArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionVersion</b>
     * </p>
     *
     * @return Production Version
     */
    @SerializedName( "ProductionVersion" )
    @JsonProperty( "ProductionVersion" )
    @Nullable
    @ODataField( odataName = "ProductionVersion" )
    private String productionVersion;
    /**
     * Use with available fluent helpers to apply the <b>ProductionVersion</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> PRODUCTION_VERSION =
        new PlannedOrderField<String>("ProductionVersion");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialProcurementCategory</b>
     * </p>
     *
     * @return Material Procurement Category
     */
    @SerializedName( "MaterialProcurementCategory" )
    @JsonProperty( "MaterialProcurementCategory" )
    @Nullable
    @ODataField( odataName = "MaterialProcurementCategory" )
    private String materialProcurementCategory;
    /**
     * Use with available fluent helpers to apply the <b>MaterialProcurementCategory</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> MATERIAL_PROCUREMENT_CATEGORY =
        new PlannedOrderField<String>("MaterialProcurementCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialProcurementType</b>
     * </p>
     *
     * @return Material Procurement Type
     */
    @SerializedName( "MaterialProcurementType" )
    @JsonProperty( "MaterialProcurementType" )
    @Nullable
    @ODataField( odataName = "MaterialProcurementType" )
    private String materialProcurementType;
    /**
     * Use with available fluent helpers to apply the <b>MaterialProcurementType</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> MATERIAL_PROCUREMENT_TYPE =
        new PlannedOrderField<String>("MaterialProcurementType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> STORAGE_LOCATION = new PlannedOrderField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> BASE_UNIT = new PlannedOrderField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalQuantity</b>
     * </p>
     *
     * @return Planned Total Order Quantity
     */
    @SerializedName( "TotalQuantity" )
    @JsonProperty( "TotalQuantity" )
    @Nullable
    @ODataField( odataName = "TotalQuantity" )
    private BigDecimal totalQuantity;
    /**
     * Use with available fluent helpers to apply the <b>TotalQuantity</b> field to query operations.
     *
     */
    public final static PlannedOrderField<BigDecimal> TOTAL_QUANTITY =
        new PlannedOrderField<BigDecimal>("TotalQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlndOrderPlannedScrapQty</b>
     * </p>
     *
     * @return Planned Scrap Quantity
     */
    @SerializedName( "PlndOrderPlannedScrapQty" )
    @JsonProperty( "PlndOrderPlannedScrapQty" )
    @Nullable
    @ODataField( odataName = "PlndOrderPlannedScrapQty" )
    private BigDecimal plndOrderPlannedScrapQty;
    /**
     * Use with available fluent helpers to apply the <b>PlndOrderPlannedScrapQty</b> field to query operations.
     *
     */
    public final static PlannedOrderField<BigDecimal> PLND_ORDER_PLANNED_SCRAP_QTY =
        new PlannedOrderField<BigDecimal>("PlndOrderPlannedScrapQty");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptQty</b>
     * </p>
     *
     * @return Quantity of Goods Received
     */
    @SerializedName( "GoodsReceiptQty" )
    @JsonProperty( "GoodsReceiptQty" )
    @Nullable
    @ODataField( odataName = "GoodsReceiptQty" )
    private BigDecimal goodsReceiptQty;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptQty</b> field to query operations.
     *
     */
    public final static PlannedOrderField<BigDecimal> GOODS_RECEIPT_QTY =
        new PlannedOrderField<BigDecimal>("GoodsReceiptQty");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>IssuedQuantity</b>
     * </p>
     *
     * @return Issued Quantity
     */
    @SerializedName( "IssuedQuantity" )
    @JsonProperty( "IssuedQuantity" )
    @Nullable
    @ODataField( odataName = "IssuedQuantity" )
    private BigDecimal issuedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>IssuedQuantity</b> field to query operations.
     *
     */
    public final static PlannedOrderField<BigDecimal> ISSUED_QUANTITY =
        new PlannedOrderField<BigDecimal>("IssuedQuantity");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlndOrderPlannedStartDate</b>
     * </p>
     *
     * @return Planned Order Start Date
     */
    @SerializedName( "PlndOrderPlannedStartDate" )
    @JsonProperty( "PlndOrderPlannedStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PlndOrderPlannedStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime plndOrderPlannedStartDate;
    /**
     * Use with available fluent helpers to apply the <b>PlndOrderPlannedStartDate</b> field to query operations.
     *
     */
    public final static PlannedOrderField<LocalDateTime> PLND_ORDER_PLANNED_START_DATE =
        new PlannedOrderField<LocalDateTime>("PlndOrderPlannedStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlndOrderPlannedStartTime</b>
     * </p>
     *
     * @return Planned Order Start Time
     */
    @SerializedName( "PlndOrderPlannedStartTime" )
    @JsonProperty( "PlndOrderPlannedStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "PlndOrderPlannedStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime plndOrderPlannedStartTime;
    /**
     * Use with available fluent helpers to apply the <b>PlndOrderPlannedStartTime</b> field to query operations.
     *
     */
    public final static PlannedOrderField<LocalTime> PLND_ORDER_PLANNED_START_TIME =
        new PlannedOrderField<LocalTime>("PlndOrderPlannedStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlndOrderPlannedEndDate</b>
     * </p>
     *
     * @return Planned Order End Date
     */
    @SerializedName( "PlndOrderPlannedEndDate" )
    @JsonProperty( "PlndOrderPlannedEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PlndOrderPlannedEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime plndOrderPlannedEndDate;
    /**
     * Use with available fluent helpers to apply the <b>PlndOrderPlannedEndDate</b> field to query operations.
     *
     */
    public final static PlannedOrderField<LocalDateTime> PLND_ORDER_PLANNED_END_DATE =
        new PlannedOrderField<LocalDateTime>("PlndOrderPlannedEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlndOrderPlannedEndTime</b>
     * </p>
     *
     * @return Planned Order End Time
     */
    @SerializedName( "PlndOrderPlannedEndTime" )
    @JsonProperty( "PlndOrderPlannedEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "PlndOrderPlannedEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime plndOrderPlannedEndTime;
    /**
     * Use with available fluent helpers to apply the <b>PlndOrderPlannedEndTime</b> field to query operations.
     *
     */
    public final static PlannedOrderField<LocalTime> PLND_ORDER_PLANNED_END_TIME =
        new PlannedOrderField<LocalTime>("PlndOrderPlannedEndTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrderOpeningDate</b>
     * </p>
     *
     * @return Planned Opening Date in Planned Order
     */
    @SerializedName( "PlannedOrderOpeningDate" )
    @JsonProperty( "PlannedOrderOpeningDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PlannedOrderOpeningDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime plannedOrderOpeningDate;
    /**
     * Use with available fluent helpers to apply the <b>PlannedOrderOpeningDate</b> field to query operations.
     *
     */
    public final static PlannedOrderField<LocalDateTime> PLANNED_ORDER_OPENING_DATE =
        new PlannedOrderField<LocalDateTime>("PlannedOrderOpeningDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Change to Planned Order: Time Stamp
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static PlannedOrderField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new PlannedOrderField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductionStartDate</b>
     * </p>
     *
     * @return Start Date for Production
     */
    @SerializedName( "ProductionStartDate" )
    @JsonProperty( "ProductionStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProductionStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime productionStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ProductionStartDate</b> field to query operations.
     *
     */
    public final static PlannedOrderField<LocalDateTime> PRODUCTION_START_DATE =
        new PlannedOrderField<LocalDateTime>("ProductionStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductionEndDate</b>
     * </p>
     *
     * @return End Date for Production
     */
    @SerializedName( "ProductionEndDate" )
    @JsonProperty( "ProductionEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProductionEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime productionEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ProductionEndDate</b> field to query operations.
     *
     */
    public final static PlannedOrderField<LocalDateTime> PRODUCTION_END_DATE =
        new PlannedOrderField<LocalDateTime>("ProductionEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> SALES_ORDER = new PlannedOrderField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Order Item
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> SALES_ORDER_ITEM = new PlannedOrderField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> CUSTOMER = new PlannedOrderField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @return Work Breakdown Structure Element Internal ID
     */
    @SerializedName( "WBSElementInternalID" )
    @JsonProperty( "WBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementInternalID" )
    private String wBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementInternalID</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> WBS_ELEMENT_INTERNAL_ID =
        new PlannedOrderField<String>("WBSElementInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return WBS Element
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> WBS_ELEMENT = new PlannedOrderField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WBSDescription</b>
     * </p>
     *
     * @return WBS Element Name
     */
    @SerializedName( "WBSDescription" )
    @JsonProperty( "WBSDescription" )
    @Nullable
    @ODataField( odataName = "WBSDescription" )
    private String wBSDescription;
    /**
     * Use with available fluent helpers to apply the <b>WBSDescription</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> WBS_DESCRIPTION = new PlannedOrderField<String>("WBSDescription");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentCategory</b>
     * </p>
     *
     * @return Account Assignment Category
     */
    @SerializedName( "AccountAssignmentCategory" )
    @JsonProperty( "AccountAssignmentCategory" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentCategory" )
    private String accountAssignmentCategory;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentCategory</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> ACCOUNT_ASSIGNMENT_CATEGORY =
        new PlannedOrderField<String>("AccountAssignmentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @return Number of reservation/dependent requirements
     */
    @SerializedName( "Reservation" )
    @JsonProperty( "Reservation" )
    @Nullable
    @ODataField( odataName = "Reservation" )
    private String reservation;
    /**
     * Use with available fluent helpers to apply the <b>Reservation</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> RESERVATION = new PlannedOrderField<String>("Reservation");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @return MRP Controller
     */
    @SerializedName( "MRPController" )
    @JsonProperty( "MRPController" )
    @Nullable
    @ODataField( odataName = "MRPController" )
    private String mRPController;
    /**
     * Use with available fluent helpers to apply the <b>MRPController</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> MRP_CONTROLLER = new PlannedOrderField<String>("MRPController");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupervisor</b>
     * </p>
     *
     * @return Production Supervisor
     */
    @SerializedName( "ProductionSupervisor" )
    @JsonProperty( "ProductionSupervisor" )
    @Nullable
    @ODataField( odataName = "ProductionSupervisor" )
    private String productionSupervisor;
    /**
     * Use with available fluent helpers to apply the <b>ProductionSupervisor</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> PRODUCTION_SUPERVISOR =
        new PlannedOrderField<String>("ProductionSupervisor");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> PURCHASING_GROUP = new PlannedOrderField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> PURCHASING_ORGANIZATION =
        new PlannedOrderField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FixedSupplier</b>
     * </p>
     *
     * @return Fixed Vendor
     */
    @SerializedName( "FixedSupplier" )
    @JsonProperty( "FixedSupplier" )
    @Nullable
    @ODataField( odataName = "FixedSupplier" )
    private String fixedSupplier;
    /**
     * Use with available fluent helpers to apply the <b>FixedSupplier</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> FIXED_SUPPLIER = new PlannedOrderField<String>("FixedSupplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @return Purchase Schedule/Outline Agreement
     */
    @SerializedName( "PurchasingDocument" )
    @JsonProperty( "PurchasingDocument" )
    @Nullable
    @ODataField( odataName = "PurchasingDocument" )
    private String purchasingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocument</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> PURCHASING_DOCUMENT =
        new PlannedOrderField<String>("PurchasingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @return Purchase Schedule/Outline Agreement Item
     */
    @SerializedName( "PurchasingDocumentItem" )
    @JsonProperty( "PurchasingDocumentItem" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItem" )
    private String purchasingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItem</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> PURCHASING_DOCUMENT_ITEM =
        new PlannedOrderField<String>("PurchasingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>QuotaArrangement</b>
     * </p>
     *
     * @return Quota Arrangement
     */
    @SerializedName( "QuotaArrangement" )
    @JsonProperty( "QuotaArrangement" )
    @Nullable
    @ODataField( odataName = "QuotaArrangement" )
    private String quotaArrangement;
    /**
     * Use with available fluent helpers to apply the <b>QuotaArrangement</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> QUOTA_ARRANGEMENT = new PlannedOrderField<String>("QuotaArrangement");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuotaArrangementItem</b>
     * </p>
     *
     * @return Quota Arrangement Item
     */
    @SerializedName( "QuotaArrangementItem" )
    @JsonProperty( "QuotaArrangementItem" )
    @Nullable
    @ODataField( odataName = "QuotaArrangementItem" )
    private String quotaArrangementItem;
    /**
     * Use with available fluent helpers to apply the <b>QuotaArrangementItem</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> QUOTA_ARRANGEMENT_ITEM =
        new PlannedOrderField<String>("QuotaArrangementItem");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>SupplierName</b>
     * </p>
     *
     * @return Name of Supplier
     */
    @SerializedName( "SupplierName" )
    @JsonProperty( "SupplierName" )
    @Nullable
    @ODataField( odataName = "SupplierName" )
    private String supplierName;
    /**
     * Use with available fluent helpers to apply the <b>SupplierName</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> SUPPLIER_NAME = new PlannedOrderField<String>("SupplierName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrderIsFirm</b>
     * </p>
     *
     * @return Firming Indicator for Planned Order Data
     */
    @SerializedName( "PlannedOrderIsFirm" )
    @JsonProperty( "PlannedOrderIsFirm" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PlannedOrderIsFirm" )
    private Boolean plannedOrderIsFirm;
    /**
     * Use with available fluent helpers to apply the <b>PlannedOrderIsFirm</b> field to query operations.
     *
     */
    public final static PlannedOrderField<Boolean> PLANNED_ORDER_IS_FIRM =
        new PlannedOrderField<Boolean>("PlannedOrderIsFirm");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrderIsConvertible</b>
     * </p>
     *
     * @return Planned Order Conversion Indicator
     */
    @SerializedName( "PlannedOrderIsConvertible" )
    @JsonProperty( "PlannedOrderIsConvertible" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PlannedOrderIsConvertible" )
    private Boolean plannedOrderIsConvertible;
    /**
     * Use with available fluent helpers to apply the <b>PlannedOrderIsConvertible</b> field to query operations.
     *
     */
    public final static PlannedOrderField<Boolean> PLANNED_ORDER_IS_CONVERTIBLE =
        new PlannedOrderField<Boolean>("PlannedOrderIsConvertible");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrderBOMIsFixed</b>
     * </p>
     *
     * @return Fixing Indicator for BOM Explosion
     */
    @SerializedName( "PlannedOrderBOMIsFixed" )
    @JsonProperty( "PlannedOrderBOMIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PlannedOrderBOMIsFixed" )
    private Boolean plannedOrderBOMIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>PlannedOrderBOMIsFixed</b> field to query operations.
     *
     */
    public final static PlannedOrderField<Boolean> PLANNED_ORDER_BOM_IS_FIXED =
        new PlannedOrderField<Boolean>("PlannedOrderBOMIsFixed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrderCapacityIsDsptchd</b>
     * </p>
     *
     * @return Indicator: Capacity for Planned Order is Dispatched
     */
    @SerializedName( "PlannedOrderCapacityIsDsptchd" )
    @JsonProperty( "PlannedOrderCapacityIsDsptchd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PlannedOrderCapacityIsDsptchd" )
    private Boolean plannedOrderCapacityIsDsptchd;
    /**
     * Use with available fluent helpers to apply the <b>PlannedOrderCapacityIsDsptchd</b> field to query operations.
     *
     */
    public final static PlannedOrderField<Boolean> PLANNED_ORDER_CAPACITY_IS_DSPTCHD =
        new PlannedOrderField<Boolean>("PlannedOrderCapacityIsDsptchd");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirement</b>
     * </p>
     *
     * @return ID of the Capacity Requirements Record
     */
    @SerializedName( "CapacityRequirement" )
    @JsonProperty( "CapacityRequirement" )
    @Nullable
    @ODataField( odataName = "CapacityRequirement" )
    private String capacityRequirement;
    /**
     * Use with available fluent helpers to apply the <b>CapacityRequirement</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> CAPACITY_REQUIREMENT =
        new PlannedOrderField<String>("CapacityRequirement");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirementOrigin</b>
     * </p>
     *
     * @return Capacity Requirement Origin
     */
    @SerializedName( "CapacityRequirementOrigin" )
    @JsonProperty( "CapacityRequirementOrigin" )
    @Nullable
    @ODataField( odataName = "CapacityRequirementOrigin" )
    private String capacityRequirementOrigin;
    /**
     * Use with available fluent helpers to apply the <b>CapacityRequirementOrigin</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> CAPACITY_REQUIREMENT_ORIGIN =
        new PlannedOrderField<String>("CapacityRequirementOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsType</b>
     * </p>
     *
     * @return Task List Type
     */
    @SerializedName( "BillOfOperationsType" )
    @JsonProperty( "BillOfOperationsType" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsType" )
    private String billOfOperationsType;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsType</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> BILL_OF_OPERATIONS_TYPE =
        new PlannedOrderField<String>("BillOfOperationsType");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @SerializedName( "BillOfOperationsGroup" )
    @JsonProperty( "BillOfOperationsGroup" )
    @Nullable
    @ODataField( odataName = "BillOfOperationsGroup" )
    private String billOfOperationsGroup;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperationsGroup</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> BILL_OF_OPERATIONS_GROUP =
        new PlannedOrderField<String>("BillOfOperationsGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperations</b>
     * </p>
     *
     * @return Group Counter
     */
    @SerializedName( "BillOfOperations" )
    @JsonProperty( "BillOfOperations" )
    @Nullable
    @ODataField( odataName = "BillOfOperations" )
    private String billOfOperations;
    /**
     * Use with available fluent helpers to apply the <b>BillOfOperations</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> BILL_OF_OPERATIONS =
        new PlannedOrderField<String>("BillOfOperations");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastScheduledDate</b>
     * </p>
     *
     * @return Date of the Last Scheduling
     */
    @SerializedName( "LastScheduledDate" )
    @JsonProperty( "LastScheduledDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastScheduledDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastScheduledDate;
    /**
     * Use with available fluent helpers to apply the <b>LastScheduledDate</b> field to query operations.
     *
     */
    public final static PlannedOrderField<LocalDateTime> LAST_SCHEDULED_DATE =
        new PlannedOrderField<LocalDateTime>("LastScheduledDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicEndDate</b>
     * </p>
     *
     * @return Scheduled finish
     */
    @SerializedName( "ScheduledBasicEndDate" )
    @JsonProperty( "ScheduledBasicEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ScheduledBasicEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime scheduledBasicEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ScheduledBasicEndDate</b> field to query operations.
     *
     */
    public final static PlannedOrderField<LocalDateTime> SCHEDULED_BASIC_END_DATE =
        new PlannedOrderField<LocalDateTime>("ScheduledBasicEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicEndTime</b>
     * </p>
     *
     * @return Earliest finish of operation (time)
     */
    @SerializedName( "ScheduledBasicEndTime" )
    @JsonProperty( "ScheduledBasicEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ScheduledBasicEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime scheduledBasicEndTime;
    /**
     * Use with available fluent helpers to apply the <b>ScheduledBasicEndTime</b> field to query operations.
     *
     */
    public final static PlannedOrderField<LocalTime> SCHEDULED_BASIC_END_TIME =
        new PlannedOrderField<LocalTime>("ScheduledBasicEndTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicStartDate</b>
     * </p>
     *
     * @return Scheduled start
     */
    @SerializedName( "ScheduledBasicStartDate" )
    @JsonProperty( "ScheduledBasicStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ScheduledBasicStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime scheduledBasicStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ScheduledBasicStartDate</b> field to query operations.
     *
     */
    public final static PlannedOrderField<LocalDateTime> SCHEDULED_BASIC_START_DATE =
        new PlannedOrderField<LocalDateTime>("ScheduledBasicStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicStartTime</b>
     * </p>
     *
     * @return Earliest scheduled start: Execution (time)
     */
    @SerializedName( "ScheduledBasicStartTime" )
    @JsonProperty( "ScheduledBasicStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ScheduledBasicStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime scheduledBasicStartTime;
    /**
     * Use with available fluent helpers to apply the <b>ScheduledBasicStartTime</b> field to query operations.
     *
     */
    public final static PlannedOrderField<LocalTime> SCHEDULED_BASIC_START_TIME =
        new PlannedOrderField<LocalTime>("ScheduledBasicStartTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingType</b>
     * </p>
     *
     * @return Scheduling Type
     */
    @SerializedName( "SchedulingType" )
    @JsonProperty( "SchedulingType" )
    @Nullable
    @ODataField( odataName = "SchedulingType" )
    private String schedulingType;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingType</b> field to query operations.
     *
     */
    public final static PlannedOrderField<String> SCHEDULING_TYPE = new PlannedOrderField<String>("SchedulingType");
    /**
     * Navigation property <b>to_PlannedOrderCapacity</b> for <b>PlannedOrder</b> to multiple
     * <b>PlannedOrderCapacity</b>.
     *
     */
    @SerializedName( "to_PlannedOrderCapacity" )
    @JsonProperty( "to_PlannedOrderCapacity" )
    @ODataField( odataName = "to_PlannedOrderCapacity" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PlannedOrderCapacity> toPlannedOrderCapacity;
    /**
     * Navigation property <b>to_PlannedOrderComponent</b> for <b>PlannedOrder</b> to multiple
     * <b>PlannedOrderComponent</b>.
     *
     */
    @SerializedName( "to_PlannedOrderComponent" )
    @JsonProperty( "to_PlannedOrderComponent" )
    @ODataField( odataName = "to_PlannedOrderComponent" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PlannedOrderComponent> toPlannedOrderComponent;
    /**
     * Use with available fluent helpers to apply the <b>to_PlannedOrderCapacity</b> navigation property to query
     * operations.
     *
     */
    public final static PlannedOrderLink<PlannedOrderCapacity> TO_PLANNED_ORDER_CAPACITY =
        new PlannedOrderLink<PlannedOrderCapacity>("to_PlannedOrderCapacity");
    /**
     * Use with available fluent helpers to apply the <b>to_PlannedOrderComponent</b> navigation property to query
     * operations.
     *
     */
    public final static PlannedOrderLink<PlannedOrderComponent> TO_PLANNED_ORDER_COMPONENT =
        new PlannedOrderLink<PlannedOrderComponent>("to_PlannedOrderComponent");

    @Nonnull
    @Override
    public Class<PlannedOrder> getType()
    {
        return PlannedOrder.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrder</b>
     * </p>
     *
     * @param plannedOrder
     *            Planned Order
     */
    public void setPlannedOrder( @Nullable final String plannedOrder )
    {
        rememberChangedField("PlannedOrder", this.plannedOrder);
        this.plannedOrder = plannedOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrderType</b>
     * </p>
     *
     * @param plannedOrderType
     *            Planned Order Type
     */
    public void setPlannedOrderType( @Nullable final String plannedOrderType )
    {
        rememberChangedField("PlannedOrderType", this.plannedOrderType);
        this.plannedOrderType = plannedOrderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrderProfile</b>
     * </p>
     *
     * @param plannedOrderProfile
     *            Planned order profile
     */
    public void setPlannedOrderProfile( @Nullable final String plannedOrderProfile )
    {
        rememberChangedField("PlannedOrderProfile", this.plannedOrderProfile);
        this.plannedOrderProfile = plannedOrderProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Planning material
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @param materialName
     *            Material Description
     */
    public void setMaterialName( @Nullable final String materialName )
    {
        rememberChangedField("MaterialName", this.materialName);
        this.materialName = materialName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @param productionPlant
     *            Production Plant
     */
    public void setProductionPlant( @Nullable final String productionPlant )
    {
        rememberChangedField("ProductionPlant", this.productionPlant);
        this.productionPlant = productionPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlant</b>
     * </p>
     *
     * @param mRPPlant
     *            Planning Plant
     */
    public void setMRPPlant( @Nullable final String mRPPlant )
    {
        rememberChangedField("MRPPlant", this.mRPPlant);
        this.mRPPlant = mRPPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @param mRPArea
     *            MRP Area
     */
    public void setMRPArea( @Nullable final String mRPArea )
    {
        rememberChangedField("MRPArea", this.mRPArea);
        this.mRPArea = mRPArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionVersion</b>
     * </p>
     *
     * @param productionVersion
     *            Production Version
     */
    public void setProductionVersion( @Nullable final String productionVersion )
    {
        rememberChangedField("ProductionVersion", this.productionVersion);
        this.productionVersion = productionVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialProcurementCategory</b>
     * </p>
     *
     * @param materialProcurementCategory
     *            Material Procurement Category
     */
    public void setMaterialProcurementCategory( @Nullable final String materialProcurementCategory )
    {
        rememberChangedField("MaterialProcurementCategory", this.materialProcurementCategory);
        this.materialProcurementCategory = materialProcurementCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialProcurementType</b>
     * </p>
     *
     * @param materialProcurementType
     *            Material Procurement Type
     */
    public void setMaterialProcurementType( @Nullable final String materialProcurementType )
    {
        rememberChangedField("MaterialProcurementType", this.materialProcurementType);
        this.materialProcurementType = materialProcurementType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalQuantity</b>
     * </p>
     *
     * @param totalQuantity
     *            Planned Total Order Quantity
     */
    public void setTotalQuantity( @Nullable final BigDecimal totalQuantity )
    {
        rememberChangedField("TotalQuantity", this.totalQuantity);
        this.totalQuantity = totalQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlndOrderPlannedScrapQty</b>
     * </p>
     *
     * @param plndOrderPlannedScrapQty
     *            Planned Scrap Quantity
     */
    public void setPlndOrderPlannedScrapQty( @Nullable final BigDecimal plndOrderPlannedScrapQty )
    {
        rememberChangedField("PlndOrderPlannedScrapQty", this.plndOrderPlannedScrapQty);
        this.plndOrderPlannedScrapQty = plndOrderPlannedScrapQty;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptQty</b>
     * </p>
     *
     * @param goodsReceiptQty
     *            Quantity of Goods Received
     */
    public void setGoodsReceiptQty( @Nullable final BigDecimal goodsReceiptQty )
    {
        rememberChangedField("GoodsReceiptQty", this.goodsReceiptQty);
        this.goodsReceiptQty = goodsReceiptQty;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>IssuedQuantity</b>
     * </p>
     *
     * @param issuedQuantity
     *            Issued Quantity
     */
    public void setIssuedQuantity( @Nullable final BigDecimal issuedQuantity )
    {
        rememberChangedField("IssuedQuantity", this.issuedQuantity);
        this.issuedQuantity = issuedQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlndOrderPlannedStartDate</b>
     * </p>
     *
     * @param plndOrderPlannedStartDate
     *            Planned Order Start Date
     */
    public void setPlndOrderPlannedStartDate( @Nullable final LocalDateTime plndOrderPlannedStartDate )
    {
        rememberChangedField("PlndOrderPlannedStartDate", this.plndOrderPlannedStartDate);
        this.plndOrderPlannedStartDate = plndOrderPlannedStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlndOrderPlannedStartTime</b>
     * </p>
     *
     * @param plndOrderPlannedStartTime
     *            Planned Order Start Time
     */
    public void setPlndOrderPlannedStartTime( @Nullable final LocalTime plndOrderPlannedStartTime )
    {
        rememberChangedField("PlndOrderPlannedStartTime", this.plndOrderPlannedStartTime);
        this.plndOrderPlannedStartTime = plndOrderPlannedStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlndOrderPlannedEndDate</b>
     * </p>
     *
     * @param plndOrderPlannedEndDate
     *            Planned Order End Date
     */
    public void setPlndOrderPlannedEndDate( @Nullable final LocalDateTime plndOrderPlannedEndDate )
    {
        rememberChangedField("PlndOrderPlannedEndDate", this.plndOrderPlannedEndDate);
        this.plndOrderPlannedEndDate = plndOrderPlannedEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlndOrderPlannedEndTime</b>
     * </p>
     *
     * @param plndOrderPlannedEndTime
     *            Planned Order End Time
     */
    public void setPlndOrderPlannedEndTime( @Nullable final LocalTime plndOrderPlannedEndTime )
    {
        rememberChangedField("PlndOrderPlannedEndTime", this.plndOrderPlannedEndTime);
        this.plndOrderPlannedEndTime = plndOrderPlannedEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrderOpeningDate</b>
     * </p>
     *
     * @param plannedOrderOpeningDate
     *            Planned Opening Date in Planned Order
     */
    public void setPlannedOrderOpeningDate( @Nullable final LocalDateTime plannedOrderOpeningDate )
    {
        rememberChangedField("PlannedOrderOpeningDate", this.plannedOrderOpeningDate);
        this.plannedOrderOpeningDate = plannedOrderOpeningDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Change to Planned Order: Time Stamp
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductionStartDate</b>
     * </p>
     *
     * @param productionStartDate
     *            Start Date for Production
     */
    public void setProductionStartDate( @Nullable final LocalDateTime productionStartDate )
    {
        rememberChangedField("ProductionStartDate", this.productionStartDate);
        this.productionStartDate = productionStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProductionEndDate</b>
     * </p>
     *
     * @param productionEndDate
     *            End Date for Production
     */
    public void setProductionEndDate( @Nullable final LocalDateTime productionEndDate )
    {
        rememberChangedField("ProductionEndDate", this.productionEndDate);
        this.productionEndDate = productionEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Order Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @param wBSElementInternalID
     *            Work Breakdown Structure Element Internal ID
     */
    public void setWBSElementInternalID( @Nullable final String wBSElementInternalID )
    {
        rememberChangedField("WBSElementInternalID", this.wBSElementInternalID);
        this.wBSElementInternalID = wBSElementInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            WBS Element
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WBSDescription</b>
     * </p>
     *
     * @param wBSDescription
     *            WBS Element Name
     */
    public void setWBSDescription( @Nullable final String wBSDescription )
    {
        rememberChangedField("WBSDescription", this.wBSDescription);
        this.wBSDescription = wBSDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentCategory</b>
     * </p>
     *
     * @param accountAssignmentCategory
     *            Account Assignment Category
     */
    public void setAccountAssignmentCategory( @Nullable final String accountAssignmentCategory )
    {
        rememberChangedField("AccountAssignmentCategory", this.accountAssignmentCategory);
        this.accountAssignmentCategory = accountAssignmentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @param reservation
     *            Number of reservation/dependent requirements
     */
    public void setReservation( @Nullable final String reservation )
    {
        rememberChangedField("Reservation", this.reservation);
        this.reservation = reservation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @param mRPController
     *            MRP Controller
     */
    public void setMRPController( @Nullable final String mRPController )
    {
        rememberChangedField("MRPController", this.mRPController);
        this.mRPController = mRPController;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupervisor</b>
     * </p>
     *
     * @param productionSupervisor
     *            Production Supervisor
     */
    public void setProductionSupervisor( @Nullable final String productionSupervisor )
    {
        rememberChangedField("ProductionSupervisor", this.productionSupervisor);
        this.productionSupervisor = productionSupervisor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FixedSupplier</b>
     * </p>
     *
     * @param fixedSupplier
     *            Fixed Vendor
     */
    public void setFixedSupplier( @Nullable final String fixedSupplier )
    {
        rememberChangedField("FixedSupplier", this.fixedSupplier);
        this.fixedSupplier = fixedSupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @param purchasingDocument
     *            Purchase Schedule/Outline Agreement
     */
    public void setPurchasingDocument( @Nullable final String purchasingDocument )
    {
        rememberChangedField("PurchasingDocument", this.purchasingDocument);
        this.purchasingDocument = purchasingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @param purchasingDocumentItem
     *            Purchase Schedule/Outline Agreement Item
     */
    public void setPurchasingDocumentItem( @Nullable final String purchasingDocumentItem )
    {
        rememberChangedField("PurchasingDocumentItem", this.purchasingDocumentItem);
        this.purchasingDocumentItem = purchasingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>QuotaArrangement</b>
     * </p>
     *
     * @param quotaArrangement
     *            Quota Arrangement
     */
    public void setQuotaArrangement( @Nullable final String quotaArrangement )
    {
        rememberChangedField("QuotaArrangement", this.quotaArrangement);
        this.quotaArrangement = quotaArrangement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuotaArrangementItem</b>
     * </p>
     *
     * @param quotaArrangementItem
     *            Quota Arrangement Item
     */
    public void setQuotaArrangementItem( @Nullable final String quotaArrangementItem )
    {
        rememberChangedField("QuotaArrangementItem", this.quotaArrangementItem);
        this.quotaArrangementItem = quotaArrangementItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>SupplierName</b>
     * </p>
     *
     * @param supplierName
     *            Name of Supplier
     */
    public void setSupplierName( @Nullable final String supplierName )
    {
        rememberChangedField("SupplierName", this.supplierName);
        this.supplierName = supplierName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrderIsFirm</b>
     * </p>
     *
     * @param plannedOrderIsFirm
     *            Firming Indicator for Planned Order Data
     */
    public void setPlannedOrderIsFirm( @Nullable final Boolean plannedOrderIsFirm )
    {
        rememberChangedField("PlannedOrderIsFirm", this.plannedOrderIsFirm);
        this.plannedOrderIsFirm = plannedOrderIsFirm;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrderIsConvertible</b>
     * </p>
     *
     * @param plannedOrderIsConvertible
     *            Planned Order Conversion Indicator
     */
    public void setPlannedOrderIsConvertible( @Nullable final Boolean plannedOrderIsConvertible )
    {
        rememberChangedField("PlannedOrderIsConvertible", this.plannedOrderIsConvertible);
        this.plannedOrderIsConvertible = plannedOrderIsConvertible;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrderBOMIsFixed</b>
     * </p>
     *
     * @param plannedOrderBOMIsFixed
     *            Fixing Indicator for BOM Explosion
     */
    public void setPlannedOrderBOMIsFixed( @Nullable final Boolean plannedOrderBOMIsFixed )
    {
        rememberChangedField("PlannedOrderBOMIsFixed", this.plannedOrderBOMIsFixed);
        this.plannedOrderBOMIsFixed = plannedOrderBOMIsFixed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrderCapacityIsDsptchd</b>
     * </p>
     *
     * @param plannedOrderCapacityIsDsptchd
     *            Indicator: Capacity for Planned Order is Dispatched
     */
    public void setPlannedOrderCapacityIsDsptchd( @Nullable final Boolean plannedOrderCapacityIsDsptchd )
    {
        rememberChangedField("PlannedOrderCapacityIsDsptchd", this.plannedOrderCapacityIsDsptchd);
        this.plannedOrderCapacityIsDsptchd = plannedOrderCapacityIsDsptchd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirement</b>
     * </p>
     *
     * @param capacityRequirement
     *            ID of the Capacity Requirements Record
     */
    public void setCapacityRequirement( @Nullable final String capacityRequirement )
    {
        rememberChangedField("CapacityRequirement", this.capacityRequirement);
        this.capacityRequirement = capacityRequirement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirementOrigin</b>
     * </p>
     *
     * @param capacityRequirementOrigin
     *            Capacity Requirement Origin
     */
    public void setCapacityRequirementOrigin( @Nullable final String capacityRequirementOrigin )
    {
        rememberChangedField("CapacityRequirementOrigin", this.capacityRequirementOrigin);
        this.capacityRequirementOrigin = capacityRequirementOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsType</b>
     * </p>
     *
     * @param billOfOperationsType
     *            Task List Type
     */
    public void setBillOfOperationsType( @Nullable final String billOfOperationsType )
    {
        rememberChangedField("BillOfOperationsType", this.billOfOperationsType);
        this.billOfOperationsType = billOfOperationsType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperationsGroup</b>
     * </p>
     *
     * @param billOfOperationsGroup
     *            Key for Task List Group
     */
    public void setBillOfOperationsGroup( @Nullable final String billOfOperationsGroup )
    {
        rememberChangedField("BillOfOperationsGroup", this.billOfOperationsGroup);
        this.billOfOperationsGroup = billOfOperationsGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfOperations</b>
     * </p>
     *
     * @param billOfOperations
     *            Group Counter
     */
    public void setBillOfOperations( @Nullable final String billOfOperations )
    {
        rememberChangedField("BillOfOperations", this.billOfOperations);
        this.billOfOperations = billOfOperations;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastScheduledDate</b>
     * </p>
     *
     * @param lastScheduledDate
     *            Date of the Last Scheduling
     */
    public void setLastScheduledDate( @Nullable final LocalDateTime lastScheduledDate )
    {
        rememberChangedField("LastScheduledDate", this.lastScheduledDate);
        this.lastScheduledDate = lastScheduledDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicEndDate</b>
     * </p>
     *
     * @param scheduledBasicEndDate
     *            Scheduled finish
     */
    public void setScheduledBasicEndDate( @Nullable final LocalDateTime scheduledBasicEndDate )
    {
        rememberChangedField("ScheduledBasicEndDate", this.scheduledBasicEndDate);
        this.scheduledBasicEndDate = scheduledBasicEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicEndTime</b>
     * </p>
     *
     * @param scheduledBasicEndTime
     *            Earliest finish of operation (time)
     */
    public void setScheduledBasicEndTime( @Nullable final LocalTime scheduledBasicEndTime )
    {
        rememberChangedField("ScheduledBasicEndTime", this.scheduledBasicEndTime);
        this.scheduledBasicEndTime = scheduledBasicEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicStartDate</b>
     * </p>
     *
     * @param scheduledBasicStartDate
     *            Scheduled start
     */
    public void setScheduledBasicStartDate( @Nullable final LocalDateTime scheduledBasicStartDate )
    {
        rememberChangedField("ScheduledBasicStartDate", this.scheduledBasicStartDate);
        this.scheduledBasicStartDate = scheduledBasicStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicStartTime</b>
     * </p>
     *
     * @param scheduledBasicStartTime
     *            Earliest scheduled start: Execution (time)
     */
    public void setScheduledBasicStartTime( @Nullable final LocalTime scheduledBasicStartTime )
    {
        rememberChangedField("ScheduledBasicStartTime", this.scheduledBasicStartTime);
        this.scheduledBasicStartTime = scheduledBasicStartTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingType</b>
     * </p>
     *
     * @param schedulingType
     *            Scheduling Type
     */
    public void setSchedulingType( @Nullable final String schedulingType )
    {
        rememberChangedField("SchedulingType", this.schedulingType);
        this.schedulingType = schedulingType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PlannedOrder";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PlannedOrder", getPlannedOrder());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PlannedOrder", getPlannedOrder());
        values.put("PlannedOrderType", getPlannedOrderType());
        values.put("PlannedOrderProfile", getPlannedOrderProfile());
        values.put("Material", getMaterial());
        values.put("MaterialName", getMaterialName());
        values.put("ProductionPlant", getProductionPlant());
        values.put("MRPPlant", getMRPPlant());
        values.put("MRPArea", getMRPArea());
        values.put("ProductionVersion", getProductionVersion());
        values.put("MaterialProcurementCategory", getMaterialProcurementCategory());
        values.put("MaterialProcurementType", getMaterialProcurementType());
        values.put("StorageLocation", getStorageLocation());
        values.put("BaseUnit", getBaseUnit());
        values.put("TotalQuantity", getTotalQuantity());
        values.put("PlndOrderPlannedScrapQty", getPlndOrderPlannedScrapQty());
        values.put("GoodsReceiptQty", getGoodsReceiptQty());
        values.put("IssuedQuantity", getIssuedQuantity());
        values.put("PlndOrderPlannedStartDate", getPlndOrderPlannedStartDate());
        values.put("PlndOrderPlannedStartTime", getPlndOrderPlannedStartTime());
        values.put("PlndOrderPlannedEndDate", getPlndOrderPlannedEndDate());
        values.put("PlndOrderPlannedEndTime", getPlndOrderPlannedEndTime());
        values.put("PlannedOrderOpeningDate", getPlannedOrderOpeningDate());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("ProductionStartDate", getProductionStartDate());
        values.put("ProductionEndDate", getProductionEndDate());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("Customer", getCustomer());
        values.put("WBSElementInternalID", getWBSElementInternalID());
        values.put("WBSElement", getWBSElement());
        values.put("WBSDescription", getWBSDescription());
        values.put("AccountAssignmentCategory", getAccountAssignmentCategory());
        values.put("Reservation", getReservation());
        values.put("MRPController", getMRPController());
        values.put("ProductionSupervisor", getProductionSupervisor());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("FixedSupplier", getFixedSupplier());
        values.put("PurchasingDocument", getPurchasingDocument());
        values.put("PurchasingDocumentItem", getPurchasingDocumentItem());
        values.put("QuotaArrangement", getQuotaArrangement());
        values.put("QuotaArrangementItem", getQuotaArrangementItem());
        values.put("SupplierName", getSupplierName());
        values.put("PlannedOrderIsFirm", getPlannedOrderIsFirm());
        values.put("PlannedOrderIsConvertible", getPlannedOrderIsConvertible());
        values.put("PlannedOrderBOMIsFixed", getPlannedOrderBOMIsFixed());
        values.put("PlannedOrderCapacityIsDsptchd", getPlannedOrderCapacityIsDsptchd());
        values.put("CapacityRequirement", getCapacityRequirement());
        values.put("CapacityRequirementOrigin", getCapacityRequirementOrigin());
        values.put("BillOfOperationsType", getBillOfOperationsType());
        values.put("BillOfOperationsGroup", getBillOfOperationsGroup());
        values.put("BillOfOperations", getBillOfOperations());
        values.put("LastScheduledDate", getLastScheduledDate());
        values.put("ScheduledBasicEndDate", getScheduledBasicEndDate());
        values.put("ScheduledBasicEndTime", getScheduledBasicEndTime());
        values.put("ScheduledBasicStartDate", getScheduledBasicStartDate());
        values.put("ScheduledBasicStartTime", getScheduledBasicStartTime());
        values.put("SchedulingType", getSchedulingType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PlannedOrder") ) {
                final Object value = values.remove("PlannedOrder");
                if( (value == null) || (!value.equals(getPlannedOrder())) ) {
                    setPlannedOrder(((String) value));
                }
            }
            if( values.containsKey("PlannedOrderType") ) {
                final Object value = values.remove("PlannedOrderType");
                if( (value == null) || (!value.equals(getPlannedOrderType())) ) {
                    setPlannedOrderType(((String) value));
                }
            }
            if( values.containsKey("PlannedOrderProfile") ) {
                final Object value = values.remove("PlannedOrderProfile");
                if( (value == null) || (!value.equals(getPlannedOrderProfile())) ) {
                    setPlannedOrderProfile(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialName") ) {
                final Object value = values.remove("MaterialName");
                if( (value == null) || (!value.equals(getMaterialName())) ) {
                    setMaterialName(((String) value));
                }
            }
            if( values.containsKey("ProductionPlant") ) {
                final Object value = values.remove("ProductionPlant");
                if( (value == null) || (!value.equals(getProductionPlant())) ) {
                    setProductionPlant(((String) value));
                }
            }
            if( values.containsKey("MRPPlant") ) {
                final Object value = values.remove("MRPPlant");
                if( (value == null) || (!value.equals(getMRPPlant())) ) {
                    setMRPPlant(((String) value));
                }
            }
            if( values.containsKey("MRPArea") ) {
                final Object value = values.remove("MRPArea");
                if( (value == null) || (!value.equals(getMRPArea())) ) {
                    setMRPArea(((String) value));
                }
            }
            if( values.containsKey("ProductionVersion") ) {
                final Object value = values.remove("ProductionVersion");
                if( (value == null) || (!value.equals(getProductionVersion())) ) {
                    setProductionVersion(((String) value));
                }
            }
            if( values.containsKey("MaterialProcurementCategory") ) {
                final Object value = values.remove("MaterialProcurementCategory");
                if( (value == null) || (!value.equals(getMaterialProcurementCategory())) ) {
                    setMaterialProcurementCategory(((String) value));
                }
            }
            if( values.containsKey("MaterialProcurementType") ) {
                final Object value = values.remove("MaterialProcurementType");
                if( (value == null) || (!value.equals(getMaterialProcurementType())) ) {
                    setMaterialProcurementType(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("TotalQuantity") ) {
                final Object value = values.remove("TotalQuantity");
                if( (value == null) || (!value.equals(getTotalQuantity())) ) {
                    setTotalQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("PlndOrderPlannedScrapQty") ) {
                final Object value = values.remove("PlndOrderPlannedScrapQty");
                if( (value == null) || (!value.equals(getPlndOrderPlannedScrapQty())) ) {
                    setPlndOrderPlannedScrapQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("GoodsReceiptQty") ) {
                final Object value = values.remove("GoodsReceiptQty");
                if( (value == null) || (!value.equals(getGoodsReceiptQty())) ) {
                    setGoodsReceiptQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("IssuedQuantity") ) {
                final Object value = values.remove("IssuedQuantity");
                if( (value == null) || (!value.equals(getIssuedQuantity())) ) {
                    setIssuedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("PlndOrderPlannedStartDate") ) {
                final Object value = values.remove("PlndOrderPlannedStartDate");
                if( (value == null) || (!value.equals(getPlndOrderPlannedStartDate())) ) {
                    setPlndOrderPlannedStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PlndOrderPlannedStartTime") ) {
                final Object value = values.remove("PlndOrderPlannedStartTime");
                if( (value == null) || (!value.equals(getPlndOrderPlannedStartTime())) ) {
                    setPlndOrderPlannedStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("PlndOrderPlannedEndDate") ) {
                final Object value = values.remove("PlndOrderPlannedEndDate");
                if( (value == null) || (!value.equals(getPlndOrderPlannedEndDate())) ) {
                    setPlndOrderPlannedEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PlndOrderPlannedEndTime") ) {
                final Object value = values.remove("PlndOrderPlannedEndTime");
                if( (value == null) || (!value.equals(getPlndOrderPlannedEndTime())) ) {
                    setPlndOrderPlannedEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("PlannedOrderOpeningDate") ) {
                final Object value = values.remove("PlannedOrderOpeningDate");
                if( (value == null) || (!value.equals(getPlannedOrderOpeningDate())) ) {
                    setPlannedOrderOpeningDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ProductionStartDate") ) {
                final Object value = values.remove("ProductionStartDate");
                if( (value == null) || (!value.equals(getProductionStartDate())) ) {
                    setProductionStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProductionEndDate") ) {
                final Object value = values.remove("ProductionEndDate");
                if( (value == null) || (!value.equals(getProductionEndDate())) ) {
                    setProductionEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("WBSElementInternalID") ) {
                final Object value = values.remove("WBSElementInternalID");
                if( (value == null) || (!value.equals(getWBSElementInternalID())) ) {
                    setWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("WBSDescription") ) {
                final Object value = values.remove("WBSDescription");
                if( (value == null) || (!value.equals(getWBSDescription())) ) {
                    setWBSDescription(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentCategory") ) {
                final Object value = values.remove("AccountAssignmentCategory");
                if( (value == null) || (!value.equals(getAccountAssignmentCategory())) ) {
                    setAccountAssignmentCategory(((String) value));
                }
            }
            if( values.containsKey("Reservation") ) {
                final Object value = values.remove("Reservation");
                if( (value == null) || (!value.equals(getReservation())) ) {
                    setReservation(((String) value));
                }
            }
            if( values.containsKey("MRPController") ) {
                final Object value = values.remove("MRPController");
                if( (value == null) || (!value.equals(getMRPController())) ) {
                    setMRPController(((String) value));
                }
            }
            if( values.containsKey("ProductionSupervisor") ) {
                final Object value = values.remove("ProductionSupervisor");
                if( (value == null) || (!value.equals(getProductionSupervisor())) ) {
                    setProductionSupervisor(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("FixedSupplier") ) {
                final Object value = values.remove("FixedSupplier");
                if( (value == null) || (!value.equals(getFixedSupplier())) ) {
                    setFixedSupplier(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocument") ) {
                final Object value = values.remove("PurchasingDocument");
                if( (value == null) || (!value.equals(getPurchasingDocument())) ) {
                    setPurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItem") ) {
                final Object value = values.remove("PurchasingDocumentItem");
                if( (value == null) || (!value.equals(getPurchasingDocumentItem())) ) {
                    setPurchasingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("QuotaArrangement") ) {
                final Object value = values.remove("QuotaArrangement");
                if( (value == null) || (!value.equals(getQuotaArrangement())) ) {
                    setQuotaArrangement(((String) value));
                }
            }
            if( values.containsKey("QuotaArrangementItem") ) {
                final Object value = values.remove("QuotaArrangementItem");
                if( (value == null) || (!value.equals(getQuotaArrangementItem())) ) {
                    setQuotaArrangementItem(((String) value));
                }
            }
            if( values.containsKey("SupplierName") ) {
                final Object value = values.remove("SupplierName");
                if( (value == null) || (!value.equals(getSupplierName())) ) {
                    setSupplierName(((String) value));
                }
            }
            if( values.containsKey("PlannedOrderIsFirm") ) {
                final Object value = values.remove("PlannedOrderIsFirm");
                if( (value == null) || (!value.equals(getPlannedOrderIsFirm())) ) {
                    setPlannedOrderIsFirm(((Boolean) value));
                }
            }
            if( values.containsKey("PlannedOrderIsConvertible") ) {
                final Object value = values.remove("PlannedOrderIsConvertible");
                if( (value == null) || (!value.equals(getPlannedOrderIsConvertible())) ) {
                    setPlannedOrderIsConvertible(((Boolean) value));
                }
            }
            if( values.containsKey("PlannedOrderBOMIsFixed") ) {
                final Object value = values.remove("PlannedOrderBOMIsFixed");
                if( (value == null) || (!value.equals(getPlannedOrderBOMIsFixed())) ) {
                    setPlannedOrderBOMIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("PlannedOrderCapacityIsDsptchd") ) {
                final Object value = values.remove("PlannedOrderCapacityIsDsptchd");
                if( (value == null) || (!value.equals(getPlannedOrderCapacityIsDsptchd())) ) {
                    setPlannedOrderCapacityIsDsptchd(((Boolean) value));
                }
            }
            if( values.containsKey("CapacityRequirement") ) {
                final Object value = values.remove("CapacityRequirement");
                if( (value == null) || (!value.equals(getCapacityRequirement())) ) {
                    setCapacityRequirement(((String) value));
                }
            }
            if( values.containsKey("CapacityRequirementOrigin") ) {
                final Object value = values.remove("CapacityRequirementOrigin");
                if( (value == null) || (!value.equals(getCapacityRequirementOrigin())) ) {
                    setCapacityRequirementOrigin(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsType") ) {
                final Object value = values.remove("BillOfOperationsType");
                if( (value == null) || (!value.equals(getBillOfOperationsType())) ) {
                    setBillOfOperationsType(((String) value));
                }
            }
            if( values.containsKey("BillOfOperationsGroup") ) {
                final Object value = values.remove("BillOfOperationsGroup");
                if( (value == null) || (!value.equals(getBillOfOperationsGroup())) ) {
                    setBillOfOperationsGroup(((String) value));
                }
            }
            if( values.containsKey("BillOfOperations") ) {
                final Object value = values.remove("BillOfOperations");
                if( (value == null) || (!value.equals(getBillOfOperations())) ) {
                    setBillOfOperations(((String) value));
                }
            }
            if( values.containsKey("LastScheduledDate") ) {
                final Object value = values.remove("LastScheduledDate");
                if( (value == null) || (!value.equals(getLastScheduledDate())) ) {
                    setLastScheduledDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ScheduledBasicEndDate") ) {
                final Object value = values.remove("ScheduledBasicEndDate");
                if( (value == null) || (!value.equals(getScheduledBasicEndDate())) ) {
                    setScheduledBasicEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ScheduledBasicEndTime") ) {
                final Object value = values.remove("ScheduledBasicEndTime");
                if( (value == null) || (!value.equals(getScheduledBasicEndTime())) ) {
                    setScheduledBasicEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ScheduledBasicStartDate") ) {
                final Object value = values.remove("ScheduledBasicStartDate");
                if( (value == null) || (!value.equals(getScheduledBasicStartDate())) ) {
                    setScheduledBasicStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ScheduledBasicStartTime") ) {
                final Object value = values.remove("ScheduledBasicStartTime");
                if( (value == null) || (!value.equals(getScheduledBasicStartTime())) ) {
                    setScheduledBasicStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("SchedulingType") ) {
                final Object value = values.remove("SchedulingType");
                if( (value == null) || (!value.equals(getSchedulingType())) ) {
                    setSchedulingType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PlannedOrderCapacity") ) {
                final Object value = (values).remove("to_PlannedOrderCapacity");
                if( value instanceof Iterable ) {
                    if( toPlannedOrderCapacity == null ) {
                        toPlannedOrderCapacity = Lists.newArrayList();
                    } else {
                        toPlannedOrderCapacity = Lists.newArrayList(toPlannedOrderCapacity);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PlannedOrderCapacity entity;
                        if( toPlannedOrderCapacity.size() > i ) {
                            entity = toPlannedOrderCapacity.get(i);
                        } else {
                            entity = new PlannedOrderCapacity();
                            toPlannedOrderCapacity.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PlannedOrderComponent") ) {
                final Object value = (values).remove("to_PlannedOrderComponent");
                if( value instanceof Iterable ) {
                    if( toPlannedOrderComponent == null ) {
                        toPlannedOrderComponent = Lists.newArrayList();
                    } else {
                        toPlannedOrderComponent = Lists.newArrayList(toPlannedOrderComponent);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PlannedOrderComponent entity;
                        if( toPlannedOrderComponent.size() > i ) {
                            entity = toPlannedOrderComponent.get(i);
                        } else {
                            entity = new PlannedOrderComponent();
                            toPlannedOrderComponent.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PlannedOrderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PlannedOrderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PlannedOrderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PlannedOrderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPlannedOrderCapacity != null ) {
            (values).put("to_PlannedOrderCapacity", toPlannedOrderCapacity);
        }
        if( toPlannedOrderComponent != null ) {
            (values).put("to_PlannedOrderComponent", toPlannedOrderComponent);
        }
        return values;
    }

    /**
     * Fetches the <b>PlannedOrderCapacity</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PlannedOrderCapacity</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PlannedOrderCapacity</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PlannedOrderCapacity> fetchPlannedOrderCapacity()
    {
        return fetchFieldAsList("to_PlannedOrderCapacity", PlannedOrderCapacity.class);
    }

    /**
     * Retrieval of associated <b>PlannedOrderCapacity</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PlannedOrderCapacity</b>.
     * <p>
     * If the navigation property <b>to_PlannedOrderCapacity</b> of a queried <b>PlannedOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PlannedOrderCapacity</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PlannedOrderCapacity> getPlannedOrderCapacityOrFetch()
    {
        if( toPlannedOrderCapacity == null ) {
            toPlannedOrderCapacity = fetchPlannedOrderCapacity();
        }
        return toPlannedOrderCapacity;
    }

    /**
     * Retrieval of associated <b>PlannedOrderCapacity</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PlannedOrderCapacity</b>.
     * <p>
     * If the navigation property for an entity <b>PlannedOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PlannedOrderCapacity</b> is already loaded, the result
     *         will contain the <b>PlannedOrderCapacity</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PlannedOrderCapacity>> getPlannedOrderCapacityIfPresent()
    {
        return Option.of(toPlannedOrderCapacity);
    }

    /**
     * Overwrites the list of associated <b>PlannedOrderCapacity</b> entities for the loaded navigation property
     * <b>to_PlannedOrderCapacity</b>.
     * <p>
     * If the navigation property <b>to_PlannedOrderCapacity</b> of a queried <b>PlannedOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PlannedOrderCapacity</b> entities.
     */
    public void setPlannedOrderCapacity( @Nonnull final List<PlannedOrderCapacity> value )
    {
        if( toPlannedOrderCapacity == null ) {
            toPlannedOrderCapacity = Lists.newArrayList();
        }
        toPlannedOrderCapacity.clear();
        toPlannedOrderCapacity.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PlannedOrderCapacity</b> entities. This corresponds to the OData
     * navigation property <b>to_PlannedOrderCapacity</b>.
     * <p>
     * If the navigation property <b>to_PlannedOrderCapacity</b> of a queried <b>PlannedOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PlannedOrderCapacity</b> entities.
     */
    public void addPlannedOrderCapacity( PlannedOrderCapacity... entity )
    {
        if( toPlannedOrderCapacity == null ) {
            toPlannedOrderCapacity = Lists.newArrayList();
        }
        toPlannedOrderCapacity.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PlannedOrderComponent</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PlannedOrderComponent</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PlannedOrderComponent</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PlannedOrderComponent> fetchPlannedOrderComponent()
    {
        return fetchFieldAsList("to_PlannedOrderComponent", PlannedOrderComponent.class);
    }

    /**
     * Retrieval of associated <b>PlannedOrderComponent</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PlannedOrderComponent</b>.
     * <p>
     * If the navigation property <b>to_PlannedOrderComponent</b> of a queried <b>PlannedOrder</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PlannedOrderComponent</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PlannedOrderComponent> getPlannedOrderComponentOrFetch()
    {
        if( toPlannedOrderComponent == null ) {
            toPlannedOrderComponent = fetchPlannedOrderComponent();
        }
        return toPlannedOrderComponent;
    }

    /**
     * Retrieval of associated <b>PlannedOrderComponent</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PlannedOrderComponent</b>.
     * <p>
     * If the navigation property for an entity <b>PlannedOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PlannedOrderComponent</b> is already loaded, the result
     *         will contain the <b>PlannedOrderComponent</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PlannedOrderComponent>> getPlannedOrderComponentIfPresent()
    {
        return Option.of(toPlannedOrderComponent);
    }

    /**
     * Overwrites the list of associated <b>PlannedOrderComponent</b> entities for the loaded navigation property
     * <b>to_PlannedOrderComponent</b>.
     * <p>
     * If the navigation property <b>to_PlannedOrderComponent</b> of a queried <b>PlannedOrder</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PlannedOrderComponent</b> entities.
     */
    public void setPlannedOrderComponent( @Nonnull final List<PlannedOrderComponent> value )
    {
        if( toPlannedOrderComponent == null ) {
            toPlannedOrderComponent = Lists.newArrayList();
        }
        toPlannedOrderComponent.clear();
        toPlannedOrderComponent.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PlannedOrderComponent</b> entities. This corresponds to the OData
     * navigation property <b>to_PlannedOrderComponent</b>.
     * <p>
     * If the navigation property <b>to_PlannedOrderComponent</b> of a queried <b>PlannedOrder</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PlannedOrderComponent</b> entities.
     */
    public void addPlannedOrderComponent( PlannedOrderComponent... entity )
    {
        if( toPlannedOrderComponent == null ) {
            toPlannedOrderComponent = Lists.newArrayList();
        }
        toPlannedOrderComponent.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PlannedOrder instances.
     *
     */
    public final static class PlannedOrderBuilder
    {

        private List<PlannedOrderCapacity> toPlannedOrderCapacity = Lists.newArrayList();
        private List<PlannedOrderComponent> toPlannedOrderComponent = Lists.newArrayList();

        private PlannedOrder.PlannedOrderBuilder toPlannedOrderCapacity( final List<PlannedOrderCapacity> value )
        {
            toPlannedOrderCapacity.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PlannedOrderCapacity</b> for <b>PlannedOrder</b> to multiple
         * <b>PlannedOrderCapacity</b>.
         *
         * @param value
         *            The PlannedOrderCapacitys to build this PlannedOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PlannedOrder.PlannedOrderBuilder plannedOrderCapacity( PlannedOrderCapacity... value )
        {
            return toPlannedOrderCapacity(Lists.newArrayList(value));
        }

        private PlannedOrder.PlannedOrderBuilder toPlannedOrderComponent( final List<PlannedOrderComponent> value )
        {
            toPlannedOrderComponent.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PlannedOrderComponent</b> for <b>PlannedOrder</b> to multiple
         * <b>PlannedOrderComponent</b>.
         *
         * @param value
         *            The PlannedOrderComponents to build this PlannedOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PlannedOrder.PlannedOrderBuilder plannedOrderComponent( PlannedOrderComponent... value )
        {
            return toPlannedOrderComponent(Lists.newArrayList(value));
        }

    }

}
