/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.field.PlannedOrderCapacityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.selectable.PlannedOrderCapacitySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Planned Order Capacity
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PlannedOrderCapacityType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PlannedOrderCapacity extends VdmEntity<PlannedOrderCapacity>
{

    /**
     * Selector for all available fields of PlannedOrderCapacity.
     *
     */
    public final static PlannedOrderCapacitySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirement</b>
     * </p>
     *
     * @return ID of the Capacity Requirements Record
     */
    @Key
    @SerializedName( "CapacityRequirement" )
    @JsonProperty( "CapacityRequirement" )
    @Nullable
    @ODataField( odataName = "CapacityRequirement" )
    private String capacityRequirement;
    /**
     * Use with available fluent helpers to apply the <b>CapacityRequirement</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<String> CAPACITY_REQUIREMENT =
        new PlannedOrderCapacityField<String>("CapacityRequirement");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirementItem</b>
     * </p>
     *
     * @return Capacity Requirement Item
     */
    @Key
    @SerializedName( "CapacityRequirementItem" )
    @JsonProperty( "CapacityRequirementItem" )
    @Nullable
    @ODataField( odataName = "CapacityRequirementItem" )
    private String capacityRequirementItem;
    /**
     * Use with available fluent helpers to apply the <b>CapacityRequirementItem</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<String> CAPACITY_REQUIREMENT_ITEM =
        new PlannedOrderCapacityField<String>("CapacityRequirementItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRqmtItemCapacity</b>
     * </p>
     *
     * @return Individual Capacity of a Capacity Requirement Item
     */
    @Key
    @SerializedName( "CapacityRqmtItemCapacity" )
    @JsonProperty( "CapacityRqmtItemCapacity" )
    @Nullable
    @ODataField( odataName = "CapacityRqmtItemCapacity" )
    private String capacityRqmtItemCapacity;
    /**
     * Use with available fluent helpers to apply the <b>CapacityRqmtItemCapacity</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<String> CAPACITY_RQMT_ITEM_CAPACITY =
        new PlannedOrderCapacityField<String>("CapacityRqmtItemCapacity");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrder</b>
     * </p>
     *
     * @return Planned Order
     */
    @SerializedName( "PlannedOrder" )
    @JsonProperty( "PlannedOrder" )
    @Nullable
    @ODataField( odataName = "PlannedOrder" )
    private String plannedOrder;
    /**
     * Use with available fluent helpers to apply the <b>PlannedOrder</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<String> PLANNED_ORDER =
        new PlannedOrderCapacityField<String>("PlannedOrder");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrderType</b>
     * </p>
     *
     * @return Planned Order Type
     */
    @SerializedName( "PlannedOrderType" )
    @JsonProperty( "PlannedOrderType" )
    @Nullable
    @ODataField( odataName = "PlannedOrderType" )
    private String plannedOrderType;
    /**
     * Use with available fluent helpers to apply the <b>PlannedOrderType</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<String> PLANNED_ORDER_TYPE =
        new PlannedOrderCapacityField<String>("PlannedOrderType");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Sequence</b>
     * </p>
     *
     * @return Sequence
     */
    @SerializedName( "Sequence" )
    @JsonProperty( "Sequence" )
    @Nullable
    @ODataField( odataName = "Sequence" )
    private String sequence;
    /**
     * Use with available fluent helpers to apply the <b>Sequence</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<String> SEQUENCE = new PlannedOrderCapacityField<String>("Sequence");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Operation</b>
     * </p>
     *
     * @return Operation/Activity Number
     */
    @SerializedName( "Operation" )
    @JsonProperty( "Operation" )
    @Nullable
    @ODataField( odataName = "Operation" )
    private String operation;
    /**
     * Use with available fluent helpers to apply the <b>Operation</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<String> OPERATION =
        new PlannedOrderCapacityField<String>("Operation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SubOperation</b>
     * </p>
     *
     * @return Suboperation
     */
    @SerializedName( "SubOperation" )
    @JsonProperty( "SubOperation" )
    @Nullable
    @ODataField( odataName = "SubOperation" )
    private String subOperation;
    /**
     * Use with available fluent helpers to apply the <b>SubOperation</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<String> SUB_OPERATION =
        new PlannedOrderCapacityField<String>("SubOperation");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @SerializedName( "WorkCenter" )
    @JsonProperty( "WorkCenter" )
    @Nullable
    @ODataField( odataName = "WorkCenter" )
    private String workCenter;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenter</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<String> WORK_CENTER =
        new PlannedOrderCapacityField<String>("WorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryCode</b>
     * </p>
     *
     * @return Capacity Category
     */
    @SerializedName( "CapacityCategoryCode" )
    @JsonProperty( "CapacityCategoryCode" )
    @Nullable
    @ODataField( odataName = "CapacityCategoryCode" )
    private String capacityCategoryCode;
    /**
     * Use with available fluent helpers to apply the <b>CapacityCategoryCode</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<String> CAPACITY_CATEGORY_CODE =
        new PlannedOrderCapacityField<String>("CapacityCategoryCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Capacity</b>
     * </p>
     *
     * @return Capacity name
     */
    @SerializedName( "Capacity" )
    @JsonProperty( "Capacity" )
    @Nullable
    @ODataField( odataName = "Capacity" )
    private String capacity;
    /**
     * Use with available fluent helpers to apply the <b>Capacity</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<String> CAPACITY = new PlannedOrderCapacityField<String>("Capacity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @return MRP Controller
     */
    @SerializedName( "MRPController" )
    @JsonProperty( "MRPController" )
    @Nullable
    @ODataField( odataName = "MRPController" )
    private String mRPController;
    /**
     * Use with available fluent helpers to apply the <b>MRPController</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<String> MRP_CONTROLLER =
        new PlannedOrderCapacityField<String>("MRPController");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlant</b>
     * </p>
     *
     * @return Planning Plant
     */
    @SerializedName( "MRPPlant" )
    @JsonProperty( "MRPPlant" )
    @Nullable
    @ODataField( odataName = "MRPPlant" )
    private String mRPPlant;
    /**
     * Use with available fluent helpers to apply the <b>MRPPlant</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<String> MRP_PLANT = new PlannedOrderCapacityField<String>("MRPPlant");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestStartDate</b>
     * </p>
     *
     * @return Latest Start Date
     */
    @SerializedName( "OperationLatestStartDate" )
    @JsonProperty( "OperationLatestStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OperationLatestStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime operationLatestStartDate;
    /**
     * Use with available fluent helpers to apply the <b>OperationLatestStartDate</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<LocalDateTime> OPERATION_LATEST_START_DATE =
        new PlannedOrderCapacityField<LocalDateTime>("OperationLatestStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestStartTime</b>
     * </p>
     *
     * @return Latest Start Time
     */
    @SerializedName( "OperationLatestStartTime" )
    @JsonProperty( "OperationLatestStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OperationLatestStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime operationLatestStartTime;
    /**
     * Use with available fluent helpers to apply the <b>OperationLatestStartTime</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<LocalTime> OPERATION_LATEST_START_TIME =
        new PlannedOrderCapacityField<LocalTime>("OperationLatestStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestEndDate</b>
     * </p>
     *
     * @return Latest End Date
     */
    @SerializedName( "OperationLatestEndDate" )
    @JsonProperty( "OperationLatestEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OperationLatestEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime operationLatestEndDate;
    /**
     * Use with available fluent helpers to apply the <b>OperationLatestEndDate</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<LocalDateTime> OPERATION_LATEST_END_DATE =
        new PlannedOrderCapacityField<LocalDateTime>("OperationLatestEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestEndTime</b>
     * </p>
     *
     * @return Latest End Time
     */
    @SerializedName( "OperationLatestEndTime" )
    @JsonProperty( "OperationLatestEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OperationLatestEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime operationLatestEndTime;
    /**
     * Use with available fluent helpers to apply the <b>OperationLatestEndTime</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<LocalTime> OPERATION_LATEST_END_TIME =
        new PlannedOrderCapacityField<LocalTime>("OperationLatestEndTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationEarliestStartDate</b>
     * </p>
     *
     * @return Earliest Start Date
     */
    @SerializedName( "OperationEarliestStartDate" )
    @JsonProperty( "OperationEarliestStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OperationEarliestStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime operationEarliestStartDate;
    /**
     * Use with available fluent helpers to apply the <b>OperationEarliestStartDate</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<LocalDateTime> OPERATION_EARLIEST_START_DATE =
        new PlannedOrderCapacityField<LocalDateTime>("OperationEarliestStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationEarliestStartTime</b>
     * </p>
     *
     * @return Earliest Start Time
     */
    @SerializedName( "OperationEarliestStartTime" )
    @JsonProperty( "OperationEarliestStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OperationEarliestStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime operationEarliestStartTime;
    /**
     * Use with available fluent helpers to apply the <b>OperationEarliestStartTime</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<LocalTime> OPERATION_EARLIEST_START_TIME =
        new PlannedOrderCapacityField<LocalTime>("OperationEarliestStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationEarliestEndDate</b>
     * </p>
     *
     * @return Earliest End Date
     */
    @SerializedName( "OperationEarliestEndDate" )
    @JsonProperty( "OperationEarliestEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OperationEarliestEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime operationEarliestEndDate;
    /**
     * Use with available fluent helpers to apply the <b>OperationEarliestEndDate</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<LocalDateTime> OPERATION_EARLIEST_END_DATE =
        new PlannedOrderCapacityField<LocalDateTime>("OperationEarliestEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationEarliestEndTime</b>
     * </p>
     *
     * @return Earliest End Time
     */
    @SerializedName( "OperationEarliestEndTime" )
    @JsonProperty( "OperationEarliestEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OperationEarliestEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime operationEarliestEndTime;
    /**
     * Use with available fluent helpers to apply the <b>OperationEarliestEndTime</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<LocalTime> OPERATION_EARLIEST_END_TIME =
        new PlannedOrderCapacityField<LocalTime>("OperationEarliestEndTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldProcgStrtDte</b>
     * </p>
     *
     * @return Latest Scheduled Processing Start Date
     */
    @SerializedName( "OpLtstSchedldProcgStrtDte" )
    @JsonProperty( "OpLtstSchedldProcgStrtDte" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpLtstSchedldProcgStrtDte",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opLtstSchedldProcgStrtDte;
    /**
     * Use with available fluent helpers to apply the <b>OpLtstSchedldProcgStrtDte</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<LocalDateTime> OP_LTST_SCHEDLD_PROCG_STRT_DTE =
        new PlannedOrderCapacityField<LocalDateTime>("OpLtstSchedldProcgStrtDte");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldProcgStrtTme</b>
     * </p>
     *
     * @return Latest Scheduled Processing Start Time
     */
    @SerializedName( "OpLtstSchedldProcgStrtTme" )
    @JsonProperty( "OpLtstSchedldProcgStrtTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpLtstSchedldProcgStrtTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opLtstSchedldProcgStrtTme;
    /**
     * Use with available fluent helpers to apply the <b>OpLtstSchedldProcgStrtTme</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<LocalTime> OP_LTST_SCHEDLD_PROCG_STRT_TME =
        new PlannedOrderCapacityField<LocalTime>("OpLtstSchedldProcgStrtTme");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldTrdwnStrtDte</b>
     * </p>
     *
     * @return Latest Scheduled Teardown Start Date
     */
    @SerializedName( "OpLtstSchedldTrdwnStrtDte" )
    @JsonProperty( "OpLtstSchedldTrdwnStrtDte" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpLtstSchedldTrdwnStrtDte",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opLtstSchedldTrdwnStrtDte;
    /**
     * Use with available fluent helpers to apply the <b>OpLtstSchedldTrdwnStrtDte</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<LocalDateTime> OP_LTST_SCHEDLD_TRDWN_STRT_DTE =
        new PlannedOrderCapacityField<LocalDateTime>("OpLtstSchedldTrdwnStrtDte");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldTrdwnStrtTme</b>
     * </p>
     *
     * @return Latest Scheduled Teardown Start Time
     */
    @SerializedName( "OpLtstSchedldTrdwnStrtTme" )
    @JsonProperty( "OpLtstSchedldTrdwnStrtTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpLtstSchedldTrdwnStrtTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opLtstSchedldTrdwnStrtTme;
    /**
     * Use with available fluent helpers to apply the <b>OpLtstSchedldTrdwnStrtTme</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<LocalTime> OP_LTST_SCHEDLD_TRDWN_STRT_TME =
        new PlannedOrderCapacityField<LocalTime>("OpLtstSchedldTrdwnStrtTme");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicEndTime</b>
     * </p>
     *
     * @return Earliest finish of operation (time)
     */
    @SerializedName( "ScheduledBasicEndTime" )
    @JsonProperty( "ScheduledBasicEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ScheduledBasicEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime scheduledBasicEndTime;
    /**
     * Use with available fluent helpers to apply the <b>ScheduledBasicEndTime</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<LocalTime> SCHEDULED_BASIC_END_TIME =
        new PlannedOrderCapacityField<LocalTime>("ScheduledBasicEndTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicStartTime</b>
     * </p>
     *
     * @return Earliest scheduled start: Execution (time)
     */
    @SerializedName( "ScheduledBasicStartTime" )
    @JsonProperty( "ScheduledBasicStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ScheduledBasicStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime scheduledBasicStartTime;
    /**
     * Use with available fluent helpers to apply the <b>ScheduledBasicStartTime</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<LocalTime> SCHEDULED_BASIC_START_TIME =
        new PlannedOrderCapacityField<LocalTime>("ScheduledBasicStartTime");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirementUnit</b>
     * </p>
     *
     * @return Unit of Measure for Capacity Requirements
     */
    @SerializedName( "CapacityRequirementUnit" )
    @JsonProperty( "CapacityRequirementUnit" )
    @Nullable
    @ODataField( odataName = "CapacityRequirementUnit" )
    private String capacityRequirementUnit;
    /**
     * Use with available fluent helpers to apply the <b>CapacityRequirementUnit</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<String> CAPACITY_REQUIREMENT_UNIT =
        new PlannedOrderCapacityField<String>("CapacityRequirementUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "UnitOfMeasureISOCode" )
    @JsonProperty( "UnitOfMeasureISOCode" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasureISOCode" )
    private String unitOfMeasureISOCode;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasureISOCode</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<String> UNIT_OF_MEASURE_ISO_CODE =
        new PlannedOrderCapacityField<String>("UnitOfMeasureISOCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledCapReqOpSegSetupDurn</b>
     * </p>
     *
     * @return Scheduled Capacity Requirements for Setup
     */
    @SerializedName( "ScheduledCapReqOpSegSetupDurn" )
    @JsonProperty( "ScheduledCapReqOpSegSetupDurn" )
    @Nullable
    @ODataField( odataName = "ScheduledCapReqOpSegSetupDurn" )
    private Double scheduledCapReqOpSegSetupDurn;
    /**
     * Use with available fluent helpers to apply the <b>ScheduledCapReqOpSegSetupDurn</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<Double> SCHEDULED_CAP_REQ_OP_SEG_SETUP_DURN =
        new PlannedOrderCapacityField<Double>("ScheduledCapReqOpSegSetupDurn");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RemainingCapReqOpSegSetupDurn</b>
     * </p>
     *
     * @return Remaining Capacity Requirements for Setup
     */
    @SerializedName( "RemainingCapReqOpSegSetupDurn" )
    @JsonProperty( "RemainingCapReqOpSegSetupDurn" )
    @Nullable
    @ODataField( odataName = "RemainingCapReqOpSegSetupDurn" )
    private Double remainingCapReqOpSegSetupDurn;
    /**
     * Use with available fluent helpers to apply the <b>RemainingCapReqOpSegSetupDurn</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<Double> REMAINING_CAP_REQ_OP_SEG_SETUP_DURN =
        new PlannedOrderCapacityField<Double>("RemainingCapReqOpSegSetupDurn");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledCapReqOpSegProcgDurn</b>
     * </p>
     *
     * @return Scheduled Capacity Requirements for Processing
     */
    @SerializedName( "ScheduledCapReqOpSegProcgDurn" )
    @JsonProperty( "ScheduledCapReqOpSegProcgDurn" )
    @Nullable
    @ODataField( odataName = "ScheduledCapReqOpSegProcgDurn" )
    private Double scheduledCapReqOpSegProcgDurn;
    /**
     * Use with available fluent helpers to apply the <b>ScheduledCapReqOpSegProcgDurn</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<Double> SCHEDULED_CAP_REQ_OP_SEG_PROCG_DURN =
        new PlannedOrderCapacityField<Double>("ScheduledCapReqOpSegProcgDurn");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RemainingCapReqOpSegProcgDurn</b>
     * </p>
     *
     * @return Remaining Capacity Requirements for Processing
     */
    @SerializedName( "RemainingCapReqOpSegProcgDurn" )
    @JsonProperty( "RemainingCapReqOpSegProcgDurn" )
    @Nullable
    @ODataField( odataName = "RemainingCapReqOpSegProcgDurn" )
    private Double remainingCapReqOpSegProcgDurn;
    /**
     * Use with available fluent helpers to apply the <b>RemainingCapReqOpSegProcgDurn</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<Double> REMAINING_CAP_REQ_OP_SEG_PROCG_DURN =
        new PlannedOrderCapacityField<Double>("RemainingCapReqOpSegProcgDurn");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledCapReqOpSegTrdwnDurn</b>
     * </p>
     *
     * @return Scheduled Capacity Requirements for the Teardown
     */
    @SerializedName( "ScheduledCapReqOpSegTrdwnDurn" )
    @JsonProperty( "ScheduledCapReqOpSegTrdwnDurn" )
    @Nullable
    @ODataField( odataName = "ScheduledCapReqOpSegTrdwnDurn" )
    private Double scheduledCapReqOpSegTrdwnDurn;
    /**
     * Use with available fluent helpers to apply the <b>ScheduledCapReqOpSegTrdwnDurn</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<Double> SCHEDULED_CAP_REQ_OP_SEG_TRDWN_DURN =
        new PlannedOrderCapacityField<Double>("ScheduledCapReqOpSegTrdwnDurn");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RemainingCapReqOpSegTrdwnDurn</b>
     * </p>
     *
     * @return Remaining Capacity Requirements for Teardown
     */
    @SerializedName( "RemainingCapReqOpSegTrdwnDurn" )
    @JsonProperty( "RemainingCapReqOpSegTrdwnDurn" )
    @Nullable
    @ODataField( odataName = "RemainingCapReqOpSegTrdwnDurn" )
    private Double remainingCapReqOpSegTrdwnDurn;
    /**
     * Use with available fluent helpers to apply the <b>RemainingCapReqOpSegTrdwnDurn</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<Double> REMAINING_CAP_REQ_OP_SEG_TRDWN_DURN =
        new PlannedOrderCapacityField<Double>("RemainingCapReqOpSegTrdwnDurn");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrkCntrHasLeadingCap</b>
     * </p>
     *
     * @return The wrkCntrHasLeadingCap contained in this entity.
     */
    @SerializedName( "WrkCntrHasLeadingCap" )
    @JsonProperty( "WrkCntrHasLeadingCap" )
    @Nullable
    @ODataField( odataName = "WrkCntrHasLeadingCap" )
    private String wrkCntrHasLeadingCap;
    /**
     * Use with available fluent helpers to apply the <b>WrkCntrHasLeadingCap</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<String> WRK_CNTR_HAS_LEADING_CAP =
        new PlannedOrderCapacityField<String>("WrkCntrHasLeadingCap");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OperationText</b>
     * </p>
     *
     * @return Operation Short Text
     */
    @SerializedName( "OperationText" )
    @JsonProperty( "OperationText" )
    @Nullable
    @ODataField( odataName = "OperationText" )
    private String operationText;
    /**
     * Use with available fluent helpers to apply the <b>OperationText</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<String> OPERATION_TEXT =
        new PlannedOrderCapacityField<String>("OperationText");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Change to Planned Order: Time Stamp
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static PlannedOrderCapacityField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new PlannedOrderCapacityField<ZonedDateTime>("LastChangeDateTime");

    @Nonnull
    @Override
    public Class<PlannedOrderCapacity> getType()
    {
        return PlannedOrderCapacity.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirement</b>
     * </p>
     *
     * @param capacityRequirement
     *            ID of the Capacity Requirements Record
     */
    public void setCapacityRequirement( @Nullable final String capacityRequirement )
    {
        rememberChangedField("CapacityRequirement", this.capacityRequirement);
        this.capacityRequirement = capacityRequirement;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirementItem</b>
     * </p>
     *
     * @param capacityRequirementItem
     *            Capacity Requirement Item
     */
    public void setCapacityRequirementItem( @Nullable final String capacityRequirementItem )
    {
        rememberChangedField("CapacityRequirementItem", this.capacityRequirementItem);
        this.capacityRequirementItem = capacityRequirementItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRqmtItemCapacity</b>
     * </p>
     *
     * @param capacityRqmtItemCapacity
     *            Individual Capacity of a Capacity Requirement Item
     */
    public void setCapacityRqmtItemCapacity( @Nullable final String capacityRqmtItemCapacity )
    {
        rememberChangedField("CapacityRqmtItemCapacity", this.capacityRqmtItemCapacity);
        this.capacityRqmtItemCapacity = capacityRqmtItemCapacity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrder</b>
     * </p>
     *
     * @param plannedOrder
     *            Planned Order
     */
    public void setPlannedOrder( @Nullable final String plannedOrder )
    {
        rememberChangedField("PlannedOrder", this.plannedOrder);
        this.plannedOrder = plannedOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrderType</b>
     * </p>
     *
     * @param plannedOrderType
     *            Planned Order Type
     */
    public void setPlannedOrderType( @Nullable final String plannedOrderType )
    {
        rememberChangedField("PlannedOrderType", this.plannedOrderType);
        this.plannedOrderType = plannedOrderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>Sequence</b>
     * </p>
     *
     * @param sequence
     *            Sequence
     */
    public void setSequence( @Nullable final String sequence )
    {
        rememberChangedField("Sequence", this.sequence);
        this.sequence = sequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Operation</b>
     * </p>
     *
     * @param operation
     *            Operation/Activity Number
     */
    public void setOperation( @Nullable final String operation )
    {
        rememberChangedField("Operation", this.operation);
        this.operation = operation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SubOperation</b>
     * </p>
     *
     * @param subOperation
     *            Suboperation
     */
    public void setSubOperation( @Nullable final String subOperation )
    {
        rememberChangedField("SubOperation", this.subOperation);
        this.subOperation = subOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryCode</b>
     * </p>
     *
     * @param capacityCategoryCode
     *            Capacity Category
     */
    public void setCapacityCategoryCode( @Nullable final String capacityCategoryCode )
    {
        rememberChangedField("CapacityCategoryCode", this.capacityCategoryCode);
        this.capacityCategoryCode = capacityCategoryCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Capacity</b>
     * </p>
     *
     * @param capacity
     *            Capacity name
     */
    public void setCapacity( @Nullable final String capacity )
    {
        rememberChangedField("Capacity", this.capacity);
        this.capacity = capacity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @param mRPController
     *            MRP Controller
     */
    public void setMRPController( @Nullable final String mRPController )
    {
        rememberChangedField("MRPController", this.mRPController);
        this.mRPController = mRPController;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlant</b>
     * </p>
     *
     * @param mRPPlant
     *            Planning Plant
     */
    public void setMRPPlant( @Nullable final String mRPPlant )
    {
        rememberChangedField("MRPPlant", this.mRPPlant);
        this.mRPPlant = mRPPlant;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestStartDate</b>
     * </p>
     *
     * @param operationLatestStartDate
     *            Latest Start Date
     */
    public void setOperationLatestStartDate( @Nullable final LocalDateTime operationLatestStartDate )
    {
        rememberChangedField("OperationLatestStartDate", this.operationLatestStartDate);
        this.operationLatestStartDate = operationLatestStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestStartTime</b>
     * </p>
     *
     * @param operationLatestStartTime
     *            Latest Start Time
     */
    public void setOperationLatestStartTime( @Nullable final LocalTime operationLatestStartTime )
    {
        rememberChangedField("OperationLatestStartTime", this.operationLatestStartTime);
        this.operationLatestStartTime = operationLatestStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestEndDate</b>
     * </p>
     *
     * @param operationLatestEndDate
     *            Latest End Date
     */
    public void setOperationLatestEndDate( @Nullable final LocalDateTime operationLatestEndDate )
    {
        rememberChangedField("OperationLatestEndDate", this.operationLatestEndDate);
        this.operationLatestEndDate = operationLatestEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestEndTime</b>
     * </p>
     *
     * @param operationLatestEndTime
     *            Latest End Time
     */
    public void setOperationLatestEndTime( @Nullable final LocalTime operationLatestEndTime )
    {
        rememberChangedField("OperationLatestEndTime", this.operationLatestEndTime);
        this.operationLatestEndTime = operationLatestEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationEarliestStartDate</b>
     * </p>
     *
     * @param operationEarliestStartDate
     *            Earliest Start Date
     */
    public void setOperationEarliestStartDate( @Nullable final LocalDateTime operationEarliestStartDate )
    {
        rememberChangedField("OperationEarliestStartDate", this.operationEarliestStartDate);
        this.operationEarliestStartDate = operationEarliestStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationEarliestStartTime</b>
     * </p>
     *
     * @param operationEarliestStartTime
     *            Earliest Start Time
     */
    public void setOperationEarliestStartTime( @Nullable final LocalTime operationEarliestStartTime )
    {
        rememberChangedField("OperationEarliestStartTime", this.operationEarliestStartTime);
        this.operationEarliestStartTime = operationEarliestStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationEarliestEndDate</b>
     * </p>
     *
     * @param operationEarliestEndDate
     *            Earliest End Date
     */
    public void setOperationEarliestEndDate( @Nullable final LocalDateTime operationEarliestEndDate )
    {
        rememberChangedField("OperationEarliestEndDate", this.operationEarliestEndDate);
        this.operationEarliestEndDate = operationEarliestEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationEarliestEndTime</b>
     * </p>
     *
     * @param operationEarliestEndTime
     *            Earliest End Time
     */
    public void setOperationEarliestEndTime( @Nullable final LocalTime operationEarliestEndTime )
    {
        rememberChangedField("OperationEarliestEndTime", this.operationEarliestEndTime);
        this.operationEarliestEndTime = operationEarliestEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldProcgStrtDte</b>
     * </p>
     *
     * @param opLtstSchedldProcgStrtDte
     *            Latest Scheduled Processing Start Date
     */
    public void setOpLtstSchedldProcgStrtDte( @Nullable final LocalDateTime opLtstSchedldProcgStrtDte )
    {
        rememberChangedField("OpLtstSchedldProcgStrtDte", this.opLtstSchedldProcgStrtDte);
        this.opLtstSchedldProcgStrtDte = opLtstSchedldProcgStrtDte;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldProcgStrtTme</b>
     * </p>
     *
     * @param opLtstSchedldProcgStrtTme
     *            Latest Scheduled Processing Start Time
     */
    public void setOpLtstSchedldProcgStrtTme( @Nullable final LocalTime opLtstSchedldProcgStrtTme )
    {
        rememberChangedField("OpLtstSchedldProcgStrtTme", this.opLtstSchedldProcgStrtTme);
        this.opLtstSchedldProcgStrtTme = opLtstSchedldProcgStrtTme;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldTrdwnStrtDte</b>
     * </p>
     *
     * @param opLtstSchedldTrdwnStrtDte
     *            Latest Scheduled Teardown Start Date
     */
    public void setOpLtstSchedldTrdwnStrtDte( @Nullable final LocalDateTime opLtstSchedldTrdwnStrtDte )
    {
        rememberChangedField("OpLtstSchedldTrdwnStrtDte", this.opLtstSchedldTrdwnStrtDte);
        this.opLtstSchedldTrdwnStrtDte = opLtstSchedldTrdwnStrtDte;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldTrdwnStrtTme</b>
     * </p>
     *
     * @param opLtstSchedldTrdwnStrtTme
     *            Latest Scheduled Teardown Start Time
     */
    public void setOpLtstSchedldTrdwnStrtTme( @Nullable final LocalTime opLtstSchedldTrdwnStrtTme )
    {
        rememberChangedField("OpLtstSchedldTrdwnStrtTme", this.opLtstSchedldTrdwnStrtTme);
        this.opLtstSchedldTrdwnStrtTme = opLtstSchedldTrdwnStrtTme;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicEndTime</b>
     * </p>
     *
     * @param scheduledBasicEndTime
     *            Earliest finish of operation (time)
     */
    public void setScheduledBasicEndTime( @Nullable final LocalTime scheduledBasicEndTime )
    {
        rememberChangedField("ScheduledBasicEndTime", this.scheduledBasicEndTime);
        this.scheduledBasicEndTime = scheduledBasicEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicStartTime</b>
     * </p>
     *
     * @param scheduledBasicStartTime
     *            Earliest scheduled start: Execution (time)
     */
    public void setScheduledBasicStartTime( @Nullable final LocalTime scheduledBasicStartTime )
    {
        rememberChangedField("ScheduledBasicStartTime", this.scheduledBasicStartTime);
        this.scheduledBasicStartTime = scheduledBasicStartTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirementUnit</b>
     * </p>
     *
     * @param capacityRequirementUnit
     *            Unit of Measure for Capacity Requirements
     */
    public void setCapacityRequirementUnit( @Nullable final String capacityRequirementUnit )
    {
        rememberChangedField("CapacityRequirementUnit", this.capacityRequirementUnit);
        this.capacityRequirementUnit = capacityRequirementUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureISOCode</b>
     * </p>
     *
     * @param unitOfMeasureISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setUnitOfMeasureISOCode( @Nullable final String unitOfMeasureISOCode )
    {
        rememberChangedField("UnitOfMeasureISOCode", this.unitOfMeasureISOCode);
        this.unitOfMeasureISOCode = unitOfMeasureISOCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledCapReqOpSegSetupDurn</b>
     * </p>
     *
     * @param scheduledCapReqOpSegSetupDurn
     *            Scheduled Capacity Requirements for Setup
     */
    public void setScheduledCapReqOpSegSetupDurn( @Nullable final Double scheduledCapReqOpSegSetupDurn )
    {
        rememberChangedField("ScheduledCapReqOpSegSetupDurn", this.scheduledCapReqOpSegSetupDurn);
        this.scheduledCapReqOpSegSetupDurn = scheduledCapReqOpSegSetupDurn;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RemainingCapReqOpSegSetupDurn</b>
     * </p>
     *
     * @param remainingCapReqOpSegSetupDurn
     *            Remaining Capacity Requirements for Setup
     */
    public void setRemainingCapReqOpSegSetupDurn( @Nullable final Double remainingCapReqOpSegSetupDurn )
    {
        rememberChangedField("RemainingCapReqOpSegSetupDurn", this.remainingCapReqOpSegSetupDurn);
        this.remainingCapReqOpSegSetupDurn = remainingCapReqOpSegSetupDurn;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledCapReqOpSegProcgDurn</b>
     * </p>
     *
     * @param scheduledCapReqOpSegProcgDurn
     *            Scheduled Capacity Requirements for Processing
     */
    public void setScheduledCapReqOpSegProcgDurn( @Nullable final Double scheduledCapReqOpSegProcgDurn )
    {
        rememberChangedField("ScheduledCapReqOpSegProcgDurn", this.scheduledCapReqOpSegProcgDurn);
        this.scheduledCapReqOpSegProcgDurn = scheduledCapReqOpSegProcgDurn;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RemainingCapReqOpSegProcgDurn</b>
     * </p>
     *
     * @param remainingCapReqOpSegProcgDurn
     *            Remaining Capacity Requirements for Processing
     */
    public void setRemainingCapReqOpSegProcgDurn( @Nullable final Double remainingCapReqOpSegProcgDurn )
    {
        rememberChangedField("RemainingCapReqOpSegProcgDurn", this.remainingCapReqOpSegProcgDurn);
        this.remainingCapReqOpSegProcgDurn = remainingCapReqOpSegProcgDurn;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledCapReqOpSegTrdwnDurn</b>
     * </p>
     *
     * @param scheduledCapReqOpSegTrdwnDurn
     *            Scheduled Capacity Requirements for the Teardown
     */
    public void setScheduledCapReqOpSegTrdwnDurn( @Nullable final Double scheduledCapReqOpSegTrdwnDurn )
    {
        rememberChangedField("ScheduledCapReqOpSegTrdwnDurn", this.scheduledCapReqOpSegTrdwnDurn);
        this.scheduledCapReqOpSegTrdwnDurn = scheduledCapReqOpSegTrdwnDurn;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RemainingCapReqOpSegTrdwnDurn</b>
     * </p>
     *
     * @param remainingCapReqOpSegTrdwnDurn
     *            Remaining Capacity Requirements for Teardown
     */
    public void setRemainingCapReqOpSegTrdwnDurn( @Nullable final Double remainingCapReqOpSegTrdwnDurn )
    {
        rememberChangedField("RemainingCapReqOpSegTrdwnDurn", this.remainingCapReqOpSegTrdwnDurn);
        this.remainingCapReqOpSegTrdwnDurn = remainingCapReqOpSegTrdwnDurn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrkCntrHasLeadingCap</b>
     * </p>
     *
     * @param wrkCntrHasLeadingCap
     *            The wrkCntrHasLeadingCap to set.
     */
    public void setWrkCntrHasLeadingCap( @Nullable final String wrkCntrHasLeadingCap )
    {
        rememberChangedField("WrkCntrHasLeadingCap", this.wrkCntrHasLeadingCap);
        this.wrkCntrHasLeadingCap = wrkCntrHasLeadingCap;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OperationText</b>
     * </p>
     *
     * @param operationText
     *            Operation Short Text
     */
    public void setOperationText( @Nullable final String operationText )
    {
        rememberChangedField("OperationText", this.operationText);
        this.operationText = operationText;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Change to Planned Order: Time Stamp
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PlannedOrderCapacity";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CapacityRequirement", getCapacityRequirement());
        result.put("CapacityRequirementItem", getCapacityRequirementItem());
        result.put("CapacityRqmtItemCapacity", getCapacityRqmtItemCapacity());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CapacityRequirement", getCapacityRequirement());
        values.put("CapacityRequirementItem", getCapacityRequirementItem());
        values.put("CapacityRqmtItemCapacity", getCapacityRqmtItemCapacity());
        values.put("PlannedOrder", getPlannedOrder());
        values.put("PlannedOrderType", getPlannedOrderType());
        values.put("Sequence", getSequence());
        values.put("Operation", getOperation());
        values.put("SubOperation", getSubOperation());
        values.put("WorkCenter", getWorkCenter());
        values.put("CapacityCategoryCode", getCapacityCategoryCode());
        values.put("Capacity", getCapacity());
        values.put("MRPController", getMRPController());
        values.put("MRPPlant", getMRPPlant());
        values.put("OperationLatestStartDate", getOperationLatestStartDate());
        values.put("OperationLatestStartTime", getOperationLatestStartTime());
        values.put("OperationLatestEndDate", getOperationLatestEndDate());
        values.put("OperationLatestEndTime", getOperationLatestEndTime());
        values.put("OperationEarliestStartDate", getOperationEarliestStartDate());
        values.put("OperationEarliestStartTime", getOperationEarliestStartTime());
        values.put("OperationEarliestEndDate", getOperationEarliestEndDate());
        values.put("OperationEarliestEndTime", getOperationEarliestEndTime());
        values.put("OpLtstSchedldProcgStrtDte", getOpLtstSchedldProcgStrtDte());
        values.put("OpLtstSchedldProcgStrtTme", getOpLtstSchedldProcgStrtTme());
        values.put("OpLtstSchedldTrdwnStrtDte", getOpLtstSchedldTrdwnStrtDte());
        values.put("OpLtstSchedldTrdwnStrtTme", getOpLtstSchedldTrdwnStrtTme());
        values.put("ScheduledBasicEndTime", getScheduledBasicEndTime());
        values.put("ScheduledBasicStartTime", getScheduledBasicStartTime());
        values.put("CapacityRequirementUnit", getCapacityRequirementUnit());
        values.put("UnitOfMeasureISOCode", getUnitOfMeasureISOCode());
        values.put("ScheduledCapReqOpSegSetupDurn", getScheduledCapReqOpSegSetupDurn());
        values.put("RemainingCapReqOpSegSetupDurn", getRemainingCapReqOpSegSetupDurn());
        values.put("ScheduledCapReqOpSegProcgDurn", getScheduledCapReqOpSegProcgDurn());
        values.put("RemainingCapReqOpSegProcgDurn", getRemainingCapReqOpSegProcgDurn());
        values.put("ScheduledCapReqOpSegTrdwnDurn", getScheduledCapReqOpSegTrdwnDurn());
        values.put("RemainingCapReqOpSegTrdwnDurn", getRemainingCapReqOpSegTrdwnDurn());
        values.put("WrkCntrHasLeadingCap", getWrkCntrHasLeadingCap());
        values.put("OperationText", getOperationText());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CapacityRequirement") ) {
                final Object value = values.remove("CapacityRequirement");
                if( (value == null) || (!value.equals(getCapacityRequirement())) ) {
                    setCapacityRequirement(((String) value));
                }
            }
            if( values.containsKey("CapacityRequirementItem") ) {
                final Object value = values.remove("CapacityRequirementItem");
                if( (value == null) || (!value.equals(getCapacityRequirementItem())) ) {
                    setCapacityRequirementItem(((String) value));
                }
            }
            if( values.containsKey("CapacityRqmtItemCapacity") ) {
                final Object value = values.remove("CapacityRqmtItemCapacity");
                if( (value == null) || (!value.equals(getCapacityRqmtItemCapacity())) ) {
                    setCapacityRqmtItemCapacity(((String) value));
                }
            }
            if( values.containsKey("PlannedOrder") ) {
                final Object value = values.remove("PlannedOrder");
                if( (value == null) || (!value.equals(getPlannedOrder())) ) {
                    setPlannedOrder(((String) value));
                }
            }
            if( values.containsKey("PlannedOrderType") ) {
                final Object value = values.remove("PlannedOrderType");
                if( (value == null) || (!value.equals(getPlannedOrderType())) ) {
                    setPlannedOrderType(((String) value));
                }
            }
            if( values.containsKey("Sequence") ) {
                final Object value = values.remove("Sequence");
                if( (value == null) || (!value.equals(getSequence())) ) {
                    setSequence(((String) value));
                }
            }
            if( values.containsKey("Operation") ) {
                final Object value = values.remove("Operation");
                if( (value == null) || (!value.equals(getOperation())) ) {
                    setOperation(((String) value));
                }
            }
            if( values.containsKey("SubOperation") ) {
                final Object value = values.remove("SubOperation");
                if( (value == null) || (!value.equals(getSubOperation())) ) {
                    setSubOperation(((String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((String) value));
                }
            }
            if( values.containsKey("CapacityCategoryCode") ) {
                final Object value = values.remove("CapacityCategoryCode");
                if( (value == null) || (!value.equals(getCapacityCategoryCode())) ) {
                    setCapacityCategoryCode(((String) value));
                }
            }
            if( values.containsKey("Capacity") ) {
                final Object value = values.remove("Capacity");
                if( (value == null) || (!value.equals(getCapacity())) ) {
                    setCapacity(((String) value));
                }
            }
            if( values.containsKey("MRPController") ) {
                final Object value = values.remove("MRPController");
                if( (value == null) || (!value.equals(getMRPController())) ) {
                    setMRPController(((String) value));
                }
            }
            if( values.containsKey("MRPPlant") ) {
                final Object value = values.remove("MRPPlant");
                if( (value == null) || (!value.equals(getMRPPlant())) ) {
                    setMRPPlant(((String) value));
                }
            }
            if( values.containsKey("OperationLatestStartDate") ) {
                final Object value = values.remove("OperationLatestStartDate");
                if( (value == null) || (!value.equals(getOperationLatestStartDate())) ) {
                    setOperationLatestStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OperationLatestStartTime") ) {
                final Object value = values.remove("OperationLatestStartTime");
                if( (value == null) || (!value.equals(getOperationLatestStartTime())) ) {
                    setOperationLatestStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("OperationLatestEndDate") ) {
                final Object value = values.remove("OperationLatestEndDate");
                if( (value == null) || (!value.equals(getOperationLatestEndDate())) ) {
                    setOperationLatestEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OperationLatestEndTime") ) {
                final Object value = values.remove("OperationLatestEndTime");
                if( (value == null) || (!value.equals(getOperationLatestEndTime())) ) {
                    setOperationLatestEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("OperationEarliestStartDate") ) {
                final Object value = values.remove("OperationEarliestStartDate");
                if( (value == null) || (!value.equals(getOperationEarliestStartDate())) ) {
                    setOperationEarliestStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OperationEarliestStartTime") ) {
                final Object value = values.remove("OperationEarliestStartTime");
                if( (value == null) || (!value.equals(getOperationEarliestStartTime())) ) {
                    setOperationEarliestStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("OperationEarliestEndDate") ) {
                final Object value = values.remove("OperationEarliestEndDate");
                if( (value == null) || (!value.equals(getOperationEarliestEndDate())) ) {
                    setOperationEarliestEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OperationEarliestEndTime") ) {
                final Object value = values.remove("OperationEarliestEndTime");
                if( (value == null) || (!value.equals(getOperationEarliestEndTime())) ) {
                    setOperationEarliestEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("OpLtstSchedldProcgStrtDte") ) {
                final Object value = values.remove("OpLtstSchedldProcgStrtDte");
                if( (value == null) || (!value.equals(getOpLtstSchedldProcgStrtDte())) ) {
                    setOpLtstSchedldProcgStrtDte(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpLtstSchedldProcgStrtTme") ) {
                final Object value = values.remove("OpLtstSchedldProcgStrtTme");
                if( (value == null) || (!value.equals(getOpLtstSchedldProcgStrtTme())) ) {
                    setOpLtstSchedldProcgStrtTme(((LocalTime) value));
                }
            }
            if( values.containsKey("OpLtstSchedldTrdwnStrtDte") ) {
                final Object value = values.remove("OpLtstSchedldTrdwnStrtDte");
                if( (value == null) || (!value.equals(getOpLtstSchedldTrdwnStrtDte())) ) {
                    setOpLtstSchedldTrdwnStrtDte(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpLtstSchedldTrdwnStrtTme") ) {
                final Object value = values.remove("OpLtstSchedldTrdwnStrtTme");
                if( (value == null) || (!value.equals(getOpLtstSchedldTrdwnStrtTme())) ) {
                    setOpLtstSchedldTrdwnStrtTme(((LocalTime) value));
                }
            }
            if( values.containsKey("ScheduledBasicEndTime") ) {
                final Object value = values.remove("ScheduledBasicEndTime");
                if( (value == null) || (!value.equals(getScheduledBasicEndTime())) ) {
                    setScheduledBasicEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ScheduledBasicStartTime") ) {
                final Object value = values.remove("ScheduledBasicStartTime");
                if( (value == null) || (!value.equals(getScheduledBasicStartTime())) ) {
                    setScheduledBasicStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CapacityRequirementUnit") ) {
                final Object value = values.remove("CapacityRequirementUnit");
                if( (value == null) || (!value.equals(getCapacityRequirementUnit())) ) {
                    setCapacityRequirementUnit(((String) value));
                }
            }
            if( values.containsKey("UnitOfMeasureISOCode") ) {
                final Object value = values.remove("UnitOfMeasureISOCode");
                if( (value == null) || (!value.equals(getUnitOfMeasureISOCode())) ) {
                    setUnitOfMeasureISOCode(((String) value));
                }
            }
            if( values.containsKey("ScheduledCapReqOpSegSetupDurn") ) {
                final Object value = values.remove("ScheduledCapReqOpSegSetupDurn");
                if( (value == null) || (!value.equals(getScheduledCapReqOpSegSetupDurn())) ) {
                    setScheduledCapReqOpSegSetupDurn(((Double) value));
                }
            }
            if( values.containsKey("RemainingCapReqOpSegSetupDurn") ) {
                final Object value = values.remove("RemainingCapReqOpSegSetupDurn");
                if( (value == null) || (!value.equals(getRemainingCapReqOpSegSetupDurn())) ) {
                    setRemainingCapReqOpSegSetupDurn(((Double) value));
                }
            }
            if( values.containsKey("ScheduledCapReqOpSegProcgDurn") ) {
                final Object value = values.remove("ScheduledCapReqOpSegProcgDurn");
                if( (value == null) || (!value.equals(getScheduledCapReqOpSegProcgDurn())) ) {
                    setScheduledCapReqOpSegProcgDurn(((Double) value));
                }
            }
            if( values.containsKey("RemainingCapReqOpSegProcgDurn") ) {
                final Object value = values.remove("RemainingCapReqOpSegProcgDurn");
                if( (value == null) || (!value.equals(getRemainingCapReqOpSegProcgDurn())) ) {
                    setRemainingCapReqOpSegProcgDurn(((Double) value));
                }
            }
            if( values.containsKey("ScheduledCapReqOpSegTrdwnDurn") ) {
                final Object value = values.remove("ScheduledCapReqOpSegTrdwnDurn");
                if( (value == null) || (!value.equals(getScheduledCapReqOpSegTrdwnDurn())) ) {
                    setScheduledCapReqOpSegTrdwnDurn(((Double) value));
                }
            }
            if( values.containsKey("RemainingCapReqOpSegTrdwnDurn") ) {
                final Object value = values.remove("RemainingCapReqOpSegTrdwnDurn");
                if( (value == null) || (!value.equals(getRemainingCapReqOpSegTrdwnDurn())) ) {
                    setRemainingCapReqOpSegTrdwnDurn(((Double) value));
                }
            }
            if( values.containsKey("WrkCntrHasLeadingCap") ) {
                final Object value = values.remove("WrkCntrHasLeadingCap");
                if( (value == null) || (!value.equals(getWrkCntrHasLeadingCap())) ) {
                    setWrkCntrHasLeadingCap(((String) value));
                }
            }
            if( values.containsKey("OperationText") ) {
                final Object value = values.remove("OperationText");
                if( (value == null) || (!value.equals(getOperationText())) ) {
                    setOperationText(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PlannedOrderCapacityField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PlannedOrderCapacityField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PlannedOrderCapacityField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PlannedOrderCapacityField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedOrderService.DEFAULT_SERVICE_PATH);
    }

}
