/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.selectable.PlannedOrderCapacitySelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity PlannedOrderCapacity}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class PlannedOrderCapacityByKeyFluentHelper
    extends
    FluentHelperByKey<PlannedOrderCapacityByKeyFluentHelper, PlannedOrderCapacity, PlannedOrderCapacitySelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity
     * PlannedOrderCapacity} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param capacityRequirementItem
     *            Capacity Requirement Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PlannedOrderCapacity}
     * @param capacityRequirement
     *            ID of the Capacity Requirements Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param capacityRqmtItemCapacity
     *            Individual Capacity of a Capacity Requirement Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PlannedOrderCapacity}
     */
    public PlannedOrderCapacityByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String capacityRequirement,
        final String capacityRequirementItem,
        final String capacityRqmtItemCapacity )
    {
        super(servicePath, entityCollection);
        this.key.put("CapacityRequirement", capacityRequirement);
        this.key.put("CapacityRequirementItem", capacityRequirementItem);
        this.key.put("CapacityRqmtItemCapacity", capacityRqmtItemCapacity);
    }

    @Override
    @Nonnull
    protected Class<PlannedOrderCapacity> getEntityClass()
    {
        return PlannedOrderCapacity.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
