/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.field.PlannedOrderComponentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.selectable.PlannedOrderComponentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Planned Order Components
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PlannedOrderComponentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PlannedOrderComponent extends VdmEntity<PlannedOrderComponent>
{

    /**
     * Selector for all available fields of PlannedOrderComponent.
     *
     */
    public final static PlannedOrderComponentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @return Number of reservation/dependent requirements
     */
    @Key
    @SerializedName( "Reservation" )
    @JsonProperty( "Reservation" )
    @Nullable
    @ODataField( odataName = "Reservation" )
    private String reservation;
    /**
     * Use with available fluent helpers to apply the <b>Reservation</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> RESERVATION =
        new PlannedOrderComponentField<String>("Reservation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @return Reservation Item
     */
    @Key
    @SerializedName( "ReservationItem" )
    @JsonProperty( "ReservationItem" )
    @Nullable
    @ODataField( odataName = "ReservationItem" )
    private String reservationItem;
    /**
     * Use with available fluent helpers to apply the <b>ReservationItem</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> RESERVATION_ITEM =
        new PlannedOrderComponentField<String>("ReservationItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrder</b>
     * </p>
     *
     * @return Planned Order
     */
    @SerializedName( "PlannedOrder" )
    @JsonProperty( "PlannedOrder" )
    @Nullable
    @ODataField( odataName = "PlannedOrder" )
    private String plannedOrder;
    /**
     * Use with available fluent helpers to apply the <b>PlannedOrder</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> PLANNED_ORDER =
        new PlannedOrderComponentField<String>("PlannedOrder");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMItem</b>
     * </p>
     *
     * @return Bill of Material Item
     */
    @SerializedName( "BOMItem" )
    @JsonProperty( "BOMItem" )
    @Nullable
    @ODataField( odataName = "BOMItem" )
    private String bOMItem;
    /**
     * Use with available fluent helpers to apply the <b>BOMItem</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> BOM_ITEM = new PlannedOrderComponentField<String>("BOMItem");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescription</b>
     * </p>
     *
     * @return BOM Item Text (Line 1)
     */
    @SerializedName( "BOMItemDescription" )
    @JsonProperty( "BOMItemDescription" )
    @Nullable
    @ODataField( odataName = "BOMItemDescription" )
    private String bOMItemDescription;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemDescription</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> BOM_ITEM_DESCRIPTION =
        new PlannedOrderComponentField<String>("BOMItemDescription");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescriptionLine2</b>
     * </p>
     *
     * @return BOM Item Text (Line 2)
     */
    @SerializedName( "BOMItemDescriptionLine2" )
    @JsonProperty( "BOMItemDescriptionLine2" )
    @Nullable
    @ODataField( odataName = "BOMItemDescriptionLine2" )
    private String bOMItemDescriptionLine2;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemDescriptionLine2</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> BOM_ITEM_DESCRIPTION_LINE2 =
        new PlannedOrderComponentField<String>("BOMItemDescriptionLine2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @return Bill of Material Category Code
     */
    @SerializedName( "BillOfMaterialCategory" )
    @JsonProperty( "BillOfMaterialCategory" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialCategory" )
    private String billOfMaterialCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialCategory</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> BILL_OF_MATERIAL_CATEGORY =
        new PlannedOrderComponentField<String>("BillOfMaterialCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SortField</b>
     * </p>
     *
     * @return Sort String
     */
    @SerializedName( "SortField" )
    @JsonProperty( "SortField" )
    @Nullable
    @ODataField( odataName = "SortField" )
    private String sortField;
    /**
     * Use with available fluent helpers to apply the <b>SortField</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> SORT_FIELD =
        new PlannedOrderComponentField<String>("SortField");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNumber</b>
     * </p>
     *
     * @return BOM item number
     */
    @SerializedName( "BillOfMaterialItemNumber" )
    @JsonProperty( "BillOfMaterialItemNumber" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemNumber" )
    private String billOfMaterialItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemNumber</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> BILL_OF_MATERIAL_ITEM_NUMBER =
        new PlannedOrderComponentField<String>("BillOfMaterialItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialInternalID</b>
     * </p>
     *
     * @return Bill of Material
     */
    @SerializedName( "BillOfMaterialInternalID" )
    @JsonProperty( "BillOfMaterialInternalID" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialInternalID" )
    private String billOfMaterialInternalID;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialInternalID</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> BILL_OF_MATERIAL_INTERNAL_ID =
        new PlannedOrderComponentField<String>("BillOfMaterialInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @return Alternative BOM
     */
    @SerializedName( "BillOfMaterialVariant" )
    @JsonProperty( "BillOfMaterialVariant" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialVariant" )
    private String billOfMaterialVariant;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialVariant</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> BILL_OF_MATERIAL_VARIANT =
        new PlannedOrderComponentField<String>("BillOfMaterialVariant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemCategory</b>
     * </p>
     *
     * @return Bill of Material Item Category
     */
    @SerializedName( "BOMItemCategory" )
    @JsonProperty( "BOMItemCategory" )
    @Nullable
    @ODataField( odataName = "BOMItemCategory" )
    private String bOMItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemCategory</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> BOM_ITEM_CATEGORY =
        new PlannedOrderComponentField<String>("BOMItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> MATERIAL =
        new PlannedOrderComponentField<String>("Material");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompRequirementDate</b>
     * </p>
     *
     * @return Material Component Requirement Date
     */
    @SerializedName( "MatlCompRequirementDate" )
    @JsonProperty( "MatlCompRequirementDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MatlCompRequirementDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime matlCompRequirementDate;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompRequirementDate</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<LocalDateTime> MATL_COMP_REQUIREMENT_DATE =
        new PlannedOrderComponentField<LocalDateTime>("MatlCompRequirementDate");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementEntryQty</b>
     * </p>
     *
     * @return Quantity in Unit of Entry
     */
    @SerializedName( "GoodsMovementEntryQty" )
    @JsonProperty( "GoodsMovementEntryQty" )
    @Nullable
    @ODataField( odataName = "GoodsMovementEntryQty" )
    private BigDecimal goodsMovementEntryQty;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementEntryQty</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<BigDecimal> GOODS_MOVEMENT_ENTRY_QTY =
        new PlannedOrderComponentField<BigDecimal>("GoodsMovementEntryQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnit</b>
     * </p>
     *
     * @return Unit of entry
     */
    @SerializedName( "EntryUnit" )
    @JsonProperty( "EntryUnit" )
    @Nullable
    @ODataField( odataName = "EntryUnit" )
    private String entryUnit;
    /**
     * Use with available fluent helpers to apply the <b>EntryUnit</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> ENTRY_UNIT =
        new PlannedOrderComponentField<String>("EntryUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequiredQuantity</b>
     * </p>
     *
     * @return Requirement Quantity
     */
    @SerializedName( "RequiredQuantity" )
    @JsonProperty( "RequiredQuantity" )
    @Nullable
    @ODataField( odataName = "RequiredQuantity" )
    private BigDecimal requiredQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RequiredQuantity</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<BigDecimal> REQUIRED_QUANTITY =
        new PlannedOrderComponentField<BigDecimal>("RequiredQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> BASE_UNIT =
        new PlannedOrderComponentField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithdrawnQuantity</b>
     * </p>
     *
     * @return Withdrawn Quantity
     */
    @SerializedName( "WithdrawnQuantity" )
    @JsonProperty( "WithdrawnQuantity" )
    @Nullable
    @ODataField( odataName = "WithdrawnQuantity" )
    private BigDecimal withdrawnQuantity;
    /**
     * Use with available fluent helpers to apply the <b>WithdrawnQuantity</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<BigDecimal> WITHDRAWN_QUANTITY =
        new PlannedOrderComponentField<BigDecimal>("WithdrawnQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @return Debit/Credit Code
     */
    @SerializedName( "DebitCreditCode" )
    @JsonProperty( "DebitCreditCode" )
    @Nullable
    @ODataField( odataName = "DebitCreditCode" )
    private String debitCreditCode;
    /**
     * Use with available fluent helpers to apply the <b>DebitCreditCode</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> DEBIT_CREDIT_CODE =
        new PlannedOrderComponentField<String>("DebitCreditCode");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ComponentScrapInPercent</b>
     * </p>
     *
     * @return Component Scrap in Percent
     */
    @SerializedName( "ComponentScrapInPercent" )
    @JsonProperty( "ComponentScrapInPercent" )
    @Nullable
    @ODataField( odataName = "ComponentScrapInPercent" )
    private BigDecimal componentScrapInPercent;
    /**
     * Use with available fluent helpers to apply the <b>ComponentScrapInPercent</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<BigDecimal> COMPONENT_SCRAP_IN_PERCENT =
        new PlannedOrderComponentField<BigDecimal>("ComponentScrapInPercent");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsFixed</b>
     * </p>
     *
     * @return Quantity is fixed
     */
    @SerializedName( "QuantityIsFixed" )
    @JsonProperty( "QuantityIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "QuantityIsFixed" )
    private Boolean quantityIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>QuantityIsFixed</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<Boolean> QUANTITY_IS_FIXED =
        new PlannedOrderComponentField<Boolean>("QuantityIsFixed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialComponentIsPhantomItem</b>
     * </p>
     *
     * @return Phantom Item Indicator
     */
    @SerializedName( "MaterialComponentIsPhantomItem" )
    @JsonProperty( "MaterialComponentIsPhantomItem" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaterialComponentIsPhantomItem" )
    private Boolean materialComponentIsPhantomItem;
    /**
     * Use with available fluent helpers to apply the <b>MaterialComponentIsPhantomItem</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<Boolean> MATERIAL_COMPONENT_IS_PHANTOM_ITEM =
        new PlannedOrderComponentField<Boolean>("MaterialComponentIsPhantomItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> PLANT = new PlannedOrderComponentField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> STORAGE_LOCATION =
        new PlannedOrderComponentField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyArea</b>
     * </p>
     *
     * @return Production Supply Area
     */
    @SerializedName( "SupplyArea" )
    @JsonProperty( "SupplyArea" )
    @Nullable
    @ODataField( odataName = "SupplyArea" )
    private String supplyArea;
    /**
     * Use with available fluent helpers to apply the <b>SupplyArea</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> SUPPLY_AREA =
        new PlannedOrderComponentField<String>("SupplyArea");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @return MRP Controller
     */
    @SerializedName( "MRPController" )
    @JsonProperty( "MRPController" )
    @Nullable
    @ODataField( odataName = "MRPController" )
    private String mRPController;
    /**
     * Use with available fluent helpers to apply the <b>MRPController</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> MRP_CONTROLLER =
        new PlannedOrderComponentField<String>("MRPController");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrderPathValue</b>
     * </p>
     *
     * @return Order path
     */
    @SerializedName( "OrderPathValue" )
    @JsonProperty( "OrderPathValue" )
    @Nullable
    @ODataField( odataName = "OrderPathValue" )
    private String orderPathValue;
    /**
     * Use with available fluent helpers to apply the <b>OrderPathValue</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> ORDER_PATH_VALUE =
        new PlannedOrderComponentField<String>("OrderPathValue");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrderLevelValue</b>
     * </p>
     *
     * @return Order level
     */
    @SerializedName( "OrderLevelValue" )
    @JsonProperty( "OrderLevelValue" )
    @Nullable
    @ODataField( odataName = "OrderLevelValue" )
    private String orderLevelValue;
    /**
     * Use with available fluent helpers to apply the <b>OrderLevelValue</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> ORDER_LEVEL_VALUE =
        new PlannedOrderComponentField<String>("OrderLevelValue");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     *
     * @return Higher-Level Assembly Material
     */
    @SerializedName( "Assembly" )
    @JsonProperty( "Assembly" )
    @Nullable
    @ODataField( odataName = "Assembly" )
    private String assembly;
    /**
     * Use with available fluent helpers to apply the <b>Assembly</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> ASSEMBLY =
        new PlannedOrderComponentField<String>("Assembly");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssemblyOrderPathValue</b>
     * </p>
     *
     * @return Assembly Order Path
     */
    @SerializedName( "AssemblyOrderPathValue" )
    @JsonProperty( "AssemblyOrderPathValue" )
    @Nullable
    @ODataField( odataName = "AssemblyOrderPathValue" )
    private String assemblyOrderPathValue;
    /**
     * Use with available fluent helpers to apply the <b>AssemblyOrderPathValue</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> ASSEMBLY_ORDER_PATH_VALUE =
        new PlannedOrderComponentField<String>("AssemblyOrderPathValue");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssemblyOrderLevelValue</b>
     * </p>
     *
     * @return Assembly Order Level
     */
    @SerializedName( "AssemblyOrderLevelValue" )
    @JsonProperty( "AssemblyOrderLevelValue" )
    @Nullable
    @ODataField( odataName = "AssemblyOrderLevelValue" )
    private String assemblyOrderLevelValue;
    /**
     * Use with available fluent helpers to apply the <b>AssemblyOrderLevelValue</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> ASSEMBLY_ORDER_LEVEL_VALUE =
        new PlannedOrderComponentField<String>("AssemblyOrderLevelValue");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DiscontinuationGroup</b>
     * </p>
     *
     * @return Discontinuation Group
     */
    @SerializedName( "DiscontinuationGroup" )
    @JsonProperty( "DiscontinuationGroup" )
    @Nullable
    @ODataField( odataName = "DiscontinuationGroup" )
    private String discontinuationGroup;
    /**
     * Use with available fluent helpers to apply the <b>DiscontinuationGroup</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> DISCONTINUATION_GROUP =
        new PlannedOrderComponentField<String>("DiscontinuationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompDiscontinuationType</b>
     * </p>
     *
     * @return Discontinuation Type
     */
    @SerializedName( "MatlCompDiscontinuationType" )
    @JsonProperty( "MatlCompDiscontinuationType" )
    @Nullable
    @ODataField( odataName = "MatlCompDiscontinuationType" )
    private String matlCompDiscontinuationType;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompDiscontinuationType</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> MATL_COMP_DISCONTINUATION_TYPE =
        new PlannedOrderComponentField<String>("MatlCompDiscontinuationType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsFollowUpMaterial</b>
     * </p>
     *
     * @return Indicator: Component is Follow-Up Material
     */
    @SerializedName( "MatlCompIsFollowUpMaterial" )
    @JsonProperty( "MatlCompIsFollowUpMaterial" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MatlCompIsFollowUpMaterial" )
    private Boolean matlCompIsFollowUpMaterial;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompIsFollowUpMaterial</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<Boolean> MATL_COMP_IS_FOLLOW_UP_MATERIAL =
        new PlannedOrderComponentField<Boolean>("MatlCompIsFollowUpMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FollowUpGroup</b>
     * </p>
     *
     * @return Follow-up Group
     */
    @SerializedName( "FollowUpGroup" )
    @JsonProperty( "FollowUpGroup" )
    @Nullable
    @ODataField( odataName = "FollowUpGroup" )
    private String followUpGroup;
    /**
     * Use with available fluent helpers to apply the <b>FollowUpGroup</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> FOLLOW_UP_GROUP =
        new PlannedOrderComponentField<String>("FollowUpGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FollowUpMaterial</b>
     * </p>
     *
     * @return Follow-Up / Original Material
     */
    @SerializedName( "FollowUpMaterial" )
    @JsonProperty( "FollowUpMaterial" )
    @Nullable
    @ODataField( odataName = "FollowUpMaterial" )
    private String followUpMaterial;
    /**
     * Use with available fluent helpers to apply the <b>FollowUpMaterial</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<String> FOLLOW_UP_MATERIAL =
        new PlannedOrderComponentField<String>("FollowUpMaterial");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FollowUpMaterialIsNotActive</b>
     * </p>
     *
     * @return Indicator: Follow-Up Material is Active
     */
    @SerializedName( "FollowUpMaterialIsNotActive" )
    @JsonProperty( "FollowUpMaterialIsNotActive" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "FollowUpMaterialIsNotActive" )
    private Boolean followUpMaterialIsNotActive;
    /**
     * Use with available fluent helpers to apply the <b>FollowUpMaterialIsNotActive</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<Boolean> FOLLOW_UP_MATERIAL_IS_NOT_ACTIVE =
        new PlannedOrderComponentField<Boolean>("FollowUpMaterialIsNotActive");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Change to Planned Order: Time Stamp
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static PlannedOrderComponentField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new PlannedOrderComponentField<ZonedDateTime>("LastChangeDateTime");

    @Nonnull
    @Override
    public Class<PlannedOrderComponent> getType()
    {
        return PlannedOrderComponent.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @param reservation
     *            Number of reservation/dependent requirements
     */
    public void setReservation( @Nullable final String reservation )
    {
        rememberChangedField("Reservation", this.reservation);
        this.reservation = reservation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @param reservationItem
     *            Reservation Item
     */
    public void setReservationItem( @Nullable final String reservationItem )
    {
        rememberChangedField("ReservationItem", this.reservationItem);
        this.reservationItem = reservationItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrder</b>
     * </p>
     *
     * @param plannedOrder
     *            Planned Order
     */
    public void setPlannedOrder( @Nullable final String plannedOrder )
    {
        rememberChangedField("PlannedOrder", this.plannedOrder);
        this.plannedOrder = plannedOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMItem</b>
     * </p>
     *
     * @param bOMItem
     *            Bill of Material Item
     */
    public void setBOMItem( @Nullable final String bOMItem )
    {
        rememberChangedField("BOMItem", this.bOMItem);
        this.bOMItem = bOMItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescription</b>
     * </p>
     *
     * @param bOMItemDescription
     *            BOM Item Text (Line 1)
     */
    public void setBOMItemDescription( @Nullable final String bOMItemDescription )
    {
        rememberChangedField("BOMItemDescription", this.bOMItemDescription);
        this.bOMItemDescription = bOMItemDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescriptionLine2</b>
     * </p>
     *
     * @param bOMItemDescriptionLine2
     *            BOM Item Text (Line 2)
     */
    public void setBOMItemDescriptionLine2( @Nullable final String bOMItemDescriptionLine2 )
    {
        rememberChangedField("BOMItemDescriptionLine2", this.bOMItemDescriptionLine2);
        this.bOMItemDescriptionLine2 = bOMItemDescriptionLine2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @param billOfMaterialCategory
     *            Bill of Material Category Code
     */
    public void setBillOfMaterialCategory( @Nullable final String billOfMaterialCategory )
    {
        rememberChangedField("BillOfMaterialCategory", this.billOfMaterialCategory);
        this.billOfMaterialCategory = billOfMaterialCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SortField</b>
     * </p>
     *
     * @param sortField
     *            Sort String
     */
    public void setSortField( @Nullable final String sortField )
    {
        rememberChangedField("SortField", this.sortField);
        this.sortField = sortField;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNumber</b>
     * </p>
     *
     * @param billOfMaterialItemNumber
     *            BOM item number
     */
    public void setBillOfMaterialItemNumber( @Nullable final String billOfMaterialItemNumber )
    {
        rememberChangedField("BillOfMaterialItemNumber", this.billOfMaterialItemNumber);
        this.billOfMaterialItemNumber = billOfMaterialItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialInternalID</b>
     * </p>
     *
     * @param billOfMaterialInternalID
     *            Bill of Material
     */
    public void setBillOfMaterialInternalID( @Nullable final String billOfMaterialInternalID )
    {
        rememberChangedField("BillOfMaterialInternalID", this.billOfMaterialInternalID);
        this.billOfMaterialInternalID = billOfMaterialInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialVariant</b>
     * </p>
     *
     * @param billOfMaterialVariant
     *            Alternative BOM
     */
    public void setBillOfMaterialVariant( @Nullable final String billOfMaterialVariant )
    {
        rememberChangedField("BillOfMaterialVariant", this.billOfMaterialVariant);
        this.billOfMaterialVariant = billOfMaterialVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemCategory</b>
     * </p>
     *
     * @param bOMItemCategory
     *            Bill of Material Item Category
     */
    public void setBOMItemCategory( @Nullable final String bOMItemCategory )
    {
        rememberChangedField("BOMItemCategory", this.bOMItemCategory);
        this.bOMItemCategory = bOMItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompRequirementDate</b>
     * </p>
     *
     * @param matlCompRequirementDate
     *            Material Component Requirement Date
     */
    public void setMatlCompRequirementDate( @Nullable final LocalDateTime matlCompRequirementDate )
    {
        rememberChangedField("MatlCompRequirementDate", this.matlCompRequirementDate);
        this.matlCompRequirementDate = matlCompRequirementDate;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementEntryQty</b>
     * </p>
     *
     * @param goodsMovementEntryQty
     *            Quantity in Unit of Entry
     */
    public void setGoodsMovementEntryQty( @Nullable final BigDecimal goodsMovementEntryQty )
    {
        rememberChangedField("GoodsMovementEntryQty", this.goodsMovementEntryQty);
        this.goodsMovementEntryQty = goodsMovementEntryQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnit</b>
     * </p>
     *
     * @param entryUnit
     *            Unit of entry
     */
    public void setEntryUnit( @Nullable final String entryUnit )
    {
        rememberChangedField("EntryUnit", this.entryUnit);
        this.entryUnit = entryUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequiredQuantity</b>
     * </p>
     *
     * @param requiredQuantity
     *            Requirement Quantity
     */
    public void setRequiredQuantity( @Nullable final BigDecimal requiredQuantity )
    {
        rememberChangedField("RequiredQuantity", this.requiredQuantity);
        this.requiredQuantity = requiredQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithdrawnQuantity</b>
     * </p>
     *
     * @param withdrawnQuantity
     *            Withdrawn Quantity
     */
    public void setWithdrawnQuantity( @Nullable final BigDecimal withdrawnQuantity )
    {
        rememberChangedField("WithdrawnQuantity", this.withdrawnQuantity);
        this.withdrawnQuantity = withdrawnQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DebitCreditCode</b>
     * </p>
     *
     * @param debitCreditCode
     *            Debit/Credit Code
     */
    public void setDebitCreditCode( @Nullable final String debitCreditCode )
    {
        rememberChangedField("DebitCreditCode", this.debitCreditCode);
        this.debitCreditCode = debitCreditCode;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ComponentScrapInPercent</b>
     * </p>
     *
     * @param componentScrapInPercent
     *            Component Scrap in Percent
     */
    public void setComponentScrapInPercent( @Nullable final BigDecimal componentScrapInPercent )
    {
        rememberChangedField("ComponentScrapInPercent", this.componentScrapInPercent);
        this.componentScrapInPercent = componentScrapInPercent;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsFixed</b>
     * </p>
     *
     * @param quantityIsFixed
     *            Quantity is fixed
     */
    public void setQuantityIsFixed( @Nullable final Boolean quantityIsFixed )
    {
        rememberChangedField("QuantityIsFixed", this.quantityIsFixed);
        this.quantityIsFixed = quantityIsFixed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialComponentIsPhantomItem</b>
     * </p>
     *
     * @param materialComponentIsPhantomItem
     *            Phantom Item Indicator
     */
    public void setMaterialComponentIsPhantomItem( @Nullable final Boolean materialComponentIsPhantomItem )
    {
        rememberChangedField("MaterialComponentIsPhantomItem", this.materialComponentIsPhantomItem);
        this.materialComponentIsPhantomItem = materialComponentIsPhantomItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyArea</b>
     * </p>
     *
     * @param supplyArea
     *            Production Supply Area
     */
    public void setSupplyArea( @Nullable final String supplyArea )
    {
        rememberChangedField("SupplyArea", this.supplyArea);
        this.supplyArea = supplyArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @param mRPController
     *            MRP Controller
     */
    public void setMRPController( @Nullable final String mRPController )
    {
        rememberChangedField("MRPController", this.mRPController);
        this.mRPController = mRPController;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrderPathValue</b>
     * </p>
     *
     * @param orderPathValue
     *            Order path
     */
    public void setOrderPathValue( @Nullable final String orderPathValue )
    {
        rememberChangedField("OrderPathValue", this.orderPathValue);
        this.orderPathValue = orderPathValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrderLevelValue</b>
     * </p>
     *
     * @param orderLevelValue
     *            Order level
     */
    public void setOrderLevelValue( @Nullable final String orderLevelValue )
    {
        rememberChangedField("OrderLevelValue", this.orderLevelValue);
        this.orderLevelValue = orderLevelValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     *
     * @param assembly
     *            Higher-Level Assembly Material
     */
    public void setAssembly( @Nullable final String assembly )
    {
        rememberChangedField("Assembly", this.assembly);
        this.assembly = assembly;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssemblyOrderPathValue</b>
     * </p>
     *
     * @param assemblyOrderPathValue
     *            Assembly Order Path
     */
    public void setAssemblyOrderPathValue( @Nullable final String assemblyOrderPathValue )
    {
        rememberChangedField("AssemblyOrderPathValue", this.assemblyOrderPathValue);
        this.assemblyOrderPathValue = assemblyOrderPathValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AssemblyOrderLevelValue</b>
     * </p>
     *
     * @param assemblyOrderLevelValue
     *            Assembly Order Level
     */
    public void setAssemblyOrderLevelValue( @Nullable final String assemblyOrderLevelValue )
    {
        rememberChangedField("AssemblyOrderLevelValue", this.assemblyOrderLevelValue);
        this.assemblyOrderLevelValue = assemblyOrderLevelValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DiscontinuationGroup</b>
     * </p>
     *
     * @param discontinuationGroup
     *            Discontinuation Group
     */
    public void setDiscontinuationGroup( @Nullable final String discontinuationGroup )
    {
        rememberChangedField("DiscontinuationGroup", this.discontinuationGroup);
        this.discontinuationGroup = discontinuationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompDiscontinuationType</b>
     * </p>
     *
     * @param matlCompDiscontinuationType
     *            Discontinuation Type
     */
    public void setMatlCompDiscontinuationType( @Nullable final String matlCompDiscontinuationType )
    {
        rememberChangedField("MatlCompDiscontinuationType", this.matlCompDiscontinuationType);
        this.matlCompDiscontinuationType = matlCompDiscontinuationType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsFollowUpMaterial</b>
     * </p>
     *
     * @param matlCompIsFollowUpMaterial
     *            Indicator: Component is Follow-Up Material
     */
    public void setMatlCompIsFollowUpMaterial( @Nullable final Boolean matlCompIsFollowUpMaterial )
    {
        rememberChangedField("MatlCompIsFollowUpMaterial", this.matlCompIsFollowUpMaterial);
        this.matlCompIsFollowUpMaterial = matlCompIsFollowUpMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FollowUpGroup</b>
     * </p>
     *
     * @param followUpGroup
     *            Follow-up Group
     */
    public void setFollowUpGroup( @Nullable final String followUpGroup )
    {
        rememberChangedField("FollowUpGroup", this.followUpGroup);
        this.followUpGroup = followUpGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FollowUpMaterial</b>
     * </p>
     *
     * @param followUpMaterial
     *            Follow-Up / Original Material
     */
    public void setFollowUpMaterial( @Nullable final String followUpMaterial )
    {
        rememberChangedField("FollowUpMaterial", this.followUpMaterial);
        this.followUpMaterial = followUpMaterial;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FollowUpMaterialIsNotActive</b>
     * </p>
     *
     * @param followUpMaterialIsNotActive
     *            Indicator: Follow-Up Material is Active
     */
    public void setFollowUpMaterialIsNotActive( @Nullable final Boolean followUpMaterialIsNotActive )
    {
        rememberChangedField("FollowUpMaterialIsNotActive", this.followUpMaterialIsNotActive);
        this.followUpMaterialIsNotActive = followUpMaterialIsNotActive;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Change to Planned Order: Time Stamp
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PlannedOrderComponent";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Reservation", getReservation());
        result.put("ReservationItem", getReservationItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Reservation", getReservation());
        values.put("ReservationItem", getReservationItem());
        values.put("PlannedOrder", getPlannedOrder());
        values.put("BOMItem", getBOMItem());
        values.put("BOMItemDescription", getBOMItemDescription());
        values.put("BOMItemDescriptionLine2", getBOMItemDescriptionLine2());
        values.put("BillOfMaterialCategory", getBillOfMaterialCategory());
        values.put("SortField", getSortField());
        values.put("BillOfMaterialItemNumber", getBillOfMaterialItemNumber());
        values.put("BillOfMaterialInternalID", getBillOfMaterialInternalID());
        values.put("BillOfMaterialVariant", getBillOfMaterialVariant());
        values.put("BOMItemCategory", getBOMItemCategory());
        values.put("Material", getMaterial());
        values.put("MatlCompRequirementDate", getMatlCompRequirementDate());
        values.put("GoodsMovementEntryQty", getGoodsMovementEntryQty());
        values.put("EntryUnit", getEntryUnit());
        values.put("RequiredQuantity", getRequiredQuantity());
        values.put("BaseUnit", getBaseUnit());
        values.put("WithdrawnQuantity", getWithdrawnQuantity());
        values.put("DebitCreditCode", getDebitCreditCode());
        values.put("ComponentScrapInPercent", getComponentScrapInPercent());
        values.put("QuantityIsFixed", getQuantityIsFixed());
        values.put("MaterialComponentIsPhantomItem", getMaterialComponentIsPhantomItem());
        values.put("Plant", getPlant());
        values.put("StorageLocation", getStorageLocation());
        values.put("SupplyArea", getSupplyArea());
        values.put("MRPController", getMRPController());
        values.put("OrderPathValue", getOrderPathValue());
        values.put("OrderLevelValue", getOrderLevelValue());
        values.put("Assembly", getAssembly());
        values.put("AssemblyOrderPathValue", getAssemblyOrderPathValue());
        values.put("AssemblyOrderLevelValue", getAssemblyOrderLevelValue());
        values.put("DiscontinuationGroup", getDiscontinuationGroup());
        values.put("MatlCompDiscontinuationType", getMatlCompDiscontinuationType());
        values.put("MatlCompIsFollowUpMaterial", getMatlCompIsFollowUpMaterial());
        values.put("FollowUpGroup", getFollowUpGroup());
        values.put("FollowUpMaterial", getFollowUpMaterial());
        values.put("FollowUpMaterialIsNotActive", getFollowUpMaterialIsNotActive());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Reservation") ) {
                final Object value = values.remove("Reservation");
                if( (value == null) || (!value.equals(getReservation())) ) {
                    setReservation(((String) value));
                }
            }
            if( values.containsKey("ReservationItem") ) {
                final Object value = values.remove("ReservationItem");
                if( (value == null) || (!value.equals(getReservationItem())) ) {
                    setReservationItem(((String) value));
                }
            }
            if( values.containsKey("PlannedOrder") ) {
                final Object value = values.remove("PlannedOrder");
                if( (value == null) || (!value.equals(getPlannedOrder())) ) {
                    setPlannedOrder(((String) value));
                }
            }
            if( values.containsKey("BOMItem") ) {
                final Object value = values.remove("BOMItem");
                if( (value == null) || (!value.equals(getBOMItem())) ) {
                    setBOMItem(((String) value));
                }
            }
            if( values.containsKey("BOMItemDescription") ) {
                final Object value = values.remove("BOMItemDescription");
                if( (value == null) || (!value.equals(getBOMItemDescription())) ) {
                    setBOMItemDescription(((String) value));
                }
            }
            if( values.containsKey("BOMItemDescriptionLine2") ) {
                final Object value = values.remove("BOMItemDescriptionLine2");
                if( (value == null) || (!value.equals(getBOMItemDescriptionLine2())) ) {
                    setBOMItemDescriptionLine2(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialCategory") ) {
                final Object value = values.remove("BillOfMaterialCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialCategory())) ) {
                    setBillOfMaterialCategory(((String) value));
                }
            }
            if( values.containsKey("SortField") ) {
                final Object value = values.remove("SortField");
                if( (value == null) || (!value.equals(getSortField())) ) {
                    setSortField(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemNumber") ) {
                final Object value = values.remove("BillOfMaterialItemNumber");
                if( (value == null) || (!value.equals(getBillOfMaterialItemNumber())) ) {
                    setBillOfMaterialItemNumber(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialInternalID") ) {
                final Object value = values.remove("BillOfMaterialInternalID");
                if( (value == null) || (!value.equals(getBillOfMaterialInternalID())) ) {
                    setBillOfMaterialInternalID(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialVariant") ) {
                final Object value = values.remove("BillOfMaterialVariant");
                if( (value == null) || (!value.equals(getBillOfMaterialVariant())) ) {
                    setBillOfMaterialVariant(((String) value));
                }
            }
            if( values.containsKey("BOMItemCategory") ) {
                final Object value = values.remove("BOMItemCategory");
                if( (value == null) || (!value.equals(getBOMItemCategory())) ) {
                    setBOMItemCategory(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MatlCompRequirementDate") ) {
                final Object value = values.remove("MatlCompRequirementDate");
                if( (value == null) || (!value.equals(getMatlCompRequirementDate())) ) {
                    setMatlCompRequirementDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("GoodsMovementEntryQty") ) {
                final Object value = values.remove("GoodsMovementEntryQty");
                if( (value == null) || (!value.equals(getGoodsMovementEntryQty())) ) {
                    setGoodsMovementEntryQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("EntryUnit") ) {
                final Object value = values.remove("EntryUnit");
                if( (value == null) || (!value.equals(getEntryUnit())) ) {
                    setEntryUnit(((String) value));
                }
            }
            if( values.containsKey("RequiredQuantity") ) {
                final Object value = values.remove("RequiredQuantity");
                if( (value == null) || (!value.equals(getRequiredQuantity())) ) {
                    setRequiredQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("WithdrawnQuantity") ) {
                final Object value = values.remove("WithdrawnQuantity");
                if( (value == null) || (!value.equals(getWithdrawnQuantity())) ) {
                    setWithdrawnQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("DebitCreditCode") ) {
                final Object value = values.remove("DebitCreditCode");
                if( (value == null) || (!value.equals(getDebitCreditCode())) ) {
                    setDebitCreditCode(((String) value));
                }
            }
            if( values.containsKey("ComponentScrapInPercent") ) {
                final Object value = values.remove("ComponentScrapInPercent");
                if( (value == null) || (!value.equals(getComponentScrapInPercent())) ) {
                    setComponentScrapInPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuantityIsFixed") ) {
                final Object value = values.remove("QuantityIsFixed");
                if( (value == null) || (!value.equals(getQuantityIsFixed())) ) {
                    setQuantityIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("MaterialComponentIsPhantomItem") ) {
                final Object value = values.remove("MaterialComponentIsPhantomItem");
                if( (value == null) || (!value.equals(getMaterialComponentIsPhantomItem())) ) {
                    setMaterialComponentIsPhantomItem(((Boolean) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("SupplyArea") ) {
                final Object value = values.remove("SupplyArea");
                if( (value == null) || (!value.equals(getSupplyArea())) ) {
                    setSupplyArea(((String) value));
                }
            }
            if( values.containsKey("MRPController") ) {
                final Object value = values.remove("MRPController");
                if( (value == null) || (!value.equals(getMRPController())) ) {
                    setMRPController(((String) value));
                }
            }
            if( values.containsKey("OrderPathValue") ) {
                final Object value = values.remove("OrderPathValue");
                if( (value == null) || (!value.equals(getOrderPathValue())) ) {
                    setOrderPathValue(((String) value));
                }
            }
            if( values.containsKey("OrderLevelValue") ) {
                final Object value = values.remove("OrderLevelValue");
                if( (value == null) || (!value.equals(getOrderLevelValue())) ) {
                    setOrderLevelValue(((String) value));
                }
            }
            if( values.containsKey("Assembly") ) {
                final Object value = values.remove("Assembly");
                if( (value == null) || (!value.equals(getAssembly())) ) {
                    setAssembly(((String) value));
                }
            }
            if( values.containsKey("AssemblyOrderPathValue") ) {
                final Object value = values.remove("AssemblyOrderPathValue");
                if( (value == null) || (!value.equals(getAssemblyOrderPathValue())) ) {
                    setAssemblyOrderPathValue(((String) value));
                }
            }
            if( values.containsKey("AssemblyOrderLevelValue") ) {
                final Object value = values.remove("AssemblyOrderLevelValue");
                if( (value == null) || (!value.equals(getAssemblyOrderLevelValue())) ) {
                    setAssemblyOrderLevelValue(((String) value));
                }
            }
            if( values.containsKey("DiscontinuationGroup") ) {
                final Object value = values.remove("DiscontinuationGroup");
                if( (value == null) || (!value.equals(getDiscontinuationGroup())) ) {
                    setDiscontinuationGroup(((String) value));
                }
            }
            if( values.containsKey("MatlCompDiscontinuationType") ) {
                final Object value = values.remove("MatlCompDiscontinuationType");
                if( (value == null) || (!value.equals(getMatlCompDiscontinuationType())) ) {
                    setMatlCompDiscontinuationType(((String) value));
                }
            }
            if( values.containsKey("MatlCompIsFollowUpMaterial") ) {
                final Object value = values.remove("MatlCompIsFollowUpMaterial");
                if( (value == null) || (!value.equals(getMatlCompIsFollowUpMaterial())) ) {
                    setMatlCompIsFollowUpMaterial(((Boolean) value));
                }
            }
            if( values.containsKey("FollowUpGroup") ) {
                final Object value = values.remove("FollowUpGroup");
                if( (value == null) || (!value.equals(getFollowUpGroup())) ) {
                    setFollowUpGroup(((String) value));
                }
            }
            if( values.containsKey("FollowUpMaterial") ) {
                final Object value = values.remove("FollowUpMaterial");
                if( (value == null) || (!value.equals(getFollowUpMaterial())) ) {
                    setFollowUpMaterial(((String) value));
                }
            }
            if( values.containsKey("FollowUpMaterialIsNotActive") ) {
                final Object value = values.remove("FollowUpMaterialIsNotActive");
                if( (value == null) || (!value.equals(getFollowUpMaterialIsNotActive())) ) {
                    setFollowUpMaterialIsNotActive(((Boolean) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PlannedOrderComponentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PlannedOrderComponentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PlannedOrderComponentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PlannedOrderComponentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedOrderService.DEFAULT_SERVICE_PATH);
    }

}
