/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>SchedldProdOrdOpMessage</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SchedldProdOrdOpMessage extends VdmComplex<SchedldProdOrdOpMessage>
{

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>PlannedOrder</b>
     * </p>
     *
     * @param plannedOrder
     *
     * @return Planned Order
     */
    @SerializedName( "PlannedOrder" )
    @JsonProperty( "PlannedOrder" )
    @Nullable
    @ODataField( odataName = "PlannedOrder" )
    private String plannedOrder;
    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>CapacityRequirement</b>
     * </p>
     *
     * @param capacityRequirement
     *
     */
    @SerializedName( "CapacityRequirement" )
    @JsonProperty( "CapacityRequirement" )
    @Nullable
    @ODataField( odataName = "CapacityRequirement" )
    private String capacityRequirement;
    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>CapacityRequirementItem</b>
     * </p>
     *
     * @param capacityRequirementItem
     *
     */
    @SerializedName( "CapacityRequirementItem" )
    @JsonProperty( "CapacityRequirementItem" )
    @Nullable
    @ODataField( odataName = "CapacityRequirementItem" )
    private String capacityRequirementItem;
    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>CapacityRqmtItemCapacity</b>
     * </p>
     *
     * @param capacityRqmtItemCapacity
     *
     */
    @SerializedName( "CapacityRqmtItemCapacity" )
    @JsonProperty( "CapacityRqmtItemCapacity" )
    @Nullable
    @ODataField( odataName = "CapacityRqmtItemCapacity" )
    private String capacityRqmtItemCapacity;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>Operation</b>
     * </p>
     *
     * @param operation
     *
     * @return Activity
     */
    @SerializedName( "Operation" )
    @JsonProperty( "Operation" )
    @Nullable
    @ODataField( odataName = "Operation" )
    private String operation;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>Message</b>
     * </p>
     *
     * @param message
     *
     */
    @SerializedName( "Message" )
    @JsonProperty( "Message" )
    @Nullable
    @ODataField( odataName = "Message" )
    private String message;

    @Nonnull
    @Override
    public Class<SchedldProdOrdOpMessage> getType()
    {
        return SchedldProdOrdOpMessage.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PlannedOrder", getPlannedOrder());
        values.put("CapacityRequirement", getCapacityRequirement());
        values.put("CapacityRequirementItem", getCapacityRequirementItem());
        values.put("CapacityRqmtItemCapacity", getCapacityRqmtItemCapacity());
        values.put("Operation", getOperation());
        values.put("Message", getMessage());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PlannedOrder") ) {
                final Object value = values.remove("PlannedOrder");
                if( (value == null) || (!value.equals(getPlannedOrder())) ) {
                    setPlannedOrder(((String) value));
                }
            }
            if( values.containsKey("CapacityRequirement") ) {
                final Object value = values.remove("CapacityRequirement");
                if( (value == null) || (!value.equals(getCapacityRequirement())) ) {
                    setCapacityRequirement(((String) value));
                }
            }
            if( values.containsKey("CapacityRequirementItem") ) {
                final Object value = values.remove("CapacityRequirementItem");
                if( (value == null) || (!value.equals(getCapacityRequirementItem())) ) {
                    setCapacityRequirementItem(((String) value));
                }
            }
            if( values.containsKey("CapacityRqmtItemCapacity") ) {
                final Object value = values.remove("CapacityRqmtItemCapacity");
                if( (value == null) || (!value.equals(getCapacityRqmtItemCapacity())) ) {
                    setCapacityRqmtItemCapacity(((String) value));
                }
            }
            if( values.containsKey("Operation") ) {
                final Object value = values.remove("Operation");
                if( (value == null) || (!value.equals(getOperation())) ) {
                    setOperation(((String) value));
                }
            }
            if( values.containsKey("Message") ) {
                final Object value = values.remove("Message");
                if( (value == null) || (!value.equals(getMessage())) ) {
                    setMessage(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>PlannedOrder</b>
     * </p>
     *
     * @param plannedOrder
     *            Planned Order
     */
    public void setPlannedOrder( @Nullable final String plannedOrder )
    {
        rememberChangedField("PlannedOrder", this.plannedOrder);
        this.plannedOrder = plannedOrder;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>CapacityRequirement</b>
     * </p>
     *
     * @param capacityRequirement
     *            The capacityRequirement to set.
     */
    public void setCapacityRequirement( @Nullable final String capacityRequirement )
    {
        rememberChangedField("CapacityRequirement", this.capacityRequirement);
        this.capacityRequirement = capacityRequirement;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>CapacityRequirementItem</b>
     * </p>
     *
     * @param capacityRequirementItem
     *            The capacityRequirementItem to set.
     */
    public void setCapacityRequirementItem( @Nullable final String capacityRequirementItem )
    {
        rememberChangedField("CapacityRequirementItem", this.capacityRequirementItem);
        this.capacityRequirementItem = capacityRequirementItem;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property from the Odata EDM: <b>CapacityRqmtItemCapacity</b>
     * </p>
     *
     * @param capacityRqmtItemCapacity
     *            The capacityRqmtItemCapacity to set.
     */
    public void setCapacityRqmtItemCapacity( @Nullable final String capacityRqmtItemCapacity )
    {
        rememberChangedField("CapacityRqmtItemCapacity", this.capacityRqmtItemCapacity);
        this.capacityRqmtItemCapacity = capacityRqmtItemCapacity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>Operation</b>
     * </p>
     *
     * @param operation
     *            Activity
     */
    public void setOperation( @Nullable final String operation )
    {
        rememberChangedField("Operation", this.operation);
        this.operation = operation;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>Message</b>
     * </p>
     *
     * @param message
     *            The message to set.
     */
    public void setMessage( @Nullable final String message )
    {
        rememberChangedField("Message", this.message);
        this.message = message;
    }

}
