/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PlannedOrderServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedOrderService PlannedOrderService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultPlannedOrderServiceBatch
    extends
    BatchFluentHelperBasic<PlannedOrderServiceBatch, PlannedOrderServiceBatchChangeSet>
    implements
    PlannedOrderServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedOrderService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPlannedOrderServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPlannedOrderServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedOrderService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedOrderService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPlannedOrderServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPlannedOrderServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedOrderService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPlannedOrderServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PlannedOrderServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPlannedOrderServiceBatchChangeSet(this, service);
    }

}
