/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent;

/**
 * Implementation of the {@link PlannedOrderServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedOrderService PlannedOrderService}.
 *
 */
public class DefaultPlannedOrderServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PlannedOrderServiceBatch, PlannedOrderServiceBatchChangeSet>
    implements
    PlannedOrderServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedOrderService service;

    @SuppressWarnings( "deprecation" )
    DefaultPlannedOrderServiceBatchChangeSet(
        @Nonnull final DefaultPlannedOrderServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedOrderService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPlannedOrderServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PlannedOrderServiceBatchChangeSet createPlannedOrder( @Nonnull final PlannedOrder plannedOrder )
    {
        return addRequestCreate(service::createPlannedOrder, plannedOrder);
    }

    @Nonnull
    @Override
    public PlannedOrderServiceBatchChangeSet updatePlannedOrder( @Nonnull final PlannedOrder plannedOrder )
    {
        return addRequestUpdate(service::updatePlannedOrder, plannedOrder);
    }

    @Nonnull
    @Override
    public PlannedOrderServiceBatchChangeSet deletePlannedOrder( @Nonnull final PlannedOrder plannedOrder )
    {
        return addRequestDelete(service::deletePlannedOrder, plannedOrder);
    }

    @Nonnull
    @Override
    public PlannedOrderServiceBatchChangeSet createPlannedOrderComponent(
        @Nonnull final PlannedOrderComponent plannedOrderComponent )
    {
        return addRequestCreate(service::createPlannedOrderComponent, plannedOrderComponent);
    }

    @Nonnull
    @Override
    public PlannedOrderServiceBatchChangeSet updatePlannedOrderComponent(
        @Nonnull final PlannedOrderComponent plannedOrderComponent )
    {
        return addRequestUpdate(service::updatePlannedOrderComponent, plannedOrderComponent);
    }

    @Nonnull
    @Override
    public PlannedOrderServiceBatchChangeSet deletePlannedOrderComponent(
        @Nonnull final PlannedOrderComponent plannedOrderComponent )
    {
        return addRequestDelete(service::deletePlannedOrderComponent, plannedOrderComponent);
    }

}
