/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlannedOrderService PlannedOrderService}.
 *
 */
public interface PlannedOrderServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<PlannedOrderServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<PlannedOrderServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder PlannedOrder}
     * entity and save it to the S/4HANA system.
     *
     * @param plannedOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder PlannedOrder}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PlannedOrderServiceBatchChangeSet createPlannedOrder( @Nonnull final PlannedOrder plannedOrder );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder
     * PlannedOrder} entity and save it to the S/4HANA system.
     *
     * @param plannedOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder PlannedOrder}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PlannedOrderServiceBatchChangeSet updatePlannedOrder( @Nonnull final PlannedOrder plannedOrder );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder
     * PlannedOrder} entity in the S/4HANA system.
     *
     * @param plannedOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder PlannedOrder}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PlannedOrderServiceBatchChangeSet deletePlannedOrder( @Nonnull final PlannedOrder plannedOrder );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent
     * PlannedOrderComponent} entity and save it to the S/4HANA system.
     *
     * @param plannedOrderComponent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent
     *            PlannedOrderComponent} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PlannedOrderServiceBatchChangeSet
        createPlannedOrderComponent( @Nonnull final PlannedOrderComponent plannedOrderComponent );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent
     * PlannedOrderComponent} entity and save it to the S/4HANA system.
     *
     * @param plannedOrderComponent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent
     *            PlannedOrderComponent} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PlannedOrderServiceBatchChangeSet
        updatePlannedOrderComponent( @Nonnull final PlannedOrderComponent plannedOrderComponent );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent
     * PlannedOrderComponent} entity in the S/4HANA system.
     *
     * @param plannedOrderComponent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent
     *            PlannedOrderComponent} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PlannedOrderServiceBatchChangeSet
        deletePlannedOrderComponent( @Nonnull final PlannedOrderComponent plannedOrderComponent );

}
