/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity PlannedOrderCapacity}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.field.PlannedOrderCapacityField
 * PlannedOrderCapacityField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.link.PlannedOrderCapacityLink
 * PlannedOrderCapacityLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#CAPACITY_REQUIREMENT
 * CAPACITY_REQUIREMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#CAPACITY_REQUIREMENT_ITEM
 * CAPACITY_REQUIREMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#CAPACITY_RQMT_ITEM_CAPACITY
 * CAPACITY_RQMT_ITEM_CAPACITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#PLANNED_ORDER
 * PLANNED_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#PLANNED_ORDER_TYPE
 * PLANNED_ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#SEQUENCE
 * SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#OPERATION
 * OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#SUB_OPERATION
 * SUB_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#WORK_CENTER
 * WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#CAPACITY_CATEGORY_CODE
 * CAPACITY_CATEGORY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#CAPACITY
 * CAPACITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#MRP_CONTROLLER
 * MRP_CONTROLLER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#MRP_PLANT
 * MRP_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#OPERATION_LATEST_START_DATE
 * OPERATION_LATEST_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#OPERATION_LATEST_START_TIME
 * OPERATION_LATEST_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#OPERATION_LATEST_END_DATE
 * OPERATION_LATEST_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#OPERATION_LATEST_END_TIME
 * OPERATION_LATEST_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#OPERATION_EARLIEST_START_DATE
 * OPERATION_EARLIEST_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#OPERATION_EARLIEST_START_TIME
 * OPERATION_EARLIEST_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#OPERATION_EARLIEST_END_DATE
 * OPERATION_EARLIEST_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#OPERATION_EARLIEST_END_TIME
 * OPERATION_EARLIEST_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#OP_LTST_SCHEDLD_PROCG_STRT_DTE
 * OP_LTST_SCHEDLD_PROCG_STRT_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#OP_LTST_SCHEDLD_PROCG_STRT_TME
 * OP_LTST_SCHEDLD_PROCG_STRT_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#OP_LTST_SCHEDLD_TRDWN_STRT_DTE
 * OP_LTST_SCHEDLD_TRDWN_STRT_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#OP_LTST_SCHEDLD_TRDWN_STRT_TME
 * OP_LTST_SCHEDLD_TRDWN_STRT_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#SCHEDULED_BASIC_END_TIME
 * SCHEDULED_BASIC_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#SCHEDULED_BASIC_START_TIME
 * SCHEDULED_BASIC_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#CAPACITY_REQUIREMENT_UNIT
 * CAPACITY_REQUIREMENT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#UNIT_OF_MEASURE_ISO_CODE
 * UNIT_OF_MEASURE_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#SCHEDULED_CAP_REQ_OP_SEG_SETUP_DURN
 * SCHEDULED_CAP_REQ_OP_SEG_SETUP_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#REMAINING_CAP_REQ_OP_SEG_SETUP_DURN
 * REMAINING_CAP_REQ_OP_SEG_SETUP_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#SCHEDULED_CAP_REQ_OP_SEG_PROCG_DURN
 * SCHEDULED_CAP_REQ_OP_SEG_PROCG_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#REMAINING_CAP_REQ_OP_SEG_PROCG_DURN
 * REMAINING_CAP_REQ_OP_SEG_PROCG_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#SCHEDULED_CAP_REQ_OP_SEG_TRDWN_DURN
 * SCHEDULED_CAP_REQ_OP_SEG_TRDWN_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#REMAINING_CAP_REQ_OP_SEG_TRDWN_DURN
 * REMAINING_CAP_REQ_OP_SEG_TRDWN_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#WRK_CNTR_HAS_LEADING_CAP
 * WRK_CNTR_HAS_LEADING_CAP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#OPERATION_TEXT
 * OPERATION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderCapacity#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * </ul>
 *
 */
public interface PlannedOrderCapacitySelectable extends EntitySelectable<PlannedOrderCapacity>
{

}
