/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent PlannedOrderComponent}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.field.PlannedOrderComponentField
 * PlannedOrderComponentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.link.PlannedOrderComponentLink
 * PlannedOrderComponentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#RESERVATION
 * RESERVATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#RESERVATION_ITEM
 * RESERVATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#PLANNED_ORDER
 * PLANNED_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#BOM_ITEM
 * BOM_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#BOM_ITEM_DESCRIPTION
 * BOM_ITEM_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#BOM_ITEM_DESCRIPTION_LINE2
 * BOM_ITEM_DESCRIPTION_LINE2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#BILL_OF_MATERIAL_CATEGORY
 * BILL_OF_MATERIAL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#SORT_FIELD
 * SORT_FIELD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#BILL_OF_MATERIAL_ITEM_NUMBER
 * BILL_OF_MATERIAL_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#BILL_OF_MATERIAL_INTERNAL_ID
 * BILL_OF_MATERIAL_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#BILL_OF_MATERIAL_VARIANT
 * BILL_OF_MATERIAL_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#BOM_ITEM_CATEGORY
 * BOM_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#MATL_COMP_REQUIREMENT_DATE
 * MATL_COMP_REQUIREMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#GOODS_MOVEMENT_ENTRY_QTY
 * GOODS_MOVEMENT_ENTRY_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#ENTRY_UNIT
 * ENTRY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#REQUIRED_QUANTITY
 * REQUIRED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#WITHDRAWN_QUANTITY
 * WITHDRAWN_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#DEBIT_CREDIT_CODE
 * DEBIT_CREDIT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#COMPONENT_SCRAP_IN_PERCENT
 * COMPONENT_SCRAP_IN_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#QUANTITY_IS_FIXED
 * QUANTITY_IS_FIXED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#MATERIAL_COMPONENT_IS_PHANTOM_ITEM
 * MATERIAL_COMPONENT_IS_PHANTOM_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#SUPPLY_AREA
 * SUPPLY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#MRP_CONTROLLER
 * MRP_CONTROLLER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#ORDER_PATH_VALUE
 * ORDER_PATH_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#ORDER_LEVEL_VALUE
 * ORDER_LEVEL_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#ASSEMBLY
 * ASSEMBLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#ASSEMBLY_ORDER_PATH_VALUE
 * ASSEMBLY_ORDER_PATH_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#ASSEMBLY_ORDER_LEVEL_VALUE
 * ASSEMBLY_ORDER_LEVEL_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#DISCONTINUATION_GROUP
 * DISCONTINUATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#MATL_COMP_DISCONTINUATION_TYPE
 * MATL_COMP_DISCONTINUATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#MATL_COMP_IS_FOLLOW_UP_MATERIAL
 * MATL_COMP_IS_FOLLOW_UP_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#FOLLOW_UP_GROUP
 * FOLLOW_UP_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#FOLLOW_UP_MATERIAL
 * FOLLOW_UP_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#FOLLOW_UP_MATERIAL_IS_NOT_ACTIVE
 * FOLLOW_UP_MATERIAL_IS_NOT_ACTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrderComponent#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * </ul>
 *
 */
public interface PlannedOrderComponentSelectable extends EntitySelectable<PlannedOrderComponent>
{

}
