/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder PlannedOrder}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.field.PlannedOrderField
 * PlannedOrderField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.link.PlannedOrderLink
 * PlannedOrderLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PLANNED_ORDER
 * PLANNED_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PLANNED_ORDER_TYPE
 * PLANNED_ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PLANNED_ORDER_PROFILE
 * PLANNED_ORDER_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#MATERIAL MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#MATERIAL_NAME
 * MATERIAL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PRODUCTION_PLANT
 * PRODUCTION_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#MRP_PLANT MRP_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#MRP_AREA MRP_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PRODUCTION_VERSION
 * PRODUCTION_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#MATERIAL_PROCUREMENT_CATEGORY
 * MATERIAL_PROCUREMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#MATERIAL_PROCUREMENT_TYPE
 * MATERIAL_PROCUREMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#BASE_UNIT BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#TOTAL_QUANTITY
 * TOTAL_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PLND_ORDER_PLANNED_SCRAP_QTY
 * PLND_ORDER_PLANNED_SCRAP_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#GOODS_RECEIPT_QTY
 * GOODS_RECEIPT_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#ISSUED_QUANTITY
 * ISSUED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PLND_ORDER_PLANNED_START_DATE
 * PLND_ORDER_PLANNED_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PLND_ORDER_PLANNED_START_TIME
 * PLND_ORDER_PLANNED_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PLND_ORDER_PLANNED_END_DATE
 * PLND_ORDER_PLANNED_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PLND_ORDER_PLANNED_END_TIME
 * PLND_ORDER_PLANNED_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PLANNED_ORDER_OPENING_DATE
 * PLANNED_ORDER_OPENING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PRODUCTION_START_DATE
 * PRODUCTION_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PRODUCTION_END_DATE
 * PRODUCTION_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#CUSTOMER CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#WBS_ELEMENT_INTERNAL_ID
 * WBS_ELEMENT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#WBS_DESCRIPTION
 * WBS_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#ACCOUNT_ASSIGNMENT_CATEGORY
 * ACCOUNT_ASSIGNMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#RESERVATION
 * RESERVATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#MRP_CONTROLLER
 * MRP_CONTROLLER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PRODUCTION_SUPERVISOR
 * PRODUCTION_SUPERVISOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PURCHASING_GROUP
 * PURCHASING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#FIXED_SUPPLIER
 * FIXED_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PURCHASING_DOCUMENT
 * PURCHASING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PURCHASING_DOCUMENT_ITEM
 * PURCHASING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#QUOTA_ARRANGEMENT
 * QUOTA_ARRANGEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#QUOTA_ARRANGEMENT_ITEM
 * QUOTA_ARRANGEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#SUPPLIER_NAME
 * SUPPLIER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PLANNED_ORDER_IS_FIRM
 * PLANNED_ORDER_IS_FIRM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PLANNED_ORDER_IS_CONVERTIBLE
 * PLANNED_ORDER_IS_CONVERTIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PLANNED_ORDER_BOM_IS_FIXED
 * PLANNED_ORDER_BOM_IS_FIXED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#PLANNED_ORDER_CAPACITY_IS_DSPTCHD
 * PLANNED_ORDER_CAPACITY_IS_DSPTCHD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#CAPACITY_REQUIREMENT
 * CAPACITY_REQUIREMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#CAPACITY_REQUIREMENT_ORIGIN
 * CAPACITY_REQUIREMENT_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#BILL_OF_OPERATIONS_TYPE
 * BILL_OF_OPERATIONS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#BILL_OF_OPERATIONS_GROUP
 * BILL_OF_OPERATIONS_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#BILL_OF_OPERATIONS
 * BILL_OF_OPERATIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#LAST_SCHEDULED_DATE
 * LAST_SCHEDULED_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#SCHEDULED_BASIC_END_DATE
 * SCHEDULED_BASIC_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#SCHEDULED_BASIC_END_TIME
 * SCHEDULED_BASIC_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#SCHEDULED_BASIC_START_DATE
 * SCHEDULED_BASIC_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#SCHEDULED_BASIC_START_TIME
 * SCHEDULED_BASIC_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#SCHEDULING_TYPE
 * SCHEDULING_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#TO_PLANNED_ORDER_CAPACITY
 * TO_PLANNED_ORDER_CAPACITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.plannedorder.PlannedOrder#TO_PLANNED_ORDER_COMPONENT
 * TO_PLANNED_ORDER_COMPONENT}</li>
 * </ul>
 *
 */
public interface PlannedOrderSelectable extends EntitySelectable<PlannedOrder>
{

}
