/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.field.PlanningCategoryTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.link.PlanningCategoryTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.selectable.PlanningCategoryTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Plan Category Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PlanningCategoryTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PlanningCategoryText extends VdmEntity<PlanningCategoryText>
{

    /**
     * Selector for all available fields of PlanningCategoryText.
     *
     */
    public final static PlanningCategoryTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PlanningCategory</b>
     * </p>
     *
     * @return Plan Category
     */
    @Key
    @SerializedName( "PlanningCategory" )
    @JsonProperty( "PlanningCategory" )
    @Nullable
    @ODataField( odataName = "PlanningCategory" )
    private String planningCategory;
    /**
     * Use with available fluent helpers to apply the <b>PlanningCategory</b> field to query operations.
     *
     */
    public final static PlanningCategoryTextField<String> PLANNING_CATEGORY =
        new PlanningCategoryTextField<String>("PlanningCategory");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PlanningCategoryTextField<String> LANGUAGE = new PlanningCategoryTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PlanningCategoryName</b>
     * </p>
     *
     * @return Planning Category
     */
    @SerializedName( "PlanningCategoryName" )
    @JsonProperty( "PlanningCategoryName" )
    @Nullable
    @ODataField( odataName = "PlanningCategoryName" )
    private String planningCategoryName;
    /**
     * Use with available fluent helpers to apply the <b>PlanningCategoryName</b> field to query operations.
     *
     */
    public final static PlanningCategoryTextField<String> PLANNING_CATEGORY_NAME =
        new PlanningCategoryTextField<String>("PlanningCategoryName");
    /**
     * Navigation property <b>to_PlanningCategory</b> for <b>PlanningCategoryText</b> to single <b>PlanningCategory</b>.
     *
     */
    @SerializedName( "to_PlanningCategory" )
    @JsonProperty( "to_PlanningCategory" )
    @ODataField( odataName = "to_PlanningCategory" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PlanningCategory toPlanningCategory;
    /**
     * Use with available fluent helpers to apply the <b>to_PlanningCategory</b> navigation property to query
     * operations.
     *
     */
    public final static PlanningCategoryTextOneToOneLink<PlanningCategory> TO_PLANNING_CATEGORY =
        new PlanningCategoryTextOneToOneLink<PlanningCategory>("to_PlanningCategory");

    @Nonnull
    @Override
    public Class<PlanningCategoryText> getType()
    {
        return PlanningCategoryText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PlanningCategory</b>
     * </p>
     *
     * @param planningCategory
     *            Plan Category
     */
    public void setPlanningCategory( @Nullable final String planningCategory )
    {
        rememberChangedField("PlanningCategory", this.planningCategory);
        this.planningCategory = planningCategory;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PlanningCategoryName</b>
     * </p>
     *
     * @param planningCategoryName
     *            Planning Category
     */
    public void setPlanningCategoryName( @Nullable final String planningCategoryName )
    {
        rememberChangedField("PlanningCategoryName", this.planningCategoryName);
        this.planningCategoryName = planningCategoryName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PlanningCategoryText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PlanningCategory", getPlanningCategory());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PlanningCategory", getPlanningCategory());
        values.put("Language", getLanguage());
        values.put("PlanningCategoryName", getPlanningCategoryName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PlanningCategory") ) {
                final Object value = values.remove("PlanningCategory");
                if( (value == null) || (!value.equals(getPlanningCategory())) ) {
                    setPlanningCategory(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("PlanningCategoryName") ) {
                final Object value = values.remove("PlanningCategoryName");
                if( (value == null) || (!value.equals(getPlanningCategoryName())) ) {
                    setPlanningCategoryName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PlanningCategory") ) {
                final Object value = (values).remove("to_PlanningCategory");
                if( value instanceof Map ) {
                    if( toPlanningCategory == null ) {
                        toPlanningCategory = new PlanningCategory();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPlanningCategory.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PlanningCategoryTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PlanningCategoryTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PlanningCategoryTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PlanningCategoryTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlanningCategoryService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPlanningCategory != null ) {
            (values).put("to_PlanningCategory", toPlanningCategory);
        }
        return values;
    }

    /**
     * Fetches the <b>PlanningCategory</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PlanningCategory</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PlanningCategory</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PlanningCategory fetchPlanningCategory()
    {
        return fetchFieldAsSingle("to_PlanningCategory", PlanningCategory.class);
    }

    /**
     * Retrieval of associated <b>PlanningCategory</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PlanningCategory</b>.
     * <p>
     * If the navigation property <b>to_PlanningCategory</b> of a queried <b>PlanningCategoryText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PlanningCategory</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PlanningCategory getPlanningCategoryOrFetch()
    {
        if( toPlanningCategory == null ) {
            toPlanningCategory = fetchPlanningCategory();
        }
        return toPlanningCategory;
    }

    /**
     * Retrieval of associated <b>PlanningCategory</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PlanningCategory</b>.
     * <p>
     * If the navigation property for an entity <b>PlanningCategoryText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PlanningCategory</b> is already loaded, the result will
     *         contain the <b>PlanningCategory</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PlanningCategory> getPlanningCategoryIfPresent()
    {
        return Option.of(toPlanningCategory);
    }

    /**
     * Overwrites the associated <b>PlanningCategory</b> entity for the loaded navigation property
     * <b>to_PlanningCategory</b>.
     *
     * @param value
     *            New <b>PlanningCategory</b> entity.
     */
    public void setPlanningCategory( final PlanningCategory value )
    {
        toPlanningCategory = value;
    }

    /**
     * Helper class to allow for fluent creation of PlanningCategoryText instances.
     *
     */
    public final static class PlanningCategoryTextBuilder
    {

        private PlanningCategory toPlanningCategory;
        private String planningCategory = null;

        private PlanningCategoryText.PlanningCategoryTextBuilder toPlanningCategory( final PlanningCategory value )
        {
            toPlanningCategory = value;
            return this;
        }

        /**
         * Navigation property <b>to_PlanningCategory</b> for <b>PlanningCategoryText</b> to single
         * <b>PlanningCategory</b>.
         *
         * @param value
         *            The PlanningCategory to build this PlanningCategoryText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PlanningCategoryText.PlanningCategoryTextBuilder planningCategory( final PlanningCategory value )
        {
            return toPlanningCategory(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>PlanningCategory</b>
         * </p>
         *
         * @param value
         *            The planningCategory to build this PlanningCategoryText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PlanningCategoryText.PlanningCategoryTextBuilder planningCategory( final String value )
        {
            planningCategory = value;
            return this;
        }

    }

}
