/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PlanningCategoryServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlanningCategoryService PlanningCategoryService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultPlanningCategoryServiceBatch
    extends
    BatchFluentHelperBasic<PlanningCategoryServiceBatch, PlanningCategoryServiceBatchChangeSet>
    implements
    PlanningCategoryServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlanningCategoryService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPlanningCategoryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPlanningCategoryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlanningCategoryService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlanningCategoryService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPlanningCategoryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPlanningCategoryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlanningCategoryService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPlanningCategoryServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PlanningCategoryServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPlanningCategoryServiceBatchChangeSet(this, service);
    }

}
