/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link PlanningCategoryServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlanningCategoryService PlanningCategoryService}.
 *
 */
public class DefaultPlanningCategoryServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PlanningCategoryServiceBatch, PlanningCategoryServiceBatchChangeSet>
    implements
    PlanningCategoryServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlanningCategoryService service;

    @SuppressWarnings( "deprecation" )
    DefaultPlanningCategoryServiceBatchChangeSet(
        @Nonnull final DefaultPlanningCategoryServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PlanningCategoryService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPlanningCategoryServiceBatchChangeSet getThis()
    {
        return this;
    }

}
