/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.PlanningCategory;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.PlanningCategory PlanningCategory}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.field.PlanningCategoryField
 * PlanningCategoryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.link.PlanningCategoryLink
 * PlanningCategoryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.PlanningCategory#PLANNING_CATEGORY
 * PLANNING_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.PlanningCategory#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface PlanningCategorySelectable extends EntitySelectable<PlanningCategory>
{

}
