/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.PlanningCategoryText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.PlanningCategoryText
 * PlanningCategoryText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.field.PlanningCategoryTextField
 * PlanningCategoryTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.link.PlanningCategoryTextLink
 * PlanningCategoryTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.PlanningCategoryText#PLANNING_CATEGORY
 * PLANNING_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.PlanningCategoryText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.PlanningCategoryText#PLANNING_CATEGORY_NAME
 * PLANNING_CATEGORY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.planningcategory.PlanningCategoryText#TO_PLANNING_CATEGORY
 * TO_PLANNING_CATEGORY}</li>
 * </ul>
 *
 */
public interface PlanningCategoryTextSelectable extends EntitySelectable<PlanningCategoryText>
{

}
