/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.field.LockboxBatchField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.link.LockboxBatchLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.selectable.LockboxBatchSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Lockbox Batch
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>LockboxBatchType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LockboxBatch extends VdmEntity<LockboxBatch>
{

    /**
     * Selector for all available fields of LockboxBatch.
     *
     */
    public final static LockboxBatchSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchInternalKey</b>
     * </p>
     *
     * @return Short Key for Bank Statement (Surrogate Key)
     */
    @Key
    @SerializedName( "LockboxBatchInternalKey" )
    @JsonProperty( "LockboxBatchInternalKey" )
    @Nullable
    @ODataField( odataName = "LockboxBatchInternalKey" )
    private String lockboxBatchInternalKey;
    /**
     * Use with available fluent helpers to apply the <b>LockboxBatchInternalKey</b> field to query operations.
     *
     */
    public final static LockboxBatchField<String> LOCKBOX_BATCH_INTERNAL_KEY =
        new LockboxBatchField<String>("LockboxBatchInternalKey");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatch</b>
     * </p>
     *
     * @return Batch number (bundle number)
     */
    @Key
    @SerializedName( "LockboxBatch" )
    @JsonProperty( "LockboxBatch" )
    @Nullable
    @ODataField( odataName = "LockboxBatch" )
    private String lockboxBatch;
    /**
     * Use with available fluent helpers to apply the <b>LockboxBatch</b> field to query operations.
     *
     */
    public final static LockboxBatchField<String> LOCKBOX_BATCH = new LockboxBatchField<String>("LockboxBatch");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>Lockbox</b>
     * </p>
     *
     * @return Lockbox Number
     */
    @SerializedName( "Lockbox" )
    @JsonProperty( "Lockbox" )
    @Nullable
    @ODataField( odataName = "Lockbox" )
    private String lockbox;
    /**
     * Use with available fluent helpers to apply the <b>Lockbox</b> field to query operations.
     *
     */
    public final static LockboxBatchField<String> LOCKBOX = new LockboxBatchField<String>("Lockbox");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static LockboxBatchField<String> COMPANY_CODE = new LockboxBatchField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchDestination</b>
     * </p>
     *
     * @return The lockboxBatchDestination contained in this entity.
     */
    @SerializedName( "LockboxBatchDestination" )
    @JsonProperty( "LockboxBatchDestination" )
    @Nullable
    @ODataField( odataName = "LockboxBatchDestination" )
    private String lockboxBatchDestination;
    /**
     * Use with available fluent helpers to apply the <b>LockboxBatchDestination</b> field to query operations.
     *
     */
    public final static LockboxBatchField<String> LOCKBOX_BATCH_DESTINATION =
        new LockboxBatchField<String>("LockboxBatchDestination");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchOrigin</b>
     * </p>
     *
     * @return The lockboxBatchOrigin contained in this entity.
     */
    @SerializedName( "LockboxBatchOrigin" )
    @JsonProperty( "LockboxBatchOrigin" )
    @Nullable
    @ODataField( odataName = "LockboxBatchOrigin" )
    private String lockboxBatchOrigin;
    /**
     * Use with available fluent helpers to apply the <b>LockboxBatchOrigin</b> field to query operations.
     *
     */
    public final static LockboxBatchField<String> LOCKBOX_BATCH_ORIGIN =
        new LockboxBatchField<String>("LockboxBatchOrigin");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DepositDateTime</b>
     * </p>
     *
     * @return Deposit Date and Time
     */
    @SerializedName( "DepositDateTime" )
    @JsonProperty( "DepositDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "DepositDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime depositDateTime;
    /**
     * Use with available fluent helpers to apply the <b>DepositDateTime</b> field to query operations.
     *
     */
    public final static LockboxBatchField<ZonedDateTime> DEPOSIT_DATE_TIME =
        new LockboxBatchField<ZonedDateTime>("DepositDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>IncomingPaymentFile</b>
     * </p>
     *
     * @return Incoming Payment File ID
     */
    @SerializedName( "IncomingPaymentFile" )
    @JsonProperty( "IncomingPaymentFile" )
    @Nullable
    @ODataField( odataName = "IncomingPaymentFile" )
    private String incomingPaymentFile;
    /**
     * Use with available fluent helpers to apply the <b>IncomingPaymentFile</b> field to query operations.
     *
     */
    public final static LockboxBatchField<String> INCOMING_PAYMENT_FILE =
        new LockboxBatchField<String>("IncomingPaymentFile");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchStatus</b>
     * </p>
     *
     * @return Lockbox Batch Status Code
     */
    @SerializedName( "LockboxBatchStatus" )
    @JsonProperty( "LockboxBatchStatus" )
    @Nullable
    @ODataField( odataName = "LockboxBatchStatus" )
    private String lockboxBatchStatus;
    /**
     * Use with available fluent helpers to apply the <b>LockboxBatchStatus</b> field to query operations.
     *
     */
    public final static LockboxBatchField<String> LOCKBOX_BATCH_STATUS =
        new LockboxBatchField<String>("LockboxBatchStatus");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchStatusName</b>
     * </p>
     *
     * @return Lockbox Batch Status Description
     */
    @SerializedName( "LockboxBatchStatusName" )
    @JsonProperty( "LockboxBatchStatusName" )
    @Nullable
    @ODataField( odataName = "LockboxBatchStatusName" )
    private String lockboxBatchStatusName;
    /**
     * Use with available fluent helpers to apply the <b>LockboxBatchStatusName</b> field to query operations.
     *
     */
    public final static LockboxBatchField<String> LOCKBOX_BATCH_STATUS_NAME =
        new LockboxBatchField<String>("LockboxBatchStatusName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfItems</b>
     * </p>
     *
     * @return Number of Checks in Lockbox Batch
     */
    @SerializedName( "NumberOfItems" )
    @JsonProperty( "NumberOfItems" )
    @Nullable
    @ODataField( odataName = "NumberOfItems" )
    private Short numberOfItems;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfItems</b> field to query operations.
     *
     */
    public final static LockboxBatchField<Short> NUMBER_OF_ITEMS = new LockboxBatchField<Short>("NumberOfItems");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return The currency contained in this entity.
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static LockboxBatchField<String> CURRENCY = new LockboxBatchField<String>("Currency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInTransactionCurrency</b>
     * </p>
     *
     * @return Payment Amount
     */
    @SerializedName( "AmountInTransactionCurrency" )
    @JsonProperty( "AmountInTransactionCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInTransactionCurrency" )
    private BigDecimal amountInTransactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInTransactionCurrency</b> field to query operations.
     *
     */
    public final static LockboxBatchField<BigDecimal> AMOUNT_IN_TRANSACTION_CURRENCY =
        new LockboxBatchField<BigDecimal>("AmountInTransactionCurrency");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfIncompleteCheques</b>
     * </p>
     *
     * @return Number of Incomplete Cheques in Lockbox Batch
     */
    @SerializedName( "NumberOfIncompleteCheques" )
    @JsonProperty( "NumberOfIncompleteCheques" )
    @Nullable
    @ODataField( odataName = "NumberOfIncompleteCheques" )
    private Short numberOfIncompleteCheques;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfIncompleteCheques</b> field to query operations.
     *
     */
    public final static LockboxBatchField<Short> NUMBER_OF_INCOMPLETE_CHEQUES =
        new LockboxBatchField<Short>("NumberOfIncompleteCheques");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BatchIsLatest</b>
     * </p>
     *
     * @return Latest Lockbox Batch
     */
    @SerializedName( "BatchIsLatest" )
    @JsonProperty( "BatchIsLatest" )
    @Nullable
    @ODataField( odataName = "BatchIsLatest" )
    private String batchIsLatest;
    /**
     * Use with available fluent helpers to apply the <b>BatchIsLatest</b> field to query operations.
     *
     */
    public final static LockboxBatchField<String> BATCH_IS_LATEST = new LockboxBatchField<String>("BatchIsLatest");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JournalEntryIsNotToBePosted</b>
     * </p>
     *
     * @return The journalEntryIsNotToBePosted contained in this entity.
     */
    @SerializedName( "JournalEntryIsNotToBePosted" )
    @JsonProperty( "JournalEntryIsNotToBePosted" )
    @Nullable
    @ODataField( odataName = "JournalEntryIsNotToBePosted" )
    private String journalEntryIsNotToBePosted;
    /**
     * Use with available fluent helpers to apply the <b>JournalEntryIsNotToBePosted</b> field to query operations.
     *
     */
    public final static LockboxBatchField<String> JOURNAL_ENTRY_IS_NOT_TO_BE_POSTED =
        new LockboxBatchField<String>("JournalEntryIsNotToBePosted");
    /**
     * Navigation property <b>to_Item</b> for <b>LockboxBatch</b> to multiple <b>LockboxBatchItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LockboxBatchItem> toItem;
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static LockboxBatchLink<LockboxBatchItem> TO_ITEM = new LockboxBatchLink<LockboxBatchItem>("to_Item");

    @Nonnull
    @Override
    public Class<LockboxBatch> getType()
    {
        return LockboxBatch.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchInternalKey</b>
     * </p>
     *
     * @param lockboxBatchInternalKey
     *            Short Key for Bank Statement (Surrogate Key)
     */
    public void setLockboxBatchInternalKey( @Nullable final String lockboxBatchInternalKey )
    {
        rememberChangedField("LockboxBatchInternalKey", this.lockboxBatchInternalKey);
        this.lockboxBatchInternalKey = lockboxBatchInternalKey;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatch</b>
     * </p>
     *
     * @param lockboxBatch
     *            Batch number (bundle number)
     */
    public void setLockboxBatch( @Nullable final String lockboxBatch )
    {
        rememberChangedField("LockboxBatch", this.lockboxBatch);
        this.lockboxBatch = lockboxBatch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>Lockbox</b>
     * </p>
     *
     * @param lockbox
     *            Lockbox Number
     */
    public void setLockbox( @Nullable final String lockbox )
    {
        rememberChangedField("Lockbox", this.lockbox);
        this.lockbox = lockbox;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchDestination</b>
     * </p>
     *
     * @param lockboxBatchDestination
     *            The lockboxBatchDestination to set.
     */
    public void setLockboxBatchDestination( @Nullable final String lockboxBatchDestination )
    {
        rememberChangedField("LockboxBatchDestination", this.lockboxBatchDestination);
        this.lockboxBatchDestination = lockboxBatchDestination;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchOrigin</b>
     * </p>
     *
     * @param lockboxBatchOrigin
     *            The lockboxBatchOrigin to set.
     */
    public void setLockboxBatchOrigin( @Nullable final String lockboxBatchOrigin )
    {
        rememberChangedField("LockboxBatchOrigin", this.lockboxBatchOrigin);
        this.lockboxBatchOrigin = lockboxBatchOrigin;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DepositDateTime</b>
     * </p>
     *
     * @param depositDateTime
     *            Deposit Date and Time
     */
    public void setDepositDateTime( @Nullable final ZonedDateTime depositDateTime )
    {
        rememberChangedField("DepositDateTime", this.depositDateTime);
        this.depositDateTime = depositDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>IncomingPaymentFile</b>
     * </p>
     *
     * @param incomingPaymentFile
     *            Incoming Payment File ID
     */
    public void setIncomingPaymentFile( @Nullable final String incomingPaymentFile )
    {
        rememberChangedField("IncomingPaymentFile", this.incomingPaymentFile);
        this.incomingPaymentFile = incomingPaymentFile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchStatus</b>
     * </p>
     *
     * @param lockboxBatchStatus
     *            Lockbox Batch Status Code
     */
    public void setLockboxBatchStatus( @Nullable final String lockboxBatchStatus )
    {
        rememberChangedField("LockboxBatchStatus", this.lockboxBatchStatus);
        this.lockboxBatchStatus = lockboxBatchStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchStatusName</b>
     * </p>
     *
     * @param lockboxBatchStatusName
     *            Lockbox Batch Status Description
     */
    public void setLockboxBatchStatusName( @Nullable final String lockboxBatchStatusName )
    {
        rememberChangedField("LockboxBatchStatusName", this.lockboxBatchStatusName);
        this.lockboxBatchStatusName = lockboxBatchStatusName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfItems</b>
     * </p>
     *
     * @param numberOfItems
     *            Number of Checks in Lockbox Batch
     */
    public void setNumberOfItems( @Nullable final Short numberOfItems )
    {
        rememberChangedField("NumberOfItems", this.numberOfItems);
        this.numberOfItems = numberOfItems;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            The currency to set.
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInTransactionCurrency</b>
     * </p>
     *
     * @param amountInTransactionCurrency
     *            Payment Amount
     */
    public void setAmountInTransactionCurrency( @Nullable final BigDecimal amountInTransactionCurrency )
    {
        rememberChangedField("AmountInTransactionCurrency", this.amountInTransactionCurrency);
        this.amountInTransactionCurrency = amountInTransactionCurrency;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfIncompleteCheques</b>
     * </p>
     *
     * @param numberOfIncompleteCheques
     *            Number of Incomplete Cheques in Lockbox Batch
     */
    public void setNumberOfIncompleteCheques( @Nullable final Short numberOfIncompleteCheques )
    {
        rememberChangedField("NumberOfIncompleteCheques", this.numberOfIncompleteCheques);
        this.numberOfIncompleteCheques = numberOfIncompleteCheques;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BatchIsLatest</b>
     * </p>
     *
     * @param batchIsLatest
     *            Latest Lockbox Batch
     */
    public void setBatchIsLatest( @Nullable final String batchIsLatest )
    {
        rememberChangedField("BatchIsLatest", this.batchIsLatest);
        this.batchIsLatest = batchIsLatest;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>JournalEntryIsNotToBePosted</b>
     * </p>
     *
     * @param journalEntryIsNotToBePosted
     *            The journalEntryIsNotToBePosted to set.
     */
    public void setJournalEntryIsNotToBePosted( @Nullable final String journalEntryIsNotToBePosted )
    {
        rememberChangedField("JournalEntryIsNotToBePosted", this.journalEntryIsNotToBePosted);
        this.journalEntryIsNotToBePosted = journalEntryIsNotToBePosted;
    }

    @Override
    protected String getEntityCollection()
    {
        return "LockboxBatch";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LockboxBatchInternalKey", getLockboxBatchInternalKey());
        result.put("LockboxBatch", getLockboxBatch());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LockboxBatchInternalKey", getLockboxBatchInternalKey());
        values.put("LockboxBatch", getLockboxBatch());
        values.put("Lockbox", getLockbox());
        values.put("CompanyCode", getCompanyCode());
        values.put("LockboxBatchDestination", getLockboxBatchDestination());
        values.put("LockboxBatchOrigin", getLockboxBatchOrigin());
        values.put("DepositDateTime", getDepositDateTime());
        values.put("IncomingPaymentFile", getIncomingPaymentFile());
        values.put("LockboxBatchStatus", getLockboxBatchStatus());
        values.put("LockboxBatchStatusName", getLockboxBatchStatusName());
        values.put("NumberOfItems", getNumberOfItems());
        values.put("Currency", getCurrency());
        values.put("AmountInTransactionCurrency", getAmountInTransactionCurrency());
        values.put("NumberOfIncompleteCheques", getNumberOfIncompleteCheques());
        values.put("BatchIsLatest", getBatchIsLatest());
        values.put("JournalEntryIsNotToBePosted", getJournalEntryIsNotToBePosted());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LockboxBatchInternalKey") ) {
                final Object value = values.remove("LockboxBatchInternalKey");
                if( (value == null) || (!value.equals(getLockboxBatchInternalKey())) ) {
                    setLockboxBatchInternalKey(((String) value));
                }
            }
            if( values.containsKey("LockboxBatch") ) {
                final Object value = values.remove("LockboxBatch");
                if( (value == null) || (!value.equals(getLockboxBatch())) ) {
                    setLockboxBatch(((String) value));
                }
            }
            if( values.containsKey("Lockbox") ) {
                final Object value = values.remove("Lockbox");
                if( (value == null) || (!value.equals(getLockbox())) ) {
                    setLockbox(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("LockboxBatchDestination") ) {
                final Object value = values.remove("LockboxBatchDestination");
                if( (value == null) || (!value.equals(getLockboxBatchDestination())) ) {
                    setLockboxBatchDestination(((String) value));
                }
            }
            if( values.containsKey("LockboxBatchOrigin") ) {
                final Object value = values.remove("LockboxBatchOrigin");
                if( (value == null) || (!value.equals(getLockboxBatchOrigin())) ) {
                    setLockboxBatchOrigin(((String) value));
                }
            }
            if( values.containsKey("DepositDateTime") ) {
                final Object value = values.remove("DepositDateTime");
                if( (value == null) || (!value.equals(getDepositDateTime())) ) {
                    setDepositDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("IncomingPaymentFile") ) {
                final Object value = values.remove("IncomingPaymentFile");
                if( (value == null) || (!value.equals(getIncomingPaymentFile())) ) {
                    setIncomingPaymentFile(((String) value));
                }
            }
            if( values.containsKey("LockboxBatchStatus") ) {
                final Object value = values.remove("LockboxBatchStatus");
                if( (value == null) || (!value.equals(getLockboxBatchStatus())) ) {
                    setLockboxBatchStatus(((String) value));
                }
            }
            if( values.containsKey("LockboxBatchStatusName") ) {
                final Object value = values.remove("LockboxBatchStatusName");
                if( (value == null) || (!value.equals(getLockboxBatchStatusName())) ) {
                    setLockboxBatchStatusName(((String) value));
                }
            }
            if( values.containsKey("NumberOfItems") ) {
                final Object value = values.remove("NumberOfItems");
                if( (value == null) || (!value.equals(getNumberOfItems())) ) {
                    setNumberOfItems(((Short) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInTransactionCurrency") ) {
                final Object value = values.remove("AmountInTransactionCurrency");
                if( (value == null) || (!value.equals(getAmountInTransactionCurrency())) ) {
                    setAmountInTransactionCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("NumberOfIncompleteCheques") ) {
                final Object value = values.remove("NumberOfIncompleteCheques");
                if( (value == null) || (!value.equals(getNumberOfIncompleteCheques())) ) {
                    setNumberOfIncompleteCheques(((Short) value));
                }
            }
            if( values.containsKey("BatchIsLatest") ) {
                final Object value = values.remove("BatchIsLatest");
                if( (value == null) || (!value.equals(getBatchIsLatest())) ) {
                    setBatchIsLatest(((String) value));
                }
            }
            if( values.containsKey("JournalEntryIsNotToBePosted") ) {
                final Object value = values.remove("JournalEntryIsNotToBePosted");
                if( (value == null) || (!value.equals(getJournalEntryIsNotToBePosted())) ) {
                    setJournalEntryIsNotToBePosted(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Iterable ) {
                    if( toItem == null ) {
                        toItem = Lists.newArrayList();
                    } else {
                        toItem = Lists.newArrayList(toItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LockboxBatchItem entity;
                        if( toItem.size() > i ) {
                            entity = toItem.get(i);
                        } else {
                            entity = new LockboxBatchItem();
                            toItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> LockboxBatchField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LockboxBatchField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LockboxBatchField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LockboxBatchField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PostLockboxService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        return values;
    }

    /**
     * Fetches the <b>LockboxBatchItem</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LockboxBatchItem</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LockboxBatchItem> fetchItem()
    {
        return fetchFieldAsList("to_Item", LockboxBatchItem.class);
    }

    /**
     * Retrieval of associated <b>LockboxBatchItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>LockboxBatch</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LockboxBatchItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LockboxBatchItem> getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>LockboxBatchItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>LockboxBatch</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>LockboxBatchItem</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<LockboxBatchItem>> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the list of associated <b>LockboxBatchItem</b> entities for the loaded navigation property
     * <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>LockboxBatch</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LockboxBatchItem</b> entities.
     */
    public void setItem( @Nonnull final List<LockboxBatchItem> value )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.clear();
        toItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LockboxBatchItem</b> entities. This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>LockboxBatch</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LockboxBatchItem</b> entities.
     */
    public void addItem( LockboxBatchItem... entity )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of LockboxBatch instances.
     *
     */
    public final static class LockboxBatchBuilder
    {

        private List<LockboxBatchItem> toItem = Lists.newArrayList();

        private LockboxBatch.LockboxBatchBuilder toItem( final List<LockboxBatchItem> value )
        {
            toItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>LockboxBatch</b> to multiple <b>LockboxBatchItem</b>.
         *
         * @param value
         *            The LockboxBatchItems to build this LockboxBatch with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LockboxBatch.LockboxBatchBuilder item( LockboxBatchItem... value )
        {
            return toItem(Lists.newArrayList(value));
        }

    }

}
