/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.selectable.LockboxBatchSelectable;

/**
 * Fluent helper to fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch
 * LockboxBatch} entity using key fields. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class LockboxBatchByKeyFluentHelper
    extends
    FluentHelperByKey<LockboxBatchByKeyFluentHelper, LockboxBatch, LockboxBatchSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch LockboxBatch} entity with the
     * provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code LockboxBatch}
     * @param lockboxBatch
     *            Batch number (bundle number)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code LockboxBatch}
     * @param lockboxBatchInternalKey
     *            Short Key for Bank Statement (Surrogate Key)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     */
    public LockboxBatchByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String lockboxBatchInternalKey,
        final String lockboxBatch )
    {
        super(servicePath, entityCollection);
        this.key.put("LockboxBatchInternalKey", lockboxBatchInternalKey);
        this.key.put("LockboxBatch", lockboxBatch);
    }

    @Override
    @Nonnull
    protected Class<LockboxBatch> getEntityClass()
    {
        return LockboxBatch.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
