/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.field.LockboxBatchItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.link.LockboxBatchItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.link.LockboxBatchItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.selectable.LockboxBatchItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Lockbox Batch Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>LockboxBatchItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LockboxBatchItem extends VdmEntity<LockboxBatchItem>
{

    /**
     * Selector for all available fields of LockboxBatchItem.
     *
     */
    public final static LockboxBatchItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchInternalKey</b>
     * </p>
     *
     * @return Short Key for Bank Statement (Surrogate Key)
     */
    @Key
    @SerializedName( "LockboxBatchInternalKey" )
    @JsonProperty( "LockboxBatchInternalKey" )
    @Nullable
    @ODataField( odataName = "LockboxBatchInternalKey" )
    private String lockboxBatchInternalKey;
    /**
     * Use with available fluent helpers to apply the <b>LockboxBatchInternalKey</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> LOCKBOX_BATCH_INTERNAL_KEY =
        new LockboxBatchItemField<String>("LockboxBatchInternalKey");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchItem</b>
     * </p>
     *
     * @return Memo Record Number (Line Item Number in Bank Statement)
     */
    @Key
    @SerializedName( "LockboxBatchItem" )
    @JsonProperty( "LockboxBatchItem" )
    @Nullable
    @ODataField( odataName = "LockboxBatchItem" )
    private String lockboxBatchItem;
    /**
     * Use with available fluent helpers to apply the <b>LockboxBatchItem</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> LOCKBOX_BATCH_ITEM =
        new LockboxBatchItemField<String>("LockboxBatchItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatch</b>
     * </p>
     *
     * @return Batch number (bundle number)
     */
    @Key
    @SerializedName( "LockboxBatch" )
    @JsonProperty( "LockboxBatch" )
    @Nullable
    @ODataField( odataName = "LockboxBatch" )
    private String lockboxBatch;
    /**
     * Use with available fluent helpers to apply the <b>LockboxBatch</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> LOCKBOX_BATCH = new LockboxBatchItemField<String>("LockboxBatch");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValueDate</b>
     * </p>
     *
     * @return Value Date
     */
    @SerializedName( "ValueDate" )
    @JsonProperty( "ValueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime valueDate;
    /**
     * Use with available fluent helpers to apply the <b>ValueDate</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<LocalDateTime> VALUE_DATE =
        new LockboxBatchItemField<LocalDateTime>("ValueDate");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Account Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> CURRENCY = new LockboxBatchItemField<String>("Currency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInTransactionCurrency</b>
     * </p>
     *
     * @return Payment Amount
     */
    @SerializedName( "AmountInTransactionCurrency" )
    @JsonProperty( "AmountInTransactionCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInTransactionCurrency" )
    private BigDecimal amountInTransactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInTransactionCurrency</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<BigDecimal> AMOUNT_IN_TRANSACTION_CURRENCY =
        new LockboxBatchItemField<BigDecimal>("AmountInTransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchItmStatus</b>
     * </p>
     *
     * @return Lockbox Batch Item Status
     */
    @SerializedName( "LockboxBatchItmStatus" )
    @JsonProperty( "LockboxBatchItmStatus" )
    @Nullable
    @ODataField( odataName = "LockboxBatchItmStatus" )
    private String lockboxBatchItmStatus;
    /**
     * Use with available fluent helpers to apply the <b>LockboxBatchItmStatus</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> LOCKBOX_BATCH_ITM_STATUS =
        new LockboxBatchItemField<String>("LockboxBatchItmStatus");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchItmStatusName</b>
     * </p>
     *
     * @return Lockbox Batch Status Description
     */
    @SerializedName( "LockboxBatchItmStatusName" )
    @JsonProperty( "LockboxBatchItmStatusName" )
    @Nullable
    @ODataField( odataName = "LockboxBatchItmStatusName" )
    private String lockboxBatchItmStatusName;
    /**
     * Use with available fluent helpers to apply the <b>LockboxBatchItmStatusName</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> LOCKBOX_BATCH_ITM_STATUS_NAME =
        new LockboxBatchItemField<String>("LockboxBatchItmStatusName");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>Cheque</b>
     * </p>
     *
     * @return Cheque Number
     */
    @SerializedName( "Cheque" )
    @JsonProperty( "Cheque" )
    @Nullable
    @ODataField( odataName = "Cheque" )
    private String cheque;
    /**
     * Use with available fluent helpers to apply the <b>Cheque</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> CHEQUE = new LockboxBatchItemField<String>("Cheque");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBankCountry</b>
     * </p>
     *
     * @return Partner Bank Account: Bank Country/Region Key
     */
    @SerializedName( "PartnerBankCountry" )
    @JsonProperty( "PartnerBankCountry" )
    @Nullable
    @ODataField( odataName = "PartnerBankCountry" )
    private String partnerBankCountry;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBankCountry</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> PARTNER_BANK_COUNTRY =
        new LockboxBatchItemField<String>("PartnerBankCountry");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBank</b>
     * </p>
     *
     * @return Partner Bank Account: Bank Number
     */
    @SerializedName( "PartnerBank" )
    @JsonProperty( "PartnerBank" )
    @Nullable
    @ODataField( odataName = "PartnerBank" )
    private String partnerBank;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBank</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> PARTNER_BANK = new LockboxBatchItemField<String>("PartnerBank");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBankAccount</b>
     * </p>
     *
     * @return Partner Bank Account: Account Number
     */
    @SerializedName( "PartnerBankAccount" )
    @JsonProperty( "PartnerBankAccount" )
    @Nullable
    @ODataField( odataName = "PartnerBankAccount" )
    private String partnerBankAccount;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBankAccount</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> PARTNER_BANK_ACCOUNT =
        new LockboxBatchItemField<String>("PartnerBankAccount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BankLedgerDocument</b>
     * </p>
     *
     * @return Document Number of an Accounting Document
     */
    @SerializedName( "BankLedgerDocument" )
    @JsonProperty( "BankLedgerDocument" )
    @Nullable
    @ODataField( odataName = "BankLedgerDocument" )
    private String bankLedgerDocument;
    /**
     * Use with available fluent helpers to apply the <b>BankLedgerDocument</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> BANK_LEDGER_DOCUMENT =
        new LockboxBatchItemField<String>("BankLedgerDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> CUSTOMER = new LockboxBatchItemField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 65
     * <p>
     * Original property name from the Odata EDM: <b>MemoLine1</b>
     * </p>
     *
     * @return Line 1 of Memo Line
     */
    @SerializedName( "MemoLine1" )
    @JsonProperty( "MemoLine1" )
    @Nullable
    @ODataField( odataName = "MemoLine1" )
    private String memoLine1;
    /**
     * Use with available fluent helpers to apply the <b>MemoLine1</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> MEMO_LINE1 = new LockboxBatchItemField<String>("MemoLine1");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>MemoLine</b>
     * </p>
     *
     * @return Memo Line
     */
    @SerializedName( "MemoLine" )
    @JsonProperty( "MemoLine" )
    @Nullable
    @ODataField( odataName = "MemoLine" )
    private String memoLine;
    /**
     * Use with available fluent helpers to apply the <b>MemoLine</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> MEMO_LINE = new LockboxBatchItemField<String>("MemoLine");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdvice</b>
     * </p>
     *
     * @return Payment Advice Number
     */
    @SerializedName( "PaymentAdvice" )
    @JsonProperty( "PaymentAdvice" )
    @Nullable
    @ODataField( odataName = "PaymentAdvice" )
    private String paymentAdvice;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdvice</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> PAYMENT_ADVICE =
        new LockboxBatchItemField<String>("PaymentAdvice");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @return Assignment number
     */
    @SerializedName( "AssignmentReference" )
    @JsonProperty( "AssignmentReference" )
    @Nullable
    @ODataField( odataName = "AssignmentReference" )
    private String assignmentReference;
    /**
     * Use with available fluent helpers to apply the <b>AssignmentReference</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> ASSIGNMENT_REFERENCE =
        new LockboxBatchItemField<String>("AssignmentReference");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DocumentItemText</b>
     * </p>
     *
     * @return Text Field
     */
    @SerializedName( "DocumentItemText" )
    @JsonProperty( "DocumentItemText" )
    @Nullable
    @ODataField( odataName = "DocumentItemText" )
    private String documentItemText;
    /**
     * Use with available fluent helpers to apply the <b>DocumentItemText</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> DOCUMENT_ITEM_TEXT =
        new LockboxBatchItemField<String>("DocumentItemText");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReferenceID</b>
     * </p>
     *
     * @return Reference Document Number
     */
    @SerializedName( "DocumentReferenceID" )
    @JsonProperty( "DocumentReferenceID" )
    @Nullable
    @ODataField( odataName = "DocumentReferenceID" )
    private String documentReferenceID;
    /**
     * Use with available fluent helpers to apply the <b>DocumentReferenceID</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> DOCUMENT_REFERENCE_ID =
        new LockboxBatchItemField<String>("DocumentReferenceID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentManualTransacType</b>
     * </p>
     *
     * @return Transaction
     */
    @SerializedName( "PaymentManualTransacType" )
    @JsonProperty( "PaymentManualTransacType" )
    @Nullable
    @ODataField( odataName = "PaymentManualTransacType" )
    private String paymentManualTransacType;
    /**
     * Use with available fluent helpers to apply the <b>PaymentManualTransacType</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> PAYMENT_MANUAL_TRANSAC_TYPE =
        new LockboxBatchItemField<String>("PaymentManualTransacType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BankLedgerIsPosted</b>
     * </p>
     *
     * @return Indicator that posting Area 1 was posted or not
     */
    @SerializedName( "BankLedgerIsPosted" )
    @JsonProperty( "BankLedgerIsPosted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BankLedgerIsPosted" )
    private Boolean bankLedgerIsPosted;
    /**
     * Use with available fluent helpers to apply the <b>BankLedgerIsPosted</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<Boolean> BANK_LEDGER_IS_POSTED =
        new LockboxBatchItemField<Boolean>("BankLedgerIsPosted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SubledgerIsPostedSuccessfully</b>
     * </p>
     *
     * @return Indicator that posting Area 2 was posted or not
     */
    @SerializedName( "SubledgerIsPostedSuccessfully" )
    @JsonProperty( "SubledgerIsPostedSuccessfully" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SubledgerIsPostedSuccessfully" )
    private Boolean subledgerIsPostedSuccessfully;
    /**
     * Use with available fluent helpers to apply the <b>SubledgerIsPostedSuccessfully</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<Boolean> SUBLEDGER_IS_POSTED_SUCCESSFULLY =
        new LockboxBatchItemField<Boolean>("SubledgerIsPostedSuccessfully");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LockboxSubledgerDocument</b>
     * </p>
     *
     * @return Number of second subledger document
     */
    @SerializedName( "LockboxSubledgerDocument" )
    @JsonProperty( "LockboxSubledgerDocument" )
    @Nullable
    @ODataField( odataName = "LockboxSubledgerDocument" )
    private String lockboxSubledgerDocument;
    /**
     * Use with available fluent helpers to apply the <b>LockboxSubledgerDocument</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> LOCKBOX_SUBLEDGER_DOCUMENT =
        new LockboxBatchItemField<String>("LockboxSubledgerDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> COMPANY_CODE = new LockboxBatchItemField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> FISCAL_YEAR = new LockboxBatchItemField<String>("FiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SubledgerDocument</b>
     * </p>
     *
     * @return Subledger Document Number
     */
    @SerializedName( "SubledgerDocument" )
    @JsonProperty( "SubledgerDocument" )
    @Nullable
    @ODataField( odataName = "SubledgerDocument" )
    private String subledgerDocument;
    /**
     * Use with available fluent helpers to apply the <b>SubledgerDocument</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> SUBLEDGER_DOCUMENT =
        new LockboxBatchItemField<String>("SubledgerDocument");
    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchItmAdditionalInfo</b>
     * </p>
     *
     * @return Additional information from file
     */
    @SerializedName( "LockboxBatchItmAdditionalInfo" )
    @JsonProperty( "LockboxBatchItmAdditionalInfo" )
    @Nullable
    @ODataField( odataName = "LockboxBatchItmAdditionalInfo" )
    private String lockboxBatchItmAdditionalInfo;
    /**
     * Use with available fluent helpers to apply the <b>LockboxBatchItmAdditionalInfo</b> field to query operations.
     *
     */
    public final static LockboxBatchItemField<String> LOCKBOX_BATCH_ITM_ADDITIONAL_INFO =
        new LockboxBatchItemField<String>("LockboxBatchItmAdditionalInfo");
    /**
     * Navigation property <b>to_Header</b> for <b>LockboxBatchItem</b> to single <b>LockboxBatch</b>.
     *
     */
    @SerializedName( "to_Header" )
    @JsonProperty( "to_Header" )
    @ODataField( odataName = "to_Header" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private LockboxBatch toHeader;
    /**
     * Navigation property <b>to_LockboxClearing</b> for <b>LockboxBatchItem</b> to multiple <b>LockboxClearing</b>.
     *
     */
    @SerializedName( "to_LockboxClearing" )
    @JsonProperty( "to_LockboxClearing" )
    @ODataField( odataName = "to_LockboxClearing" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LockboxClearing> toLockboxClearing;
    /**
     * Use with available fluent helpers to apply the <b>to_Header</b> navigation property to query operations.
     *
     */
    public final static LockboxBatchItemOneToOneLink<LockboxBatch> TO_HEADER =
        new LockboxBatchItemOneToOneLink<LockboxBatch>("to_Header");
    /**
     * Use with available fluent helpers to apply the <b>to_LockboxClearing</b> navigation property to query operations.
     *
     */
    public final static LockboxBatchItemLink<LockboxClearing> TO_LOCKBOX_CLEARING =
        new LockboxBatchItemLink<LockboxClearing>("to_LockboxClearing");

    @Nonnull
    @Override
    public Class<LockboxBatchItem> getType()
    {
        return LockboxBatchItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchInternalKey</b>
     * </p>
     *
     * @param lockboxBatchInternalKey
     *            Short Key for Bank Statement (Surrogate Key)
     */
    public void setLockboxBatchInternalKey( @Nullable final String lockboxBatchInternalKey )
    {
        rememberChangedField("LockboxBatchInternalKey", this.lockboxBatchInternalKey);
        this.lockboxBatchInternalKey = lockboxBatchInternalKey;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchItem</b>
     * </p>
     *
     * @param lockboxBatchItem
     *            Memo Record Number (Line Item Number in Bank Statement)
     */
    public void setLockboxBatchItem( @Nullable final String lockboxBatchItem )
    {
        rememberChangedField("LockboxBatchItem", this.lockboxBatchItem);
        this.lockboxBatchItem = lockboxBatchItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatch</b>
     * </p>
     *
     * @param lockboxBatch
     *            Batch number (bundle number)
     */
    public void setLockboxBatch( @Nullable final String lockboxBatch )
    {
        rememberChangedField("LockboxBatch", this.lockboxBatch);
        this.lockboxBatch = lockboxBatch;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValueDate</b>
     * </p>
     *
     * @param valueDate
     *            Value Date
     */
    public void setValueDate( @Nullable final LocalDateTime valueDate )
    {
        rememberChangedField("ValueDate", this.valueDate);
        this.valueDate = valueDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Account Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInTransactionCurrency</b>
     * </p>
     *
     * @param amountInTransactionCurrency
     *            Payment Amount
     */
    public void setAmountInTransactionCurrency( @Nullable final BigDecimal amountInTransactionCurrency )
    {
        rememberChangedField("AmountInTransactionCurrency", this.amountInTransactionCurrency);
        this.amountInTransactionCurrency = amountInTransactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchItmStatus</b>
     * </p>
     *
     * @param lockboxBatchItmStatus
     *            Lockbox Batch Item Status
     */
    public void setLockboxBatchItmStatus( @Nullable final String lockboxBatchItmStatus )
    {
        rememberChangedField("LockboxBatchItmStatus", this.lockboxBatchItmStatus);
        this.lockboxBatchItmStatus = lockboxBatchItmStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchItmStatusName</b>
     * </p>
     *
     * @param lockboxBatchItmStatusName
     *            Lockbox Batch Status Description
     */
    public void setLockboxBatchItmStatusName( @Nullable final String lockboxBatchItmStatusName )
    {
        rememberChangedField("LockboxBatchItmStatusName", this.lockboxBatchItmStatusName);
        this.lockboxBatchItmStatusName = lockboxBatchItmStatusName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>Cheque</b>
     * </p>
     *
     * @param cheque
     *            Cheque Number
     */
    public void setCheque( @Nullable final String cheque )
    {
        rememberChangedField("Cheque", this.cheque);
        this.cheque = cheque;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBankCountry</b>
     * </p>
     *
     * @param partnerBankCountry
     *            Partner Bank Account: Bank Country/Region Key
     */
    public void setPartnerBankCountry( @Nullable final String partnerBankCountry )
    {
        rememberChangedField("PartnerBankCountry", this.partnerBankCountry);
        this.partnerBankCountry = partnerBankCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBank</b>
     * </p>
     *
     * @param partnerBank
     *            Partner Bank Account: Bank Number
     */
    public void setPartnerBank( @Nullable final String partnerBank )
    {
        rememberChangedField("PartnerBank", this.partnerBank);
        this.partnerBank = partnerBank;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBankAccount</b>
     * </p>
     *
     * @param partnerBankAccount
     *            Partner Bank Account: Account Number
     */
    public void setPartnerBankAccount( @Nullable final String partnerBankAccount )
    {
        rememberChangedField("PartnerBankAccount", this.partnerBankAccount);
        this.partnerBankAccount = partnerBankAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BankLedgerDocument</b>
     * </p>
     *
     * @param bankLedgerDocument
     *            Document Number of an Accounting Document
     */
    public void setBankLedgerDocument( @Nullable final String bankLedgerDocument )
    {
        rememberChangedField("BankLedgerDocument", this.bankLedgerDocument);
        this.bankLedgerDocument = bankLedgerDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 65
     * <p>
     * Original property name from the Odata EDM: <b>MemoLine1</b>
     * </p>
     *
     * @param memoLine1
     *            Line 1 of Memo Line
     */
    public void setMemoLine1( @Nullable final String memoLine1 )
    {
        rememberChangedField("MemoLine1", this.memoLine1);
        this.memoLine1 = memoLine1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>MemoLine</b>
     * </p>
     *
     * @param memoLine
     *            Memo Line
     */
    public void setMemoLine( @Nullable final String memoLine )
    {
        rememberChangedField("MemoLine", this.memoLine);
        this.memoLine = memoLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdvice</b>
     * </p>
     *
     * @param paymentAdvice
     *            Payment Advice Number
     */
    public void setPaymentAdvice( @Nullable final String paymentAdvice )
    {
        rememberChangedField("PaymentAdvice", this.paymentAdvice);
        this.paymentAdvice = paymentAdvice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @param assignmentReference
     *            Assignment number
     */
    public void setAssignmentReference( @Nullable final String assignmentReference )
    {
        rememberChangedField("AssignmentReference", this.assignmentReference);
        this.assignmentReference = assignmentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DocumentItemText</b>
     * </p>
     *
     * @param documentItemText
     *            Text Field
     */
    public void setDocumentItemText( @Nullable final String documentItemText )
    {
        rememberChangedField("DocumentItemText", this.documentItemText);
        this.documentItemText = documentItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReferenceID</b>
     * </p>
     *
     * @param documentReferenceID
     *            Reference Document Number
     */
    public void setDocumentReferenceID( @Nullable final String documentReferenceID )
    {
        rememberChangedField("DocumentReferenceID", this.documentReferenceID);
        this.documentReferenceID = documentReferenceID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentManualTransacType</b>
     * </p>
     *
     * @param paymentManualTransacType
     *            Transaction
     */
    public void setPaymentManualTransacType( @Nullable final String paymentManualTransacType )
    {
        rememberChangedField("PaymentManualTransacType", this.paymentManualTransacType);
        this.paymentManualTransacType = paymentManualTransacType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BankLedgerIsPosted</b>
     * </p>
     *
     * @param bankLedgerIsPosted
     *            Indicator that posting Area 1 was posted or not
     */
    public void setBankLedgerIsPosted( @Nullable final Boolean bankLedgerIsPosted )
    {
        rememberChangedField("BankLedgerIsPosted", this.bankLedgerIsPosted);
        this.bankLedgerIsPosted = bankLedgerIsPosted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SubledgerIsPostedSuccessfully</b>
     * </p>
     *
     * @param subledgerIsPostedSuccessfully
     *            Indicator that posting Area 2 was posted or not
     */
    public void setSubledgerIsPostedSuccessfully( @Nullable final Boolean subledgerIsPostedSuccessfully )
    {
        rememberChangedField("SubledgerIsPostedSuccessfully", this.subledgerIsPostedSuccessfully);
        this.subledgerIsPostedSuccessfully = subledgerIsPostedSuccessfully;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LockboxSubledgerDocument</b>
     * </p>
     *
     * @param lockboxSubledgerDocument
     *            Number of second subledger document
     */
    public void setLockboxSubledgerDocument( @Nullable final String lockboxSubledgerDocument )
    {
        rememberChangedField("LockboxSubledgerDocument", this.lockboxSubledgerDocument);
        this.lockboxSubledgerDocument = lockboxSubledgerDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SubledgerDocument</b>
     * </p>
     *
     * @param subledgerDocument
     *            Subledger Document Number
     */
    public void setSubledgerDocument( @Nullable final String subledgerDocument )
    {
        rememberChangedField("SubledgerDocument", this.subledgerDocument);
        this.subledgerDocument = subledgerDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 100
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchItmAdditionalInfo</b>
     * </p>
     *
     * @param lockboxBatchItmAdditionalInfo
     *            Additional information from file
     */
    public void setLockboxBatchItmAdditionalInfo( @Nullable final String lockboxBatchItmAdditionalInfo )
    {
        rememberChangedField("LockboxBatchItmAdditionalInfo", this.lockboxBatchItmAdditionalInfo);
        this.lockboxBatchItmAdditionalInfo = lockboxBatchItmAdditionalInfo;
    }

    @Override
    protected String getEntityCollection()
    {
        return "LockboxBatchItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LockboxBatchInternalKey", getLockboxBatchInternalKey());
        result.put("LockboxBatchItem", getLockboxBatchItem());
        result.put("LockboxBatch", getLockboxBatch());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LockboxBatchInternalKey", getLockboxBatchInternalKey());
        values.put("LockboxBatchItem", getLockboxBatchItem());
        values.put("LockboxBatch", getLockboxBatch());
        values.put("ValueDate", getValueDate());
        values.put("Currency", getCurrency());
        values.put("AmountInTransactionCurrency", getAmountInTransactionCurrency());
        values.put("LockboxBatchItmStatus", getLockboxBatchItmStatus());
        values.put("LockboxBatchItmStatusName", getLockboxBatchItmStatusName());
        values.put("Cheque", getCheque());
        values.put("PartnerBankCountry", getPartnerBankCountry());
        values.put("PartnerBank", getPartnerBank());
        values.put("PartnerBankAccount", getPartnerBankAccount());
        values.put("BankLedgerDocument", getBankLedgerDocument());
        values.put("Customer", getCustomer());
        values.put("MemoLine1", getMemoLine1());
        values.put("MemoLine", getMemoLine());
        values.put("PaymentAdvice", getPaymentAdvice());
        values.put("AssignmentReference", getAssignmentReference());
        values.put("DocumentItemText", getDocumentItemText());
        values.put("DocumentReferenceID", getDocumentReferenceID());
        values.put("PaymentManualTransacType", getPaymentManualTransacType());
        values.put("BankLedgerIsPosted", getBankLedgerIsPosted());
        values.put("SubledgerIsPostedSuccessfully", getSubledgerIsPostedSuccessfully());
        values.put("LockboxSubledgerDocument", getLockboxSubledgerDocument());
        values.put("CompanyCode", getCompanyCode());
        values.put("FiscalYear", getFiscalYear());
        values.put("SubledgerDocument", getSubledgerDocument());
        values.put("LockboxBatchItmAdditionalInfo", getLockboxBatchItmAdditionalInfo());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LockboxBatchInternalKey") ) {
                final Object value = values.remove("LockboxBatchInternalKey");
                if( (value == null) || (!value.equals(getLockboxBatchInternalKey())) ) {
                    setLockboxBatchInternalKey(((String) value));
                }
            }
            if( values.containsKey("LockboxBatchItem") ) {
                final Object value = values.remove("LockboxBatchItem");
                if( (value == null) || (!value.equals(getLockboxBatchItem())) ) {
                    setLockboxBatchItem(((String) value));
                }
            }
            if( values.containsKey("LockboxBatch") ) {
                final Object value = values.remove("LockboxBatch");
                if( (value == null) || (!value.equals(getLockboxBatch())) ) {
                    setLockboxBatch(((String) value));
                }
            }
            if( values.containsKey("ValueDate") ) {
                final Object value = values.remove("ValueDate");
                if( (value == null) || (!value.equals(getValueDate())) ) {
                    setValueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInTransactionCurrency") ) {
                final Object value = values.remove("AmountInTransactionCurrency");
                if( (value == null) || (!value.equals(getAmountInTransactionCurrency())) ) {
                    setAmountInTransactionCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("LockboxBatchItmStatus") ) {
                final Object value = values.remove("LockboxBatchItmStatus");
                if( (value == null) || (!value.equals(getLockboxBatchItmStatus())) ) {
                    setLockboxBatchItmStatus(((String) value));
                }
            }
            if( values.containsKey("LockboxBatchItmStatusName") ) {
                final Object value = values.remove("LockboxBatchItmStatusName");
                if( (value == null) || (!value.equals(getLockboxBatchItmStatusName())) ) {
                    setLockboxBatchItmStatusName(((String) value));
                }
            }
            if( values.containsKey("Cheque") ) {
                final Object value = values.remove("Cheque");
                if( (value == null) || (!value.equals(getCheque())) ) {
                    setCheque(((String) value));
                }
            }
            if( values.containsKey("PartnerBankCountry") ) {
                final Object value = values.remove("PartnerBankCountry");
                if( (value == null) || (!value.equals(getPartnerBankCountry())) ) {
                    setPartnerBankCountry(((String) value));
                }
            }
            if( values.containsKey("PartnerBank") ) {
                final Object value = values.remove("PartnerBank");
                if( (value == null) || (!value.equals(getPartnerBank())) ) {
                    setPartnerBank(((String) value));
                }
            }
            if( values.containsKey("PartnerBankAccount") ) {
                final Object value = values.remove("PartnerBankAccount");
                if( (value == null) || (!value.equals(getPartnerBankAccount())) ) {
                    setPartnerBankAccount(((String) value));
                }
            }
            if( values.containsKey("BankLedgerDocument") ) {
                final Object value = values.remove("BankLedgerDocument");
                if( (value == null) || (!value.equals(getBankLedgerDocument())) ) {
                    setBankLedgerDocument(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("MemoLine1") ) {
                final Object value = values.remove("MemoLine1");
                if( (value == null) || (!value.equals(getMemoLine1())) ) {
                    setMemoLine1(((String) value));
                }
            }
            if( values.containsKey("MemoLine") ) {
                final Object value = values.remove("MemoLine");
                if( (value == null) || (!value.equals(getMemoLine())) ) {
                    setMemoLine(((String) value));
                }
            }
            if( values.containsKey("PaymentAdvice") ) {
                final Object value = values.remove("PaymentAdvice");
                if( (value == null) || (!value.equals(getPaymentAdvice())) ) {
                    setPaymentAdvice(((String) value));
                }
            }
            if( values.containsKey("AssignmentReference") ) {
                final Object value = values.remove("AssignmentReference");
                if( (value == null) || (!value.equals(getAssignmentReference())) ) {
                    setAssignmentReference(((String) value));
                }
            }
            if( values.containsKey("DocumentItemText") ) {
                final Object value = values.remove("DocumentItemText");
                if( (value == null) || (!value.equals(getDocumentItemText())) ) {
                    setDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("DocumentReferenceID") ) {
                final Object value = values.remove("DocumentReferenceID");
                if( (value == null) || (!value.equals(getDocumentReferenceID())) ) {
                    setDocumentReferenceID(((String) value));
                }
            }
            if( values.containsKey("PaymentManualTransacType") ) {
                final Object value = values.remove("PaymentManualTransacType");
                if( (value == null) || (!value.equals(getPaymentManualTransacType())) ) {
                    setPaymentManualTransacType(((String) value));
                }
            }
            if( values.containsKey("BankLedgerIsPosted") ) {
                final Object value = values.remove("BankLedgerIsPosted");
                if( (value == null) || (!value.equals(getBankLedgerIsPosted())) ) {
                    setBankLedgerIsPosted(((Boolean) value));
                }
            }
            if( values.containsKey("SubledgerIsPostedSuccessfully") ) {
                final Object value = values.remove("SubledgerIsPostedSuccessfully");
                if( (value == null) || (!value.equals(getSubledgerIsPostedSuccessfully())) ) {
                    setSubledgerIsPostedSuccessfully(((Boolean) value));
                }
            }
            if( values.containsKey("LockboxSubledgerDocument") ) {
                final Object value = values.remove("LockboxSubledgerDocument");
                if( (value == null) || (!value.equals(getLockboxSubledgerDocument())) ) {
                    setLockboxSubledgerDocument(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("SubledgerDocument") ) {
                final Object value = values.remove("SubledgerDocument");
                if( (value == null) || (!value.equals(getSubledgerDocument())) ) {
                    setSubledgerDocument(((String) value));
                }
            }
            if( values.containsKey("LockboxBatchItmAdditionalInfo") ) {
                final Object value = values.remove("LockboxBatchItmAdditionalInfo");
                if( (value == null) || (!value.equals(getLockboxBatchItmAdditionalInfo())) ) {
                    setLockboxBatchItmAdditionalInfo(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Header") ) {
                final Object value = (values).remove("to_Header");
                if( value instanceof Map ) {
                    if( toHeader == null ) {
                        toHeader = new LockboxBatch();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toHeader.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_LockboxClearing") ) {
                final Object value = (values).remove("to_LockboxClearing");
                if( value instanceof Iterable ) {
                    if( toLockboxClearing == null ) {
                        toLockboxClearing = Lists.newArrayList();
                    } else {
                        toLockboxClearing = Lists.newArrayList(toLockboxClearing);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LockboxClearing entity;
                        if( toLockboxClearing.size() > i ) {
                            entity = toLockboxClearing.get(i);
                        } else {
                            entity = new LockboxClearing();
                            toLockboxClearing.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LockboxBatchItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LockboxBatchItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LockboxBatchItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LockboxBatchItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PostLockboxService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toHeader != null ) {
            (values).put("to_Header", toHeader);
        }
        if( toLockboxClearing != null ) {
            (values).put("to_LockboxClearing", toLockboxClearing);
        }
        return values;
    }

    /**
     * Fetches the <b>LockboxBatch</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Header</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>LockboxBatch</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public LockboxBatch fetchHeader()
    {
        return fetchFieldAsSingle("to_Header", LockboxBatch.class);
    }

    /**
     * Retrieval of associated <b>LockboxBatch</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Header</b>.
     * <p>
     * If the navigation property <b>to_Header</b> of a queried <b>LockboxBatchItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LockboxBatch</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public LockboxBatch getHeaderOrFetch()
    {
        if( toHeader == null ) {
            toHeader = fetchHeader();
        }
        return toHeader;
    }

    /**
     * Retrieval of associated <b>LockboxBatch</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Header</b>.
     * <p>
     * If the navigation property for an entity <b>LockboxBatchItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Header</b> is already loaded, the result will contain
     *         the <b>LockboxBatch</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<LockboxBatch> getHeaderIfPresent()
    {
        return Option.of(toHeader);
    }

    /**
     * Overwrites the associated <b>LockboxBatch</b> entity for the loaded navigation property <b>to_Header</b>.
     *
     * @param value
     *            New <b>LockboxBatch</b> entity.
     */
    public void setHeader( final LockboxBatch value )
    {
        toHeader = value;
    }

    /**
     * Fetches the <b>LockboxClearing</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_LockboxClearing</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LockboxClearing</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LockboxClearing> fetchLockboxClearing()
    {
        return fetchFieldAsList("to_LockboxClearing", LockboxClearing.class);
    }

    /**
     * Retrieval of associated <b>LockboxClearing</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_LockboxClearing</b>.
     * <p>
     * If the navigation property <b>to_LockboxClearing</b> of a queried <b>LockboxBatchItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LockboxClearing</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LockboxClearing> getLockboxClearingOrFetch()
    {
        if( toLockboxClearing == null ) {
            toLockboxClearing = fetchLockboxClearing();
        }
        return toLockboxClearing;
    }

    /**
     * Retrieval of associated <b>LockboxClearing</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_LockboxClearing</b>.
     * <p>
     * If the navigation property for an entity <b>LockboxBatchItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LockboxClearing</b> is already loaded, the result will
     *         contain the <b>LockboxClearing</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<LockboxClearing>> getLockboxClearingIfPresent()
    {
        return Option.of(toLockboxClearing);
    }

    /**
     * Overwrites the list of associated <b>LockboxClearing</b> entities for the loaded navigation property
     * <b>to_LockboxClearing</b>.
     * <p>
     * If the navigation property <b>to_LockboxClearing</b> of a queried <b>LockboxBatchItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LockboxClearing</b> entities.
     */
    public void setLockboxClearing( @Nonnull final List<LockboxClearing> value )
    {
        if( toLockboxClearing == null ) {
            toLockboxClearing = Lists.newArrayList();
        }
        toLockboxClearing.clear();
        toLockboxClearing.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LockboxClearing</b> entities. This corresponds to the OData navigation
     * property <b>to_LockboxClearing</b>.
     * <p>
     * If the navigation property <b>to_LockboxClearing</b> of a queried <b>LockboxBatchItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LockboxClearing</b> entities.
     */
    public void addLockboxClearing( LockboxClearing... entity )
    {
        if( toLockboxClearing == null ) {
            toLockboxClearing = Lists.newArrayList();
        }
        toLockboxClearing.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of LockboxBatchItem instances.
     *
     */
    public final static class LockboxBatchItemBuilder
    {

        private LockboxBatch toHeader;
        private List<LockboxClearing> toLockboxClearing = Lists.newArrayList();

        private LockboxBatchItem.LockboxBatchItemBuilder toHeader( final LockboxBatch value )
        {
            toHeader = value;
            return this;
        }

        /**
         * Navigation property <b>to_Header</b> for <b>LockboxBatchItem</b> to single <b>LockboxBatch</b>.
         *
         * @param value
         *            The LockboxBatch to build this LockboxBatchItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LockboxBatchItem.LockboxBatchItemBuilder header( final LockboxBatch value )
        {
            return toHeader(value);
        }

        private LockboxBatchItem.LockboxBatchItemBuilder toLockboxClearing( final List<LockboxClearing> value )
        {
            toLockboxClearing.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LockboxClearing</b> for <b>LockboxBatchItem</b> to multiple <b>LockboxClearing</b>.
         *
         * @param value
         *            The LockboxClearings to build this LockboxBatchItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LockboxBatchItem.LockboxBatchItemBuilder lockboxClearing( LockboxClearing... value )
        {
            return toLockboxClearing(Lists.newArrayList(value));
        }

    }

}
