/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.field.LockboxClearingField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.link.LockboxClearingOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.selectable.LockboxClearingSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Lockbox Payment Advice Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>LockboxClearing_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LockboxClearing extends VdmEntity<LockboxClearing>
{

    /**
     * Selector for all available fields of LockboxClearing.
     *
     */
    public final static LockboxClearingSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdvice</b>
     * </p>
     *
     * @return Payment Advice Number
     */
    @Key
    @SerializedName( "PaymentAdvice" )
    @JsonProperty( "PaymentAdvice" )
    @Nullable
    @ODataField( odataName = "PaymentAdvice" )
    private String paymentAdvice;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdvice</b> field to query operations.
     *
     */
    public final static LockboxClearingField<String> PAYMENT_ADVICE = new LockboxClearingField<String>("PaymentAdvice");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceItem</b>
     * </p>
     *
     * @return Payment Advice Line Item
     */
    @Key
    @SerializedName( "PaymentAdviceItem" )
    @JsonProperty( "PaymentAdviceItem" )
    @Nullable
    @ODataField( odataName = "PaymentAdviceItem" )
    private String paymentAdviceItem;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdviceItem</b> field to query operations.
     *
     */
    public final static LockboxClearingField<String> PAYMENT_ADVICE_ITEM =
        new LockboxClearingField<String>("PaymentAdviceItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceAccount</b>
     * </p>
     *
     * @return Account Number
     */
    @Key
    @SerializedName( "PaymentAdviceAccount" )
    @JsonProperty( "PaymentAdviceAccount" )
    @Nullable
    @ODataField( odataName = "PaymentAdviceAccount" )
    private String paymentAdviceAccount;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdviceAccount</b> field to query operations.
     *
     */
    public final static LockboxClearingField<String> PAYMENT_ADVICE_ACCOUNT =
        new LockboxClearingField<String>("PaymentAdviceAccount");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceAccountType</b>
     * </p>
     *
     * @return Payment Advice Account Type
     */
    @Key
    @SerializedName( "PaymentAdviceAccountType" )
    @JsonProperty( "PaymentAdviceAccountType" )
    @Nullable
    @ODataField( odataName = "PaymentAdviceAccountType" )
    private String paymentAdviceAccountType;
    /**
     * Use with available fluent helpers to apply the <b>PaymentAdviceAccountType</b> field to query operations.
     *
     */
    public final static LockboxClearingField<String> PAYMENT_ADVICE_ACCOUNT_TYPE =
        new LockboxClearingField<String>("PaymentAdviceAccountType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static LockboxClearingField<String> COMPANY_CODE = new LockboxClearingField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchInternalKey</b>
     * </p>
     *
     * @return Short Key for Bank Statement (Surrogate Key)
     */
    @SerializedName( "LockboxBatchInternalKey" )
    @JsonProperty( "LockboxBatchInternalKey" )
    @Nullable
    @ODataField( odataName = "LockboxBatchInternalKey" )
    private String lockboxBatchInternalKey;
    /**
     * Use with available fluent helpers to apply the <b>LockboxBatchInternalKey</b> field to query operations.
     *
     */
    public final static LockboxClearingField<String> LOCKBOX_BATCH_INTERNAL_KEY =
        new LockboxClearingField<String>("LockboxBatchInternalKey");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchItem</b>
     * </p>
     *
     * @return Memo Record Number (Line Item Number in Bank Statement)
     */
    @SerializedName( "LockboxBatchItem" )
    @JsonProperty( "LockboxBatchItem" )
    @Nullable
    @ODataField( odataName = "LockboxBatchItem" )
    private String lockboxBatchItem;
    /**
     * Use with available fluent helpers to apply the <b>LockboxBatchItem</b> field to query operations.
     *
     */
    public final static LockboxClearingField<String> LOCKBOX_BATCH_ITEM =
        new LockboxClearingField<String>("LockboxBatchItem");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatch</b>
     * </p>
     *
     * @return Batch number (bundle number)
     */
    @SerializedName( "LockboxBatch" )
    @JsonProperty( "LockboxBatch" )
    @Nullable
    @ODataField( odataName = "LockboxBatch" )
    private String lockboxBatch;
    /**
     * Use with available fluent helpers to apply the <b>LockboxBatch</b> field to query operations.
     *
     */
    public final static LockboxClearingField<String> LOCKBOX_BATCH = new LockboxClearingField<String>("LockboxBatch");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentReference</b>
     * </p>
     *
     * @return Payment Reference
     */
    @SerializedName( "PaymentReference" )
    @JsonProperty( "PaymentReference" )
    @Nullable
    @ODataField( odataName = "PaymentReference" )
    private String paymentReference;
    /**
     * Use with available fluent helpers to apply the <b>PaymentReference</b> field to query operations.
     *
     */
    public final static LockboxClearingField<String> PAYMENT_REFERENCE =
        new LockboxClearingField<String>("PaymentReference");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentAmountInPaytCurrency</b>
     * </p>
     *
     * @return Net Payment Amount with +/- Sign
     */
    @SerializedName( "NetPaymentAmountInPaytCurrency" )
    @JsonProperty( "NetPaymentAmountInPaytCurrency" )
    @Nullable
    @ODataField( odataName = "NetPaymentAmountInPaytCurrency" )
    private BigDecimal netPaymentAmountInPaytCurrency;
    /**
     * Use with available fluent helpers to apply the <b>NetPaymentAmountInPaytCurrency</b> field to query operations.
     *
     */
    public final static LockboxClearingField<BigDecimal> NET_PAYMENT_AMOUNT_IN_PAYT_CURRENCY =
        new LockboxClearingField<BigDecimal>("NetPaymentAmountInPaytCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeductionAmountInPaytCurrency</b>
     * </p>
     *
     * @return Deduction Amount
     */
    @SerializedName( "DeductionAmountInPaytCurrency" )
    @JsonProperty( "DeductionAmountInPaytCurrency" )
    @Nullable
    @ODataField( odataName = "DeductionAmountInPaytCurrency" )
    private BigDecimal deductionAmountInPaytCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DeductionAmountInPaytCurrency</b> field to query operations.
     *
     */
    public final static LockboxClearingField<BigDecimal> DEDUCTION_AMOUNT_IN_PAYT_CURRENCY =
        new LockboxClearingField<BigDecimal>("DeductionAmountInPaytCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaymentDifferenceReason</b>
     * </p>
     *
     * @return Reason Code for Payments
     */
    @SerializedName( "PaymentDifferenceReason" )
    @JsonProperty( "PaymentDifferenceReason" )
    @Nullable
    @ODataField( odataName = "PaymentDifferenceReason" )
    private String paymentDifferenceReason;
    /**
     * Use with available fluent helpers to apply the <b>PaymentDifferenceReason</b> field to query operations.
     *
     */
    public final static LockboxClearingField<String> PAYMENT_DIFFERENCE_REASON =
        new LockboxClearingField<String>("PaymentDifferenceReason");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static LockboxClearingField<String> CURRENCY = new LockboxClearingField<String>("Currency");
    /**
     * Navigation property <b>to_BatchItem</b> for <b>LockboxClearing</b> to single <b>LockboxBatchItem</b>.
     *
     */
    @SerializedName( "to_BatchItem" )
    @JsonProperty( "to_BatchItem" )
    @ODataField( odataName = "to_BatchItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private LockboxBatchItem toBatchItem;
    /**
     * Navigation property <b>to_Root</b> for <b>LockboxClearing</b> to single <b>LockboxBatch</b>.
     *
     */
    @SerializedName( "to_Root" )
    @JsonProperty( "to_Root" )
    @ODataField( odataName = "to_Root" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private LockboxBatch toRoot;
    /**
     * Use with available fluent helpers to apply the <b>to_BatchItem</b> navigation property to query operations.
     *
     */
    public final static LockboxClearingOneToOneLink<LockboxBatchItem> TO_BATCH_ITEM =
        new LockboxClearingOneToOneLink<LockboxBatchItem>("to_BatchItem");
    /**
     * Use with available fluent helpers to apply the <b>to_Root</b> navigation property to query operations.
     *
     */
    public final static LockboxClearingOneToOneLink<LockboxBatch> TO_ROOT =
        new LockboxClearingOneToOneLink<LockboxBatch>("to_Root");

    @Nonnull
    @Override
    public Class<LockboxClearing> getType()
    {
        return LockboxClearing.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdvice</b>
     * </p>
     *
     * @param paymentAdvice
     *            Payment Advice Number
     */
    public void setPaymentAdvice( @Nullable final String paymentAdvice )
    {
        rememberChangedField("PaymentAdvice", this.paymentAdvice);
        this.paymentAdvice = paymentAdvice;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceItem</b>
     * </p>
     *
     * @param paymentAdviceItem
     *            Payment Advice Line Item
     */
    public void setPaymentAdviceItem( @Nullable final String paymentAdviceItem )
    {
        rememberChangedField("PaymentAdviceItem", this.paymentAdviceItem);
        this.paymentAdviceItem = paymentAdviceItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceAccount</b>
     * </p>
     *
     * @param paymentAdviceAccount
     *            Account Number
     */
    public void setPaymentAdviceAccount( @Nullable final String paymentAdviceAccount )
    {
        rememberChangedField("PaymentAdviceAccount", this.paymentAdviceAccount);
        this.paymentAdviceAccount = paymentAdviceAccount;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentAdviceAccountType</b>
     * </p>
     *
     * @param paymentAdviceAccountType
     *            Payment Advice Account Type
     */
    public void setPaymentAdviceAccountType( @Nullable final String paymentAdviceAccountType )
    {
        rememberChangedField("PaymentAdviceAccountType", this.paymentAdviceAccountType);
        this.paymentAdviceAccountType = paymentAdviceAccountType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchInternalKey</b>
     * </p>
     *
     * @param lockboxBatchInternalKey
     *            Short Key for Bank Statement (Surrogate Key)
     */
    public void setLockboxBatchInternalKey( @Nullable final String lockboxBatchInternalKey )
    {
        rememberChangedField("LockboxBatchInternalKey", this.lockboxBatchInternalKey);
        this.lockboxBatchInternalKey = lockboxBatchInternalKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatchItem</b>
     * </p>
     *
     * @param lockboxBatchItem
     *            Memo Record Number (Line Item Number in Bank Statement)
     */
    public void setLockboxBatchItem( @Nullable final String lockboxBatchItem )
    {
        rememberChangedField("LockboxBatchItem", this.lockboxBatchItem);
        this.lockboxBatchItem = lockboxBatchItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LockboxBatch</b>
     * </p>
     *
     * @param lockboxBatch
     *            Batch number (bundle number)
     */
    public void setLockboxBatch( @Nullable final String lockboxBatch )
    {
        rememberChangedField("LockboxBatch", this.lockboxBatch);
        this.lockboxBatch = lockboxBatch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentReference</b>
     * </p>
     *
     * @param paymentReference
     *            Payment Reference
     */
    public void setPaymentReference( @Nullable final String paymentReference )
    {
        rememberChangedField("PaymentReference", this.paymentReference);
        this.paymentReference = paymentReference;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentAmountInPaytCurrency</b>
     * </p>
     *
     * @param netPaymentAmountInPaytCurrency
     *            Net Payment Amount with +/- Sign
     */
    public void setNetPaymentAmountInPaytCurrency( @Nullable final BigDecimal netPaymentAmountInPaytCurrency )
    {
        rememberChangedField("NetPaymentAmountInPaytCurrency", this.netPaymentAmountInPaytCurrency);
        this.netPaymentAmountInPaytCurrency = netPaymentAmountInPaytCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeductionAmountInPaytCurrency</b>
     * </p>
     *
     * @param deductionAmountInPaytCurrency
     *            Deduction Amount
     */
    public void setDeductionAmountInPaytCurrency( @Nullable final BigDecimal deductionAmountInPaytCurrency )
    {
        rememberChangedField("DeductionAmountInPaytCurrency", this.deductionAmountInPaytCurrency);
        this.deductionAmountInPaytCurrency = deductionAmountInPaytCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PaymentDifferenceReason</b>
     * </p>
     *
     * @param paymentDifferenceReason
     *            Reason Code for Payments
     */
    public void setPaymentDifferenceReason( @Nullable final String paymentDifferenceReason )
    {
        rememberChangedField("PaymentDifferenceReason", this.paymentDifferenceReason);
        this.paymentDifferenceReason = paymentDifferenceReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    @Override
    protected String getEntityCollection()
    {
        return "LockboxClearing";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PaymentAdvice", getPaymentAdvice());
        result.put("PaymentAdviceItem", getPaymentAdviceItem());
        result.put("PaymentAdviceAccount", getPaymentAdviceAccount());
        result.put("PaymentAdviceAccountType", getPaymentAdviceAccountType());
        result.put("CompanyCode", getCompanyCode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PaymentAdvice", getPaymentAdvice());
        values.put("PaymentAdviceItem", getPaymentAdviceItem());
        values.put("PaymentAdviceAccount", getPaymentAdviceAccount());
        values.put("PaymentAdviceAccountType", getPaymentAdviceAccountType());
        values.put("CompanyCode", getCompanyCode());
        values.put("LockboxBatchInternalKey", getLockboxBatchInternalKey());
        values.put("LockboxBatchItem", getLockboxBatchItem());
        values.put("LockboxBatch", getLockboxBatch());
        values.put("PaymentReference", getPaymentReference());
        values.put("NetPaymentAmountInPaytCurrency", getNetPaymentAmountInPaytCurrency());
        values.put("DeductionAmountInPaytCurrency", getDeductionAmountInPaytCurrency());
        values.put("PaymentDifferenceReason", getPaymentDifferenceReason());
        values.put("Currency", getCurrency());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PaymentAdvice") ) {
                final Object value = values.remove("PaymentAdvice");
                if( (value == null) || (!value.equals(getPaymentAdvice())) ) {
                    setPaymentAdvice(((String) value));
                }
            }
            if( values.containsKey("PaymentAdviceItem") ) {
                final Object value = values.remove("PaymentAdviceItem");
                if( (value == null) || (!value.equals(getPaymentAdviceItem())) ) {
                    setPaymentAdviceItem(((String) value));
                }
            }
            if( values.containsKey("PaymentAdviceAccount") ) {
                final Object value = values.remove("PaymentAdviceAccount");
                if( (value == null) || (!value.equals(getPaymentAdviceAccount())) ) {
                    setPaymentAdviceAccount(((String) value));
                }
            }
            if( values.containsKey("PaymentAdviceAccountType") ) {
                final Object value = values.remove("PaymentAdviceAccountType");
                if( (value == null) || (!value.equals(getPaymentAdviceAccountType())) ) {
                    setPaymentAdviceAccountType(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("LockboxBatchInternalKey") ) {
                final Object value = values.remove("LockboxBatchInternalKey");
                if( (value == null) || (!value.equals(getLockboxBatchInternalKey())) ) {
                    setLockboxBatchInternalKey(((String) value));
                }
            }
            if( values.containsKey("LockboxBatchItem") ) {
                final Object value = values.remove("LockboxBatchItem");
                if( (value == null) || (!value.equals(getLockboxBatchItem())) ) {
                    setLockboxBatchItem(((String) value));
                }
            }
            if( values.containsKey("LockboxBatch") ) {
                final Object value = values.remove("LockboxBatch");
                if( (value == null) || (!value.equals(getLockboxBatch())) ) {
                    setLockboxBatch(((String) value));
                }
            }
            if( values.containsKey("PaymentReference") ) {
                final Object value = values.remove("PaymentReference");
                if( (value == null) || (!value.equals(getPaymentReference())) ) {
                    setPaymentReference(((String) value));
                }
            }
            if( values.containsKey("NetPaymentAmountInPaytCurrency") ) {
                final Object value = values.remove("NetPaymentAmountInPaytCurrency");
                if( (value == null) || (!value.equals(getNetPaymentAmountInPaytCurrency())) ) {
                    setNetPaymentAmountInPaytCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("DeductionAmountInPaytCurrency") ) {
                final Object value = values.remove("DeductionAmountInPaytCurrency");
                if( (value == null) || (!value.equals(getDeductionAmountInPaytCurrency())) ) {
                    setDeductionAmountInPaytCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("PaymentDifferenceReason") ) {
                final Object value = values.remove("PaymentDifferenceReason");
                if( (value == null) || (!value.equals(getPaymentDifferenceReason())) ) {
                    setPaymentDifferenceReason(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BatchItem") ) {
                final Object value = (values).remove("to_BatchItem");
                if( value instanceof Map ) {
                    if( toBatchItem == null ) {
                        toBatchItem = new LockboxBatchItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBatchItem.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Root") ) {
                final Object value = (values).remove("to_Root");
                if( value instanceof Map ) {
                    if( toRoot == null ) {
                        toRoot = new LockboxBatch();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRoot.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LockboxClearingField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LockboxClearingField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LockboxClearingField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LockboxClearingField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PostLockboxService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBatchItem != null ) {
            (values).put("to_BatchItem", toBatchItem);
        }
        if( toRoot != null ) {
            (values).put("to_Root", toRoot);
        }
        return values;
    }

    /**
     * Fetches the <b>LockboxBatchItem</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BatchItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>LockboxBatchItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public LockboxBatchItem fetchBatchItem()
    {
        return fetchFieldAsSingle("to_BatchItem", LockboxBatchItem.class);
    }

    /**
     * Retrieval of associated <b>LockboxBatchItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BatchItem</b>.
     * <p>
     * If the navigation property <b>to_BatchItem</b> of a queried <b>LockboxClearing</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LockboxBatchItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public LockboxBatchItem getBatchItemOrFetch()
    {
        if( toBatchItem == null ) {
            toBatchItem = fetchBatchItem();
        }
        return toBatchItem;
    }

    /**
     * Retrieval of associated <b>LockboxBatchItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_BatchItem</b>.
     * <p>
     * If the navigation property for an entity <b>LockboxClearing</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BatchItem</b> is already loaded, the result will contain
     *         the <b>LockboxBatchItem</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<LockboxBatchItem> getBatchItemIfPresent()
    {
        return Option.of(toBatchItem);
    }

    /**
     * Overwrites the associated <b>LockboxBatchItem</b> entity for the loaded navigation property <b>to_BatchItem</b>.
     *
     * @param value
     *            New <b>LockboxBatchItem</b> entity.
     */
    public void setBatchItem( final LockboxBatchItem value )
    {
        toBatchItem = value;
    }

    /**
     * Fetches the <b>LockboxBatch</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Root</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>LockboxBatch</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public LockboxBatch fetchRoot()
    {
        return fetchFieldAsSingle("to_Root", LockboxBatch.class);
    }

    /**
     * Retrieval of associated <b>LockboxBatch</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property <b>to_Root</b> of a queried <b>LockboxClearing</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LockboxBatch</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public LockboxBatch getRootOrFetch()
    {
        if( toRoot == null ) {
            toRoot = fetchRoot();
        }
        return toRoot;
    }

    /**
     * Retrieval of associated <b>LockboxBatch</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Root</b>.
     * <p>
     * If the navigation property for an entity <b>LockboxClearing</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Root</b> is already loaded, the result will contain the
     *         <b>LockboxBatch</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<LockboxBatch> getRootIfPresent()
    {
        return Option.of(toRoot);
    }

    /**
     * Overwrites the associated <b>LockboxBatch</b> entity for the loaded navigation property <b>to_Root</b>.
     *
     * @param value
     *            New <b>LockboxBatch</b> entity.
     */
    public void setRoot( final LockboxBatch value )
    {
        toRoot = value;
    }

    /**
     * Helper class to allow for fluent creation of LockboxClearing instances.
     *
     */
    public final static class LockboxClearingBuilder
    {

        private LockboxBatchItem toBatchItem;
        private LockboxBatch toRoot;

        private LockboxClearing.LockboxClearingBuilder toBatchItem( final LockboxBatchItem value )
        {
            toBatchItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_BatchItem</b> for <b>LockboxClearing</b> to single <b>LockboxBatchItem</b>.
         *
         * @param value
         *            The LockboxBatchItem to build this LockboxClearing with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LockboxClearing.LockboxClearingBuilder batchItem( final LockboxBatchItem value )
        {
            return toBatchItem(value);
        }

        private LockboxClearing.LockboxClearingBuilder toRoot( final LockboxBatch value )
        {
            toRoot = value;
            return this;
        }

        /**
         * Navigation property <b>to_Root</b> for <b>LockboxClearing</b> to single <b>LockboxBatch</b>.
         *
         * @param value
         *            The LockboxBatch to build this LockboxClearing with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LockboxClearing.LockboxClearingBuilder root( final LockboxBatch value )
        {
            return toRoot(value);
        }

    }

}
